/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2.actions;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JOptionPane;

public class DeleteAction
extends SwingAction {
    private static final String RB_KEY = "RemoteFileSelector.";
    private TableView table = null;

    public void actionPerformed(ActionEvent event) {
        String title;
        this.table = (TableView)this.getAttribute("table");
        int index = this.table.getSelectedRow();
        SortableTableModelAdapter tableModel = (SortableTableModelAdapter)this.getAttribute("tableModel");
        Integer actualIndex = new Integer(tableModel.convertRowIndexToModel(index));
        String folderName = (String)tableModel.getValueAt(index, 0);
        String message = MessageFormat.format(RB.getStringResource(RB_KEY, "confirmDeleteMessage.txt"), folderName);
        int answer = JOptionPane.showConfirmDialog(null, message, title = RB.getStringResource(RB_KEY, "confirmDeleteTitle.txt"), 0, 3);
        if (answer == 0) {
            try {
                this.setAttribute("index", actualIndex);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            DynamicAttributeCommandInterface command = this.getCommand();
            if (command != null) {
                AttributeDescriptorInterface[] adi = this.getAttributeDescriptors();
                if (adi != null) {
                    for (int i = 0; i < adi.length; ++i) {
                        try {
                            AttributeDescriptorInterface attributeDescriptor = adi[i];
                            if (!attributeDescriptor.isModifiable()) continue;
                            command.setAttribute(attributeDescriptor.getName(), this.getValue(attributeDescriptor.getName()));
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
                this.executeCommand(command);
                SwingActionProvider actionProvider = (SwingActionProvider)this.getActionProvider();
                if (command instanceof ContentsChangedInterface && actionProvider != null && ((ContentsChangedInterface)command).isContentsChanged()) {
                    actionProvider.fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)command).getEventSource(), (Map)((ContentsChangedInterface)command).getEventInfo()));
                }
            }
        }
    }

    protected void executeCommand(DynamicAttributeCommandInterface command) {
        try {
            command.execute(null);
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog((Component)this.table, iae.getMessage(), RB.getStringResource(RB_KEY, "error.txt"), 0);
        }
    }
}

