/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RFSSortableTableModelAdapter;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponent;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RemoteFileTableComponent
extends RemoteFileComponent
implements ListSelectionListener {
    private static final String RB_KEY = "RemoteFileTableComponent.";
    protected TableView table;
    protected Object[] columnRenderers;
    protected String currentPath;
    private List previousPath;
    private ActionSupportFilter filter;
    private ListSelectionModel selectionObject;
    private Cursor waitCursor;
    private SortableTableModelAdapter sortableModel;

    public RemoteFileTableComponent(BaseRemoteFileSelectorPanel parentComponent) {
        this(parentComponent, "");
    }

    public RemoteFileTableComponent(BaseRemoteFileSelectorPanel parentComponent, String supportType) {
        this.parentComponent = parentComponent;
        this.table = new TableView(){

            public void tableRowsInserted(TableModelEvent e) {
                super.tableRowsInserted(e);
                this.firePropertyChange("rfsDetailViewRowInsertionComplete", false, true);
            }
        };
        this.table.getAccessibleContext().setAccessibleName("FileView");
        if (!supportType.equals("")) {
            this.table.setActionSupportType(supportType);
        }
        this.init();
    }

    protected void init() {
        ListSelectionModel rowSM;
        this.waitCursor = new Cursor(3);
        TableColumnModel displayedColumns = this.parentComponent.getDisplayedColumns();
        if (displayedColumns != null) {
            this.table.setAutoCreateColumnsFromModel(false);
            this.table.setColumnModel(displayedColumns);
            this.parentComponent.updateColumnHeaders(displayedColumns);
        }
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeaderVisible(false);
        this.table.setAutoResizeMode(2);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 10, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        JScrollPane tablePane = new JScrollPane();
        tablePane.setPreferredSize(new Dimension(425, 200));
        tablePane.getViewport().add((Component)this.table);
        tablePane.getViewport().setBackground(this.table.getBackground());
        this.add(tablePane);
        TableRowModel rowModel = this.table.getRowModel();
        this.selectionObject = rowSM = rowModel.getSelectionModel();
        rowSM.addListSelectionListener(this);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RemoteFileTableComponent.this.handleDoubleClick();
                }
            }
        };
        this.table.addMouseListener((MouseListener)mouseListener);
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    RemoteFileTableComponent.this.handleDoubleClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDoubleClick() {
        block13: {
            Cursor cursor = this.getCursor();
            try {
                RemoteFileMetadataInterface fileNode;
                SwingAction action = null;
                this.setCursor(this.waitCursor);
                List items = this.parentComponent.getSelectedItemObjects();
                if (items != null && items.size() == 1 && !(fileNode = (RemoteFileMetadataInterface)items.get(0)).isFolder()) {
                    if (this.parentComponent.getSelectionMode() == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY) {
                        this.showInvalidTypeSelectionDialog(fileNode.getName());
                        return;
                    }
                    this.parentComponent.viewPanel.firePropertyChange("fileSelectionComplete", false, true);
                }
                this.filter = this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.DRILL_DOWN_FILTER);
                try {
                    int columnNumber = this.table.getSelectedColumn();
                    if (columnNumber < 0) {
                        columnNumber = 0;
                    }
                    this.filter.setAttribute("modelColumn", (Object)new Integer(columnNumber));
                    int rowNumber = this.table.getSelectedRow();
                    this.filter.setAttribute("modelRow", (Object)new Integer(rowNumber));
                }
                catch (AttributeSetException e) {
                    LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
                }
                ActionList actions = this.parentComponent.getActionProvider().getActions(this.filter);
                if (actions == null) break block13;
                List list = actions.getActions();
                action = (SwingAction)list.get(0);
                try {
                    action.setAttribute("path", (Object)this.currentPath);
                    action.removeAttribute("component");
                    action.setAttribute("component", (Object)this);
                }
                catch (AttributeSetException e) {
                    LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
                }
                this.table.clearSelection();
                action.actionPerformed(new ActionEvent(this, 1, "OpenFolder"));
                try {
                    action.removeAttribute("component");
                    action.setAttribute("component", null);
                }
                catch (AttributeSetException e) {
                    LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.setCursor(cursor);
            }
        }
    }

    private void showInvalidTypeSelectionDialog(String itemName) {
        JOptionPane.showMessageDialog(null, MessageFormat.format(RB.getStringResource(RB_KEY, "nonFolderSelectedMessage.txt"), itemName));
    }

    @Override
    public List getPreviousPath() {
        return this.previousPath;
    }

    @Override
    public void setPreviousPath(List previousPath) {
        this.previousPath = previousPath;
    }

    @Override
    public void refreshData(String path) {
        this.spcs.firePropertyChange("path", null, path);
    }

    @Override
    public void setPath(String path) {
        try {
            if (this.parentComponent.isInitializing() || path != null && this.currentPath != null && !this.currentPath.equals(path)) {
                int pathSize;
                if (this.previousPath != null && (pathSize = this.previousPath.size()) > 0) {
                    this.previousPath.remove(pathSize - 1);
                }
                if (!this.parentComponent.isInitializing()) {
                    this.previousPath.add(this.currentPath);
                }
                this.currentPath = path;
                this.refreshData(path);
                try {
                    this.filter = this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.TOOLBAR_FILTER);
                    this.filter.setAttribute("path", (Object)this.currentPath);
                }
                catch (AttributeSetException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(null, iae.getMessage(), "Error", 0);
        }
    }

    @Override
    public Object getSelectionObject() {
        return this.selectionObject;
    }

    @Override
    public void setSelectionObject(Object newSelectionObject) {
        if (newSelectionObject != null) {
            int minSelection = ((ListSelectionModel)newSelectionObject).getMinSelectionIndex();
            int maxSelection = ((ListSelectionModel)newSelectionObject).getMaxSelectionIndex();
            if (minSelection > -1 && maxSelection > -1) {
                this.table.setRowSelectionInterval(minSelection, maxSelection);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.selections == null) {
            this.selections = new ArrayList();
        } else if (!this.selections.isEmpty()) {
            this.selections.clear();
        }
        if (this.folderSelections == null) {
            this.folderSelections = new ArrayList();
        } else if (!this.folderSelections.isEmpty()) {
            this.folderSelections.clear();
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                RemoteFileMetadataInterface item = this.rfsModel.getNodeAt(((SortableTableModelAdapter)this.table.getModel()).convertRowIndexToModel(i));
                this.selections.add(item);
            }
        }
        this.spcs.firePropertyChange("selections", null, this.selections);
    }

    @Override
    public void setModel(BaseRemoteFileModelInterface brfModel) {
        this.rfsModel = brfModel;
        SortableTableModelAdapter model = this.getSortModel();
        model.setAutoResortEnabled(true);
        this.table.setModel((TableModel)model);
        this.currentPath = this.rfsModel.getLocation();
        try {
            this.filter = this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.DRILL_DOWN_FILTER);
            this.filter.setAttribute("model", (Object)model);
        }
        catch (AttributeSetException e) {
            e.printStackTrace();
        }
        int nameColIndex = this.rfsModel.getColumnIndex("NAME_COLUMN");
        if (nameColIndex >= 0) {
            String sortColName = this.rfsModel.getColumnName(nameColIndex);
            RemoteFileVisualsUtil.sortFoldersFirst(model, this.rfsModel, sortColName, 0);
        }
        this.spcs.firePropertyChange("path", null, this.currentPath);
    }

    public void setSortModel(SortableTableModelAdapter sortModel) {
        this.sortableModel = sortModel;
    }

    public SortableTableModelAdapter getSortModel() {
        if (this.sortableModel == null) {
            return new RFSSortableTableModelAdapter(this.rfsModel, this.getLocale());
        }
        return this.sortableModel;
    }

    @Override
    public JComponent getViewComponent() {
        return this.table;
    }

    @Override
    public void setActionProvider(SwingActionProvider actionProvider) {
        this.table.setActionProvider(actionProvider);
    }

    @Override
    public void clearSelections() {
        JComponent view = this.getViewComponent();
        if (view instanceof TableView) {
            ((TableView)view).clearSelection();
        }
    }

    @Override
    public void setColumnRenderers(Object[] columnRenderers) {
        this.columnRenderers = columnRenderers;
        for (int i = 0; i < columnRenderers.length; ++i) {
            this.table.setCellRenderer(1, -1, 1, i + 1, i + 1, 1, (TableCellRenderer)columnRenderers[i]);
        }
    }

    @Override
    public Object[] getColumnRenderers() {
        return this.columnRenderers;
    }
}

