/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.swing.models.remotefileselector2.AddPermissionsInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.WriteObjectPermissionsInterface;
import java.util.List;

public class RemoteFileServicesSelectorVisualsUtil {
    public static String checkWritePermissionsOnFiles(List<RemoteFileMetadataInterface> selections, WriteObjectPermissionsInterface rfsModel) {
        StringBuffer filesWithWriteDenied = new StringBuffer();
        int numOfSelections = selections.size();
        for (int i = 0; i < numOfSelections; ++i) {
            RemoteFileMetadataInterface selection = selections.get(i);
            if (rfsModel.canWrite(selection)) continue;
            if (filesWithWriteDenied.length() > 0) {
                filesWithWriteDenied.append(", ");
            }
            filesWithWriteDenied.append(selection.getName());
        }
        return filesWithWriteDenied.toString();
    }

    public static boolean isValidLocationForSave(RemoteFileModel2Interface model, String[] fileInfo, String entryFileName) {
        if (fileInfo[0] == null) {
            String[] pathParts = RemoteFileModelsUtil.removeStartingEndingPathDelimiters(entryFileName, "/").split("/");
            if (pathParts.length > 1) {
                return true;
            }
            if (pathParts.length == 1 && !model.getRootLocation().equalsIgnoreCase(model.getLocation())) {
                return true;
            }
            if (model.getRootLocation().equalsIgnoreCase(model.getLocation())) {
                return false;
            }
        } else {
            String[] pathParts = RemoteFileModelsUtil.removeStartingEndingPathDelimiters(fileInfo[1], "/").split("/");
            if (pathParts.length > 1) {
                return true;
            }
            if (pathParts.length == 1 && !model.getRootLocation().equalsIgnoreCase(model.getLocation())) {
                return true;
            }
            if (model.getRootLocation().equalsIgnoreCase(model.getLocation())) {
                return false;
            }
        }
        return !RemoteFileServicesSelectorVisualsUtil.isRootLocation(model, model.getLocation());
    }

    public static boolean canAddToCurrentFolder(RemoteFileModel2Interface model) {
        if (model instanceof AddPermissionsInterface) {
            return ((AddPermissionsInterface)((Object)model)).canAdd(model.getLocation());
        }
        return false;
    }

    public static boolean isValidLocationForSelection(RemoteFileModel2Interface model, String location, boolean rootValid) {
        if (rootValid) {
            return true;
        }
        return !RemoteFileServicesSelectorVisualsUtil.isRootLocation(model, location);
    }

    public static boolean isRootLocation(RemoteFileModel2Interface model, String location) {
        if (null == location || "".equals(location.trim())) {
            return true;
        }
        return model.getRootLocation().equalsIgnoreCase(location);
    }
}

