/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.FileSelectionInfo;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidationInfo;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidator;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidatorInterface;
import com.sas.swing.visuals.remotefileselector2.FileServicesSelectionValidator;
import com.sas.swing.visuals.remotefileselector2.FileServicesSelectorInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialogInterface;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class RemoteFileSelectorDialog
extends JDialog
implements RemoteFileSelectorDialogInterface,
ActionListener,
PropertyChangeListener {
    private static final String RB_KEY = "RemoteFileSelector.";
    private String dialogTypeString;
    private BaseRemoteFileSelectorPanel compositePanel;
    private JButton actionButton;
    private JButton cancelButton;
    private int dialogType;
    private boolean allowNonExistentSelections;
    public static final int DIALOG_TYPE_OPEN = 0;
    public static final int DIALOG_TYPE_SAVE = 1;
    public static final int DIALOG_TYPE_OK = 2;
    private FileSelectionValidatorInterface selectionValidator;
    private FileSelectionValidationInfo validationInfo;

    public RemoteFileSelectorDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, BaseRemoteFileSelectorPanel selectorPanel) {
        super(parent, titleOfDialog, modal);
        this.commonInit(titleOfDialog, modal, typeOfDialog, selectorPanel);
    }

    public RemoteFileSelectorDialog(Dialog parent, String titleOfDialog, boolean modal, int typeOfDialog, BaseRemoteFileSelectorPanel selectorPanel) {
        super(parent, titleOfDialog, modal);
        this.commonInit(titleOfDialog, modal, typeOfDialog, selectorPanel);
    }

    private void commonInit(String titleOfDialog, boolean modal, int typeOfDialog, BaseRemoteFileSelectorPanel selectorPanel) {
        this.dialogType = typeOfDialog;
        selectorPanel.setDialog(this);
        this.setAllowNonExistentSelections(true);
        this.setAcceptButtonText(typeOfDialog);
        Container contentPane = this.getContentPane();
        this.compositePanel = selectorPanel;
        this.compositePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add(this.compositePanel);
        this.createAcceptActionButton();
        this.createCancelActionButton();
        if (this.compositePanel.filePanel != null) {
            this.compositePanel.filePanel.addActionButtons(this.actionButton, this.cancelButton);
        }
        if (this.dialogType == 1 && this.compositePanel.buttonPanel != null) {
            JLabel choiceLabel = this.compositePanel.buttonPanel.getChoiceLabel();
            if (choiceLabel != null) {
                choiceLabel.setText(RB.getStringResource(RB_KEY, "saveIn.txt", this.getLocale()));
            }
            this.compositePanel.setOpenSelectedFolderItemOn(false);
        }
        this.compositePanel.viewPanel.addPropertyChangeListener("fileSelectionComplete", this);
        this.compositePanel.filePanel.addPropertyChangeListener(this);
        this.pack();
        if (this.getParent() != null) {
            Util.centerOverWindow((Window)this, (Component)this.getParent());
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
        this.getRootPane().setDefaultButton(this.actionButton);
        this.enableActionButton();
        String escKey = this.getClass().getName() + "CLOSE_ON_ESC";
        this.getRootPane().getActionMap().put(escKey, this.getEscAction());
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), escKey);
    }

    protected void createCancelActionButton() {
        this.cancelButton = new JButton(RB.getStringResource(RB_KEY, "Cancel.txt"));
        this.cancelButton.setToolTipText(RB.getStringResource(RB_KEY, "CancelTip.txt"));
        this.cancelButton.getAccessibleContext().setAccessibleName("Cancel");
        this.cancelButton.addActionListener(this);
    }

    protected void createAcceptActionButton() {
        this.actionButton = new JButton(this.dialogTypeString);
        this.actionButton.setToolTipText(RB.getStringResource(RB_KEY, "ActionTip.txt"));
        this.actionButton.getAccessibleContext().setAccessibleName("ReturnValueAction");
        this.actionButton.addActionListener(this);
    }

    private void setAcceptButtonText(int typeOfDialog) {
        this.dialogTypeString = typeOfDialog == 1 ? RB.getStringResource(RB_KEY, "saveText.txt") : (typeOfDialog == 2 ? RB.getStringResource(RB_KEY, "OKText.txt") : RB.getStringResource(RB_KEY, "openText.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog(true);
        }
        if (e.getSource() != this.actionButton) {
            return;
        }
        if (this.onActionButton()) {
            this.closeDialog(false);
        }
    }

    private boolean onActionButton() {
        this.validationInfo = this.getSelectionValidator().validate(this.getNewFileSelectionInfo());
        this.showValidationDialogIfApplicable();
        return this.validationInfo.isCloseDialog();
    }

    private void showValidationDialogIfApplicable() {
        if (this.validationInfo == null) {
            return;
        }
        List msgList = this.validationInfo.getMessages();
        if (msgList == null || msgList.isEmpty()) {
            return;
        }
        int msgType = this.validationInfo.getMessagesType();
        if (msgType < 0) {
            return;
        }
        String msg = this.combineMessages(msgList);
        if (msgType == 0) {
            int answer;
            int iconType = 3;
            if (this.validationInfo.getIconType() != -999) {
                iconType = this.validationInfo.getIconType();
            }
            if ((answer = JOptionPane.showConfirmDialog(this, msg, this.validationInfo.getTitle(), 0, iconType)) == 0) {
                this.closeDialog(false);
            }
        } else if (msgType == 1) {
            JOptionPane.showMessageDialog(this, msg);
        }
        this.setFocusAfterSelection();
    }

    private String combineMessages(List msgList) {
        StringBuffer sb = new StringBuffer();
        int numMsgs = msgList.size();
        for (int i = 0; i < numMsgs; ++i) {
            Object msg = msgList.get(i);
            if (msg == null) continue;
            sb.append(msg.toString() + "\n");
        }
        return sb.toString();
    }

    private void setFocusAfterSelection() {
        if (this.validationInfo.getFocusComponent() == null && this.validationInfo.getSelectComponent() == null) {
            return;
        }
        Runnable doRequestFocus = new Runnable(){

            @Override
            public void run() {
                if (RemoteFileSelectorDialog.this.validationInfo.getFocusComponent() != null) {
                    RemoteFileSelectorDialog.this.validationInfo.getFocusComponent().requestFocusInWindow();
                }
                if (RemoteFileSelectorDialog.this.validationInfo.getSelectComponent() != null) {
                    RemoteFileSelectorDialog.this.validationInfo.getSelectComponent().selectAll();
                }
            }
        };
        SwingUtilities.invokeLater(doRequestFocus);
    }

    private void closeDialog(boolean cancel) {
        this.compositePanel.setCancelled(cancel);
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("fileSelectionComplete")) {
            this.validationInfo = this.getSelectionValidator().validate(this.getNewFileSelectionInfo());
            this.showValidationDialogIfApplicable();
            if (this.validationInfo.isCloseDialog()) {
                this.closeDialog(false);
            }
        } else if (evt.getPropertyName().equals("selections") || evt.getPropertyName().equals("FileNameEntryTextInserted") || evt.getPropertyName().equals("FileNameEntryTextDeleted") || evt.getPropertyName().equals("FileNameEntryTextSet")) {
            this.enableActionButton();
        }
    }

    protected void enableActionButton() {
        List selections = this.compositePanel.viewPanel.getViewComponent().getSelections();
        String fileName = this.compositePanel.filePanel.getFileName();
        this.actionButton.setEnabled(RemoteFileVisualsUtil.hasValidSelectionDependingOnSelectionMode(selections, this.compositePanel.getSelectionMode()) || fileName != null && fileName.trim().length() > 0);
    }

    public boolean isAllowNonExistentSelections() {
        return this.allowNonExistentSelections;
    }

    public void setAllowNonExistentSelections(boolean allowNonExistentSelections) {
        this.allowNonExistentSelections = allowNonExistentSelections;
    }

    @Override
    public int getDialogType() {
        return this.dialogType;
    }

    public Action getEscAction() {
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RemoteFileSelectorDialog.this.closeDialog(true);
            }
        };
        return escAction;
    }

    public void setSelectionValidator(FileSelectionValidatorInterface selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    private FileSelectionValidatorInterface getSelectionValidator() {
        if (this.selectionValidator == null && this.compositePanel instanceof FileServicesSelectorInterface) {
            this.selectionValidator = new FileServicesSelectionValidator();
        } else if (this.selectionValidator == null) {
            this.selectionValidator = new FileSelectionValidator();
        }
        return this.selectionValidator;
    }

    private FileSelectionInfo getNewFileSelectionInfo() {
        FileSelectionInfo info = new FileSelectionInfo();
        info.setPanel(this.compositePanel);
        info.setSelections(this.compositePanel.viewPanel.getViewComponent().getSelections());
        info.setNameFieldText(this.compositePanel.filePanel.getFileName());
        info.setAllowNonExistentSelections(this.isAllowNonExistentSelections());
        info.setDialogType(this.getDialogType());
        return info;
    }
}

