/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelDirectoriesOnlyInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RemoteFileNamePanel
extends JPanel
implements PropertyChangeListener {
    private static final String RB_KEY = "RemoteFileSelector.";
    protected JTextField fileNameField;
    private RemoteFileComponentInterface viewComponent;
    private JComboBox fileTypes;
    private JPanel actionButtonPanel;
    private BaseRemoteFileSelectorPanel parentComponent;
    private ActionSupportFilter filter;
    private FileNameFieldDocumentListener fileNameListener;
    private Map filterTypes = null;
    private int applicableTypesIndex = -1;
    private int allTypesIndex = -1;
    private int folderTypeIndex = -1;
    private int dialogType = 0;
    private boolean protectTextField;
    private boolean userInputInNameField;
    private boolean selectionTextInNameField;
    private boolean firstPaint = true;

    public RemoteFileNamePanel(Map fileExtensions, JComponent parent) {
        this.parentComponent = (BaseRemoteFileSelectorPanel)parent;
        this.createFileTypesSelector(fileExtensions);
        JLabel fileTypeLabel = this.createFileTypeLabel();
        this.createFileNameComponent();
        JLabel saveFileLabel = this.createFileNameFieldLabel();
        JPanel saveFileLeft = new JPanel();
        AutoSizingGridLayout saveFileLeftLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        saveFileLeftLayout.setRemainderColumn(0);
        saveFileLeft.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 45));
        saveFileLeft.setLayout((LayoutManager)saveFileLeftLayout);
        saveFileLeft.add(saveFileLabel);
        saveFileLeft.add(this.fileNameField);
        saveFileLeft.add(fileTypeLabel);
        saveFileLeft.add(this.fileTypes);
        AutoSizingGridLayout saveFileRightLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        this.actionButtonPanel = new JPanel((LayoutManager)saveFileRightLayout);
        AutoSizingGridLayout saveFilePanelLayout = new AutoSizingGridLayout(1, 2, 10, 10, true, true, true);
        saveFilePanelLayout.setRemainderColumn(1);
        this.setLayout((LayoutManager)saveFilePanelLayout);
        this.add(saveFileLeft);
        this.add(this.actionButtonPanel);
        this.setDialogType(0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.firstPaint) {
            this.setupFileTypesComboBoxModel();
            int selectedItemIndex = this.getInitialFilterItemIndex(this.parentComponent, this.fileTypes);
            if (this.fileTypes.getModel().getSize() > 0) {
                this.fileTypes.setSelectedIndex(selectedItemIndex == -1 ? 0 : selectedItemIndex);
            }
            this.firstPaint = false;
            if (this.parentComponent.isMultiSelectionEnabled()) {
                this.setFileNameFieldText("");
            }
            if (this.parentComponent.getSelectionMode() == BaseRemoteFileSelectorPanel.FILES_ONLY && !this.protectTextField && this.getFileName() != null) {
                this.setFileNameFieldText("");
            }
        }
        super.paintComponent(g);
    }

    protected JLabel createFileNameFieldLabel() {
        JLabel saveFileLabel = new JLabel(RB.getStringResource(RB_KEY, "saveFileString.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "saveFileMnemonic.txt"))));
        saveFileLabel.setDisplayedMnemonic(keyEvent);
        saveFileLabel.setLabelFor(this.fileNameField);
        return saveFileLabel;
    }

    protected void createFileNameComponent() {
        this.fileNameField = new JTextField(20);
        this.fileNameField.getAccessibleContext().setAccessibleName("FileNameField");
        this.addPropertyChangeListener(this.parentComponent);
        this.fileNameListener = new FileNameFieldDocumentListener();
        this.fileNameField.getDocument().addDocumentListener(this.fileNameListener);
        Runnable doRequestFocus = new Runnable(){

            @Override
            public void run() {
                RemoteFileNamePanel.this.fileNameField.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(doRequestFocus);
    }

    protected JLabel createFileTypeLabel() {
        JLabel fileTypeLabel = new JLabel(RB.getStringResource(RB_KEY, "fileType.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "fileTypeMnemonic.txt"))));
        fileTypeLabel.setDisplayedMnemonic(keyEvent);
        fileTypeLabel.setLabelFor(this.fileTypes);
        return fileTypeLabel;
    }

    protected void createFileTypesSelector(Map fileExtensions) {
        this.filterTypes = fileExtensions;
        this.fileTypes = new JComboBox();
        this.fileTypes.getAccessibleContext().setAccessibleName("FileTypeSelector");
        this.fileTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent menuTypeChoices) {
                int selectionMode = RemoteFileNamePanel.this.parentComponent.getSelectionMode();
                if ((selectionMode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY || selectionMode == BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES) && RemoteFileNamePanel.this.parentComponent.getModel() instanceof RemoteFileModelDirectoriesOnlyInterface) {
                    BaseRemoteFileModelInterface brfsm = RemoteFileNamePanel.this.parentComponent.getModel();
                    int folderItemIndex = RemoteFileNamePanel.getIndexOfFilterItem(RemoteFileNamePanel.this.fileTypes, RB.getStringResource(RemoteFileNamePanel.RB_KEY, "folderType.txt", RemoteFileNamePanel.this.getLocale()));
                    if (RemoteFileNamePanel.this.fileTypes.getSelectedIndex() == folderItemIndex) {
                        ((RemoteFileModelDirectoriesOnlyInterface)((Object)brfsm)).setDirectoriesOnly(true);
                        brfsm.setRefreshNeeded(true);
                        return;
                    }
                    ((RemoteFileModelDirectoriesOnlyInterface)((Object)brfsm)).setDirectoriesOnly(false);
                }
                if (RemoteFileNamePanel.this.fileTypes.getSelectedIndex() == RemoteFileNamePanel.this.applicableTypesIndex && RemoteFileNamePanel.this.parentComponent.getModel() instanceof RemoteFileModel2Interface) {
                    RemoteFileModel2Interface model = (RemoteFileModel2Interface)RemoteFileNamePanel.this.parentComponent.getModel();
                    List filterList = RemoteFileNamePanel.this.getApplicableFiltersList(RemoteFileNamePanel.this.filterTypes);
                    if (!filterList.isEmpty()) {
                        model.setFilterValues(filterList);
                    }
                    model.setRefreshNeeded(true);
                    return;
                }
                RemoteFileNamePanel.this.filter = RemoteFileNamePanel.this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.FILTER_TYPE_FILTER);
                ActionList actions = RemoteFileNamePanel.this.parentComponent.getActionProvider().getActions(RemoteFileNamePanel.this.filter);
                if (actions != null) {
                    List list = actions.getActions();
                    SwingAction action = (SwingAction)list.get(0);
                    try {
                        action.setAttribute("selectedKey", RemoteFileNamePanel.this.fileTypes.getSelectedItem());
                        action.setAttribute("filterTypes", (Object)RemoteFileNamePanel.this.filterTypes);
                    }
                    catch (AttributeSetException attributeSetException) {
                        // empty catch block
                    }
                    action.actionPerformed(new ActionEvent(this, 1, "FilterType"));
                }
            }
        });
    }

    private List getApplicableFiltersList(Map filterTypes) {
        ArrayList applicableTypesList = new ArrayList();
        String folderTypeText = RB.getStringResource(RB_KEY, "folderType.txt", this.getLocale());
        for (Object key : filterTypes.keySet()) {
            Object value;
            if (key == null || !(key instanceof String) || ((String)key).equals(folderTypeText) || !((value = filterTypes.get(key)) instanceof String)) continue;
            if (value == BaseRemoteFileSelectorPanel.ALL_TYPES) continue;
            if (value == BaseRemoteFileSelectorPanel.ALL_APPLICABLE_TYPES) continue;
            applicableTypesList.add(value);
        }
        return applicableTypesList;
    }

    private void setupFileTypesComboBoxModel() {
        if (this.filterTypes == null) {
            this.filterTypes = this.parentComponent.getDefaultFilterTypes();
        }
        this.filterTypes = this.getApplicableFileTypesForDialogType(this.filterTypes);
        Vector tempVector = new Vector(this.filterTypes.keySet());
        int selectionMode = this.parentComponent.getSelectionMode();
        if (selectionMode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY || selectionMode == BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES) {
            this.folderTypeIndex = this.getPositionOfFirstSingleItem(this.filterTypes);
            tempVector.insertElementAt(RB.getStringResource(RB_KEY, "folderType.txt", this.getLocale()), this.folderTypeIndex);
        }
        for (Object key : this.filterTypes.keySet()) {
            if (this.filterTypes.get(key) == BaseRemoteFileSelectorPanel.ALL_APPLICABLE_TYPES) {
                this.applicableTypesIndex = tempVector.indexOf(key);
                continue;
            }
            if (this.filterTypes.get(key) != BaseRemoteFileSelectorPanel.ALL_TYPES) continue;
            this.allTypesIndex = tempVector.indexOf(key);
        }
        this.fileTypes.setModel(new DefaultComboBoxModel(tempVector));
        if (tempVector.size() <= 1) {
            this.fileTypes.setEnabled(false);
        }
    }

    private int getPositionOfFirstSingleItem(Map map) {
        if (map == null) {
            return 0;
        }
        int pos = 0;
        for (Object key : map.keySet()) {
            block8: {
                block7: {
                    if (key == null) {
                        ++pos;
                        continue;
                    }
                    Object value = map.get(key);
                    if (value == null || !(value instanceof String)) {
                        ++pos;
                        continue;
                    }
                    if (value == BaseRemoteFileSelectorPanel.ALL_TYPES) break block7;
                    if (value != BaseRemoteFileSelectorPanel.ALL_APPLICABLE_TYPES) break block8;
                }
                ++pos;
                continue;
            }
            return pos;
        }
        return 0;
    }

    private boolean filterListContainsIndividualFilterType() {
        String folderType = RB.getStringResource(RB_KEY, "folderType.txt", this.getLocale());
        for (Object o : this.filterTypes.keySet()) {
            if (o == null || !(o instanceof String) || ((String)o).equals(folderType)) continue;
            Object value = this.filterTypes.get(o);
            if (value instanceof String) {
                if (value.equals(BaseRemoteFileSelectorPanel.ALL_TYPES)) continue;
            }
            return true;
        }
        return false;
    }

    private int getAllSASFileTypesItemIndex(List filterTypes) {
        String resourceKey = "allSASFileTypes.txt";
        if (this.parentComponent.getModel() instanceof BaseIFileServiceModel) {
            resourceKey = "allfiles.txt";
        }
        String allSASFileTypesText = RB.getStringResource(RB_KEY, resourceKey, this.getLocale());
        int numFilters = filterTypes.size();
        for (int i = 0; i < numFilters; ++i) {
            Object o = filterTypes.get(i);
            if (o == null || !(o instanceof String) || !((String)o).equals(allSASFileTypesText)) continue;
            return i;
        }
        return -1;
    }

    private int getInitialFilterItemIndex(BaseRemoteFileSelectorPanel parentComponent, JComboBox filterTypes) {
        int initialFilterTypeIndex = parentComponent.getInitialFilterTypeIndex();
        if (initialFilterTypeIndex != -1) {
            return initialFilterTypeIndex;
        }
        int selectionMode = parentComponent.getSelectionMode();
        if (selectionMode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY) {
            return RemoteFileNamePanel.getIndexOfFilterItem(filterTypes, RB.getStringResource(RB_KEY, "folderType.txt", this.getLocale()));
        }
        if (this.applicableTypesIndex != -1) {
            return this.applicableTypesIndex;
        }
        if (this.allTypesIndex != -1) {
            return this.allTypesIndex;
        }
        if (this.folderTypeIndex != 0) {
            return 0;
        }
        int numItems = filterTypes.getModel().getSize();
        if (numItems > 1) {
            return 1;
        }
        return 0;
    }

    private static int getIndexOfFilterItem(JComboBox comboBox, String filterItem) {
        ComboBoxModel model = comboBox.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object element = model.getElementAt(i);
            if (element == null || !element.toString().equals(filterItem)) continue;
            return i;
        }
        return -1;
    }

    public void addActionButtons(JButton action, JButton cancel) {
        this.actionButtonPanel.removeAll();
        this.actionButtonPanel.add(action);
        this.actionButtonPanel.add(cancel);
    }

    public void setRemoteFileViewComponent(RemoteFileComponentInterface component) {
        this.viewComponent = component;
        this.viewComponent.addPropertyChangeListener(this);
    }

    public String getFileName() {
        return this.fileNameField.getText();
    }

    public void clearFileNameText() {
        this.fileNameField.setText("");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        List selections;
        if (e.getPropertyName().equals("selections") && !this.parentComponent.isMultiSelectionEnabled() && (selections = this.viewComponent.getSelections()) != null && selections.size() == 1) {
            RemoteFileMetadataInterface fileMetadata = null;
            if (selections.get(0) instanceof RemoteFileMetadataInterface) {
                fileMetadata = (RemoteFileMetadataInterface)selections.get(0);
            }
            if (fileMetadata == null) {
                this.clearFileNameText();
                return;
            }
            int dialogType = -1;
            dialogType = this.parentComponent.getDialog() != null ? this.parentComponent.getDialog().getDialogType() : this.getDialogType();
            int selectionMode = this.parentComponent.getSelectionMode();
            if (selectionMode == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY && !fileMetadata.isFolder()) {
                return;
            }
            if (selectionMode == BaseRemoteFileSelectorPanel.FILES_ONLY && fileMetadata.isFolder()) {
                return;
            }
            this.userInputInNameField = false;
            Object node = null;
            if (selections.size() > 0) {
                node = selections.get(0);
            }
            if (node != null && node instanceof RemoteFileMetadataInterface) {
                this.setFileNameFieldText(((RemoteFileMetadataInterface)node).getName());
                this.selectionTextInNameField = true;
            }
        }
    }

    public void setFileNameFieldText(String fileName) {
        if (fileName == null) {
            return;
        }
        this.fileNameField.getDocument().removeDocumentListener(this.fileNameListener);
        this.fileNameField.setText(fileName);
        this.selectionTextInNameField = false;
        this.firePropertyChange("FileNameEntryTextSet", null, fileName);
        this.fileNameField.getDocument().addDocumentListener(this.fileNameListener);
    }

    public boolean isUserInputInNameField() {
        return this.userInputInNameField;
    }

    public boolean isSelectionTextInNameField() {
        return this.selectionTextInNameField;
    }

    public void setSelectionTextInNameField(boolean selectionTextInNameField) {
        this.selectionTextInNameField = selectionTextInNameField;
    }

    public void componentShown(ComponentEvent componentevent) {
        this.setupFileTypesComboBoxModel();
        int selectedItemIndex = this.getInitialFilterItemIndex(this.parentComponent, this.fileTypes);
        this.fileTypes.setSelectedIndex(selectedItemIndex == -1 ? 0 : selectedItemIndex);
    }

    private Map getApplicableFileTypesForDialogType(Map types) {
        if (this.parentComponent.getDialog() != null && this.parentComponent.getDialog().getDialogType() != 1) {
            return types;
        }
        LinkedHashMap newfileTypes = new LinkedHashMap();
        for (Object key : this.filterTypes.keySet()) {
            Object value = this.filterTypes.get(key);
            if (value == null || !(value instanceof String) || value.equals(BaseRemoteFileSelectorPanel.ALL_APPLICABLE_TYPES) || value.equals(BaseRemoteFileSelectorPanel.ALL_TYPES)) continue;
            newfileTypes.put(key, value);
        }
        return newfileTypes;
    }

    public JComboBox getFileTypes() {
        return this.fileTypes;
    }

    public Map getFilterTypes() {
        return this.filterTypes;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public void setProtectTextField(boolean protectTextField) {
        this.protectTextField = protectTextField;
    }

    public JTextField getFileNameField() {
        return this.fileNameField;
    }

    private class FileNameFieldDocumentListener
    implements DocumentListener {
        private FileNameFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RemoteFileNamePanel.this.userInputInNameField = true;
            RemoteFileNamePanel.this.firePropertyChange("FileNameEntryTextInserted", 0, e.getLength());
            RemoteFileNamePanel.this.selectionTextInNameField = false;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RemoteFileNamePanel.this.firePropertyChange("FileNameEntryTextDeleted", 0, e.getLength());
            RemoteFileNamePanel.this.selectionTextInNameField = false;
        }
    }
}

