/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadata;
import com.sas.visuals.Resources;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class RemoteFileMetadataNameCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final RemoteFileMetadataNameCellRenderer defaultInstance = new RemoteFileMetadataNameCellRenderer();
    private static final ImageIcon folderImage = new ImageIcon(Resources.getImage((String)"Folder"));
    private static final ImageIcon fileImage = new ImageIcon(Resources.getImage((String)"File"));
    private static final ImageIcon repositoryImage = new ImageIcon(Resources.getImage((String)"Repository", (int)16));

    public Icon getIcon(RemoteFileMetadataInterface node) {
        if (node == null) {
            return fileImage;
        }
        if (node instanceof InformationServicesFileMetadata && ((InformationServicesFileMetadata)node).isRepository()) {
            return repositoryImage;
        }
        if (node.isFolder()) {
            return folderImage;
        }
        return fileImage;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
        SortableTableModelAdapter sortableModel = (SortableTableModelAdapter)table.getModel();
        row = sortableModel.convertRowIndexToModel(row);
        RemoteFileMetadataInterface node = ((BaseRemoteFileModelInterface)sortableModel.getModel()).getNodeAt(row);
        this.setIcon(this.getIcon(node));
        if (node != null) {
            this.setText(node.getName());
        }
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setEnabled(table.isEnabled());
        this.setFont(table.getFont());
        return this;
    }
}

