/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.LocationNode;
import com.sas.swing.models.remotefileselector2.LocationToTreeModelAdapter;
import com.sas.swing.models.remotefileselector2.MultipleLocationsToTreeModelAdapter;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.LocationFolderRenderer;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentInterface;
import com.sas.swing.visuals.treecombobox.TreeComboBox;
import com.sas.swing.visuals.util.Util;
import com.sas.util.ValueItem;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeModel;

public class RemoteFileButtonPanel
extends JPanel
implements PropertyChangeListener {
    private static final String RB_KEY = "RemoteFileSelector.";
    private RemoteFileComponentInterface viewComponent;
    private Insets nullInsets = new Insets(0, 0, 0, 0);
    private ActionSupportFilter filter;
    private BaseRemoteFileSelectorPanel parentComponent;
    private LocationToTreeModelAdapter pathAsTreeModel;
    private int previousDirectorySelectionIndex;
    private boolean selectedDirectoryItem;
    private String basePath;
    private MultipleLocationsToTreeModelAdapter multipleRoots;
    protected JToolBar toolBar;
    protected TreeComboBox directorySelection;
    protected JLabel choiceLabel;

    public RemoteFileButtonPanel(BaseRemoteFileSelectorPanel containingComponent) {
        this.parentComponent = containingComponent;
        this.createToolBar();
        this.createLocationSelector();
        this.choiceLabel = this.createLocationLabel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(1, 3, 5, 5, false, false, true);
        buttonLayout.setRemainderColumn(2);
        buttonLayout.setDefaultCellGravity(256);
        this.setLayout((LayoutManager)buttonLayout);
        this.add(this.choiceLabel);
        this.add((Component)this.directorySelection);
        this.add(this.toolBar);
        this.previousDirectorySelectionIndex = this.directorySelection.getSelectedIndex();
        this.selectedDirectoryItem = true;
    }

    protected JLabel createLocationLabel() {
        this.choiceLabel = new JLabel(RB.getStringResource(RB_KEY, "choiceText.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "choiceMnemonic.txt"))));
        this.choiceLabel.setDisplayedMnemonic(keyEvent);
        this.choiceLabel.setLabelFor((Component)this.directorySelection);
        this.choiceLabel.setName("ChoiceLabel");
        return this.choiceLabel;
    }

    private void createLocationSelector() {
        this.directorySelection = new TreeComboBox();
        this.directorySelection.setMaximumRowCount(20);
        this.directorySelection.setName("DirectorySelection");
        this.directorySelection.getAccessibleContext().setAccessibleName(this.directorySelection.getName());
        this.directorySelection.setPreferredSize(new Dimension(200, 26));
        this.directorySelection.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        this.directorySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent directorySelectionEvent) {
                JComboBox cb = (JComboBox)directorySelectionEvent.getSource();
                if (!cb.isPopupVisible()) {
                    RemoteFileButtonPanel.this.setDirectorySelection(cb);
                }
            }
        });
        this.directorySelection.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupEvent) {
                JComboBox cb = (JComboBox)popupEvent.getSource();
                RemoteFileButtonPanel.this.setDirectorySelection(cb);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupEvent) {
            }
        });
        BaseRemoteFileModelInterface rfsModel = this.parentComponent.getModel();
        if (this.parentComponent.isMultipleRootLocationsOn() && rfsModel instanceof RemoteFileModel2Interface) {
            this.multipleRoots = new MultipleLocationsToTreeModelAdapter(((RemoteFileModel2Interface)rfsModel).getLocations());
            this.directorySelection.setRootVisible(false);
            this.directorySelection.setTreeModel((TreeModel)this.multipleRoots);
            LocationFolderRenderer folderRenderer = new LocationFolderRenderer();
            this.directorySelection.setTreeItemsListCellRenderer((ListCellRenderer)((Object)folderRenderer));
        } else {
            this.pathAsTreeModel = new LocationToTreeModelAdapter("", rfsModel);
            this.directorySelection.setTreeModel((TreeModel)this.pathAsTreeModel);
        }
    }

    protected void createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.getAccessibleContext().setAccessibleName("ActionToolBar");
        this.toolBar.setName("ToolBar");
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.populateToolbar(this.toolBar);
    }

    public void setRemoteFileViewComponent(RemoteFileComponentInterface component) {
        this.viewComponent = component;
        this.viewComponent.removePropertyChangeListener(this);
        this.viewComponent.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        BaseRemoteFileModelInterface rfsModel;
        if (e.getPropertyName().equals("path")) {
            rfsModel = this.parentComponent.getModel();
            if (this.parentComponent.isMultipleRootLocationsOn() && rfsModel instanceof RemoteFileModel2Interface) {
                this.updateWithMultipleRootLocations((RemoteFileModel2Interface)rfsModel);
            } else {
                String path = (String)e.getNewValue();
                this.updateWithSingleRootLocation(rfsModel, path);
            }
            this.populateToolbar(this.toolBar);
        }
        if (e.getPropertyName().equals("viewType") && this.toolBar != null) {
            this.populateToolbar(this.toolBar);
        }
        if (e.getPropertyName().equals("locationRootType")) {
            rfsModel = this.parentComponent.getModel();
            if (this.parentComponent.isMultipleRootLocationsOn()) {
                if (this.parentComponent.isMultipleRootLocationsOn() && rfsModel instanceof RemoteFileModel2Interface) {
                    if (this.multipleRoots == null) {
                        this.multipleRoots = new MultipleLocationsToTreeModelAdapter(((RemoteFileModel2Interface)rfsModel).getLocations());
                    } else {
                        this.multipleRoots.refresh(((RemoteFileModel2Interface)rfsModel).getLocations());
                    }
                    this.directorySelection.setRootVisible(false);
                    this.directorySelection.setTreeModel((TreeModel)this.multipleRoots);
                    this.directorySelection.refresh();
                }
            } else {
                if (this.pathAsTreeModel == null) {
                    this.pathAsTreeModel = new LocationToTreeModelAdapter(rfsModel.getLocation(), rfsModel);
                } else {
                    this.pathAsTreeModel.refresh();
                }
                this.directorySelection.setTreeModel((TreeModel)this.pathAsTreeModel);
                this.directorySelection.setRootVisible(true);
                this.directorySelection.refresh();
            }
        }
    }

    private void updateWithSingleRootLocation(BaseRemoteFileModelInterface rfsModel, String path) {
        String defaultPath = null;
        if ((path == null || "".equals(path)) && rfsModel instanceof RemoteFileModel2Interface) {
            if (rfsModel instanceof BaseIFileServiceModel) {
                BaseIFileServiceModel iFileModel = (BaseIFileServiceModel)((Object)rfsModel);
                defaultPath = iFileModel.getDefaultLocation();
            } else {
                defaultPath = ((RemoteFileModel2Interface)rfsModel).getRootLocation();
            }
        }
        this.selectedDirectoryItem = false;
        this.basePath = this.parentComponent.getModel().getBasePath();
        if (this.basePath != null && !this.basePath.equals("")) {
            String[][] pathAndFileNames = this.getLocationsWithoutBase(path, this.basePath);
            this.pathAsTreeModel.refresh(pathAndFileNames);
        } else if (defaultPath != null) {
            this.pathAsTreeModel.refresh(defaultPath);
        } else {
            this.pathAsTreeModel.refresh(path);
        }
        this.directorySelection.refresh();
        this.directorySelection.setSelectedIndex(this.directorySelection.getItemCount() - 1);
        this.selectedDirectoryItem = true;
    }

    private void updateWithMultipleRootLocations(RemoteFileModel2Interface rfsModel) {
        this.multipleRoots.refresh(rfsModel.getLocations());
        this.selectedDirectoryItem = false;
        this.directorySelection.refresh();
        this.directorySelection.setSelectedIndex(rfsModel.getLocationsCurrentPathIndex());
        this.selectedDirectoryItem = true;
    }

    void setDirectorySelection(JComboBox cb) {
        int selectedIndex = cb.getSelectedIndex();
        if (this.selectedDirectoryItem && selectedIndex >= 0 && selectedIndex != this.previousDirectorySelectionIndex) {
            Object dirItem = cb.getSelectedItem();
            if (dirItem instanceof ValueItem) {
                ValueItem valueDirItem = (ValueItem)dirItem;
                if (this.viewComponent != null && valueDirItem != null) {
                    String newDirPath = (String)valueDirItem.getValue();
                    this.parentComponent.getModel().setLocation(newDirPath);
                }
            } else if (dirItem instanceof LocationNode) {
                LocationNode nodeItem = (LocationNode)dirItem;
                if (this.viewComponent != null && nodeItem != null) {
                    String newDirPath = nodeItem.getLocation();
                    this.parentComponent.getModel().setLocation(newDirPath);
                }
            }
            this.parentComponent.filePanel.setSelectionTextInNameField(false);
        }
        this.previousDirectorySelectionIndex = selectedIndex;
    }

    public void setToolTipText(JComponent component, String text) {
        super.setToolTipText(text);
        component.setToolTipText(text);
    }

    protected void populateToolbar(JToolBar toolBar) {
        this.filter = this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.TOOLBAR_FILTER);
        ActionList actions = this.parentComponent.getActionProvider().getActions(this.filter);
        if (actions != null) {
            List list = actions.getActions();
            int size = actions.size();
            for (int i = 0; i < size; ++i) {
                SwingAction action = (SwingAction)list.get(i);
                JButton button = this.findButtonForAction(action);
                if (button != null) {
                    button.setAction((Action)action);
                    continue;
                }
                button = toolBar.add((Action)action);
                button.setMargin(this.nullInsets);
                button.getAccessibleContext().setAccessibleName(action.getActionType());
            }
        }
    }

    protected JButton findButtonForAction(SwingAction action) {
        for (int i = 0; i < this.toolBar.getComponentCount(); ++i) {
            JButton button = (JButton)this.toolBar.getComponentAtIndex(i);
            if (((SwingAction)button.getAction()).getActionType() != action.getActionType()) continue;
            return button;
        }
        return null;
    }

    protected String[][] getLocationsWithoutBase(String location, String basePath) {
        String rootLocation;
        BaseRemoteFileModelInterface selectorModel = this.parentComponent.getModel();
        String[][] parsedCurrentLocation = selectorModel.parseIntoFoldersAndLocations(location);
        if (selectorModel instanceof RemoteFileModel2Interface && (rootLocation = ((RemoteFileModel2Interface)selectorModel).getRootLocation()).equals(location)) {
            String[][] rootOfBase = new String[1][2];
            rootOfBase[0][0] = parsedCurrentLocation[0][0];
            rootOfBase[0][1] = parsedCurrentLocation[0][1];
            return rootOfBase;
        }
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        int numOfParsedLocations = parsedCurrentLocation.length;
        boolean itemsPopulated = false;
        for (int count = 0; count < numOfParsedLocations && !itemsPopulated; ++count) {
            String checkLocation = parsedCurrentLocation[count][0];
            if (basePath != null && !basePath.equals(checkLocation)) {
                locations.add(checkLocation);
                names.add(parsedCurrentLocation[count][1]);
                continue;
            }
            itemsPopulated = true;
        }
        String[][] locationsWithoutBase = new String[locations.size()][2];
        int numOfLocations = locations.size();
        for (int i = 0; i < numOfLocations; ++i) {
            locationsWithoutBase[i][0] = (String)locations.get(i);
            locationsWithoutBase[i][1] = (String)names.get(i);
        }
        return locationsWithoutBase;
    }

    public JLabel getChoiceLabel() {
        return this.choiceLabel;
    }

    public void setChoiceLabel(JLabel choiceLabel) {
        this.choiceLabel = choiceLabel;
    }

    public void refreshToolBarActions() {
        this.toolBar.removeAll();
        this.populateToolbar(this.toolBar);
    }
}

