/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.remotefileselector2.DefaultRFSComparator;
import com.sas.swing.visuals.remotefileselector2.FileMetadataComparator;
import java.util.Locale;
import javax.swing.table.TableModel;

public class RFSSortableTableModelAdapter
extends SortableTableModelAdapter {
    private String rfsTriggerColumnName = null;

    public RFSSortableTableModelAdapter(TableModel model, Locale locale) {
        super(model, true);
        this.setAutoResortEnabled(true);
        DefaultRFSComparator defaultComparatorWithLocale = new DefaultRFSComparator(locale);
        this.setDefaultComparator(defaultComparatorWithLocale);
        FileMetadataComparator comparatorWithLocale = new FileMetadataComparator(locale);
        this.setColumnComparator("FILE_METADATA_COLUMN", comparatorWithLocale);
        this.setCaseSensitive(true);
    }

    private String getTriggerColumn() {
        return this.rfsTriggerColumnName;
    }

    public void rfsSort(String triggerColumnName, int direction) {
        String underlyingColumnName = "FILE_METADATA_COLUMN";
        String[] requestedSortCols = new String[]{underlyingColumnName};
        int[] requestedSortDirections = new int[]{direction};
        this.sortColumns(requestedSortCols, requestedSortDirections);
        this.rfsTriggerColumnName = triggerColumnName;
        this.sortedColumns = this.toStringArray(triggerColumnName);
    }

    public void resort() {
        String triggerColumnName = this.getTriggerColumn();
        String[] underlyingSortColumns = this.getSortedColumns();
        int[] sortDirs = this.getSortedDirections();
        if (triggerColumnName == null && underlyingSortColumns != null && underlyingSortColumns.length > 0) {
            super.resort();
            return;
        }
        if (triggerColumnName == null || sortDirs == null || sortDirs.length < 1) {
            return;
        }
        int sortDirection = sortDirs[0];
        this.rfsSort(triggerColumnName, sortDirection);
    }

    private String[] toStringArray(String string) {
        String[] rval = new String[]{string};
        return rval;
    }
}

