/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.LocaleDataInterface;
import com.sas.swing.models.remotefileselector2.informationservices.BaseInformationServicesModel;
import com.sas.swing.models.remotefileselector2.informationservices.IncludeSystemFoldersInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.swing.visuals.remotefileselector2.ifileservice.IFileServiceDateCellRenderer;
import com.sas.swing.visuals.remotefileselector2.ifileservice.IFileServiceEngineCellRenderer;
import com.sas.swing.visuals.remotefileselector2.ifileservice.IFileServiceSizeCellRenderer;
import com.sas.swing.visuals.remotefileselector2.informationservices.InformationServicesFileMetadataNameCellRenderer;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class InformationServicesSelectorPanel
extends BaseRemoteFileSelectorPanel {
    private static final String RB_KEY = "RemoteFileSelector.";
    private boolean returnInfoInAbsolutePathForm = false;

    public static List showDialog(JFrame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, UserContextInterface user, boolean returnSelectedItem, boolean showDirectoriesOnly, InformationServicesSelectorPanel panel) {
        if (panel == null) {
            panel = new InformationServicesSelectorPanel(initialPath, user, null, showDirectoriesOnly);
        }
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, (BaseRemoteFileSelectorPanel)panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(returnSelectedItem);
    }

    public static List showDialog(JFrame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, ServerInterface server, InformationServicesSelectorPanel panel) {
        if (panel == null) {
            panel = new InformationServicesSelectorPanel(initialPath, server, null);
        }
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, (BaseRemoteFileSelectorPanel)panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(true);
    }

    public InformationServicesSelectorPanel() {
    }

    public InformationServicesSelectorPanel(String initialPath, ServerInterface server, Map fileTypes) {
        this(initialPath, server, fileTypes, false);
    }

    public InformationServicesSelectorPanel(String initialPath, ServerInterface server, Map fileTypes, boolean showDirectoriesOnly) {
        super(showDirectoriesOnly);
        this.setMultipleRootLocationsOn(true);
        InformationServicesNavigationModel rfsModel = new InformationServicesNavigationModel(server);
        this.initialize(initialPath, rfsModel, "REMOTE_INFO_SERVICES_COMPOSITE_SUPPORT", fileTypes, this.getDefaultColumnRenderers(server));
        this.initializeInfoServices(rfsModel);
    }

    public InformationServicesSelectorPanel(String initialPath, ServerInterface server, RepositoryInterface repositoryFilter, Map fileTypes) {
        super(false);
        this.setMultipleRootLocationsOn(true);
        InformationServicesNavigationModel rfsModel = new InformationServicesNavigationModel(server, repositoryFilter);
        this.initialize(initialPath, rfsModel, "REMOTE_INFO_SERVICES_COMPOSITE_SUPPORT", fileTypes, this.getDefaultColumnRenderers(server));
        this.initializeInfoServices(rfsModel);
    }

    @Override
    protected LinkedHashMap getDefaultFilterTypes() {
        LinkedHashMap<String, Object> defaultFilterTypes = new LinkedHashMap<String, Object>();
        defaultFilterTypes.put(RB.getStringResource(RB_KEY, "allSASFileTypes.txt"), ALL_TYPES);
        if (this.getSelectionMode() != BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY) {
            if (this.getDialog() != null && this.getDialog().getDialogType() != 1) {
                defaultFilterTypes.put(RB.getStringResource(RB_KEY, "infomap.txt"), "InformationMap");
            } else {
                defaultFilterTypes.put(RB.getStringResource(RB_KEY, "olapInfomap.txt"), "InformationMap.OLAP");
                defaultFilterTypes.put(RB.getStringResource(RB_KEY, "relationalInfomap.txt"), "InformationMap.Relational");
            }
            defaultFilterTypes.put(RB.getStringResource(RB_KEY, "report.txt"), "Report");
            defaultFilterTypes.put(RB.getStringResource(RB_KEY, "storedprocess.txt"), "StoredProcess");
        }
        return defaultFilterTypes;
    }

    public InformationServicesSelectorPanel(String initialPath, UserContextInterface user, Map fileTypes, boolean showDirectoriesOnly) {
        super(showDirectoriesOnly);
        this.setMultipleRootLocationsOn(true);
        InformationServicesNavigationModel navigationModel = new InformationServicesNavigationModel(user, true);
        this.initialize(initialPath, navigationModel, "REMOTE_INFO_SERVICES_COMPOSITE_SUPPORT", fileTypes, this.getDefaultColumnRenderers(navigationModel.getServer()));
        this.initializeInfoServices(navigationModel);
    }

    private void initializeInfoServices(InformationServicesNavigationModel navigationModel) {
        if (navigationModel != null && navigationModel instanceof LocaleDataInterface) {
            ((LocaleDataInterface)((Object)this.model)).setLocale(this.getLocale());
        }
    }

    @Override
    public TableColumnModel getDisplayedColumns() {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("NAME_COLUMN")));
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("TYPE_COLUMN")));
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("MODIFIED_DATE_COLUMN")));
        return columnModel;
    }

    @Override
    public void updateColumnHeaders(TableColumnModel displayedColumnsModel) {
        Locale locale = this.getLocale();
        this.model = this.getModel();
        Enumeration<TableColumn> e = displayedColumnsModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn fileColumn = e.nextElement();
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("NAME_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "name.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("AUTHOR_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "author.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("MODIFIED_DATE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "modDate.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("KEYWORDS_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "keywords.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() != this.model.getColumnIndex("TYPE_COLUMN")) continue;
            fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "type.txt", locale));
        }
    }

    @Override
    protected Object[] getDefaultColumnRenderers() {
        if (this.getModel() instanceof BaseInformationServicesModel) {
            return this.getDefaultColumnRenderers(((BaseInformationServicesModel)((Object)this.getModel())).getServer());
        }
        return super.getDefaultColumnRenderers();
    }

    private Object[] getDefaultColumnRenderers(ServerInterface server) {
        InformationServicesFileMetadataNameCellRenderer nameCellRenderer = InformationServicesFileMetadataNameCellRenderer.defaultInstance;
        nameCellRenderer.setServer(server);
        return new Object[]{nameCellRenderer, IFileServiceSizeCellRenderer.defaultInstance, IFileServiceDateCellRenderer.defaultInstance, IFileServiceEngineCellRenderer.defaultInstance};
    }

    @Override
    protected List getSelectedItems() {
        List selectedItems = super.getSelectedItems();
        if (!this.isReturnInfoInAbsolutePathForm()) {
            return selectedItems;
        }
        ArrayList<String> selectedItemsInAbsolutePathForm = new ArrayList<String>();
        int numSelectedItems = selectedItems == null ? 0 : selectedItems.size();
        for (int i = 0; i < numSelectedItems; ++i) {
            try {
                String item = (String)selectedItems.get(i);
                selectedItemsInAbsolutePathForm.add(new PathUrl(item).getAbsolutePath());
                continue;
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)InformationServicesSelectorPanel.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return selectedItemsInAbsolutePathForm;
    }

    public boolean isReturnInfoInAbsolutePathForm() {
        return this.returnInfoInAbsolutePathForm;
    }

    public void setReturnInfoInAbsolutePathForm(boolean returnInfoInAbsolutePathForm) {
        this.returnInfoInAbsolutePathForm = returnInfoInAbsolutePathForm;
    }

    public void setShowSystemFolders(boolean show) {
        if (!(this.model instanceof IncludeSystemFoldersInterface)) {
            throw new UnsupportedOperationException("showSystemFolders isn't supported for the model associated with this viewer.");
        }
        ((IncludeSystemFoldersInterface)((Object)this.model)).setIncludeSystemFolders(show);
    }

    public boolean isShowSystemFoldersOn() {
        if (this.model instanceof IncludeSystemFoldersInterface) {
            return ((IncludeSystemFoldersInterface)((Object)this.model)).isIncludeSystemFolders();
        }
        return false;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.model = this.getModel();
        if (this.model != null && this.model instanceof LocaleDataInterface) {
            ((LocaleDataInterface)((Object)this.model)).setLocale(locale);
        }
    }
}

