/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.iom.SAS.IWorkspace;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceNavigationModel;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class IFileServiceSelectorPanel
extends BaseRemoteFileSelectorPanel {
    private static final String RB_KEY = "RemoteFileSelector.";
    private IFileServiceNavigationModel navigationModel;

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, IWorkspace workspace, boolean returnSelectedItems, boolean showDirectoriesOnly) {
        return IFileServiceSelectorPanel.showDialog(parent, titleOfDialog, modal, typeOfDialog, initialPath, workspace, returnSelectedItems, showDirectoriesOnly, null);
    }

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, IWorkspace workspace, int fileSystem) {
        IFileServiceSelectorPanel panel = new IFileServiceSelectorPanel(initialPath, workspace, null, fileSystem);
        return IFileServiceSelectorPanel.showDialog(parent, titleOfDialog, modal, typeOfDialog, initialPath, workspace, true, false, panel);
    }

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, IWorkspace workspace, boolean returnSelectedItems, boolean showDirectoriesOnly, IFileServiceSelectorPanel panel) {
        return IFileServiceSelectorPanel.showDialog(parent, titleOfDialog, modal, typeOfDialog, initialPath, workspace, returnSelectedItems, showDirectoriesOnly, panel, true);
    }

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, IWorkspace workspace, boolean returnSelectedItems, boolean showDirectoriesOnly, IFileServiceSelectorPanel panel, boolean allowNonExistentSelections) {
        if (panel == null) {
            panel = new IFileServiceSelectorPanel(initialPath, workspace, null, showDirectoriesOnly);
        }
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, (BaseRemoteFileSelectorPanel)panel);
        dialog.setAllowNonExistentSelections(allowNonExistentSelections);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(returnSelectedItems);
    }

    public IFileServiceSelectorPanel() {
    }

    public IFileServiceSelectorPanel(String initialPath, IWorkspace workspace, Map fileTypes, boolean showDirectoriesOnly) {
        super(showDirectoriesOnly);
        this.navigationModel = new IFileServiceNavigationModel(workspace);
        this.initialize(initialPath, this.navigationModel, this.supportType, fileTypes);
    }

    @Override
    protected LinkedHashMap getDefaultFilterTypes() {
        LinkedHashMap<String, Object> fileTypes = new LinkedHashMap<String, Object>();
        fileTypes.put(RB.getStringResource(RB_KEY, "allfiles.txt"), ALL_TYPES);
        return fileTypes;
    }

    public IFileServiceSelectorPanel(String initialPath, IWorkspace workspace, Map fileTypes, int fileSystem) {
        super(false);
        this.navigationModel = new IFileServiceNavigationModel(workspace, fileSystem);
        this.initialize(initialPath, this.navigationModel, this.supportType, fileTypes);
    }

    @Override
    public void initialize(String initialPath, BaseRemoteFileModelInterface fsModel, String supportType, Map filterTypes) {
        if ("".equals(initialPath)) {
            fsModel.setLocation("");
        }
        super.initialize(initialPath, fsModel, supportType, filterTypes, null);
    }

    @Override
    public TableColumnModel getDisplayedColumns() {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("NAME_COLUMN")));
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("SIZE_COLUMN")));
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("MODIFIED_DATE_COLUMN")));
        columnModel.addColumn(new TableColumn(this.model.getColumnIndex("ENGINE_COLUMN")));
        return columnModel;
    }

    @Override
    public void updateColumnHeaders(TableColumnModel displayedColumnsModel) {
        Locale locale = this.getLocale();
        this.model = this.getModel();
        Enumeration<TableColumn> e = displayedColumnsModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn fileColumn = e.nextElement();
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("NAME_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "name.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("SIZE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "size.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("MODIFIED_DATE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "modDate.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() != this.model.getColumnIndex("ENGINE_COLUMN")) continue;
            fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "engine.txt", locale));
        }
    }
}

