/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.FileSelectionInfo;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidationInfo;
import com.sas.swing.visuals.remotefileselector2.FileSelectionValidatorInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FileSelectionValidator
implements FileSelectionValidatorInterface {
    private static final String RB_KEY = "RemoteFileSelector.";

    @Override
    public FileSelectionValidationInfo validate(FileSelectionInfo selectionInfo) {
        List selections = selectionInfo.getSelections();
        String fileName = selectionInfo.getNameFieldText();
        if ((selections == null || selections.isEmpty()) && (fileName == null || "".equals(fileName))) {
            return new FileSelectionValidationInfo(0, true);
        }
        int dialogType = selectionInfo.getDialogType();
        BaseRemoteFileSelectorPanel compositePanel = selectionInfo.getPanel();
        boolean saveVerificationOn = dialogType == 1 && compositePanel.isSaveVerificationOn();
        int selectionMode = compositePanel.getSelectionMode();
        if (selectionMode == BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES) {
            if (selections != null && !selections.isEmpty()) {
                if (!saveVerificationOn) {
                    return new FileSelectionValidationInfo(1, true);
                }
                return this.getExistingItemValidationInfo(selections, null, compositePanel);
            }
        } else if (RemoteFileVisualsUtil.listContainsItemByType(selections, selectionMode == BaseRemoteFileSelectorPanel.FILES_ONLY ? 1 : 0)) {
            if (!saveVerificationOn) {
                return new FileSelectionValidationInfo(1, true);
            }
            String filesWithWriteDenied = this.getWriteDeniedFiles(selectionInfo, selections);
            if (!filesWithWriteDenied.equals("")) {
                return this.getWriteDeniedValidationInfo(filesWithWriteDenied);
            }
            return this.getExistingItemValidationInfo(selections, null, compositePanel);
        }
        if (selectionMode == BaseRemoteFileSelectorPanel.FILES_ONLY && selections != null && selections.size() == 1) {
            RemoteFileMetadataInterface node = (RemoteFileMetadataInterface)selections.get(0);
            compositePanel.getModel().setLocation(node.getLocation());
            return new FileSelectionValidationInfo(0, false);
        }
        return this.processNameFieldValue(selectionInfo, fileName, saveVerificationOn);
    }

    private String getWriteDeniedFiles(FileSelectionInfo selectionInfo, List selections) {
        BaseRemoteFileModelInterface panelModel = selectionInfo.getPanel().getModel();
        RemoteFileModel2Interface rfsModel = (RemoteFileModel2Interface)panelModel;
        return RemoteFileVisualsUtil.checkWritePermissionsOnFiles(selections, rfsModel);
    }

    protected FileSelectionValidationInfo processNameFieldValue(FileSelectionInfo selectionInfo, String fileName, boolean saveVerificationOn) {
        if (fileName == null || "".equals(fileName)) {
            return new FileSelectionValidationInfo(0, false);
        }
        BaseRemoteFileModelInterface panelModel = selectionInfo.getPanel().getModel();
        if (!(panelModel instanceof RemoteFileModel2Interface)) {
            return new FileSelectionValidationInfo(0, false);
        }
        BaseRemoteFileSelectorPanel panel = selectionInfo.getPanel();
        RemoteFileModel2Interface rfsModel = (RemoteFileModel2Interface)panelModel;
        String[] fileInfo = rfsModel.getFileInfo(rfsModel.getValidName(fileName));
        if (!panel.isUserInputInNameField()) {
            if (selectionInfo.getDialogType() == 1 && panel.getSelectionMode() != BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY && !RemoteFileVisualsUtil.isValidLocationForSave(rfsModel, fileInfo, fileName)) {
                return this.getNoSelectionsAtRootValidationInfo();
            }
            if (panel.getSelectionMode() == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY) {
                return new FileSelectionValidationInfo(1, true);
            }
        }
        if (fileInfo[0] == null) {
            return this.getFileNotDisplayedInViewerSelectionValidationInfo(selectionInfo, fileName, saveVerificationOn, panel, rfsModel, fileInfo);
        }
        String itemType = fileInfo[0];
        String itemLocation = fileInfo[1];
        if (itemType.equals("FOLDER")) {
            return this.getFolderSelectionValidationInfo(selectionInfo, fileName, saveVerificationOn, panel, rfsModel, itemLocation);
        }
        return this.getFileSelectionValidationInfo(selectionInfo, fileName, saveVerificationOn, panel, rfsModel, fileInfo);
    }

    private FileSelectionValidationInfo getFileSelectionValidationInfo(FileSelectionInfo selectionInfo, String fileName, boolean saveVerificationOn, BaseRemoteFileSelectorPanel panel, RemoteFileModel2Interface rfsModel, String[] fileInfo) {
        if (panel.getSelectionMode() == BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY) {
            return this.getInvalidTypeValidationInfo(fileName, panel);
        }
        if (saveVerificationOn) {
            if (fileInfo.length > 2 && fileInfo[2] != null) {
                if (fileInfo[2] == "WRITE_PERMISSIONS_DENIED") {
                    return this.getWriteDeniedValidationInfo(fileName);
                }
                Map filterTypes = panel.filePanel.getFilterTypes();
                if (filterTypes != null && !RemoteFileVisualsUtil.isTypeTheSame(fileInfo[2], filterTypes.get(panel.filePanel.getFileTypes().getSelectedItem()))) {
                    if (!selectionInfo.isAllowNonExistentSelections()) {
                        return this.newNonExistingItemValidationInfo(rfsModel.getValidName(fileName), panel);
                    }
                    if (selectionInfo.getDialogType() == 1 && saveVerificationOn && !RemoteFileVisualsUtil.hasWritePermissionsOnCurrentFolder(rfsModel)) {
                        ArrayList<String> msgList = new ArrayList<String>();
                        msgList.add(RB.getStringResource(RB_KEY, "notAuthorizedToSaveInFolder.txt"));
                        return new FileSelectionValidationInfo(msgList, 1);
                    }
                    return new FileSelectionValidationInfo(1, true);
                }
            }
            return this.getExistingItemValidationInfo(null, rfsModel.getValidName(fileName), panel);
        }
        if (selectionInfo.getDialogType() == 1 && !RemoteFileVisualsUtil.isValidLocationForSave(rfsModel, fileInfo, fileName)) {
            return this.getNoSaveAtRootValidationInfo();
        }
        return new FileSelectionValidationInfo(1, true);
    }

    private FileSelectionValidationInfo getFolderSelectionValidationInfo(FileSelectionInfo selectionInfo, String fileName, boolean saveVerificationOn, BaseRemoteFileSelectorPanel panel, RemoteFileModel2Interface rfsModel, String itemLocation) {
        if (panel.isOpenSelectedFolderItemOn()) {
            panel.getModel().setLocation(itemLocation != null ? itemLocation : fileName);
            panel.filePanel.fileNameField.setText("");
            return new FileSelectionValidationInfo(0, false);
        }
        if (selectionInfo.getPanel().getSelectionMode() == BaseRemoteFileSelectorPanel.FILES_ONLY && saveVerificationOn) {
            String typeToCheck = null;
            Object selectedTypeFromPanel = panel.filePanel.getFileTypes().getSelectedItem();
            Map filterTypes = panel.filePanel.getFilterTypes();
            if (selectedTypeFromPanel instanceof String && filterTypes != null) {
                typeToCheck = (String)filterTypes.get(selectedTypeFromPanel);
                if (rfsModel.isFileDuplicate(rfsModel.getLocation(), fileName, typeToCheck)) {
                    String[] fileInfoForType = rfsModel.getFileInfo(rfsModel.getLocation(), rfsModel.getValidName(fileName), typeToCheck);
                    if (fileInfoForType != null) {
                        if (fileInfoForType[0] == null) {
                            if (!selectionInfo.isAllowNonExistentSelections()) {
                                return this.newNonExistingItemValidationInfo(rfsModel.getValidName(fileName), panel);
                            }
                            return this.getNotVisibleDuplicateValidationInfo(rfsModel.getValidName(fileName));
                        }
                        if (fileInfoForType[2] == "WRITE_PERMISSIONS_DENIED") {
                            return this.getWriteDeniedValidationInfo(rfsModel.getValidName(fileName));
                        }
                        return this.getExistingItemValidationInfo(null, rfsModel.getValidName(fileName), panel);
                    }
                } else if (!selectionInfo.isAllowNonExistentSelections()) {
                    return this.newNonExistingItemValidationInfo(rfsModel.getValidName(fileName), panel);
                }
            }
        }
        if (!RemoteFileVisualsUtil.isValidLocationForSelection(rfsModel, fileName, panel.isRootFolderSelectable())) {
            return this.getNoSelectionsAtRootValidationInfo();
        }
        return new FileSelectionValidationInfo(1, true);
    }

    private FileSelectionValidationInfo getFileNotDisplayedInViewerSelectionValidationInfo(FileSelectionInfo selectionInfo, String fileName, boolean saveVerificationOn, BaseRemoteFileSelectorPanel panel, RemoteFileModel2Interface rfsModel, String[] fileInfo) {
        if (!selectionInfo.isAllowNonExistentSelections()) {
            return this.newNonExistingItemValidationInfo(rfsModel.getValidName(fileName), panel);
        }
        if (selectionInfo.getDialogType() == 1 && !RemoteFileVisualsUtil.isValidLocationForSave(rfsModel, fileInfo, fileName)) {
            return this.getNoSaveAtRootValidationInfo();
        }
        if (selectionInfo.isAllowNonExistentSelections() && selectionInfo.getPanel().getSelectionMode() == BaseRemoteFileSelectorPanel.FILES_ONLY) {
            String notValidNameMessage = rfsModel.getValidNameStatus(fileName);
            if (notValidNameMessage != null) {
                return this.getInvalidNameValidationInfo(notValidNameMessage);
            }
            if (saveVerificationOn) {
                Object selectedTypeFromPanel = panel.filePanel.getFileTypes().getSelectedItem();
                Map filterTypes = panel.filePanel.getFilterTypes();
                String selectedFileType = null;
                if (selectedTypeFromPanel instanceof String && filterTypes != null) {
                    selectedFileType = (String)filterTypes.get(selectedTypeFromPanel);
                    if (rfsModel.isFileDuplicate(rfsModel.getLocation(), fileName, selectedFileType)) {
                        return this.getNotVisibleDuplicateValidationInfo(fileName);
                    }
                }
            }
        }
        if (selectionInfo.getDialogType() == 1 && saveVerificationOn && !RemoteFileVisualsUtil.hasWritePermissionsOnCurrentFolder(rfsModel)) {
            ArrayList<String> msgList = new ArrayList<String>();
            msgList.add(RB.getStringResource(RB_KEY, "notAuthorizedToSaveInFolder.txt"));
            return new FileSelectionValidationInfo(msgList, 1);
        }
        return new FileSelectionValidationInfo(1, true);
    }

    private FileSelectionValidationInfo getWriteDeniedValidationInfo(String fileName) {
        ArrayList<String> msgList = new ArrayList<String>();
        String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "noWritePermissions.txt"), fileName);
        msgList.add(msg);
        return new FileSelectionValidationInfo(msgList, 1, fileName);
    }

    private FileSelectionValidationInfo getNotVisibleDuplicateValidationInfo(String fileName) {
        ArrayList<String> msgList = new ArrayList<String>();
        String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "existingItemIsNotVisibleMessage.txt"), fileName);
        msgList.add(msg);
        return new FileSelectionValidationInfo(msgList, 1, fileName);
    }

    private FileSelectionValidationInfo getInvalidTypeValidationInfo(String itemName, BaseRemoteFileSelectorPanel panel) {
        ArrayList<String> msgList = new ArrayList<String>();
        String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "nonFolderSelectedMessage.txt"), itemName);
        msgList.add(msg);
        return new FileSelectionValidationInfo(msgList, 1, itemName, panel.filePanel.fileNameField, panel.filePanel.fileNameField);
    }

    private FileSelectionValidationInfo newNonExistingItemValidationInfo(String itemName, BaseRemoteFileSelectorPanel panel) {
        ArrayList<String> msgList = new ArrayList<String>();
        String msg = MessageFormat.format(RB.getStringResource(RB_KEY, "unavailablePathMessage.txt"), itemName);
        msgList.add(msg);
        return new FileSelectionValidationInfo(msgList, 1, itemName, panel.filePanel.fileNameField, panel.filePanel.fileNameField);
    }

    private FileSelectionValidationInfo getExistingItemValidationInfo(List selections, String fileName, BaseRemoteFileSelectorPanel panel) {
        String itemName = fileName != null ? fileName : RemoteFileVisualsUtil.getSelectedItemText(selections.get(0));
        ArrayList<String> msgList = new ArrayList<String>();
        String msg = MessageFormat.format(RB.getStringResource(RB_KEY, selections != null && selections.size() > 1 ? "multipleExistingItemsMessage.txt" : "existingItemMessage.txt"), itemName);
        msgList.add(msg);
        FileSelectionValidationInfo fileSelectionValidationInfo = new FileSelectionValidationInfo(msgList, 0, itemName, panel.filePanel.fileNameField, panel.filePanel.fileNameField);
        fileSelectionValidationInfo.setTitle(RB.getStringResource(RB_KEY, "saveText.txt"));
        fileSelectionValidationInfo.setIconType(2);
        return fileSelectionValidationInfo;
    }

    private FileSelectionValidationInfo getNoSaveAtRootValidationInfo() {
        ArrayList<String> msgList = new ArrayList<String>();
        msgList.add(RB.getStringResource(RB_KEY, "invalidLocation.txt"));
        return new FileSelectionValidationInfo(msgList, 1);
    }

    private FileSelectionValidationInfo getNoSelectionsAtRootValidationInfo() {
        ArrayList<String> msgList = new ArrayList<String>();
        msgList.add(RB.getStringResource(RB_KEY, "invalidSelectionOfRoot.txt"));
        return new FileSelectionValidationInfo(msgList, 1);
    }

    private FileSelectionValidationInfo getInvalidNameValidationInfo(String invalidNameMessage) {
        ArrayList<String> msgList = new ArrayList<String>();
        msgList.add(invalidNameMessage);
        return new FileSelectionValidationInfo(msgList, 1);
    }
}

