/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector2;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.SwingActionProviderViewInterface;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelDirectoriesOnlyInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import com.sas.swing.visuals.remotefileselector2.RemoteFileButtonPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentInterface;
import com.sas.swing.visuals.remotefileselector2.RemoteFileComponentPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileMetadataNameCellRenderer;
import com.sas.swing.visuals.remotefileselector2.RemoteFileNamePanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialogInterface;
import com.sas.swing.visuals.remotefileselector2.RemoteFileShortcutPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileTableComponent;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import com.sas.swing.visuals.remotefileselector2.ifileservice.IFileServiceDateCellRenderer;
import com.sas.swing.visuals.remotefileselector2.ifileservice.IFileServiceEngineCellRenderer;
import com.sas.swing.visuals.remotefileselector2.ifileservice.IFileServiceSizeCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseRemoteFileSelectorPanel
extends JPanel
implements SwingActionProviderViewInterface,
ContentsChangedListener,
PropertyChangeListener {
    public static Object ALL_TYPES = "*";
    public static final Object ALL_APPLICABLE_TYPES = "ALL_APPLICABLE_TYPES";
    public static final String RB_KEY = "RemoteFileSelector.";
    public static final String ALL_SAS_TYPES_RESOURCE_KEY = "allSASFileTypes.txt";
    public static final String ALL_APPLICABLE_TYPES_RESOURCE_KEY = "allApplicableSASFileTypes.txt";
    private boolean[] showPanel = new boolean[]{true, true, true};
    private boolean showDirectoriesOnly;
    protected LinkedHashMap fileTypes;
    private boolean rootFolderSelectable = false;
    public static int TOOLBAR_FILTER = 0;
    public static int TABLE_DATA_FILTER = 1;
    public static int TABLE_HEADER_FILTER = 2;
    public static int DRILL_DOWN_FILTER = 4;
    public static int FILTER_TYPE_FILTER = 5;
    public static int FILES_AND_DIRECTORIES = 0;
    public static int FILES_ONLY = 1;
    public static int DIRECTORIES_ONLY = 2;
    protected static boolean cancelled;
    protected RemoteFileComponentInterface component;
    public RemoteFileNamePanel filePanel;
    public RemoteFileButtonPanel buttonPanel;
    public RemoteFileShortcutPanel shortcutPanel;
    public RemoteFileComponentPanel viewPanel;
    public String supportType;
    protected BaseRemoteFileModelInterface model;
    protected ActionSupportFilter toolbarFilter;
    protected ActionSupportFilter drillDownFilter;
    protected ActionSupportFilter filterTypeFilter;
    protected SwingViewerSupport viewerSupport;
    private CommonLoggerInterface log = this.log = LoggerRepository2.getLogger((String)BaseRemoteFileSelectorPanel.class.getPackage().getName(), null);
    private boolean openSelectedFolderItem;
    private int selectionMode;
    private boolean multiSelectionEnabled;
    private boolean multipleRootLocationsActive;
    private boolean saveVerification;
    private int initialFilterTypeIndex;
    private boolean groupFilterTypesAsAllApplicableTypes = false;
    private String[] folderSelections;
    private String[] fileSelections;
    private RemoteFileSelectorDialogInterface dialog = null;
    private boolean initializing = false;
    private Cursor waitCursor;

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, BaseRemoteFileModelInterface fsModel, boolean returnSelectedItems, boolean showDirectoriesOnly) {
        return BaseRemoteFileSelectorPanel.showDialog(parent, titleOfDialog, modal, typeOfDialog, initialPath, fsModel, returnSelectedItems, showDirectoriesOnly, true);
    }

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, BaseRemoteFileModelInterface fsModel, boolean returnSelectedItems, boolean showDirectoriesOnly, boolean allowNonExistentSelections) {
        BaseRemoteFileSelectorPanel panel = new BaseRemoteFileSelectorPanel(initialPath, fsModel, null, showDirectoriesOnly);
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, panel);
        dialog.setAllowNonExistentSelections(allowNonExistentSelections);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(returnSelectedItems);
    }

    public BaseRemoteFileSelectorPanel() {
        this(null, null, null, false);
    }

    public BaseRemoteFileSelectorPanel(boolean showDirectoriesOnly) {
        this(null, null, null, showDirectoriesOnly);
    }

    public BaseRemoteFileSelectorPanel(String initialPath, BaseRemoteFileModelInterface fsModel, Map filterTypes, boolean showDirectoriesOnly) {
        this.showDirectoriesOnly = showDirectoriesOnly;
        this.setShowShortcutPanel(false);
        if (fsModel != null) {
            this.initialize(initialPath, fsModel, null, filterTypes);
        }
    }

    public void initialize(String initialPath, BaseRemoteFileModelInterface fsModel, String supportType, Map filterTypes) {
        this.initialize(initialPath, fsModel, supportType, filterTypes, null);
    }

    public void initialize(String initialPath, BaseRemoteFileModelInterface fsModel, String supportType, Map filterTypes, Object[] columnRenderers) {
        this.initializing = true;
        this.model = fsModel;
        this.waitCursor = new Cursor(3);
        this.setCancelled(true);
        this.setInitialFilterTypeIndex(-1);
        this.setFileTypes(filterTypes);
        this.setMultiSelectionEnabled(true);
        this.setSaveVerificationOn(true);
        this.setupActionProviderFilters(initialPath, supportType);
        this.createViewComponents();
        this.component.setColumnRenderers(columnRenderers == null ? this.getDefaultColumnRenderers() : columnRenderers);
        if (this.model instanceof RemoteFileModel2Interface) {
            if (this.model instanceof RemoteFileModelDirectoriesOnlyInterface) {
                ((RemoteFileModelDirectoriesOnlyInterface)((Object)this.model)).setDirectoriesOnly(this.showDirectoriesOnly);
            }
            ((RemoteFileModel2Interface)this.model).addPropertyChangeListener(this);
        }
        if (initialPath != null && !"".equals(initialPath)) {
            this.model.setLocation(initialPath);
        } else {
            this.model.setRefreshNeeded(true);
        }
        if (this.showDirectoriesOnly) {
            this.setSelectionMode(DIRECTORIES_ONLY);
        } else {
            this.setSelectionMode(FILES_ONLY);
        }
        this.initializing = false;
    }

    protected void createViewComponents() {
        if (this.showPanel[0]) {
            this.buttonPanel = new RemoteFileButtonPanel(this);
            this.buttonPanel.getAccessibleContext().setAccessibleName("ActionPanel");
        }
        if (this.showPanel[1]) {
            this.filePanel = new RemoteFileNamePanel(this.fileTypes, this);
            this.filePanel.getAccessibleContext().setAccessibleName("NamePanel");
        }
        if (this.showPanel[2]) {
            this.shortcutPanel = new RemoteFileShortcutPanel(null);
        }
        if (this.buttonPanel != null) {
            this.addPropertyChangeListener(this.buttonPanel);
            this.buttonPanel.setRemoteFileViewComponent(this.component);
        }
        if (this.filePanel != null) {
            this.filePanel.setRemoteFileViewComponent(this.component);
        }
        if (this.viewPanel != null) {
            this.addPropertyChangeListener(this.viewPanel);
            this.viewPanel.getViewComponent().addPropertyChangeListener(this);
        }
        if (this.shortcutPanel != null) {
            AutoSizingGridLayout compositeLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
            compositeLayout.setIgnoreSizeOfNonVisibleComponents(true);
            this.setLayout((LayoutManager)compositeLayout);
            this.add(this.shortcutPanel);
            JPanel mainPanel = new JPanel();
            AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
            mainLayout.setRemainderRow(2);
            mainPanel.setLayout((LayoutManager)mainLayout);
            if (this.buttonPanel != null) {
                mainPanel.add(this.buttonPanel);
            }
            if (this.viewPanel != null) {
                mainPanel.add(this.viewPanel);
            }
            if (this.filePanel != null) {
                mainLayout.setDefaultCellGravity(2);
                mainPanel.add(this.filePanel);
            }
            this.add(mainPanel);
        } else {
            AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
            mainLayout.setRemainderRow(2);
            this.setLayout((LayoutManager)mainLayout);
            this.removeAll();
            if (this.buttonPanel != null) {
                this.add(this.buttonPanel);
            }
            if (this.viewPanel != null) {
                this.add(this.viewPanel);
            }
            if (this.filePanel != null) {
                mainLayout.setDefaultCellGravity(2);
                this.add(this.filePanel);
            }
        }
    }

    private void setupActionProviderFilters(String initialPath, String apType) {
        this.supportType = apType == null ? "REMOTE_FILE_SELECTOR2_COMPOSITE_SUPPORT" : apType;
        this.viewerSupport = new SwingViewerSupport((ActionProviderViewInterface)this);
        if (this.supportType.equals("REMOTE_FILE_SELECTOR2_COMPOSITE_SUPPORT") || this.supportType.equals("REMOTE_INFO_SERVICES_COMPOSITE_SUPPORT") || this.supportType.equals("NAVIGATION_SERVICE_COMPOSITE_SUPPORT")) {
            this.viewerSupport.setActionSupportType(this.supportType);
            this.drillDownFilter = new ActionSupportFilter(this.getActionSupportType(), "DRILL_DOWN_AREA", (ActionProviderViewInterface)this);
            this.toolbarFilter = new ActionSupportFilter(this.getActionSupportType(), "TOOLBAR_AREA", (ActionProviderViewInterface)this);
            this.filterTypeFilter = new ActionSupportFilter(this.getActionSupportType(), "FILTER_TYPE_AREA", (ActionProviderViewInterface)this);
        }
        this.viewPanel = new RemoteFileComponentPanel(this);
        this.viewPanel.getAccessibleContext().setAccessibleName("ViewPanel");
        this.component = this.viewPanel.getViewComponent();
        this.component.setShowDirectoriesOnly(this.showDirectoriesOnly);
        if (this.getActionProvider() == null) {
            this.setActionProvider(new SwingActionProvider());
        }
        this.component.setActionProvider(this.getActionProvider());
        try {
            this.drillDownFilter.setAttribute("path", (Object)initialPath);
            this.toolbarFilter.setAttribute("model", (Object)this.model);
            this.toolbarFilter.setAttribute("component", (Object)this.component);
            this.toolbarFilter.setAttribute("previousPath", (Object)this.component.getPreviousPath());
            this.filterTypeFilter.setAttribute("model", (Object)this.model);
            this.filterTypeFilter.setAttribute("filterTypes", (Object)this.fileTypes);
        }
        catch (AttributeSetException ase) {
            this.log.error(ase.getMessage(), (Throwable)ase);
        }
        this.viewPanel.setModel(this.model);
    }

    protected void setFileTypes(Map filterTypes) {
        if (filterTypes != null) {
            this.fileTypes = new LinkedHashMap(filterTypes);
        }
    }

    protected LinkedHashMap getDefaultFilterTypes() {
        LinkedHashMap<String, String> defaultFilterTypes = new LinkedHashMap<String, String>();
        defaultFilterTypes.put("All Files", "*");
        return defaultFilterTypes;
    }

    public void setCancelled(boolean value) {
        cancelled = value;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    public void setShowDirectoriesOnly(boolean showDirectoriesOnly) {
        this.showDirectoriesOnly = showDirectoriesOnly;
        if (showDirectoriesOnly && this.getSelectionMode() != DIRECTORIES_ONLY) {
            this.setSelectionMode(DIRECTORIES_ONLY);
        }
    }

    public boolean isShowDirectoriesOnly() {
        return this.showDirectoriesOnly;
    }

    public void setShowButtonPanel(boolean show) {
        this.showPanel[0] = show;
    }

    public void setShowFileNamePanel(boolean show) {
        this.showPanel[1] = show;
        if (this.filePanel != null && show != this.filePanel.isVisible()) {
            this.filePanel.setVisible(show);
            if (!show) {
                this.remove(this.filePanel);
                if (this.model != null) {
                    this.model.setRefreshNeeded(true);
                }
            } else {
                this.add(this.filePanel);
                this.validate();
            }
        }
    }

    public void setShowShortcutPanel(boolean show) {
        this.showPanel[2] = show;
    }

    public RemoteFileComponentInterface getViewComponent() {
        return this.component;
    }

    public List getReturnedInformation(boolean returnSelectedItems) {
        if (returnSelectedItems) {
            return this.getSelectedItems();
        }
        return null;
    }

    public List getSelectedItemObjects() {
        return this.component.getSelections();
    }

    protected List getSelectedItems() {
        if (this.selectionMode == DIRECTORIES_ONLY) {
            return this.getSelectedItemsForDirOnlyMode();
        }
        return this.getSelectedItemsForNonDirectoriesOnlyMode();
    }

    private List getSelectedItemsForNonDirectoriesOnlyMode() {
        ArrayList fileNamesWithLocations = new ArrayList();
        List selections = this.component.getSelections();
        String entryFile = this.filePanel.getFileName();
        if (selections != null && !selections.isEmpty()) {
            int[] validSelectionIndexes = RemoteFileVisualsUtil.getValidSelectionIndexesDependingOnSelectionMode(selections, this.getSelectionMode());
            if (validSelectionIndexes != null) {
                this.updateFileListBasedOnValidIndexesArray(selections, fileNamesWithLocations, validSelectionIndexes);
            }
        } else if (entryFile != null && !"".equals(entryFile)) {
            BaseRemoteFileModelInterface rfsModel = this.getModel();
            if (rfsModel instanceof RemoteFileModel2Interface) {
                entryFile = ((RemoteFileModel2Interface)rfsModel).getValidName(entryFile);
            }
            this.updateFileListBasedOnEntryField(this.getModel(), fileNamesWithLocations, entryFile, false);
        }
        return fileNamesWithLocations;
    }

    private List getSelectedItemsForDirOnlyMode() {
        ArrayList<String> fileNamesWithLocations = new ArrayList<String>();
        List selections = this.component.getSelections();
        int[] validSelectionIndexes = RemoteFileVisualsUtil.getValidSelectionIndexesDependingOnSelectionMode(selections, this.getSelectionMode());
        if (validSelectionIndexes != null) {
            return this.updateFileListBasedOnValidIndexesArray(selections, fileNamesWithLocations, validSelectionIndexes);
        }
        String entryFile = this.filePanel.getFileName();
        if (entryFile == null || "".equals(entryFile)) {
            String location;
            if (this.getModel() instanceof RemoteFileModel2Interface && (location = this.getModel().getLocation()) != null) {
                fileNamesWithLocations.add(location);
            }
            return fileNamesWithLocations;
        }
        BaseRemoteFileModelInterface fileModel = this.getModel();
        if (!(this.isUserInputInNameField() || this.multiSelectionEnabled || this.isSelectionTextInNameField())) {
            fileNamesWithLocations.add(fileModel.getLocation());
            return fileNamesWithLocations;
        }
        if (!(fileModel instanceof RemoteFileModel2Interface)) {
            fileNamesWithLocations.add(entryFile);
            return fileNamesWithLocations;
        }
        RemoteFileModel2Interface rfsModel = (RemoteFileModel2Interface)fileModel;
        String[] fileInfo = rfsModel.getFileInfo(entryFile = rfsModel.getValidName(entryFile));
        if (fileInfo[0] == null) {
            if (!RemoteFileVisualsUtil.startsWithValidAbsolutePathIndentifier(rfsModel, entryFile)) {
                fileNamesWithLocations.add(rfsModel.buildFullyQualifiedLocation(fileModel.getLocation(), entryFile));
            } else {
                fileNamesWithLocations.add(entryFile);
            }
        } else {
            fileNamesWithLocations.add(fileInfo[1]);
        }
        return fileNamesWithLocations;
    }

    private List updateFileListBasedOnValidIndexesArray(List selections, List fileNamesWithLocations, int[] validSelectionIndexes) {
        for (int i = 0; i < validSelectionIndexes.length && validSelectionIndexes[i] != -1; ++i) {
            Object node = selections.get(validSelectionIndexes[i]);
            if (node instanceof RemoteFileMetadataInterface) {
                fileNamesWithLocations.add(((RemoteFileMetadataInterface)node).getLocation().toString());
                continue;
            }
            fileNamesWithLocations.add(node.toString());
        }
        return fileNamesWithLocations;
    }

    private void updateFileListBasedOnEntryField(BaseRemoteFileModelInterface fileModel, List fileNamesWithLocations, String entryFile, boolean nameFieldPopulatedViaSelection) {
        if (entryFile == null || "".equals(entryFile)) {
            return;
        }
        if (!(fileModel instanceof RemoteFileModel2Interface)) {
            fileNamesWithLocations.add(entryFile);
            return;
        }
        if (!(this.getSelectionMode() == FILES_ONLY || this.isUserInputInNameField() || this.multiSelectionEnabled || nameFieldPopulatedViaSelection)) {
            fileNamesWithLocations.add(fileModel.getLocation());
            return;
        }
        RemoteFileModel2Interface rfsModel = (RemoteFileModel2Interface)fileModel;
        String[] fileInfo = rfsModel.getFileInfo(entryFile);
        if (fileInfo[0] == null) {
            if (!RemoteFileVisualsUtil.startsWithValidAbsolutePathIndentifier(rfsModel, entryFile)) {
                if (this.getSelectionMode() == FILES_ONLY && this.getDialog() != null && this.getDialog().getDialogType() == 1) {
                    this.loadFilePathAndIncludeType(fileNamesWithLocations, entryFile, rfsModel);
                } else {
                    fileNamesWithLocations.add(rfsModel.buildFullyQualifiedLocation(rfsModel.getLocation(), entryFile));
                }
            } else {
                fileNamesWithLocations.add(entryFile);
            }
        } else if (this.getSelectionMode() == FILES_ONLY && !this.isOpenSelectedFolderItemOn() && "FOLDER".equalsIgnoreCase(fileInfo[0]) && this.getDialog() != null && this.getDialog().getDialogType() == 1 && this.isUserInputInNameField()) {
            this.loadFilePathAndIncludeType(fileNamesWithLocations, entryFile, rfsModel);
        } else {
            fileNamesWithLocations.add(fileInfo[1]);
        }
    }

    private void loadFilePathAndIncludeType(List fileNamesWithLocations, String entryFile, RemoteFileModel2Interface rfsModel) {
        Object fileTypeObj;
        String fileType = null;
        String[] fileInfoForType = null;
        Map filterTypes = this.filePanel.getFilterTypes();
        if (filterTypes != null && (fileTypeObj = filterTypes.get(this.filePanel.getFileTypes().getSelectedItem())) instanceof String && !(fileType = (String)fileTypeObj).equals("*")) {
            fileInfoForType = rfsModel.getFileInfo(rfsModel.getLocation(), entryFile, fileType);
        }
        if (fileInfoForType != null) {
            fileNamesWithLocations.add(fileInfoForType[1]);
        } else {
            fileNamesWithLocations.add(rfsModel.buildFullyQualifiedLocation(rfsModel.getLocation(), entryFile));
        }
    }

    public void setModel(BaseRemoteFileModelInterface rfsModel) {
        if (rfsModel != this.model) {
            this.model = rfsModel;
            if (this.viewPanel != null) {
                this.viewPanel.setModel(rfsModel);
            }
        }
    }

    public BaseRemoteFileModelInterface getModel() {
        return this.model;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        Object type;
        Map eventInfo = ((ActionProviderEvent)event).getEventInfo();
        if (eventInfo != null && eventInfo.containsKey("viewType")) {
            String view = (String)eventInfo.get("viewType");
            this.viewPanel.setViewComponent(view);
            this.component = this.viewPanel.getViewComponent();
            try {
                this.toolbarFilter.setAttribute("component", (Object)this.component);
                this.drillDownFilter.setAttribute("component", (Object)this.component);
            }
            catch (AttributeSetException ase) {
                this.log.error(ase.getMessage(), (Throwable)ase);
            }
            if (this.buttonPanel != null) {
                this.buttonPanel.setRemoteFileViewComponent(this.component);
            }
            if (this.filePanel != null) {
                this.filePanel.setRemoteFileViewComponent(this.component);
            }
            this.firePropertyChange("viewType", null, view);
        }
        if (eventInfo != null && eventInfo.containsKey("type") && (type = eventInfo.get("type")) != null && type.equals("NAVIGATE")) {
            if (this.filePanel != null) {
                this.filePanel.setSelectionTextInNameField(false);
            }
            this.folderSelections = null;
            this.fileSelections = null;
        }
    }

    protected void setCursorOnPanel(Cursor cursor) {
        this.setCursor(cursor);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("refreshNeeded")) {
            TableModel sortModel;
            final boolean wasInitializing = this.isInitializing();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Cursor cursor = BaseRemoteFileSelectorPanel.this.getCursor();
                    BaseRemoteFileSelectorPanel.this.setCursorOnPanel(BaseRemoteFileSelectorPanel.this.waitCursor);
                    BaseRemoteFileSelectorPanel.this.initializing = wasInitializing;
                    BaseRemoteFileSelectorPanel.this.refresh();
                    BaseRemoteFileSelectorPanel.this.initializing = false;
                    BaseRemoteFileSelectorPanel.this.setCursorOnPanel(cursor);
                }
            });
            JComponent detailView = this.viewPanel.getViewComponent().getViewComponent();
            if (detailView instanceof TableView && (sortModel = ((TableView)detailView).getModel()) instanceof SortableTableModelAdapter) {
                ((SortableTableModelAdapter)sortModel).setAutoResortEnabled(true);
            }
        } else if (evt.getPropertyName().equalsIgnoreCase("FileNameEntryTextInserted") || evt.getPropertyName().equalsIgnoreCase("FileNameEntryTextDeleted")) {
            this.component.clearSelections();
        } else if (evt.getPropertyName().equalsIgnoreCase("invalidLocation")) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(com.sas.swing.models.remotefileselector2.RB.getStringResource(RB_KEY, "unknownLocationMessage.txt"), evt.getNewValue()));
        } else if (evt.getPropertyName().equalsIgnoreCase("modelUpdateFailed")) {
            JOptionPane.showMessageDialog(this, new Object[]{evt.getNewValue()}, RB.getStringResource(RB_KEY, "error.txt", this.getLocale()), 0);
        } else if (evt.getPropertyName().equalsIgnoreCase("path")) {
            this.pathChanged((String)evt.getNewValue(), false);
        }
    }

    protected void refresh() {
        BaseRemoteFileModelInterface model = this.getModel();
        if (model instanceof RemoteFileNavigationModelInterface) {
            try {
                ((RemoteFileNavigationModelInterface)model).loadFileInfo();
                this.component.setPath(model.getLocation());
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg != null && !"".equalsIgnoreCase(msg)) {
                    this.setCursorOnPanel(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(this, e.getMessage(), RB.getStringResource(RB_KEY, "error.txt"), 0);
                }
                this.displayGenericNotAbleToLoadMessage(model.getLocation());
            }
        }
        if (this.fileSelections != null && (this.selectionMode == FILES_ONLY || this.selectionMode == FILES_AND_DIRECTORIES)) {
            this.setSelections(0);
        }
        if (this.folderSelections != null && (this.selectionMode == DIRECTORIES_ONLY || this.selectionMode == FILES_AND_DIRECTORIES)) {
            this.setSelections(1);
        }
        if (this.isInitializing()) {
            this.pathChanged(model.getLocation(), true);
        }
    }

    protected void displayGenericNotAbleToLoadMessage(String location) {
        this.setCursorOnPanel(Cursor.getDefaultCursor());
        String genericErrorMessage = MessageFormat.format(RB.getStringResource(RB_KEY, "notAbleToLoadFiles.txt"), RemoteFileVisualsUtil.getDisplayPath(location));
        JOptionPane.showMessageDialog(this, genericErrorMessage, RB.getStringResource(RB_KEY, "error.txt"), 0);
    }

    protected void pathChanged(String path, boolean force) {
        if (this.component != null && this.component.getViewComponent() != null) {
            this.component.getViewComponent().scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
        if (!this.isInitializing() && (this.getSelectionMode() == FILES_ONLY || this.isMultiSelectionEnabled())) {
            return;
        }
        if (!force && this.isInitializing() && (this.fileSelections != null || this.folderSelections != null)) {
            return;
        }
        if (!(this.model instanceof RemoteFileModel2Interface)) {
            return;
        }
        String[][] parsedNamesAndLocations = this.getModel().parseIntoFoldersAndLocations(path);
        if (parsedNamesAndLocations == null) {
            return;
        }
        String newFileNameFieldText = "";
        if (RemoteFileVisualsUtil.isValidLocationForSelection((RemoteFileModel2Interface)this.model, parsedNamesAndLocations[0][0], this.isRootFolderSelectable())) {
            newFileNameFieldText = parsedNamesAndLocations[0][1];
        }
        this.filePanel.setFileNameFieldText(newFileNameFieldText);
    }

    public TableColumnModel getDisplayedColumns() {
        return null;
    }

    public void updateColumnHeaders(TableColumnModel displayedColumns) {
    }

    public ActionSupportFilter getActionSupportFilter(int filter) {
        if (filter == TOOLBAR_FILTER) {
            return this.toolbarFilter;
        }
        if (filter == DRILL_DOWN_FILTER) {
            return this.drillDownFilter;
        }
        if (filter == FILTER_TYPE_FILTER) {
            return this.filterTypeFilter;
        }
        return null;
    }

    public void setActionProvider(SwingActionProvider actionProvider) {
        if (this.viewerSupport.getActionProvider() != actionProvider) {
            SwingActionProvider old = this.viewerSupport.getActionProvider();
            if (old != null) {
                old.removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.viewerSupport.setActionProvider(actionProvider);
            if (actionProvider != null) {
                actionProvider.addContentsChangedListener((ContentsChangedListener)this);
            }
            this.firePropertyChange("actionProvider", old, actionProvider);
        }
    }

    public SwingActionProvider getActionProvider() {
        return this.viewerSupport.getActionProvider();
    }

    public void setActionVisible(String actionType, String areaType, boolean visible) {
        this.viewerSupport.setActionVisible(actionType, areaType, visible);
    }

    public boolean isActionVisible(String actionType, String areaType) {
        return this.viewerSupport.isActionVisible(actionType, areaType);
    }

    public Object getUniqueId() {
        return this.viewerSupport.getUniqueId();
    }

    public void setUniqueId(Object uniqueId) {
        this.viewerSupport.setUniqueId(uniqueId);
    }

    public Collection listAreaTypes() {
        return this.viewerSupport.listAreaTypes();
    }

    public Collection listActionTypes(String areaType) {
        return this.viewerSupport.listActionTypes(areaType);
    }

    public void setActionSupportType(String actionSupportType) {
        if (this.viewerSupport.getActionSupportType() != actionSupportType) {
            String old = this.viewerSupport.getActionSupportType();
            this.viewerSupport.setActionSupportType(actionSupportType);
            this.firePropertyChange("actionSupportType", old, actionSupportType);
        }
    }

    public String getActionSupportType() {
        return this.viewerSupport.getActionSupportType();
    }

    public boolean isOpenSelectedFolderItemOn() {
        return this.openSelectedFolderItem;
    }

    public void setOpenSelectedFolderItemOn(boolean openSelectedFolder) {
        this.openSelectedFolderItem = openSelectedFolder;
    }

    public void setSelectionMode(int mode) {
        this.validateSelectionModeForDialogType(mode);
        this.selectionMode = mode;
        if (mode == FILES_AND_DIRECTORIES) {
            this.setShowDirectoriesOnly(false);
            this.setOpenSelectedFolderItemOn(false);
            this.component.setSelectionMode(mode);
        } else if (mode == FILES_ONLY) {
            this.setShowDirectoriesOnly(false);
            this.setOpenSelectedFolderItemOn(true);
            this.component.setSelectionMode(mode);
        } else if (mode == DIRECTORIES_ONLY) {
            this.setShowDirectoriesOnly(true);
            this.setOpenSelectedFolderItemOn(false);
            this.component.setSelectionMode(mode);
        }
    }

    private void validateSelectionModeForDialogType(int mode) {
        if (mode == DIRECTORIES_ONLY && this.getDialog() != null && this.getDialog().getDialogType() == 1) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "directoriesOnlyInvalidInSaveMode.txt"));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setMultiSelectionEnabled(boolean enable) {
        if (enable != this.multiSelectionEnabled) {
            boolean previousEnableStatus = this.multiSelectionEnabled;
            this.multiSelectionEnabled = enable;
            this.firePropertyChange("multiSelectionEnabled", previousEnableStatus, enable);
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultipleRootLocationsOn(boolean visible) {
        if (visible != this.multipleRootLocationsActive) {
            boolean old = this.multipleRootLocationsActive;
            this.multipleRootLocationsActive = visible;
            this.firePropertyChange("locationRootType", old, visible);
        }
    }

    public boolean isMultipleRootLocationsOn() {
        return this.multipleRootLocationsActive;
    }

    public boolean isUserInputInNameField() {
        if (this.filePanel != null) {
            return this.filePanel.isUserInputInNameField();
        }
        return false;
    }

    public boolean isSelectionTextInNameField() {
        if (this.filePanel != null) {
            return this.filePanel.isSelectionTextInNameField();
        }
        return false;
    }

    protected Object[] getDefaultColumnRenderers() {
        return new Object[]{RemoteFileMetadataNameCellRenderer.defaultInstance, IFileServiceSizeCellRenderer.defaultInstance, IFileServiceDateCellRenderer.defaultInstance, IFileServiceEngineCellRenderer.defaultInstance};
    }

    public void setSaveVerificationOn(boolean verify) {
        this.saveVerification = verify;
    }

    public boolean isSaveVerificationOn() {
        return this.saveVerification;
    }

    public void setFileSelections(String[] selections) {
        this.fileSelections = selections;
    }

    public void setFolderSelections(String[] selections) {
        this.folderSelections = selections;
    }

    private void setSelections(int type) {
        String[] selections;
        String[] stringArray = selections = type == 0 ? this.fileSelections : this.folderSelections;
        if (this.filePanel == null) {
            return;
        }
        Object selectionObject = this.component.getSelectionObject();
        if (selectionObject == null || !(selectionObject instanceof ListSelectionModel)) {
            return;
        }
        final ListSelectionModel listSelectionModel = (ListSelectionModel)selectionObject;
        if (selections == null || selections.length == 0) {
            return;
        }
        BaseRemoteFileModelInterface fileModel = this.getModel();
        SortableTableModelAdapter sortableTableModel = null;
        TableView table = (TableView)((RemoteFileTableComponent)this.viewPanel.getViewComponent()).getViewComponent();
        if (table != null && table.getModel() instanceof SortableTableModelAdapter) {
            sortableTableModel = (SortableTableModelAdapter)table.getModel();
        }
        int selectionCount = 0;
        final int[] selectionIndices = new int[selections.length];
        int numRows = fileModel.getRowCount();
        boolean foundMatchingItem = false;
        block0: for (int i = 0; i < selections.length; ++i) {
            for (int j = 0; j < numRows; ++j) {
                RemoteFileMetadataInterface rfmi = fileModel.getNodeAt(j);
                if (type == 0 && rfmi.isFolder() || type == 1 && !rfmi.isFolder() || !rfmi.getName().equals(selections[i])) continue;
                selectionIndices[selectionCount++] = sortableTableModel == null ? j : sortableTableModel.convertRowIndexToView(j);
                foundMatchingItem = true;
                continue block0;
            }
        }
        if (foundMatchingItem) {
            this.filePanel.setProtectTextField(true);
        } else if (type == 0) {
            RemoteFileSelectorDialogInterface dialog = this.getDialog();
            boolean allowNonExistentSelections = false;
            if (dialog != null && dialog instanceof RemoteFileSelectorDialog) {
                allowNonExistentSelections = ((RemoteFileSelectorDialog)dialog).isAllowNonExistentSelections();
            }
            if (allowNonExistentSelections) {
                this.filePanel.setFileNameFieldText(selections[selections.length - 1]);
                this.filePanel.setProtectTextField(true);
            }
        }
        final int finalSelectionCount = selectionCount;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int k = 0; k < finalSelectionCount; ++k) {
                    listSelectionModel.addSelectionInterval(selectionIndices[k], selectionIndices[k]);
                }
            }
        });
    }

    public int getInitialFilterTypeIndex() {
        return this.initialFilterTypeIndex;
    }

    public void setInitialFilterTypeIndex(int initialFilterTypeIndex) {
        this.initialFilterTypeIndex = initialFilterTypeIndex;
    }

    public void setDialog(RemoteFileSelectorDialogInterface dialog) {
        this.dialog = dialog;
        this.validateSelectionModeForDialogType(this.getSelectionMode());
    }

    public RemoteFileSelectorDialogInterface getDialog() {
        return this.dialog;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public String[] getFolderSelections() {
        return this.folderSelections;
    }

    public String[] getFileSelections() {
        return this.fileSelections;
    }

    public boolean isRootFolderSelectable() {
        return this.rootFolderSelectable;
    }

    public void setRootFolderSelectable(boolean rootFolderSelectable) {
        this.rootFolderSelectable = rootFolderSelectable;
        if (rootFolderSelectable && !this.isInitializing()) {
            String[][] parsedNamesAndLocations = this.model.parseIntoFoldersAndLocations(this.model.getLocation());
            this.filePanel.setFileNameFieldText(parsedNamesAndLocations[0][1]);
        }
    }
}

