/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector.actions;

import com.sas.actionprovider.SwingAction;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentInterface;
import com.sas.swing.visuals.remotefileselector.RemoteFileSearchPanel;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class FindAction
extends SwingAction {
    public void actionPerformed(ActionEvent event) {
        RemoteFileComponentInterface component = (RemoteFileComponentInterface)this.getAttribute("component");
        TableView table = (TableView)component.getViewComponent();
        RemoteFileServiceModelInterface serviceModel = (RemoteFileServiceModelInterface)this.getAttribute("serviceModel");
        if (table.isEditing()) {
            TableCellEditor editor = table.getCellEditor(table.getSelectedRow(), 0);
            editor.stopCellEditing();
        }
        RemoteFileSearchPanel searchPanel = (RemoteFileSearchPanel)this.getAttribute("searchPanel");
        String currentPath = (String)this.getAttribute("path");
        searchPanel.setCurrentPath(currentPath);
        Frame parent = (Frame)this.getAttribute("parent");
        List returnedItems = RemoteFileSearchPanel.showDialog(parent, currentPath, searchPanel);
        if (returnedItems.size() > 0) {
            String selectedFile = (String)returnedItems.get(0);
            String[] results = serviceModel.splitDirectoryPathAndFileName(selectedFile);
            String resultFile = results[0];
            String resultPath = results[1];
            resultPath = serviceModel.getDirectoryPath(resultPath);
            component.setPath(resultPath);
            SortableTableModelAdapter sortModel = (SortableTableModelAdapter)table.getModel();
            TableModel model = sortModel.getModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!resultFile.equals(model.getValueAt(i, 0))) continue;
                int realSelection = sortModel.convertRowIndexToView(i);
                Rectangle rect = table.getCellRect(realSelection, 0, false);
                table.scrollRectToVisible(rect);
                table.setRowSelectionAllowed(true);
                table.setRowSelectionInterval(realSelection, realSelection);
            }
        }
    }
}

