/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector.actions;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JOptionPane;

public class DeleteAction
extends SwingAction {
    private static final String RB_KEY = "RemoteFileSelector.";

    public void actionPerformed(ActionEvent event) {
        String title;
        TableView table = (TableView)this.getAttribute("table");
        int index = table.getSelectedRow();
        SortableTableModelAdapter tableModel = (SortableTableModelAdapter)this.getAttribute("tableModel");
        Integer actualIndex = new Integer(tableModel.convertRowIndexToModel(index));
        String folderName = (String)tableModel.getValueAt(index, 0);
        String message = MessageFormat.format(RB.getStringResource(RB_KEY, "confirmDeleteMessage.txt"), folderName);
        int answer = JOptionPane.showConfirmDialog(null, message, title = RB.getStringResource(RB_KEY, "confirmDeleteTitle.txt"), 0, 3);
        if (answer == 0) {
            try {
                this.setAttribute("index", actualIndex);
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            DynamicAttributeCommandInterface command = this.getCommand();
            if (command != null) {
                AttributeDescriptorInterface[] adi = this.getAttributeDescriptors();
                if (adi != null) {
                    for (int i = 0; i < adi.length; ++i) {
                        try {
                            AttributeDescriptorInterface attributeDescriptor = adi[i];
                            if (!attributeDescriptor.isModifiable()) continue;
                            command.setAttribute(attributeDescriptor.getName(), this.getValue(attributeDescriptor.getName()));
                            continue;
                        }
                        catch (AttributeSetException attributeSetException) {
                            // empty catch block
                        }
                    }
                }
                command.execute(null);
                SwingActionProvider actionProvider = (SwingActionProvider)this.getActionProvider();
                if (command instanceof ContentsChangedInterface && actionProvider != null && ((ContentsChangedInterface)command).isContentsChanged()) {
                    actionProvider.fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)command).getEventSource(), (Map)((ContentsChangedInterface)command).getEventInfo()));
                }
            }
        }
    }
}

