/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.swing.models.remotefileselector.CacheModel;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponent;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class RemoteFileTreeComponent
extends RemoteFileComponent
implements TreeSelectionListener,
TreeModelListener {
    protected JTree tree;
    private List typeCategories;
    private List names;
    private String currentPath;
    private List previousPath = new ArrayList();
    private boolean hasInitialized;
    private String returnedFolderName;
    private DefaultMutableTreeNode currentCacheNode;
    private RemoteFileMetadataInterface currentRemoteFileMetadataInterface;

    public RemoteFileTreeComponent(BaseRemoteFileSelectorPanel parentComponent) {
        this.parentComponent = parentComponent;
        this.tree = new JTree();
        this.init();
    }

    public RemoteFileTreeComponent(DefaultTreeModel model) {
        this.tree = new JTree(model);
        this.init();
    }

    protected void init() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 10, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        JScrollPane treePane = new JScrollPane();
        treePane.setPreferredSize(new Dimension(425, 200));
        treePane.getViewport().add(this.tree);
        this.add(treePane);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setShowsRootHandles(true);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RemoteFileTreeComponent.this.handleDoubleClick();
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
    }

    public void handleDoubleClick() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        if (node.isLeaf()) {
            RemoteFileMetadataInterface nodeObject = (RemoteFileMetadataInterface)node.getUserObject();
            if (nodeObject.isDrillable()) {
                this.previousPath.add(this.currentPath);
                String name = nodeObject.getName();
                TreePath selectionPath = this.tree.getSelectionPath();
                Object[] tempArray = selectionPath.getPath();
                Object[] namesArray = new Object[tempArray.length - 2];
                for (int i = 0; i < tempArray.length; ++i) {
                    if (i <= 1) continue;
                    namesArray[i - 2] = tempArray[i];
                }
                this.currentPath = this.remoteServerModel.createPathFromArray(namesArray);
                this.setPath(this.currentPath);
                this.tree.expandPath(selectionPath);
            }
            this.spcs.firePropertyChange("path", null, this.currentPath);
        }
    }

    @Override
    public void setSelectionObject(Object selectionObject) {
    }

    @Override
    public Object getSelectionObject() {
        return new Object[0];
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] treePathArray;
        if (this.selections == null) {
            this.selections = new ArrayList();
        }
        if (this.selections.size() > 0) {
            this.selections.clear();
        }
        if ((treePathArray = this.tree.getSelectionPaths()) != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                RemoteFileMetadataInterface nodeObject;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) continue;
                if (node == null) {
                    return;
                }
                if (!((RemoteFileMetadataInterface)node.getUserObject() instanceof RemoteFileMetadataInterface) || (nodeObject = (RemoteFileMetadataInterface)node.getUserObject()) == null) continue;
                if (!this.showDirectoriesOnly) {
                    if (!nodeObject.isDrillable()) {
                        this.selections.add(nodeObject.getName());
                    }
                } else {
                    this.selections.add(nodeObject.getName());
                }
                if (!nodeObject.isDrillable()) continue;
                Object[] tempArray = treePathArray[i].getPath();
                Object[] pathArray = new Object[tempArray.length - 2];
                for (int j = 2; j < tempArray.length; ++j) {
                    pathArray[j - 2] = tempArray[j];
                }
                String pathString = this.remoteServerModel.createPathFromArray(pathArray);
                this.setPath(pathString);
            }
            this.spcs.firePropertyChange("selections", null, this.selections);
        }
    }

    @Override
    public void setPath(String originalPath) {
        MyCellRenderer cellRenderer = (MyCellRenderer)this.tree.getCellRenderer();
        this.remoteServerModel.setPath(originalPath);
        TreePath currentTreePath = this.remoteServerModel.getCacheModel().getCurrentTreePath();
        this.tree.scrollPathToVisible(currentTreePath);
        this.spcs.firePropertyChange("path", null, originalPath);
    }

    @Override
    public void setRemoteModel(RemoteFileServerModelInterface remoteServerModel) {
        this.remoteServerModel = remoteServerModel;
        this.currentPath = remoteServerModel.getPath();
        CacheModel treeModel = remoteServerModel.getCacheModel();
        this.tree.setModel(treeModel);
        TreePath currentTreePath = this.remoteServerModel.getCacheModel().getCurrentTreePath();
        this.tree.removeTreeSelectionListener(this);
        this.tree.setSelectionPath(currentTreePath);
        this.tree.addTreeSelectionListener(this);
        ((DefaultTreeModel)treeModel).addTreeModelListener(this);
        this.tree.scrollPathToVisible(currentTreePath);
        if (!this.hasInitialized) {
            this.tree.setCellRenderer(new MyCellRenderer());
        }
        this.hasInitialized = true;
        this.spcs.firePropertyChange("path", null, this.currentPath);
    }

    @Override
    public void refreshData(String path) {
        this.spcs.firePropertyChange("path", null, path);
    }

    @Override
    public List getPreviousPath() {
        return null;
    }

    @Override
    public void setPreviousPath(List previousPath) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    @Override
    public JComponent getViewComponent() {
        return this.tree;
    }

    @Override
    public void setActionProvider(SwingActionProvider actionProvider) {
    }

    @Override
    public void setColumnRenderers(Object[] columnRenderers) {
    }

    @Override
    public Object[] getColumnRenderers() {
        return null;
    }

    class MyCellRenderer
    extends DefaultTreeCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String s = value.toString();
            this.setText(s);
            String iconName = ((RemoteFileMetadataInterface)((DefaultMutableTreeNode)value).getUserObject()).getIcon();
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof RemoteFileMetadataInterface) {
                this.setIcon(new ImageIcon(Resources.getImage((String)iconName)));
            }
            return this;
        }
    }
}

