/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileDrillableToObjectTransform;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModel;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesKeywordsToObjectTransform;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponent;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.table.SortException;
import com.sas.util.BaseStringComparator;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class RemoteFileTableComponent
extends RemoteFileComponent
implements ListSelectionListener,
PropertyChangeListener {
    protected TableView table;
    protected Object[] columnRenderers;
    private List typeCategories;
    private List names;
    private String currentPath;
    private List previousPath;
    private String returnedFolderName;
    private ActionSupportFilter filter;
    private ListSelectionModel selectionObject;
    private Cursor waitCursor;

    public RemoteFileTableComponent(BaseRemoteFileSelectorPanel parentComponent) {
        this(parentComponent, "");
    }

    public RemoteFileTableComponent(BaseRemoteFileSelectorPanel parentComponent, String supportType) {
        this.parentComponent = parentComponent;
        this.table = new TableView();
        if (!supportType.equals("")) {
            this.table.setActionSupportType(supportType);
        }
        this.init();
    }

    public RemoteFileTableComponent(DefaultTableModel model) {
        this.table = new TableView((TableModel)model);
        this.init();
    }

    protected void init() {
        ListSelectionModel rowSM;
        this.waitCursor = new Cursor(3);
        this.previousPath = new ArrayList();
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeaderVisible(false);
        this.table.setAutoResizeMode(2);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 10, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        JScrollPane tablePane = new JScrollPane();
        tablePane.setPreferredSize(new Dimension(425, 200));
        tablePane.getViewport().add((Component)this.table);
        tablePane.getViewport().setBackground(this.table.getBackground());
        this.add(tablePane);
        TableRowModel rowModel = this.table.getRowModel();
        this.selectionObject = rowSM = rowModel.getSelectionModel();
        rowSM.addListSelectionListener(this);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RemoteFileTableComponent.this.handleDoubleClick();
                }
            }
        };
        this.table.addMouseListener((MouseListener)mouseListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("path")) {
            String path = (String)e.getNewValue();
            try {
                if (this.filter != null) {
                    this.filter.setAttribute("path", e.getNewValue());
                    this.filter.setAttribute("previousPath", (Object)this.getPreviousPath());
                }
            }
            catch (AttributeSetException ase) {
                LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(ase.getMessage(), (Throwable)ase);
            }
            this.refreshData(path);
        }
    }

    public void handleDoubleClick() {
        SwingAction action = null;
        Cursor cursor = this.getCursor();
        this.setCursor(this.waitCursor);
        this.filter = this.parentComponent.getActionSupportFilter(BaseRemoteFileSelectorPanel.DRILL_DOWN_FILTER);
        try {
            int columnNumber = this.table.getSelectedColumn();
            if (columnNumber < 0) {
                columnNumber = 0;
            }
            this.filter.setAttribute("modelColumn", (Object)new Integer(columnNumber));
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        ActionList actions = this.parentComponent.getActionProvider().getActions(this.filter);
        if (actions != null) {
            List list = actions.getActions();
            action = (SwingAction)list.get(0);
            try {
                action.setAttribute("path", (Object)this.currentPath);
                action.removeAttribute("component");
                action.setAttribute("component", (Object)this);
            }
            catch (AttributeSetException e) {
                LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            action.actionPerformed(new ActionEvent(this, 1, "OpenFolder"));
            this.setCursor(cursor);
        }
        try {
            action.removeAttribute("component");
            action.setAttribute("component", null);
        }
        catch (AttributeSetException e) {
            LoggerRepository2.getLogger((String)RemoteFileTableComponent.class.getPackage().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List getPreviousPath() {
        return this.previousPath;
    }

    @Override
    public void setPreviousPath(List previousPath) {
        this.previousPath = previousPath;
    }

    @Override
    public void refreshData(String path) {
        this.spcs.firePropertyChange("path", null, path);
    }

    @Override
    public void setPath(String path) {
        try {
            this.remoteServerModel.setPath(path);
            if (path != null && this.currentPath != null && !this.currentPath.equals(path)) {
                this.previousPath.add(this.currentPath);
                this.currentPath = path;
            }
            this.spcs.firePropertyChange("path", null, path);
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(null, iae.getMessage(), "Error", 0);
        }
    }

    @Override
    public Object getSelectionObject() {
        return this.selectionObject;
    }

    @Override
    public void setSelectionObject(Object newSelectionObject) {
        if (newSelectionObject != null) {
            int minSelection = ((ListSelectionModel)newSelectionObject).getMinSelectionIndex();
            int maxSelection = ((ListSelectionModel)newSelectionObject).getMaxSelectionIndex();
            if (minSelection > -1 && maxSelection > -1) {
                this.table.setRowSelectionInterval(minSelection, maxSelection);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.selections == null) {
            this.selections = new ArrayList();
        }
        if (this.selections.size() > 0) {
            this.selections.clear();
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        if (!lsm.isSelectionEmpty()) {
            int minIndex = lsm.getMinSelectionIndex();
            int maxIndex = lsm.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!lsm.isSelectedIndex(i)) continue;
                int realSelection = ((SortableTableModelAdapter)this.table.getModel()).convertRowIndexToModel(i);
                if (!this.showDirectoriesOnly) {
                    RemoteFileMetadataInterface item = this.remoteServerModel.getNodeAt(realSelection);
                    if (item.isDrillable()) continue;
                    this.selections.add(this.table.getValueAt(i, 0));
                    continue;
                }
                this.selections.add(this.table.getValueAt(i, 0));
            }
        }
        this.spcs.firePropertyChange("selections", null, this.selections);
    }

    @Override
    public void setRemoteModel(RemoteFileServerModelInterface remoteServerModel) {
        this.remoteServerModel = remoteServerModel;
        ((RemoteFileServerModel)remoteServerModel).addPropertyChangeListener(this);
        SortableTableModelAdapter model = new SortableTableModelAdapter((TableModel)this.remoteServerModel);
        model.setAutoResortEnabled(true);
        this.table.setModel((TableModel)model);
        this.currentPath = remoteServerModel.getPath();
        TransformInterface[] transforms = remoteServerModel.getTransforms();
        int columnNumber = remoteServerModel.getColumnCount() - 1;
        String drillableName = null;
        if (transforms[columnNumber] instanceof RemoteFileDrillableToObjectTransform) {
            this.table.hideColumn(columnNumber);
            drillableName = remoteServerModel.getColumnName(columnNumber);
        }
        int numberOfColumns = remoteServerModel.getColumnCount();
        for (int i = 0; i < numberOfColumns - 1; ++i) {
            if (!(transforms[i] instanceof InformationServicesKeywordsToObjectTransform)) continue;
            model.setColumnComparator(remoteServerModel.getColumnName(i), (Comparator)new BaseStringComparator(true, false));
        }
        try {
            model.sort(new String[]{drillableName, remoteServerModel.getColumnName(0)}, new int[]{0, 0});
        }
        catch (SortException sortException) {
            // empty catch block
        }
        this.spcs.firePropertyChange("path", null, this.currentPath);
    }

    @Override
    public JComponent getViewComponent() {
        return this.table;
    }

    @Override
    public void setActionProvider(SwingActionProvider actionProvider) {
        this.table.setActionProvider(actionProvider);
    }

    @Override
    public void setColumnRenderers(Object[] columnRenderers) {
        this.columnRenderers = columnRenderers;
        for (int i = 0; i < columnRenderers.length; ++i) {
            this.table.setCellRenderer(1, -1, 1, i + 1, i + 1, 1, (TableCellRenderer)columnRenderers[i]);
        }
    }

    @Override
    public Object[] getColumnRenderers() {
        return this.columnRenderers;
    }
}

