/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.SwingActionProviderViewInterface;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.remotefileselector.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.remotefileselector.RemoteFileTableComponent;
import com.sas.swing.visuals.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class RemoteFileSearchComponent
extends JPanel
implements SwingActionProviderViewInterface,
ContentsChangedListener {
    private static final String RB_KEY = "RemoteFileSelector.";
    protected SwingViewerSupport viewerSupport;
    protected ActionSupportFilter buttonFilter;
    protected JButton startSearch;
    protected SwingAction startAction;
    protected RemoteFileTableComponent component;
    protected JComboBox searchWhereField;
    protected RemoteFileServerModelInterface model;
    private CommonLoggerInterface logger = LoggerRepository2.getLogger((String)RemoteFileSearchComponent.class.getPackage().getName(), null);

    public RemoteFileSearchComponent(String supportType, RemoteFileSearchModelInterface serviceModel, RemoteFileTableComponent tablePanel, RemoteFileServerModelInterface model) {
        this.component = tablePanel;
        this.model = model;
        this.viewerSupport = new SwingViewerSupport((ActionProviderViewInterface)this);
        if (this.getActionProvider() == null) {
            this.setActionProvider(new SwingActionProvider());
        }
        if (supportType == "REMOTE_IFILE_SERVICE_SUPPORT") {
            this.viewerSupport.setActionSupportType("REMOTE_IFILE_SERVICE_SUPPORT");
            this.buttonFilter = new ActionSupportFilter("REMOTE_IFILE_SERVICE_SUPPORT", "SEARCH_BUTTON_AREA", (ActionProviderViewInterface)this);
        } else if (supportType == "REMOTE_INFO_SERVICE_SUPPORT") {
            this.viewerSupport.setActionSupportType("REMOTE_INFO_SERVICE_SUPPORT");
            this.buttonFilter = new ActionSupportFilter("REMOTE_INFO_SERVICE_SUPPORT", "SEARCH_BUTTON_AREA", (ActionProviderViewInterface)this);
        }
        JTextField searchForField = new JTextField(20);
        JLabel searchForLabel = new JLabel(RB.getStringResource(RB_KEY, "searchFor.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "searchForMnemonic.txt"))));
        searchForLabel.setDisplayedMnemonic(keyEvent);
        searchForLabel.setLabelFor(searchForField);
        searchForField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent searchForEvent) {
                try {
                    RemoteFileSearchComponent.this.startAction.setAttribute("searchText", (Object)((JTextField)searchForEvent.getSource()).getText());
                }
                catch (AttributeSetException e) {
                    RemoteFileSearchComponent.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        Vector<String> whatList = new Vector<String>();
        whatList.add(RB.getStringResource(RB_KEY, "name.txt"));
        whatList.add(RB.getStringResource(RB_KEY, "keywords.txt"));
        JComboBox searchWhatField = new JComboBox(whatList);
        JLabel searchWhatLabel = new JLabel(RB.getStringResource(RB_KEY, "searchWhat.txt"));
        keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "searchWhatMnemonic.txt"))));
        searchWhatLabel.setDisplayedMnemonic(keyEvent);
        searchWhatLabel.setLabelFor(searchWhatField);
        try {
            this.buttonFilter.setAttribute("searchContext", searchWhatField.getItemAt(0));
        }
        catch (AttributeSetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        searchWhatField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent searchWhatEvent) {
                try {
                    RemoteFileSearchComponent.this.startAction.setAttribute("searchContext", ((JComboBox)searchWhatEvent.getSource()).getSelectedItem());
                }
                catch (AttributeSetException e) {
                    RemoteFileSearchComponent.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        String currentPath = model.getPath();
        this.searchWhereField = new JComboBox();
        this.searchWhereField.setEditable(true);
        this.searchWhereField.setEditor(new DirectorySelectionEditor());
        this.searchWhereField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        this.searchWhereField.setRenderer(new DirectorySelectionRenderer());
        int position = this.populateWhereField(currentPath);
        JLabel searchWhereLabel = new JLabel(RB.getStringResource(RB_KEY, "searchWhere.txt"));
        keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "searchWhereMnemonic.txt"))));
        searchWhereLabel.setDisplayedMnemonic(keyEvent);
        searchWhereLabel.setLabelFor(this.searchWhereField);
        try {
            if (position == 0) {
                this.buttonFilter.setAttribute("startingPath", (Object)model.getPath());
            } else {
                this.buttonFilter.setAttribute("startingPath", this.searchWhereField.getSelectedItem());
            }
        }
        catch (AttributeSetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.searchWhereField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent searchWhereEvent) {
                try {
                    String path = RemoteFileSearchComponent.this.buildWherePath();
                    if (path != null) {
                        RemoteFileSearchComponent.this.startAction.setAttribute("startingPath", (Object)path);
                    }
                }
                catch (AttributeSetException e) {
                    RemoteFileSearchComponent.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        JCheckBox searchRecursiveField = new JCheckBox(RB.getStringResource(RB_KEY, "searchRecursive.txt"));
        keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "searchRecursiveMnemonic.txt"))));
        searchRecursiveField.setMnemonic(keyEvent);
        searchRecursiveField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent searchRecursiveEvent) {
                try {
                    RemoteFileSearchComponent.this.startAction.setAttribute("recursive", (Object)new Boolean(((JCheckBox)searchRecursiveEvent.getSource()).isSelected()));
                }
                catch (AttributeSetException e) {
                    RemoteFileSearchComponent.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        AutoSizingGridLayout searchLeftLayout = new AutoSizingGridLayout(4, 2, 5, 5, true, false, true);
        searchLeftLayout.setRemainderColumn(0);
        JPanel searchLeftPanel = new JPanel((LayoutManager)searchLeftLayout);
        searchLeftPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 45));
        searchLeftPanel.add(searchForLabel);
        searchLeftPanel.add(searchForField);
        searchLeftPanel.add(searchWhatLabel);
        searchLeftPanel.add(searchWhatField);
        searchLeftPanel.add(searchWhereLabel);
        searchLeftPanel.add(this.searchWhereField);
        searchLeftPanel.add(searchRecursiveField);
        try {
            this.buttonFilter.setAttribute("searchPanel", (Object)this);
            this.buttonFilter.setAttribute("searchText", (Object)"");
            this.buttonFilter.setAttribute("searchContext", searchWhatField.getSelectedItem());
            this.buttonFilter.setAttribute("startingPath", (Object)currentPath);
            this.buttonFilter.setAttribute("recursive", (Object)new Boolean(false));
            this.buttonFilter.setAttribute("serviceModel", (Object)serviceModel);
            this.buttonFilter.setAttribute("remoteModel", (Object)model);
        }
        catch (AttributeSetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        AutoSizingGridLayout searchRightLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        searchRightLayout.setRemainderColumn(0);
        JPanel searchRightPanel = new JPanel((LayoutManager)searchRightLayout);
        searchRightPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 45));
        ActionList actions = this.getActionProvider().getActions(this.buttonFilter);
        if (actions != null) {
            List list = actions.getActions();
            this.startAction = (SwingAction)list.get(0);
            this.startSearch = new JButton((Action)this.startAction);
            searchRightPanel.add(this.startSearch);
        }
        this.add(searchLeftPanel);
        this.add(searchRightPanel);
    }

    public void setCurrentPath(String path) {
        try {
            this.startAction.setAttribute("startingPath", (Object)path);
            int position = this.populateWhereField(path);
            this.component.setPath(path);
        }
        catch (AttributeSetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String buildWherePath() {
        String path;
        int selectedIndex = this.searchWhereField.getSelectedIndex();
        if (selectedIndex > 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 1; i <= selectedIndex; ++i) {
                names.add(((JLabel)this.searchWhereField.getItemAt(i)).getText());
            }
            path = this.model.createPathFromArray(names.toArray());
        } else {
            path = selectedIndex == 0 ? "" : null;
        }
        return path;
    }

    private int populateWhereField(String currentPath) {
        ArrayList<String> newList = new ArrayList<String>();
        this.searchWhereField.removeAllItems();
        String text = this.model.getServerName();
        JLabel label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.searchWhereField.addItem(label);
        while (currentPath != null && !currentPath.equals("")) {
            String[] stringArray = this.model.splitDirectoryPathAndFileName(currentPath);
            currentPath = stringArray[1];
            String fileName = stringArray[0];
            if (fileName.equals("")) {
                if (!currentPath.equals("")) {
                    newList.add(currentPath);
                }
                currentPath = null;
                continue;
            }
            newList.add(fileName);
        }
        int size = newList.size();
        int position = 0;
        for (int i = size - 1; i >= 0; --i) {
            String tempItem = (String)newList.get(i);
            if (tempItem == null || tempItem.equals("")) continue;
            label = new JLabel((String)newList.get(i));
            label.setBorder(BorderFactory.createEmptyBorder(0, 16 + 16 * position, 0, 0));
            this.searchWhereField.insertItemAt(label, position + 1);
            ++position;
        }
        this.searchWhereField.setSelectedIndex(position);
        return position;
    }

    public void setActionProvider(SwingActionProvider actionProvider) {
        if (this.viewerSupport.getActionProvider() != actionProvider) {
            SwingActionProvider old = this.viewerSupport.getActionProvider();
            if (old != null) {
                old.removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.viewerSupport.setActionProvider(actionProvider);
            if (actionProvider != null) {
                actionProvider.addContentsChangedListener((ContentsChangedListener)this);
            }
            this.firePropertyChange("actionProvider", old, actionProvider);
        }
    }

    public SwingActionProvider getActionProvider() {
        return this.viewerSupport.getActionProvider();
    }

    public void setActionVisible(String actionType, String areaType, boolean visible) {
        this.viewerSupport.setActionVisible(actionType, areaType, visible);
    }

    public boolean isActionVisible(String actionType, String areaType) {
        return this.viewerSupport.isActionVisible(actionType, areaType);
    }

    public Object getUniqueId() {
        return this.viewerSupport.getUniqueId();
    }

    public void setUniqueId(Object uniqueId) {
        this.viewerSupport.setUniqueId(uniqueId);
    }

    public Collection listAreaTypes() {
        return this.viewerSupport.listAreaTypes();
    }

    public Collection listActionTypes(String areaType) {
        return this.viewerSupport.listActionTypes(areaType);
    }

    public void setActionSupportType(String actionSupportType) {
        if (this.viewerSupport.getActionSupportType() != actionSupportType) {
            String old = this.viewerSupport.getActionSupportType();
            this.viewerSupport.setActionSupportType(actionSupportType);
            this.firePropertyChange("actionSupportType", old, actionSupportType);
        }
    }

    public String getActionSupportType() {
        return this.viewerSupport.getActionSupportType();
    }

    public void contentsChanged(ContentsChangedEvent event) {
        Map eventInfo = ((ActionProviderEvent)event).getEventInfo();
        if (eventInfo.containsKey("search")) {
            String path = (String)eventInfo.get("path");
            this.component.refreshData(path);
        }
    }

    class DirectorySelectionEditor
    extends JLabel
    implements ComboBoxEditor {
        private static final String RB_KEY = "RemoteFileSelector.";
        private ImageIcon directoryIcon = new ImageIcon(Resources.getImage((String)RB.getStringResource("RemoteFileSelector.", "folderImage.image")));

        DirectorySelectionEditor() {
        }

        @Override
        public void addActionListener(ActionListener al) {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void removeActionListener(ActionListener al) {
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                this.setIcon(this.directoryIcon);
                this.setText(((JLabel)anObject).getText());
            }
        }
    }

    class DirectorySelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final String RB_KEY = "RemoteFileSelector.";
        private ImageIcon directoryIcon = new ImageIcon(Resources.getImage((String)RB.getStringResource("RemoteFileSelector.", "folderImage.image")));

        DirectorySelectionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = ((JLabel)value).getText();
            this.setText(s);
            this.setBorder(((JLabel)value).getBorder());
            this.setIcon(this.directoryIcon);
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }
}

