/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.entities.AttributeSetException;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class RemoteFileNamePanel
extends JPanel
implements PropertyChangeListener {
    private static final String RB_KEY = "RemoteFileSelector.";
    private JTextField fileNameField;
    private RemoteFileComponentInterface viewComponent;
    private JComboBox fileTypes;
    private JPanel actionButtonPanel;
    private HashMap fileExtensions;
    private BaseRemoteFileSelectorPanel parentComponent;
    private ActionSupportFilter filter;

    public RemoteFileNamePanel(Map fileExtensions, JComponent parent) {
        this.parentComponent = (BaseRemoteFileSelectorPanel)parent;
        this.fileExtensions = (HashMap)fileExtensions;
        if (fileExtensions != null && fileExtensions.size() > 0) {
            Vector tempVector = new Vector(fileExtensions.keySet());
            this.fileTypes = new JComboBox(tempVector);
        } else {
            this.fileTypes = new JComboBox();
        }
        this.fileTypes.setSelectedIndex(0);
        JLabel fileTypeLabel = new JLabel(RB.getStringResource(RB_KEY, "fileType.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "fileTypeMnemonic.txt"))));
        fileTypeLabel.setDisplayedMnemonic(keyEvent);
        fileTypeLabel.setLabelFor(this.fileTypes);
        this.fileTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent menuTypeChoices) {
                BaseRemoteFileSelectorPanel baseRemoteFileSelectorPanel = RemoteFileNamePanel.this.parentComponent;
                RemoteFileNamePanel.this.parentComponent;
                RemoteFileNamePanel.this.filter = baseRemoteFileSelectorPanel.getActionSupportFilter(BaseRemoteFileSelectorPanel.FILTER_TYPE_FILTER);
                ActionList actions = RemoteFileNamePanel.this.parentComponent.getActionProvider().getActions(RemoteFileNamePanel.this.filter);
                if (actions != null) {
                    List list = actions.getActions();
                    SwingAction action = (SwingAction)list.get(0);
                    try {
                        action.setAttribute("selectedKey", RemoteFileNamePanel.this.fileTypes.getSelectedItem());
                    }
                    catch (AttributeSetException attributeSetException) {
                        // empty catch block
                    }
                    action.actionPerformed(new ActionEvent(this, 1, "FilterType"));
                }
            }
        });
        this.fileNameField = new JTextField(20);
        Runnable doRequestFocus = new Runnable(){

            @Override
            public void run() {
                RemoteFileNamePanel.this.fileNameField.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(doRequestFocus);
        JLabel saveFileLabel = new JLabel(RB.getStringResource(RB_KEY, "saveFileString.txt"));
        keyEvent = new Integer(Util.getKeyMapping((String)("VK_" + RB.getStringResource(RB_KEY, "saveFileMnemonic.txt"))));
        saveFileLabel.setDisplayedMnemonic(keyEvent);
        saveFileLabel.setLabelFor(this.fileNameField);
        JPanel saveFileLeft = new JPanel();
        AutoSizingGridLayout saveFileLeftLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        saveFileLeftLayout.setRemainderColumn(0);
        saveFileLeft.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 45));
        saveFileLeft.setLayout((LayoutManager)saveFileLeftLayout);
        saveFileLeft.add(saveFileLabel);
        saveFileLeft.add(this.fileNameField);
        saveFileLeft.add(fileTypeLabel);
        saveFileLeft.add(this.fileTypes);
        AutoSizingGridLayout saveFileRightLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        this.actionButtonPanel = new JPanel((LayoutManager)saveFileRightLayout);
        AutoSizingGridLayout saveFilePanelLayout = new AutoSizingGridLayout(1, 2, 10, 10, true, true, true);
        saveFilePanelLayout.setRemainderColumn(1);
        this.setLayout((LayoutManager)saveFilePanelLayout);
        this.add(saveFileLeft);
        this.add(this.actionButtonPanel);
    }

    public void addActionButtons(JButton action, JButton cancel) {
        this.actionButtonPanel.removeAll();
        this.actionButtonPanel.add(action);
        this.actionButtonPanel.add(cancel);
    }

    public void setRemoteFileViewComponent(RemoteFileComponentInterface component) {
        this.viewComponent = component;
        this.viewComponent.addPropertyChangeListener(this);
    }

    public String getFileName() {
        return this.fileNameField.getText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("selections")) {
            List selections = this.viewComponent.getSelections();
            if (selections != null) {
                String tempString = selections.toString();
                tempString = tempString.substring(1, tempString.length() - 1);
                this.fileNameField.setText(tempString);
            } else {
                this.fileNameField.setText(null);
            }
        }
    }
}

