/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector.RemoteFileDrillableToObjectTransform;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector.RemoteFileMetadataNameToStringTransform;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesAuthorToObjectTransform;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesFileMetadata;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesKeywordsToObjectTransform;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesModTimeToDateTransform;
import com.sas.swing.models.remotefileselector.informationservices.InformationServicesModel;
import com.sas.swing.visuals.remotefileselector.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector.InformationServicesSearchPanel;
import com.sas.swing.visuals.remotefileselector.RB;
import com.sas.swing.visuals.remotefileselector.RemoteFileMetadataNameCellRenderer;
import com.sas.swing.visuals.remotefileselector.RemoteFileSelectorDialog;
import com.sas.swing.visuals.remotefileselector.informationservices.InformationServicesAuthorCellRenderer;
import com.sas.swing.visuals.remotefileselector.informationservices.InformationServicesDateCellRenderer;
import com.sas.swing.visuals.remotefileselector.informationservices.InformationServicesKeywordsCellRenderer;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.util.transforms.TransformInterface;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class InformationServicesSelectorPanel
extends BaseRemoteFileSelectorPanel {
    private static final String RB_KEY = "RemoteFileSelector.";

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, RepositoryInterface repository, boolean returnSelectedItems, boolean showDirectoriesOnly) {
        InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(initialPath, repository, null, showDirectoriesOnly);
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(returnSelectedItems);
    }

    public static List showDialog(JFrame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, UserContextInterface user, boolean returnSelectedItem, boolean showDirectoriesOnly) {
        InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(initialPath, user, null, showDirectoriesOnly);
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(true);
    }

    public InformationServicesSelectorPanel(String initialPath, RepositoryInterface repository, Map fileTypes, boolean showDirectoriesOnly) {
        super(showDirectoriesOnly);
        TransformInterface[] transformArray = new TransformInterface[]{RemoteFileMetadataNameToStringTransform.defaultInstance, InformationServicesAuthorToObjectTransform.defaultInstance, InformationServicesModTimeToDateTransform.defaultInstance, InformationServicesKeywordsToObjectTransform.defaultInstance, RemoteFileDrillableToObjectTransform.defaultInstance};
        String[] nameArray = new String[]{RB.getStringResource(RB_KEY, "name.txt"), RB.getStringResource(RB_KEY, "author.txt"), RB.getStringResource(RB_KEY, "modDate.txt"), RB.getStringResource(RB_KEY, "keywords.txt"), "drillable"};
        Object[] columnRenderers = new Object[]{RemoteFileMetadataNameCellRenderer.defaultInstance, InformationServicesAuthorCellRenderer.defaultInstance, InformationServicesDateCellRenderer.defaultInstance, InformationServicesKeywordsCellRenderer.defaultInstance};
        if (fileTypes == null) {
            fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(RB.getStringResource(RB_KEY, "allfiles.txt"), "*");
            fileTypes.put(RB.getStringResource(RB_KEY, "storedprocess.txt"), "StoredProcess");
            fileTypes.put(RB.getStringResource(RB_KEY, "infomap.txt"), "InformationMap");
            fileTypes.put(RB.getStringResource(RB_KEY, "report.txt"), "Report");
        }
        InformationServicesModel service = new InformationServicesModel(repository);
        InformationServicesSearchPanel searchPanel = new InformationServicesSearchPanel(initialPath, repository);
        String supportType = "REMOTE_INFO_SERVICE_SUPPORT";
        this.initialize(initialPath, transformArray, nameArray, columnRenderers, service, supportType, fileTypes, searchPanel);
    }

    public InformationServicesSelectorPanel(String initialPath, RepositoryInterface repository, TransformInterface[] transformArray, String[] nameArray, Map fileTypes, boolean showDirectoriesOnly) {
        this(initialPath, repository, transformArray, nameArray, null, fileTypes, showDirectoriesOnly);
    }

    public InformationServicesSelectorPanel(String initialPath, RepositoryInterface repository, TransformInterface[] transformArray, String[] nameArray, Object[] columnRenderers, Map fileTypes, boolean showDirectoriesOnly) {
        super(showDirectoriesOnly);
        if (fileTypes == null) {
            fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(RB.getStringResource(RB_KEY, "allfiles.txt"), "*");
            fileTypes.put(RB.getStringResource(RB_KEY, "storedprocess.txt"), "StoredProcess");
            fileTypes.put(RB.getStringResource(RB_KEY, "infomap.txt"), "InformationMap");
            fileTypes.put(RB.getStringResource(RB_KEY, "report.txt"), "Report");
        }
        InformationServicesModel service = new InformationServicesModel(repository);
        InformationServicesSearchPanel searchPanel = new InformationServicesSearchPanel(initialPath, repository);
        String supportType = "REMOTE_INFO_SERVICE_SUPPORT";
        this.initialize(initialPath, transformArray, nameArray, columnRenderers, service, supportType, fileTypes, searchPanel);
    }

    public InformationServicesSelectorPanel(String initialPath, UserContextInterface user, Object object, boolean showDirectoriesOnly) {
        super(showDirectoriesOnly);
        TransformInterface[] transformArray = new TransformInterface[]{RemoteFileMetadataNameToStringTransform.defaultInstance, InformationServicesAuthorToObjectTransform.defaultInstance, InformationServicesModTimeToDateTransform.defaultInstance, InformationServicesKeywordsToObjectTransform.defaultInstance, RemoteFileDrillableToObjectTransform.defaultInstance};
        String[] nameArray = new String[]{RB.getStringResource(RB_KEY, "name.txt"), RB.getStringResource(RB_KEY, "author.txt"), RB.getStringResource(RB_KEY, "modDate.txt"), RB.getStringResource(RB_KEY, "keywords.txt"), "drillable"};
        Object[] columnRenderers = new Object[]{RemoteFileMetadataNameCellRenderer.defaultInstance, InformationServicesAuthorCellRenderer.defaultInstance, InformationServicesDateCellRenderer.defaultInstance, InformationServicesKeywordsCellRenderer.defaultInstance};
        if (this.fileTypes == null) {
            this.fileTypes = new LinkedHashMap();
            this.fileTypes.put(RB.getStringResource(RB_KEY, "allfiles.txt"), "*");
            this.fileTypes.put(RB.getStringResource(RB_KEY, "storedprocess.txt"), "StoredProcess");
            this.fileTypes.put(RB.getStringResource(RB_KEY, "infomap.txt"), "InformationMap");
            this.fileTypes.put(RB.getStringResource(RB_KEY, "report.txt"), "Report");
        }
        InformationServicesModel service = new InformationServicesModel(user);
        InformationServicesSearchPanel searchPanel = new InformationServicesSearchPanel(initialPath, user);
        String supportType = "REMOTE_INFO_SERVICE_SUPPORT";
        this.initialize(initialPath, transformArray, nameArray, columnRenderers, service, supportType, this.fileTypes, searchPanel);
    }

    @Override
    public List getReturnedInformation(boolean returnSelectedItems) {
        return this.getSelectedItems();
    }

    private List getSelectedItems() {
        ArrayList<String> fileNames = new ArrayList<String>();
        String modelPath = this.model.getPath();
        Object selectionObj = this.component.getSelectionObject();
        JComponent viewer = this.component.getViewComponent();
        TableModel tableModel = null;
        if (viewer instanceof JTable) {
            tableModel = ((JTable)viewer).getModel();
        }
        if (selectionObj instanceof ListSelectionModel) {
            ListSelectionModel selectionModel = (ListSelectionModel)selectionObj;
            int iMin = selectionModel.getMinSelectionIndex();
            int iMax = selectionModel.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                String saveFile = this.filePanel.getFileName();
                if (saveFile != null) {
                    fileNames.add(this.serviceModel.getFullyQualifiedPath(modelPath, saveFile));
                }
            } else {
                for (int i = iMin; i <= iMax; ++i) {
                    RemoteFileMetadataInterface node;
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    int index = i;
                    if (tableModel instanceof SortableTableModelAdapter) {
                        index = ((SortableTableModelAdapter)tableModel).convertRowIndexToModel(i);
                    }
                    if ((node = this.model.getNodeAt(index)) instanceof InformationServicesFileMetadata) {
                        InformationServicesFileMetadata isfm = (InformationServicesFileMetadata)node;
                        try {
                            try {
                                String url = isfm.getServiceObject().getPathUrl().toString();
                                fileNames.add(url);
                            }
                            catch (ServiceException e) {
                                LoggerRepository2.getLogger((String)InformationServicesSelectorPanel.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                            }
                        }
                        catch (RemoteException e) {}
                        continue;
                    }
                    String nodeName = node.getName();
                    String nodePath = node.getPath();
                    fileNames.add(this.serviceModel.getFullyQualifiedPath(nodePath, nodeName));
                }
            }
        }
        return fileNames;
    }
}

