/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.remotefileselector;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.SwingActionProviderViewInterface;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.entities.AttributeSetException;
import com.sas.swing.models.remotefileselector.RemoteFileServerModel;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.visuals.remotefileselector.RemoteFileButtonPanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentInterface;
import com.sas.swing.visuals.remotefileselector.RemoteFileComponentPanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileNamePanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileSearchPanel;
import com.sas.swing.visuals.remotefileselector.RemoteFileSelectorDialog;
import com.sas.swing.visuals.remotefileselector.RemoteFileShortcutPanel;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class BaseRemoteFileSelectorPanel
extends JPanel
implements SwingActionProviderViewInterface,
ContentsChangedListener {
    private boolean[] showPanel = new boolean[]{true, true, true};
    private boolean showDirectoriesOnly;
    protected LinkedHashMap fileTypes;
    private int typeOfDialog;
    public static int TOOLBAR_FILTER = 0;
    public static int TABLE_DATA_FILTER = 1;
    public static int TABLE_HEADER_FILTER = 2;
    public static int DRILL_DOWN_FILTER = 4;
    public static int FILTER_TYPE_FILTER = 5;
    protected static boolean cancelled;
    protected RemoteFileComponentInterface component;
    public RemoteFileNamePanel filePanel;
    public RemoteFileButtonPanel buttonPanel;
    public RemoteFileShortcutPanel shortcutPanel;
    public RemoteFileComponentPanel viewPanel;
    public String supportType;
    protected TransformInterface[] transforms;
    protected String[] columnNames;
    protected RemoteFileServiceModelInterface serviceModel;
    protected RemoteFileServerModelInterface model;
    protected ActionSupportFilter tableDataCellFilter;
    protected ActionSupportFilter tableColumnHeaderFilter;
    protected ActionSupportFilter toolbarFilter;
    protected ActionSupportFilter drillDownFilter;
    protected ActionSupportFilter filterTypeFilter;
    protected SwingViewerSupport viewerSupport;
    private CommonLoggerInterface log = this.log = LoggerRepository2.getLogger((String)BaseRemoteFileSelectorPanel.class.getPackage().getName(), null);

    public static List showDialog(Frame parent, String titleOfDialog, boolean modal, int typeOfDialog, String initialPath, TransformInterface[] transforms, String[] columnNames, RemoteFileServiceModelInterface serviceModel, boolean returnSelectedItems, boolean showDirectoriesOnly, RemoteFileSearchPanel searchPanel) {
        BaseRemoteFileSelectorPanel panel = new BaseRemoteFileSelectorPanel(initialPath, transforms, columnNames, serviceModel, null, showDirectoriesOnly, searchPanel);
        RemoteFileSelectorDialog dialog = new RemoteFileSelectorDialog(parent, titleOfDialog, modal, typeOfDialog, panel);
        dialog.setVisible(true);
        if (cancelled) {
            return new ArrayList();
        }
        return panel.getReturnedInformation(returnSelectedItems);
    }

    public BaseRemoteFileSelectorPanel() {
        this(null, null, null, null, null, false, null);
    }

    public BaseRemoteFileSelectorPanel(boolean showDirectoriesOnly) {
        this(null, null, null, null, null, showDirectoriesOnly, null);
    }

    public BaseRemoteFileSelectorPanel(String initialPath, TransformInterface[] transforms, String[] columnNames, RemoteFileServiceModelInterface serviceModel, Map filterTypes, boolean showDirectoriesOnly, RemoteFileSearchPanel searchPanel) {
        this.showDirectoriesOnly = showDirectoriesOnly;
        this.setShowShortcutPanel(false);
        if (initialPath != null) {
            this.initialize(initialPath, transforms, columnNames, serviceModel, null, filterTypes, null);
        }
    }

    public void initialize(String initialPath, TransformInterface[] transforms, String[] columnNames, RemoteFileServiceModelInterface serviceModel, String supportType, Map filterTypes, RemoteFileSearchPanel searchPanel) {
        this.initialize(initialPath, transforms, columnNames, null, serviceModel, supportType, filterTypes, searchPanel);
    }

    public void initialize(String initialPath, TransformInterface[] transforms, String[] columnNames, Object[] columnRenderers, RemoteFileServiceModelInterface serviceModel, String supportType, Map filterTypes, RemoteFileSearchPanel searchPanel) {
        this.serviceModel = serviceModel;
        this.supportType = supportType;
        initialPath = serviceModel.getDirectoryPath(initialPath);
        if (filterTypes == null) {
            filterTypes = new LinkedHashMap<String, String>();
            filterTypes.put("All Files", "*");
        }
        this.fileTypes = new LinkedHashMap(filterTypes);
        ArrayList<String> tempList = new ArrayList<String>();
        if (this.fileTypes != null) {
            ArrayList typeValues = new ArrayList(this.fileTypes.values());
            String filterValue = (String)typeValues.get(0);
            tempList.add(filterValue);
        }
        serviceModel.setFilterValues(tempList);
        this.viewPanel = new RemoteFileComponentPanel(this);
        this.component = this.viewPanel.getViewComponent();
        this.component.setShowDirectoriesOnly(this.showDirectoriesOnly);
        this.component.setColumnRenderers(columnRenderers);
        this.model = new RemoteFileServerModel(initialPath, serviceModel, this.showDirectoriesOnly, transforms, columnNames);
        this.viewPanel.setRemoteModel(this.model);
        this.viewerSupport = new SwingViewerSupport((ActionProviderViewInterface)this);
        if (this.getActionProvider() == null) {
            this.setActionProvider(new SwingActionProvider());
        }
        this.component.setActionProvider(this.getActionProvider());
        if (this.supportType == "REMOTE_IFILE_SERVICE_SUPPORT") {
            this.viewerSupport.setActionSupportType("REMOTE_IFILE_SERVICE_SUPPORT");
            this.tableDataCellFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_DATA_CELL_AREA", (ActionProviderViewInterface)this);
            this.tableColumnHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_COLUMN_HEADER_AREA", (ActionProviderViewInterface)this);
            this.toolbarFilter = new ActionSupportFilter(this.getActionSupportType(), "TOOLBAR_AREA", (ActionProviderViewInterface)this);
            this.drillDownFilter = new ActionSupportFilter(this.getActionSupportType(), "DRILL_DOWN_AREA", (ActionProviderViewInterface)this);
            this.filterTypeFilter = new ActionSupportFilter(this.getActionSupportType(), "FILTER_TYPE_AREA", (ActionProviderViewInterface)this);
        } else if (this.supportType == "REMOTE_INFO_SERVICE_SUPPORT") {
            this.viewerSupport.setActionSupportType("REMOTE_INFO_SERVICE_SUPPORT");
            this.tableDataCellFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_DATA_CELL_AREA", (ActionProviderViewInterface)this);
            this.tableColumnHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "TABLE_COLUMN_HEADER_AREA", (ActionProviderViewInterface)this);
            this.toolbarFilter = new ActionSupportFilter(this.getActionSupportType(), "TOOLBAR_AREA", (ActionProviderViewInterface)this);
            this.drillDownFilter = new ActionSupportFilter(this.getActionSupportType(), "DRILL_DOWN_AREA", (ActionProviderViewInterface)this);
            this.filterTypeFilter = new ActionSupportFilter(this.getActionSupportType(), "FILTER_TYPE_AREA", (ActionProviderViewInterface)this);
        }
        try {
            this.toolbarFilter.setAttribute("path", (Object)initialPath);
            this.toolbarFilter.setAttribute("serviceModel", (Object)serviceModel);
            this.toolbarFilter.setAttribute("model", (Object)this.model);
            this.toolbarFilter.setAttribute("component", (Object)this.component);
            if (searchPanel != null) {
                this.toolbarFilter.setAttribute("searchPanel", (Object)searchPanel);
                this.toolbarFilter.setAttribute("parentFrame", (Object)this.getTopLevelAncestor());
            }
            this.drillDownFilter.setAttribute("path", (Object)initialPath);
            this.drillDownFilter.setAttribute("model", (Object)this.model);
            this.drillDownFilter.setAttribute("component", (Object)this.component);
            this.filterTypeFilter.setAttribute("model", (Object)this.model);
            this.filterTypeFilter.setAttribute("path", (Object)initialPath);
            this.filterTypeFilter.setAttribute("filterTypes", (Object)this.fileTypes);
        }
        catch (AttributeSetException ase) {
            this.log.error(ase.getMessage(), (Throwable)ase);
        }
        if (this.showPanel[0]) {
            this.buttonPanel = new RemoteFileButtonPanel(this);
        }
        if (this.showPanel[1]) {
            this.filePanel = new RemoteFileNamePanel(this.fileTypes, this);
        }
        if (this.showPanel[2]) {
            this.shortcutPanel = new RemoteFileShortcutPanel(null);
        }
        if (this.buttonPanel != null) {
            this.buttonPanel.setRemoteFileViewComponent(this.component);
        }
        if (this.filePanel != null) {
            this.filePanel.setRemoteFileViewComponent(this.component);
        }
        if (this.shortcutPanel != null) {
            AutoSizingGridLayout compositeLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
            compositeLayout.setIgnoreSizeOfNonVisibleComponents(true);
            this.setLayout((LayoutManager)compositeLayout);
            this.add(this.shortcutPanel);
            JPanel mainPanel = new JPanel();
            AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
            mainLayout.setRemainderRow(2);
            mainPanel.setLayout((LayoutManager)mainLayout);
            if (this.buttonPanel != null) {
                mainPanel.add(this.buttonPanel);
            }
            if (this.viewPanel != null) {
                mainPanel.add(this.viewPanel);
            }
            if (this.filePanel != null) {
                mainLayout.setDefaultCellGravity(2);
                mainPanel.add(this.filePanel);
            }
            this.add(mainPanel);
        } else {
            AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
            mainLayout.setRemainderRow(2);
            this.setLayout((LayoutManager)mainLayout);
            if (this.buttonPanel != null) {
                this.add(this.buttonPanel);
            }
            if (this.viewPanel != null) {
                this.add(this.viewPanel);
            }
            if (this.filePanel != null) {
                mainLayout.setDefaultCellGravity(2);
                this.add(this.filePanel);
            }
        }
    }

    public void setCancelled(boolean value) {
        cancelled = value;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    public void setShowDirectoriesOnly(boolean showDirectoriesOnly) {
        this.showDirectoriesOnly = showDirectoriesOnly;
    }

    public boolean isShowDirectoriesOnly() {
        return this.showDirectoriesOnly;
    }

    public void setShowButtonPanel(boolean show) {
        this.showPanel[0] = show;
    }

    public void setShowFileNamePanel(boolean show) {
        this.showPanel[1] = show;
    }

    public void setShowShortcutPanel(boolean show) {
        this.showPanel[2] = show;
    }

    public RemoteFileComponentInterface getViewComponent() {
        return this.component;
    }

    public void setDialogType(int typeOfDialog) {
        this.typeOfDialog = typeOfDialog;
    }

    public List getReturnedInformation(boolean returnSelectedItems) {
        return this.getSelectedItems();
    }

    private List getSelectedItems() {
        ArrayList<String> fileNames = new ArrayList<String>();
        String modelPath = this.model.getPath();
        List selections = this.component.getSelections();
        if (selections == null || selections.size() == 0 || selections.size() == 1) {
            String saveFile = this.filePanel.getFileName();
            if (saveFile != null) {
                fileNames.add(this.serviceModel.getFullyQualifiedPath(modelPath, saveFile));
                this.log.debug("Selected file name is:", saveFile);
            }
        } else if (selections != null) {
            for (int i = 0; i < selections.size(); ++i) {
                fileNames.add(this.serviceModel.getFullyQualifiedPath(modelPath, selections.get(i).toString()));
            }
        }
        return fileNames;
    }

    public void setServiceModel(RemoteFileServiceModelInterface serviceModel) {
        this.serviceModel = serviceModel;
    }

    public void setTransforms(TransformInterface[] transforms) {
        this.transforms = transforms;
    }

    public void setColumnLabels(String[] columnLabels) {
        this.columnNames = columnLabels;
    }

    public void contentsChanged(ContentsChangedEvent event) {
        Map eventInfo = ((ActionProviderEvent)event).getEventInfo();
        if (eventInfo.containsKey("path")) {
            String path = (String)eventInfo.get("path");
            try {
                this.filterTypeFilter.setAttribute("path", (Object)path);
            }
            catch (AttributeSetException ase) {
                this.log.error(ase.getMessage(), (Throwable)ase);
            }
            this.component.refreshData(path);
        } else if (eventInfo.containsKey("viewType")) {
            String view = (String)eventInfo.get("viewType");
            this.viewPanel.setViewComponent(view);
            this.component = this.viewPanel.getViewComponent();
            try {
                this.toolbarFilter.setAttribute("component", (Object)this.component);
                this.drillDownFilter.setAttribute("component", (Object)this.component);
            }
            catch (AttributeSetException ase) {
                this.log.error(ase.getMessage(), (Throwable)ase);
            }
            if (this.buttonPanel != null) {
                this.buttonPanel.setRemoteFileViewComponent(this.component);
            }
            if (this.filePanel != null) {
                this.filePanel.setRemoteFileViewComponent(this.component);
            }
            this.firePropertyChange("viewType", null, view);
        }
    }

    public ActionSupportFilter getActionSupportFilter(int filter) {
        if (filter == TOOLBAR_FILTER) {
            return this.toolbarFilter;
        }
        if (filter == DRILL_DOWN_FILTER) {
            return this.drillDownFilter;
        }
        if (filter == FILTER_TYPE_FILTER) {
            return this.filterTypeFilter;
        }
        return null;
    }

    public void setActionProvider(SwingActionProvider actionProvider) {
        if (this.viewerSupport.getActionProvider() != actionProvider) {
            SwingActionProvider old = this.viewerSupport.getActionProvider();
            if (old != null) {
                old.removeContentsChangedListener((ContentsChangedListener)this);
            }
            this.viewerSupport.setActionProvider(actionProvider);
            if (actionProvider != null) {
                actionProvider.addContentsChangedListener((ContentsChangedListener)this);
            }
            this.firePropertyChange("actionProvider", old, actionProvider);
        }
    }

    public SwingActionProvider getActionProvider() {
        return this.viewerSupport.getActionProvider();
    }

    public void setActionVisible(String actionType, String areaType, boolean visible) {
        this.viewerSupport.setActionVisible(actionType, areaType, visible);
    }

    public boolean isActionVisible(String actionType, String areaType) {
        return this.viewerSupport.isActionVisible(actionType, areaType);
    }

    public Object getUniqueId() {
        return this.viewerSupport.getUniqueId();
    }

    public void setUniqueId(Object uniqueId) {
        this.viewerSupport.setUniqueId(uniqueId);
    }

    public Collection listAreaTypes() {
        return this.viewerSupport.listAreaTypes();
    }

    public Collection listActionTypes(String areaType) {
        return this.viewerSupport.listActionTypes(areaType);
    }

    public void setActionSupportType(String actionSupportType) {
        if (this.viewerSupport.getActionSupportType() != actionSupportType) {
            String old = this.viewerSupport.getActionSupportType();
            this.viewerSupport.setActionSupportType(actionSupportType);
            this.firePropertyChange("actionSupportType", old, actionSupportType);
        }
    }

    public String getActionSupportType() {
        return this.viewerSupport.getActionSupportType();
    }
}

