/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import java.util.ArrayList;

@SASScope(value="ALL")
public class OLAPTableFormatArea {
    ArrayList levelInfos_;
    String measure;

    public OLAPTableFormatArea() {
        this.levelInfos_ = new ArrayList();
    }

    @SASScope
    public OLAPTableFormatArea(String[][] levelMap, String measure) {
        this.setLevelMap(levelMap);
        this.setMeasure(measure);
    }

    @SASScope
    public void clearLevelMap() {
        this.levelInfos_.clear();
    }

    @SASScope
    public String[][] getLevelMap() {
        String[][] levelMap = new String[this.levelInfos_.size()][];
        for (int i = 0; i < this.levelInfos_.size(); ++i) {
            LevelInfo li = (LevelInfo)this.levelInfos_.get(i);
            levelMap[i] = new String[]{li.getDimension(), li.getHierarchy(), li.getLevel()};
        }
        return levelMap;
    }

    private void setLevelMap(String[][] levelMap) {
        for (int i = 0; i < levelMap.length; ++i) {
            String[] level = levelMap[i];
            LevelInfo levelInfo = new LevelInfo();
            levelInfo.setDimension(level[0]);
            levelInfo.setHierarchy(level[1]);
            levelInfo.setLevel(level[2]);
            this.levelInfos_.add(levelInfo);
        }
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public void setLevel(String dimension, String hierarchy, String level) {
        LevelInfo levelinfo = this.getLevel(dimension, hierarchy, level);
        if (levelinfo == null) {
            levelinfo = new LevelInfo();
            levelinfo.setDimension(dimension);
            levelinfo.setHierarchy(hierarchy);
            levelinfo.setLevel(level);
            this.levelInfos_.add(levelinfo);
        }
    }

    @SASScope
    public LevelInfo getLevel(String dimension, String hierarchy, String level) {
        for (int i = 0; i < this.levelInfos_.size(); ++i) {
            LevelInfo li = (LevelInfo)this.levelInfos_.get(i);
            if (!this.match(li.getDimension(), dimension) || !this.match(li.getHierarchy(), hierarchy) || !this.match(li.getLevel(), level)) continue;
            return li;
        }
        return null;
    }

    private boolean match(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    @SASScope
    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        if (this.getMeasure() != null) {
            buf.append('$').append(this.getMeasure());
        }
        for (int i = 0; i < this.levelInfos_.size(); ++i) {
            LevelInfo li = (LevelInfo)this.levelInfos_.get(i);
            buf.append('[').append(li.getDimension()).append("].[").append(OLAPTableFormatArea.checkNull(li.getHierarchy())).append("][").append(li.getLevel()).append("]");
        }
        return buf.toString();
    }

    private static String checkNull(String str) {
        return str == null ? "" : str;
    }

    @SASScope
    public static class LevelInfo {
        private String dimension;
        private String hierarchy;
        private String level;

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getHierarchy() {
            return this.hierarchy;
        }

        public void setHierarchy(String hierarchy) {
            this.hierarchy = hierarchy;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }
    }
}

