/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.olaptableview.OLAPNavigationalAction;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

@SASScope(value="ALL")
public class OLAPPagingAction
extends OLAPNavigationalAction {
    private boolean forwards;
    private boolean vertically;
    private boolean toLimit;

    public OLAPPagingAction(boolean extend, boolean forwards, boolean vertically, boolean toLimit) {
        super(0, 0, false, extend, false);
        this.forwards = forwards;
        this.vertically = vertically;
        this.toLimit = toLimit;
    }

    public void actionPerformed(ActionEvent e) {
        OLAPTableView table = null;
        if (e.getSource() instanceof OLAPTableView) {
            table = (OLAPTableView)((Object)e.getSource());
        }
        if (table != null) {
            int currentRow = table.getCurrentRow();
            int currentColumn = table.getCurrentColumn();
            ListSelectionModel sm = null;
            int startRow = 0;
            int startCol = 0;
            int columnCount = table.getColumnCount();
            int rowCount = table.getRowCount();
            if (currentRow < 0 && currentColumn >= 0) {
                if (this.extend && table.getColumnSelectionAllowed() && table.getSelectedColumnCount() > 0) {
                    sm = table.getColumnModel().getSelectionModel();
                    startRow = sm.getLeadSelectionIndex() / columnCount;
                    startCol = sm.getLeadSelectionIndex() % columnCount;
                } else {
                    startRow = currentRow;
                    startCol = currentColumn;
                }
            } else if (currentColumn < 0 && currentRow >= 0) {
                if (this.extend && table.getRowSelectionAllowed() && table.getSelectedRowCount() > 0) {
                    sm = table.getRowModel().getSelectionModel();
                    startRow = sm.getLeadSelectionIndex() % rowCount;
                    startCol = sm.getLeadSelectionIndex() / rowCount;
                } else {
                    startRow = currentRow;
                    startCol = currentColumn;
                }
            } else if (currentRow >= 0 && currentColumn >= 0) {
                if (this.extend && table.getCellSelectionEnabled() && table.getSelectedCellCount() > 0) {
                    sm = table.getSelectionModel();
                    startRow = sm.getLeadSelectionIndex() / columnCount;
                    startCol = sm.getLeadSelectionIndex() % columnCount;
                } else {
                    startRow = currentRow;
                    startCol = currentColumn;
                }
            } else {
                return;
            }
            if (this.toLimit) {
                if (this.vertically) {
                    this.dx = 0;
                    this.dy = this.forwards ? rowCount : -startRow;
                } else {
                    this.dx = this.forwards ? columnCount : -startCol;
                    this.dy = 0;
                }
            } else {
                if (!(table.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension delta = table.getParent().getSize();
                if (this.vertically) {
                    Rectangle r = table.getCellRect(startRow, 0, true);
                    r.y = r.y + (this.forwards ? delta.height : -delta.height);
                    this.dx = 0;
                    int newRow = table.rowAtPoint(r.getLocation());
                    if (newRow < 0) {
                        newRow = this.forwards ? rowCount - 1 : 0;
                    }
                    if (startRow >= 0 && newRow >= 0) {
                        table.getRowHeader().sizeRowsToFit(Math.min(startRow, newRow), Math.max(startRow, newRow), false);
                        r = table.getCellRect(startRow, 0, true);
                        r.y = r.y + (this.forwards ? delta.height : -delta.height);
                        newRow = table.rowAtPoint(r.getLocation());
                        if (newRow == -1) {
                            newRow = this.forwards ? rowCount - 1 : 0;
                        }
                        this.dy = newRow - startRow;
                    } else {
                        this.dy = 0;
                    }
                } else {
                    if (startCol >= 0) {
                        Rectangle r = table.getCellRect(0, startCol, true);
                        r.x = r.x + (this.forwards ? delta.width : -delta.width);
                        int newColumn = table.columnAtPoint(r.getLocation());
                        if (newColumn == -1) {
                            newColumn = this.forwards ? columnCount : 0;
                        }
                        this.dx = newColumn - startCol;
                    } else {
                        this.dx = 0;
                    }
                    this.dy = 0;
                }
            }
        }
        super.actionPerformed(e);
    }
}

