/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.models.OLAPDataSetInterfaceProvider;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPHeaderRenderer;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.OriginComponent;
import com.sas.swing.visuals.tableview.OriginComponentUI;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

@SASScope(value="ALL")
public class OLAPOriginComponent
extends OriginComponent
implements TableModelListener {
    private static final String uiClassID = "OLAPOriginComponentUI";
    protected int rowAxisLabelsHeight;
    protected int preferredRowLevelHeight;
    protected int preferredHeightForLastColumnLevel;
    protected TableCellRenderer rowLabelRenderer;
    protected TableCellRenderer columnLabelRenderer;
    protected boolean rowHeightSet;
    private Filter filter;

    public OLAPOriginComponent() {
        this(null);
    }

    public OLAPOriginComponent(TableView table) {
        super(table);
    }

    public void initializeLocalVars() {
        this.rowAxisLabelsHeight = -1;
        this.preferredRowLevelHeight = -1;
        this.preferredHeightForLastColumnLevel = -1;
        this.rowHeightSet = false;
        this.setRowLabelRenderer(this.createDefaultRowLabelRenderer());
        this.setColumnLabelRenderer(this.createDefaultColumnLabelRenderer());
        this.filter = new Filter();
        this.updateUI();
    }

    public void setTable(TableView newTable) {
        if (this.table != newTable) {
            TableView old = this.table;
            this.table = newTable;
            this.resetSizes();
            this.firePropertyChange("table", old, this.table);
        }
    }

    public TableCellRenderer getRowLabelRenderer() {
        return this.rowLabelRenderer;
    }

    public void setRowLabelRenderer(TableCellRenderer newRenderer) {
        if (this.rowLabelRenderer != newRenderer) {
            TableCellRenderer old = this.rowLabelRenderer;
            this.rowLabelRenderer = newRenderer;
            this.firePropertyChange("rowLabelRenderer", old, this.rowLabelRenderer);
        }
    }

    public TableCellRenderer getColumnLabelRenderer() {
        return this.columnLabelRenderer;
    }

    public void setColumnLabelRenderer(TableCellRenderer newRenderer) {
        if (this.columnLabelRenderer != newRenderer) {
            TableCellRenderer old = this.columnLabelRenderer;
            this.columnLabelRenderer = newRenderer;
            this.firePropertyChange("columnLabelRenderer", old, this.columnLabelRenderer);
        }
    }

    protected TableCellRenderer createDefaultRowLabelRenderer() {
        OLAPHeaderRenderer label = new OLAPHeaderRenderer();
        label.setHorizontalAlignment(10);
        label.setVerticalAlignment(3);
        return label;
    }

    protected TableCellRenderer createDefaultColumnLabelRenderer() {
        OLAPHeaderRenderer label = new OLAPHeaderRenderer();
        label.setHorizontalAlignment(11);
        label.setVerticalAlignment(1);
        return label;
    }

    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.olaptableview.BasicOLAPOriginComponentUI");
        }
        this.setUI((OriginComponentUI)UIManager.getUI((JComponent)((Object)this)));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public OLAPRowHeader getRowHeader() {
        if (this.table != null) {
            return (OLAPRowHeader)this.table.getRowHeader();
        }
        return null;
    }

    public OLAPColumnHeader getColumnHeader() {
        if (this.table != null) {
            return (OLAPColumnHeader)((Object)this.table.getTableHeader());
        }
        return null;
    }

    public String getColumnLabel(int level) {
        if (this.getTable().getModel() instanceof OLAPDataSetInterfaceProvider) {
            try {
                AxisInterface axis;
                if (this.getColumnHeader() != null && (axis = this.getColumnHeader().getAxis()) != null) {
                    MetadataInterface metadata;
                    String[] colLabels = axis.getAxisHeaders();
                    String[] dimNames = axis.getDimensionNames();
                    String cubeName = ((OLAPDataSetInterfaceProvider)this.getTable().getModel()).getOLAPDataSetInterface().getCubeName();
                    if (cubeName != null && dimNames != null && dimNames.length > level && (metadata = ((OLAPDataSetInterfaceProvider)this.getTable().getModel()).getOLAPDataSetInterface().getDatabaseMetadata()) != null) {
                        this.filter.setDimensionName(dimNames[level]);
                        this.filter.setCubeName(cubeName);
                        DimensionInterface[] dims = metadata.getDimensions(this.filter);
                        for (int i = 0; i < dims.length; ++i) {
                            if (dims[i].getType() != 2) continue;
                            return " ";
                        }
                    }
                    if (colLabels != null && colLabels.length > level) {
                        return colLabels[level];
                    }
                    return null;
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPOriginComponent.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return " ";
    }

    public String getRowLabel(int level) {
        if (this.getTable().getModel() instanceof OLAPDataSetInterfaceProvider) {
            try {
                AxisInterface axis;
                if (this.getRowHeader() != null && (axis = this.getRowHeader().getAxis()) != null) {
                    String[] rowLabels = axis.getAxisHeaders();
                    String[] dimNames = axis.getDimensionNames();
                    String cubeName = ((OLAPDataSetInterfaceProvider)this.getTable().getModel()).getOLAPDataSetInterface().getCubeName();
                    if (cubeName != null && dimNames != null && dimNames.length > level) {
                        MetadataInterface metadata = ((OLAPDataSetInterfaceProvider)this.getTable().getModel()).getOLAPDataSetInterface().getDatabaseMetadata();
                        this.filter.setDimensionName(dimNames[level]);
                        this.filter.setCubeName(cubeName);
                        DimensionInterface[] dims = metadata.getDimensions(this.filter);
                        for (int i = 0; i < dims.length; ++i) {
                            if (dims[i].getType() != 2) continue;
                            return " ";
                        }
                    }
                    if (rowLabels != null && rowLabels.length > level) {
                        return rowLabels[level];
                    }
                    return null;
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPOriginComponent.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return " ";
    }

    protected void refreshRowLevelHeight() {
        int height = this.getColumnHeader().getLevelHeight(this.getColumnHeader().getMaxLevelCount() - 1);
        if (!this.rowHeightSet) {
            int heightChange = (height - this.preferredRowLevelHeight - this.preferredHeightForLastColumnLevel) / 2;
            this.rowAxisLabelsHeight = heightChange + this.preferredRowLevelHeight;
            if (this.rowAxisLabelsHeight > height) {
                this.rowAxisLabelsHeight = height;
            }
        }
    }

    public int getPreferredRowLevelWidth(int level) {
        int rendWidth;
        Component comp = this.getRowHeaderRendererComponent(level);
        int maxWidth = rendWidth = comp.getPreferredSize().width;
        int colLevelCount = this.getColumnHeader().getMaxLevelCount();
        int maxColWidth = 0;
        for (int i = 0; i < colLevelCount; ++i) {
            comp = this.getColumnHeaderRendererComponent(i);
            rendWidth = comp.getPreferredSize().width;
            maxColWidth = Math.max(maxColWidth, rendWidth);
        }
        if (maxColWidth > maxWidth) {
            int maxLevelCount = this.getRowHeader().getMaxLevelCount();
            int totalLevelWidths = maxWidth;
            for (int i = level + 1; i < maxLevelCount; ++i) {
                comp = this.getRowHeaderRendererComponent(i);
                totalLevelWidths += comp.getPreferredSize().width;
            }
            if (maxColWidth > totalLevelWidths) {
                maxWidth = maxColWidth - (totalLevelWidths - maxWidth);
            }
        }
        return maxWidth;
    }

    public int getPreferredColumnLevelHeight(int level) {
        int levelHeight = 0;
        int colLevelCount = this.getColumnHeader().getMaxLevelCount();
        if (colLevelCount == level + 1) {
            if (this.preferredRowLevelHeight == -1) {
                int size = this.getRowHeader().getMaxLevelCount();
                for (int i = 0; i < size; ++i) {
                    if (this.getRowLabel(i) != null) {
                        Component comp = this.getRowHeaderRendererComponent(i);
                        int rendererHeight = comp.getPreferredSize().height;
                        levelHeight = Math.max(levelHeight, rendererHeight);
                        continue;
                    }
                    levelHeight = 0;
                }
                this.rowAxisLabelsHeight = levelHeight;
                this.preferredRowLevelHeight = levelHeight;
            }
            levelHeight = this.rowAxisLabelsHeight;
        }
        if (this.getColumnLabel(level) != null) {
            Component comp = this.getColumnHeaderRendererComponent(level);
            this.preferredHeightForLastColumnLevel = comp.getPreferredSize().height;
        } else {
            this.preferredHeightForLastColumnLevel = 0;
        }
        int height = levelHeight + this.preferredHeightForLastColumnLevel;
        if (height == 0) {
            height = this.getColumnHeader().getPreferredLevelHeight(level);
        }
        return height;
    }

    public int getRowLevelHeight() {
        return this.rowAxisLabelsHeight;
    }

    public void setRowLevelHeight(int newHeight) {
        if (newHeight != this.rowAxisLabelsHeight) {
            this.rowHeightSet = true;
            int old = this.rowAxisLabelsHeight;
            this.rowAxisLabelsHeight = newHeight;
            this.firePropertyChange("rowLevelHeight", old, newHeight);
        }
    }

    protected Component getColumnHeaderRendererComponent(int levelIndex) {
        TableCellRenderer renderer = this.getColumnLabelRenderer();
        if (renderer == null) {
            renderer = this.getColumnHeader().getDefaultRenderer();
        }
        boolean hasFocus = false;
        if (this.getTable().isFocusOwner()) {
            int maxLevel;
            int curLevel;
            int curCol = ((OLAPTableView)this.getTable()).getCurrentColumn();
            int curRow = ((OLAPTableView)this.getTable()).getCurrentRow();
            if (curCol < 0 && curRow < -1 && (curLevel = (maxLevel = this.getColumnHeader().getMaxLevelCount()) - 1 - (Math.abs(curRow) - 2)) == levelIndex) {
                hasFocus = true;
            }
        }
        return renderer.getTableCellRendererComponent((JTable)this.getTable(), this.getColumnLabel(levelIndex), false, hasFocus, -levelIndex, -1);
    }

    protected Component getRowHeaderRendererComponent(int levelIndex) {
        TableCellRenderer renderer = this.getRowLabelRenderer();
        if (renderer == null) {
            renderer = this.getRowHeader().getDefaultRenderer();
        }
        boolean hasFocus = false;
        if (this.getTable().isFocusOwner()) {
            int maxLevel;
            int curLevel;
            int curCol = ((OLAPTableView)this.getTable()).getCurrentColumn();
            int curRow = ((OLAPTableView)this.getTable()).getCurrentRow();
            if (curCol < 0 && curRow == -1 && (curLevel = (maxLevel = this.getRowHeader().getMaxLevelCount()) - 1 - (Math.abs(curCol) - 1)) == levelIndex) {
                hasFocus = true;
            }
        }
        return renderer.getTableCellRendererComponent((JTable)this.getTable(), this.getRowLabel(levelIndex), false, hasFocus, -levelIndex, -1);
    }

    public int getRowLevelAtPoint(Point point) {
        if (point.y < this.getHeight() - this.rowAxisLabelsHeight) {
            return -1;
        }
        int x = point.x;
        int width = 0;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (!ltr) {
            width = this.getWidth() - 1;
        }
        int maxLevelCount = this.getRowHeader().getMaxLevelCount();
        int result = 0;
        if (ltr) {
            int i = 0;
            while (width <= x) {
                if (i == maxLevelCount) {
                    result = maxLevelCount - 1;
                    break;
                }
                int levelWidth = this.getRowHeader().getLevelWidth(i);
                if ((width += levelWidth) > x) {
                    result = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (width >= x) {
                if (i == maxLevelCount) {
                    result = maxLevelCount - 1;
                    break;
                }
                int levelWidth = this.getRowHeader().getLevelWidth(i);
                if ((width -= levelWidth) < x) {
                    result = i;
                }
                ++i;
            }
        }
        if (result < 0) {
            return -1;
        }
        if (result >= maxLevelCount) {
            return -1;
        }
        return result;
    }

    public int getColumnLevelAtPoint(Point point) {
        if (point.y >= this.getHeight() - this.rowAxisLabelsHeight) {
            return -1;
        }
        int y = point.y;
        int height = 0;
        int maxLevelCount = this.getColumnHeader().getMaxLevelCount();
        int result = 0;
        int i = 0;
        while (height <= y) {
            if (i == maxLevelCount) {
                result = maxLevelCount - 1;
                break;
            }
            int levelHeight = this.getColumnHeader().getLevelHeight(i);
            if ((height += levelHeight) > y) {
                result = i;
            }
            ++i;
        }
        if (result < 0) {
            return -1;
        }
        if (result >= maxLevelCount) {
            return -1;
        }
        return result;
    }

    protected void resetSizes() {
        this.rowHeightSet = false;
        this.preferredRowLevelHeight = -1;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e == null || e.getFirstRow() == -1) {
            this.resetSizes();
            this.repaint();
        }
    }
}

