/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.tableview.NavigationalAction;
import com.sas.swing.visuals.tableview.TableView;

@SASScope(value="ALL")
public class OLAPNavigationalAction
extends NavigationalAction {
    public OLAPNavigationalAction(int dx, int dy, boolean toggle, boolean extend, boolean inSelection) {
        super(dx, dy, toggle, extend, inSelection);
    }

    protected int clipToRange(int i, int a, int b) {
        return Math.min(Math.max(i, a), b);
    }

    protected void moveWithinTableRange(TableView table, int dx, int dy, boolean changeLead) {
        int col;
        int row;
        if (changeLead) {
            row = this.leadRow;
            col = this.leadColumn;
        } else {
            row = this.anchorRow;
            col = this.anchorColumn;
        }
        int rowMin = Integer.MIN_VALUE;
        int colMin = Integer.MIN_VALUE;
        int rowMax = table.getRowCount() - 1;
        int colMax = table.getColumnCount() - 1;
        try {
            if (row < 0 && col >= 0) {
                if (changeLead) {
                    rowMax = 0;
                }
                int maxLevel = ((OLAPColumnHeader)table.getColumnHeader()).getMaxLevelCount();
                rowMin = -maxLevel;
                int curLevel = maxLevel - 1 - (Math.abs(row) - 1);
                TupleElementInterface tupleElement = ((OLAPColumnHeader)table.getColumnHeader()).getTupleElementAt(col, curLevel);
                if (dx == 1) {
                    dx = tupleElement.getMaximumCoordinate() + dx - col;
                } else if (dx == -1) {
                    int min = tupleElement.getMinimumCoordinate();
                    dx = min + dx - col;
                    if (min == 0) {
                        --rowMin;
                        --dy;
                    }
                }
                int span = tupleElement.getSpan();
                if (span > 1 && dx == 0) {
                    TupleElementInterface[] elements = ((OLAPColumnHeader)table.getColumnHeader()).getTupleElementsForCoordinate(col);
                    int dest = 0;
                    for (int i = 0; i <= elements.length && (dest += elements[i].getSpan()) <= curLevel; ++i) {
                    }
                    if (dy == -1) {
                        dest = dest - span - 1;
                    }
                    dy = dest - curLevel;
                }
            } else if (col < 0 && row >= 0) {
                if (changeLead) {
                    colMax = 0;
                }
                int maxLevel = ((OLAPRowHeader)table.getRowHeader()).getMaxLevelCount();
                colMin = -maxLevel;
                int curLevel = maxLevel - 1 - (Math.abs(col) - 1);
                TupleElementInterface tupleElement = ((OLAPRowHeader)table.getRowHeader()).getTupleElementAt(row, curLevel);
                if (dy == 1) {
                    dy = tupleElement.getMaximumCoordinate() + dy - row;
                } else if (dy == -1) {
                    int min = tupleElement.getMinimumCoordinate();
                    dy = min + dy - row;
                }
                int span = tupleElement.getSpan();
                if (span > 1 && dy == 0) {
                    TupleElementInterface[] elements = ((OLAPRowHeader)table.getRowHeader()).getTupleElementsForCoordinate(row);
                    int dest = 0;
                    for (int i = 0; i <= elements.length && (dest += elements[i].getSpan()) <= curLevel; ++i) {
                    }
                    if (dx == -1) {
                        dest = dest - span - 1;
                    }
                    dx = dest - curLevel;
                }
            } else if (row < 0 && col < 0) {
                if (changeLead) {
                    rowMax = 0;
                    colMax = 0;
                    dy = 0;
                    dx = 0;
                } else {
                    rowMin = -((OLAPColumnHeader)table.getColumnHeader()).getMaxLevelCount() - 1;
                    colMin = -((OLAPRowHeader)table.getRowHeader()).getMaxLevelCount();
                    if (dx == 1 && row < -1) {
                        dx = -col;
                        ++dy;
                    }
                }
            } else if (changeLead) {
                rowMin = 0;
                colMin = 0;
            } else {
                rowMin = -((OLAPColumnHeader)table.getColumnHeader()).getMaxLevelCount();
                colMin = -((OLAPRowHeader)table.getRowHeader()).getMaxLevelCount();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        row = this.clipToRange(row + dy, rowMin, rowMax);
        col = this.clipToRange(col + dx, colMin, colMax);
        if (changeLead) {
            this.leadRow = row;
            this.leadColumn = col;
        } else {
            this.anchorRow = row;
            this.anchorColumn = col;
        }
    }
}

