/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.embedded.OLAPDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@SASScope(value="ALL")
public class OLAPDrillStateUtil {
    public static final int NONE = 0;
    public static final int DIMENSION = 1;
    public static final int HIERARCHY = 2;

    public static List getOLAPDrillStateInfo(OLAPDataSetInterface model, boolean includeAllMember) {
        return OLAPDrillStateUtil.getOLAPDrillStateInfo(model, includeAllMember, false);
    }

    public static List getOLAPDrillStateInfo(OLAPDataSetInterface model, boolean includeAllMember, boolean useCachedTuples) {
        ArrayList allAxesDrillInfo = new ArrayList();
        OLAPDrillStateUtil.getAxisDrillStateInfo(model, OLAPDrillStateUtil.getDrilledDimensionElements(1, model, includeAllMember, useCachedTuples), includeAllMember, allAxesDrillInfo);
        OLAPDrillStateUtil.getAxisDrillStateInfo(model, OLAPDrillStateUtil.getDrilledDimensionElements(0, model, includeAllMember, useCachedTuples), includeAllMember, allAxesDrillInfo);
        return allAxesDrillInfo;
    }

    @SASScope
    public static List getDrilledDimensionElements(int axisType, OLAPDataSetInterface model, boolean includeAllMember, boolean useCachedTuples) {
        HashMap<String, TupleElementInterface> drilledElementMap = new HashMap<String, TupleElementInterface>();
        if (model != null && !(model instanceof OLAPDataSet)) {
            try {
                ResultSetMetadataInterface metadata = model.getResultSetMetadata();
                AxisInterface[] axesArray = metadata.getAxes(axisType, 1);
                if (axesArray == null || axesArray.length == 0) {
                    return new ArrayList();
                }
                AxisInterface axis = axesArray[0];
                TupleInterface[] tuples = null;
                tuples = useCachedTuples ? axis.getTuples(-12, -18) : axis.getTuples(0, -1);
                int maxTupleDepth = axis.getMaximumTupleDepth();
                String[] dimensionNames = axis.getDimensionNames();
                block2: for (int i = 0; i < maxTupleDepth; ++i) {
                    Object[] tupleElements = OLAPUtil.getTupleElementsForLevel((int)i, (TupleInterface[])tuples);
                    for (int j = 0; j < tupleElements.length; ++j) {
                        TupleInterface parentTuple;
                        int elementIndex;
                        int span;
                        TupleElementInterface element = (TupleElementInterface)tupleElements[j];
                        int elementLevelDepth = element.getLevelDepth();
                        String dimension = dimensionNames[i];
                        if (!includeAllMember && elementLevelDepth == 0) continue;
                        if (!(drilledElementMap.containsKey(dimension) && elementLevelDepth >= ((TupleElementInterface)drilledElementMap.get(dimension)).getLevelDepth() || element.getType() == TupleElementType.TOTAL || element.getType() == TupleElementType.SUBTOTAL)) {
                            drilledElementMap.put(dimension, element);
                        }
                        if ((span = element.getSpan()) <= 1 || (element.getType() == TupleElementType.TOTAL || element.getType() == TupleElementType.SUBTOTAL) && (elementIndex = element.getTupleElementIndex()) + 1 < (parentTuple = element.getTuple()).getTupleDepth() && parentTuple.getElement(elementIndex + 1).getSpan() == 0) continue;
                        i += span - 1;
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                return new ArrayList();
            }
        }
        return new ArrayList(drilledElementMap.values());
    }

    private static void getAxisDrillStateInfo(OLAPDataSetInterface model, List drilledElements, boolean includeAllMember, List drillInfoList) {
        if (model == null || drilledElements == null || drillInfoList == null || model instanceof OLAPDataSet) {
            return;
        }
        for (TupleElementInterface tupleElement : drilledElements) {
            List drillInfo = OLAPDrillStateUtil.getAncestorInfo(tupleElement, model, includeAllMember);
            if (drillInfo.isEmpty()) continue;
            drillInfoList.add(drillInfo);
        }
    }

    public static List getAncestorInfo(TupleElementInterface element, OLAPDataSetInterface model, boolean includeAllMember) {
        boolean showAll = includeAllMember;
        ArrayList<Object> ancestorInfo = new ArrayList<Object>(7);
        if (model != null && element != null && !(model instanceof OLAPDataSet)) {
            try {
                MetadataInterface metadata = model.getDatabaseMetadata();
                String cubeName = model.getCubeName();
                if (cubeName != null && metadata != null) {
                    BusinessQuery bq;
                    Filter filter = new Filter();
                    filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                    filter.setUniqueMemberName(element.getName());
                    filter.setCubeName(cubeName);
                    if (model instanceof BusinessQueryProviderInterface && ((bq = ((BusinessQueryProviderInterface)model).getBusinessQuery()) == null || bq.getInputStructure().isRelational())) {
                        return ancestorInfo;
                    }
                    MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                    Arrays.sort(members, MemberLevelComparator.defaultInstance);
                    int ancestorCount = members.length - 1;
                    if (ancestorCount >= 1) {
                        ArrayList<String> ancestorLabels = new ArrayList<String>();
                        ArrayList<String> ancestorUniqueNames = new ArrayList<String>();
                        ancestorInfo.add(Boolean.FALSE);
                        ancestorInfo.add(ancestorLabels);
                        ancestorInfo.add(ancestorUniqueNames);
                        ancestorInfo.add(element);
                        ancestorInfo.add(new Boolean(includeAllMember));
                        for (int i = 0; i < ancestorCount; ++i) {
                            if (i == 0) {
                                Object level2;
                                HierarchyInterface hierarchy;
                                LevelInterface level = members[i].getLevel();
                                boolean isAllLevel = OLAPUtil.isAllLevel((LevelInterface)level);
                                if (isAllLevel && includeAllMember) {
                                    hierarchy = level.getHierarchy();
                                    ancestorLabels.add(hierarchy.getLabel());
                                    ancestorUniqueNames.add(level.getUniqueName());
                                    Boolean o = ancestorInfo.set(0, Boolean.TRUE);
                                    level2 = members[i + 1].getLevel();
                                    ancestorLabels.add(members[i].getLabel());
                                    ancestorUniqueNames.add(level2.getUniqueName());
                                } else if (isAllLevel && !includeAllMember && members.length > 2) {
                                    LevelInterface level22 = members[i + 1].getLevel();
                                    HierarchyInterface hierarchy2 = level22.getHierarchy();
                                    ancestorLabels.add(hierarchy2.getLabel());
                                    ancestorUniqueNames.add(level22.getUniqueName());
                                    level2 = ancestorInfo.set(0, Boolean.FALSE);
                                } else if (!isAllLevel) {
                                    hierarchy = level.getHierarchy();
                                    ancestorLabels.add(hierarchy.getLabel());
                                    LevelInterface[] levels = hierarchy.getLevels();
                                    if (levels.length > 1) {
                                        String levelName = levels[1].getUniqueName();
                                        ancestorUniqueNames.add(levelName);
                                    }
                                    Boolean o = ancestorInfo.set(0, Boolean.FALSE);
                                    ancestorLabels.add(members[i].getLabel());
                                    ancestorUniqueNames.add(members[i].getUniqueName());
                                }
                                hierarchy = level.getHierarchy();
                                String hierarchyLabel = hierarchy.getLabel();
                                String dimensionLabel = hierarchy.getDimension().getLabel();
                                ancestorInfo.add(0, hierarchyLabel);
                                ancestorInfo.add(0, dimensionLabel);
                                continue;
                            }
                            ancestorLabels.add(members[i].getLabel());
                            ancestorUniqueNames.add(members[i].getUniqueName());
                        }
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return ancestorInfo;
    }

    public static List getAncestorAxisHeaders(TupleElementInterface element, OLAPDataSetInterface model) {
        ArrayList<String> ancestorLabels = new ArrayList<String>();
        if (model != null && element != null && !(model instanceof OLAPDataSet)) {
            try {
                MetadataInterface metadata = model.getDatabaseMetadata();
                String cubeName = model.getCubeName();
                if (cubeName != null && metadata != null) {
                    BusinessQuery bq;
                    if (model instanceof BusinessQueryProviderInterface && ((bq = ((BusinessQueryProviderInterface)model).getBusinessQuery()) == null || bq.getInputStructure().isRelational())) {
                        return ancestorLabels;
                    }
                    Filter filter = new Filter();
                    String uniqueLevelName = element.getUniqueLevelName();
                    int depth = element.getLevelDepth();
                    filter.setCubeName(cubeName);
                    filter.setUniqueLevelName(uniqueLevelName);
                    LevelInterface[] levels = metadata.getLevels(filter);
                    LevelInterface[] dimLevels = levels[0].getHierarchy().getLevels();
                    if (depth > 0 && depth < dimLevels.length) {
                        ancestorLabels.add(dimLevels[depth - 1].getLabel());
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return ancestorLabels;
    }
}

