/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeaderSelectionModel;
import com.sas.swing.visuals.olaptableview.OLAPHeaderRenderer;
import com.sas.swing.visuals.olaptableview.OLAPOriginComponent;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.olaptableview.RB;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.UIManager;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

@SASScope(value="ALL")
public class OLAPColumnHeader
extends ColumnHeader {
    private static final String uiClassID = "OLAPColumnHeaderUI";
    public static final String RB_KEY = "OLAPColumnHeader.";
    protected AxisInterface axis;
    protected SizeSequence levelHeights;
    protected List columnLevelHeights;
    private TupleInterface[] tuples;

    public OLAPColumnHeader() {
        this(null);
    }

    public OLAPColumnHeader(TableColumnModel model) {
        super(model);
    }

    protected TableColumnModel createDefaultColumnModel() {
        TableColumnModel columnModel = super.createDefaultColumnModel();
        columnModel.setSelectionModel((ListSelectionModel)((Object)new OLAPColumnHeaderSelectionModel((OLAPTableView)((Object)this.getTable()))));
        return columnModel;
    }

    protected TableCellRenderer createDefaultRenderer() {
        OLAPHeaderRenderer renderer = new OLAPHeaderRenderer();
        renderer.setVerticalAlignment(1);
        return renderer;
    }

    private int getWidthInRightToLeft() {
        if (this.table != null && this.table.getAutoResizeMode() != 0) {
            return this.table.getWidth();
        }
        return super.getWidth();
    }

    public int levelAtPoint(Point point) {
        int column = this.columnAtPoint(point);
        if (column == -1) {
            return -1;
        }
        int y = point.y;
        int height = 0;
        int maxLevelCount = this.getMaxLevelCount();
        int result = 0;
        int i = 0;
        while (height <= y) {
            if (i == maxLevelCount) {
                result = maxLevelCount - 1;
                break;
            }
            int levelHeight = this.getLevelHeight(i);
            if ((height += levelHeight) > y) {
                result = i;
            }
            ++i;
        }
        if (result < 0) {
            return -1;
        }
        if (result >= maxLevelCount) {
            return -1;
        }
        return result;
    }

    public Rectangle getHeaderRect(int column, int level) {
        Rectangle r = new Rectangle();
        TableColumnModel tcm = this.getColumnModel();
        int maxLevelCount = this.getMaxLevelCount();
        int levelCount = this.getLevelCount(column);
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (column < 0) {
            if (!ltr) {
                r.x = this.getWidthInRightToLeft();
            }
        } else if (column >= tcm.getColumnCount()) {
            if (ltr) {
                r.x = this.getWidth();
            }
        } else {
            int spanCount;
            int i;
            TupleElementInterface[] tupleElements = this.getTupleElementsForCoordinate(column);
            int min = 0;
            int max = 0;
            int span = 0;
            try {
                int elementIndex = 0;
                i = 0;
                for (spanCount = 0; spanCount <= level; spanCount += tupleElements[i].getSpan()) {
                    elementIndex = i++;
                }
                min = tupleElements[elementIndex].getMinimumCoordinate();
                max = tupleElements[elementIndex].getMaximumCoordinate();
                span = tupleElements[elementIndex].getSpan();
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            int colWidth = 0;
            for (i = 0; i <= max; ++i) {
                if (i <= min) {
                    r.x += colWidth;
                }
                colWidth = tcm.getColumn(i).getWidth();
                if (i < min) continue;
                r.width += colWidth;
            }
            if (!ltr) {
                r.x = this.getWidthInRightToLeft() - r.x - r.width + 1;
            }
            for (i = 0; i < spanCount - span; ++i) {
                r.y += this.getLevelHeight(i);
            }
            r.height = 0;
            for (i = spanCount - span; i < spanCount; ++i) {
                r.height += this.getLevelHeight(i);
            }
        }
        return r;
    }

    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.reorderingAllowed = false;
        this.setHoldingEnabled(false);
        this.tuples = null;
    }

    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void setHoldingEnabled(boolean b) {
        super.setHoldingEnabled(false);
    }

    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.olaptableview.BasicOLAPColumnHeaderUI");
        }
        this.setUI((TableHeaderUI)UIManager.getUI((JComponent)((Object)this)));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setAxis(AxisInterface newAxis) {
        if (this.axis != newAxis) {
            AxisInterface oldValue = this.axis;
            this.axis = newAxis;
            if (this.columnLevelHeights != null) {
                this.columnLevelHeights.clear();
            }
            this.levelHeights = null;
            this.lastColumnSized = -1;
            this.tuples = null;
            this.sizeColumnsToFit();
            this.firePropertyChange("axis", oldValue, this.axis);
        }
    }

    public AxisInterface getAxis() {
        return this.axis;
    }

    public TupleElementInterface[] getTupleElementsForCoordinate(int axisCoordinate) {
        TupleElementInterface[] axisLabels = new TupleElementInterface[]{};
        try {
            if (this.getAxis() == null) {
                return axisLabels;
            }
            TupleInterface[] axisTuples = this.getTuples();
            if (axisTuples != null && axisTuples.length > axisCoordinate && axisCoordinate != -1) {
                axisLabels = axisTuples[axisCoordinate].getElements(0, -1);
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return axisLabels;
    }

    public int getMaxLevelCount() {
        try {
            if (this.getAxis() != null) {
                return this.getAxis().getAxisHeaders().length;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return 0;
    }

    public int getLevelCount(int column) {
        try {
            if (this.getAxis() != null) {
                TupleInterface tuple = this.getTuples()[column];
                return tuple.getTupleDepth();
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    protected SizeSequence getLevelHeights() {
        if (this.levelHeights == null) {
            this.levelHeights = new SizeSequence(this.getMaxLevelCount(), -1);
        }
        return this.levelHeights;
    }

    public int getLevelHeight(int level) {
        int i;
        Object obj;
        int listSize;
        int size;
        if (this.levelHeights != null && (size = this.levelHeights.getSize(level)) != -1) {
            return size;
        }
        if (this.columnLevelHeights == null) {
            this.columnLevelHeights = new ArrayList();
        }
        if ((listSize = this.columnLevelHeights.size()) > level && level >= 0 && (obj = this.columnLevelHeights.get(level)) != null && obj instanceof Integer && (i = ((Integer)obj).intValue()) != -1) {
            return i;
        }
        int columnLevelHeight = 0;
        if (((OLAPTableView)((Object)this.getTable())).getOriginComponent() instanceof OLAPOriginComponent) {
            columnLevelHeight = ((OLAPOriginComponent)((Object)((OLAPTableView)((Object)this.getTable())).getOriginComponent())).getPreferredColumnLevelHeight(level);
        }
        columnLevelHeight = Math.max(this.getPreferredLevelHeight(level), columnLevelHeight);
        for (i = this.columnLevelHeights.size(); i < level + 1; ++i) {
            this.columnLevelHeights.add(i, new Integer(-1));
        }
        this.columnLevelHeights.set(level, new Integer(columnLevelHeight));
        return columnLevelHeight;
    }

    public int getPreferredLevelHeight(int level) {
        int levelHeight = 0;
        try {
            TupleElementInterface[] tupleElements = OLAPUtil.getTupleElementsForLevel((int)level, (TupleInterface[])this.getTuples(), (boolean)false, (int)-1);
            for (int j = 0; j < tupleElements.length; ++j) {
                Component comp = this.getHeaderRendererComponent(tupleElements[j], level, tupleElements[j].getMaximumCoordinate());
                int rendererHeight = comp.getPreferredSize().height;
                levelHeight = Math.max(levelHeight, rendererHeight);
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
        }
        return levelHeight;
    }

    public Component getHeaderRendererComponent(TupleElementInterface element, int level, int column) {
        TableCellRenderer renderer = null;
        if (renderer == null) {
            renderer = this.getDefaultRenderer();
        }
        boolean selected = false;
        int levelCount = this.getMaxLevelCount();
        int columnCount = this.table.getColumnCount();
        TupleElementInterface[] elements = this.getTupleElementsForCoordinate(column);
        int span = 0;
        for (int i = 0; i < elements.length && i <= level; ++i) {
            try {
                int sp = elements[i].getSpan();
                if (sp <= 1) continue;
                span += sp - 1;
                continue;
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        int ordinal = column + Math.max(0, levelCount - 1 - level - span) * columnCount;
        if (this.getTable().isColumnSelected(ordinal)) {
            selected = true;
        }
        boolean hasFocus = false;
        if (this.getTable().isFocusOwner()) {
            int curCol = ((OLAPTableView)((Object)this.getTable())).getCurrentColumn();
            int curRow = ((OLAPTableView)((Object)this.getTable())).getCurrentRow();
            if (curRow < 0 && curCol >= 0) {
                int curLevel = this.getMaxLevelCount() - 1 - (Math.abs(curRow) - 1);
                try {
                    TupleElementInterface tupleElement = this.getTupleElementAt(curCol, curLevel);
                    if (tupleElement != null && tupleElement.getMinimumCoordinate() == element.getMinimumCoordinate() && tupleElement.getMaximumCoordinate() == element.getMaximumCoordinate() && tupleElement.getTupleElementIndex() == element.getTupleElementIndex()) {
                        hasFocus = true;
                    }
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return renderer.getTableCellRendererComponent(this.getTable(), element, selected, hasFocus, level, column);
    }

    public void setLevelHeight(int level, int levelHeight) {
        JComponent axis;
        if (levelHeight < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "LevelHeightLessThanZero.txt"));
        }
        this.getLevelHeights().setSize(level, levelHeight);
        if (((TableView)this.getTable()).isRowHeaderVisible() && (axis = ((TableView)this.getTable()).getOriginComponent()) instanceof OLAPOriginComponent) {
            ((OLAPOriginComponent)((Object)axis)).refreshRowLevelHeight();
        }
        this.resizeAndRepaint();
    }

    public TupleElementInterface getTupleElementAt(int columnIndex, int levelIndex) {
        TupleElementInterface[] labels = this.getTupleElementsForCoordinate(columnIndex);
        if (labels != null && levelIndex != -1) {
            try {
                int count = 0;
                for (int i = 0; i < labels.length; ++i) {
                    if ((count += labels[i].getSpan()) <= levelIndex) continue;
                    return labels[i];
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        Component component;
        TupleElementInterface tup;
        String tip = null;
        Point p = event.getPoint();
        int column = this.columnModel.getColumnIndexAtX(p.x);
        int level = this.levelAtPoint(p);
        if (column != -1 && level != -1 && (tup = this.getTupleElementAt(column, level)) != null && (component = this.getHeaderRendererComponent(tup, level, column)) instanceof JComponent) {
            Rectangle cellRect = this.getHeaderRect(column);
            p.translate(-cellRect.x, -cellRect.y);
            MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            tip = ((JComponent)component).getToolTipText(newEvent);
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    public int[] calculatePreferredWidthForColumns(int[] columns) {
        JTable table;
        if (columns != null && columns.length > 0 && (table = this.getTable()) != null && this.getAxis() != null && table.getAutoResizeMode() == 0 && this.getResizingAllowed()) {
            int colCount = this.getTable().getColumnCount();
            int cellSpacing = this.getColumnModel().getColumnMargin();
            SizeSequence columnSizes = new SizeSequence(colCount);
            int rowCount = this.cellsToSizeCount < 0 ? table.getRowCount() : Math.min(table.getRowCount(), this.cellsToSizeCount);
            int[] maxCellWidths = new int[colCount];
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    TableCellRenderer cellRenderer = this.getTable().getCellRenderer(r, c);
                    Component component = this.getTable().prepareRenderer(cellRenderer, r, c);
                    int cellWidth = component.getPreferredSize().width + cellSpacing;
                    if (cellWidth <= maxCellWidths[c]) continue;
                    maxCellWidths[c] = cellWidth;
                    columnSizes.setSize(c, cellWidth);
                }
            }
            try {
                for (int i = this.getMaxLevelCount() - 1; i >= 0; --i) {
                    TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel((int)i, (TupleInterface[])this.getTuples(), (boolean)true, (int)-1);
                    for (int j = 0; j < elements.length; ++j) {
                        Component component = this.getHeaderRendererComponent(elements[j], i, j);
                        int headerWidth = component.getPreferredSize().width;
                        int index = elements[j].getTuple().getTupleIndex();
                        int min = elements[j].getMinimumCoordinate();
                        int max = elements[j].getMaximumCoordinate();
                        if (headerWidth > columnSizes.getSize(index)) {
                            if (min != max) {
                                int start = columnSizes.getPosition(min);
                                int end = columnSizes.getPosition(max + 1);
                                int span = max - min + 1;
                                if (end - start < headerWidth) {
                                    int size = headerWidth / span;
                                    int leftover = headerWidth % span;
                                    for (int k = min; k <= max; ++k) {
                                        if (leftover > 0) {
                                            columnSizes.setSize(k, size + 1);
                                            --leftover;
                                            continue;
                                        }
                                        columnSizes.setSize(k, size);
                                    }
                                }
                            } else {
                                columnSizes.setSize(index, headerWidth);
                            }
                        }
                        j += max - min;
                    }
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)OLAPColumnHeader.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage(), (Throwable)e);
            }
            int[] sizes = columnSizes.getSizes();
            int[] retSizes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                retSizes[i] = sizes[columns[i]];
            }
            return retSizes;
        }
        return new int[0];
    }

    public void columnAdded(TableColumnModelEvent e) {
        this.resizeAndRepaint();
        this.tuples = null;
    }

    private TupleInterface[] getTuples() throws OLAPException {
        if (this.tuples == null) {
            this.tuples = this.getAxis().getTuples(0, -1);
        }
        return this.tuples == null ? new TupleInterface[]{} : this.tuples;
    }
}

