/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.SwingAction;
import com.sas.codepolicy.SASScope;
import com.sas.commands.olap.DrillDownCommand;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.BasicRowHeaderUI;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

@SASScope(value="ALL")
public class BasicOLAPRowHeaderUI
extends BasicRowHeaderUI {
    protected OLAPRowHeader header;
    protected boolean resizingLevel;
    protected int resizingLevelIndex;
    protected boolean resizingRow;
    protected boolean resizingColumnHeader;
    private static Insets emptyInsets = new Insets(0, 0, 0, 0);

    protected int viewIndexForRow(int row) {
        TableView table = this.header.getTable();
        return table.convertRowIndexToView(row);
    }

    protected int modelIndexForRow(int row) {
        TableView table = this.header.getTable();
        return table.convertRowIndexToModel(row);
    }

    public void setResizingLevelIndex(int newValue) {
        this.resizingLevelIndex = newValue;
    }

    public int getResizingLevelIndex() {
        return this.resizingLevelIndex;
    }

    public void setResizingRow(boolean newValue) {
        this.resizingRow = newValue;
    }

    public void setResizingColumnHeader(boolean newValue) {
        this.resizingColumnHeader = newValue;
    }

    public boolean isResizingRow() {
        return this.resizingRow;
    }

    public boolean isResizingColumnHeader() {
        return this.resizingColumnHeader;
    }

    public static ComponentUI createUI(JComponent h) {
        return new BasicOLAPRowHeaderUI();
    }

    public void installUI(JComponent c) {
        this.header = (OLAPRowHeader)((Object)c);
        super.installUI(c);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public void paint(Graphics g, JComponent c) {
        if (this.header.getRowModel() == null) {
            return;
        }
        if (this.header.getRowModel().getRowCount() <= 0) {
            return;
        }
        Rectangle clipBounds = g.getClipBounds();
        Dimension size = this.header.getSize();
        int levelCount = this.header.getMaxLevelCount();
        if (this.header.isOpaque()) {
            g.setColor(this.header.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Point left = new Point(clipBounds.x, 0);
        Point right = new Point(clipBounds.x + clipBounds.width - 1, clipBounds.y);
        int rMin = this.header.rowAtPoint(new Point(0, clipBounds.y));
        int rMax = this.header.rowAtPoint(new Point(0, clipBounds.y + clipBounds.height - 1));
        int lMax = levelCount - 1;
        int lMin = this.header.levelAtPoint(ltr ? left : right);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.header.getRowModel().getRowCount() - 1;
        }
        if (lMin < 0) {
            lMin = 0;
        }
        this.paintCells(g, rMin, rMax, lMin, lMax);
    }

    private void paintCell(Graphics g, Rectangle cellRect, TupleElementInterface element, int level, int indexOnLevel) {
        Component component = this.header.getHeaderRendererComponent(element, level, indexOnLevel);
        this.rendererPane.add(component);
        Insets borderInsets = null;
        borderInsets = component instanceof JComponent && ((JComponent)component).getBorder() != null ? ((JComponent)component).getBorder().getBorderInsets(component) : emptyInsets;
        Rectangle visibleRect = g.getClipBounds();
        if (cellRect.y < visibleRect.y) {
            cellRect.height = cellRect.height - (visibleRect.y - cellRect.y) + borderInsets.top;
            cellRect.y = visibleRect.y - borderInsets.top;
        }
        if (cellRect.y + cellRect.height > visibleRect.y + visibleRect.height) {
            cellRect.height = visibleRect.y + visibleRect.height - cellRect.y + borderInsets.bottom;
        }
        this.rendererPane.paintComponent(g, component, (Container)((Object)this.header), cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintCells(Graphics g, int rMin, int rMax, int lMin, int lMax) {
        int i;
        TableView table = this.getHeader().getTable();
        int levelCount = this.header.getMaxLevelCount();
        TableRowModel tm = this.header.getRowModel();
        int rowCount = tm.getRowCount();
        int[] rowYCoord = new int[rowCount + 1];
        int[] xCoord = new int[levelCount + 1];
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        for (i = 0; i <= rowCount; ++i) {
            rowYCoord[i] = i == 0 ? 0 : rowYCoord[i - 1] + table.getRowHeight(i - 1);
        }
        if (ltr) {
            for (i = 0; i <= levelCount; ++i) {
                xCoord[i] = i == 0 ? 0 : xCoord[i - 1] + this.header.getLevelWidth(i - 1);
            }
        } else {
            for (i = 0; i <= levelCount; ++i) {
                xCoord[i] = i == 0 ? this.header.getWidth() : xCoord[i - 1] - this.header.getLevelWidth(i - 1);
            }
        }
        Rectangle cellRect = new Rectangle();
        int min = 0;
        int span = 0;
        int spanDepth = 0;
        int max = 0;
        int spanCount = 0;
        TupleElementInterface tupleElement = null;
        for (int j = rMin; j <= rMax; ++j) {
            spanCount = lMin;
            for (int level = lMin; level <= lMax; ++level) {
                TupleElementInterface[] elements = this.header.getTupleElementsForCoordinate(j);
                if (level >= elements.length) continue;
                tupleElement = elements[level];
                try {
                    span = tupleElement.getSpan();
                    spanDepth = tupleElement.getSpanDepth();
                    max = tupleElement.getMaximumCoordinate();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                if (j == max || j == rMax) {
                    try {
                        min = tupleElement.getMinimumCoordinate();
                    }
                    catch (OLAPException oLAPException) {
                        // empty catch block
                    }
                    cellRect.y = rowYCoord[min];
                    cellRect.height = rowYCoord[max + 1] - rowYCoord[min];
                    if (ltr) {
                        cellRect.x = xCoord[spanCount];
                        cellRect.width = xCoord[spanCount + span] - xCoord[spanCount];
                    } else {
                        cellRect.x = xCoord[spanCount + span];
                        cellRect.width = xCoord[spanCount] - xCoord[spanCount + span];
                    }
                    this.paintCell(g, cellRect, tupleElement, spanCount + spanDepth - 1, j);
                }
                spanCount += span;
            }
        }
    }

    protected int getHeaderWidth() {
        if (this.getHeader().isWidthSet()) {
            return this.header.getWidth();
        }
        int width = 0;
        int levels = this.header.getMaxLevelCount();
        for (int i = 0; i < levels; ++i) {
            width += this.header.getLevelWidth(i);
        }
        return width;
    }

    private Dimension createHeaderSize(long height) {
        if (height > Integer.MAX_VALUE) {
            height = Integer.MAX_VALUE;
        }
        return new Dimension(this.getHeaderWidth(), (int)height);
    }

    public Dimension getPreferredSize(JComponent c) {
        long height = 0L;
        TableView table = this.getHeader().getTable();
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            height += (long)table.getRowHeight(i);
        }
        return this.createHeaderSize(height);
    }

    @SASScope
    class MouseInputHandler
    implements MouseInputListener {
        private int lastEffectiveMouseY;
        private int lastEffectiveMouseX;

        MouseInputHandler() {
        }

        private boolean shouldIgnore(MouseEvent e) {
            return !BasicOLAPRowHeaderUI.this.header.getTable().isEnabled() || !BasicOLAPRowHeaderUI.this.header.isEnabled();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && !this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e) && BasicOLAPRowHeaderUI.this.getResizingLevelIndex() == -1 && BasicOLAPRowHeaderUI.this.isResizingRow() && !BasicOLAPRowHeaderUI.this.isResizingColumnHeader() && !e.isConsumed()) {
                BasicOLAPRowHeaderUI.this.header.sizeRowToFit(this.getResizingRow(e.getPoint()));
            }
            if (e.getClickCount() == 2 && !this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e) && BasicOLAPRowHeaderUI.this.getHeader().getDraggedRow() == -1 && BasicOLAPRowHeaderUI.this.getResizingLevelIndex() == -1 && !BasicOLAPRowHeaderUI.this.isResizingRow() && !BasicOLAPRowHeaderUI.this.isResizingColumnHeader() && !e.isConsumed() && BasicOLAPRowHeaderUI.this.getHeader().getTable().isPopupMenuEnabled()) {
                OLAPTableView table = (OLAPTableView)BasicOLAPRowHeaderUI.this.header.getTable();
                Point p = e.getPoint();
                Point point = new Point(p.x - BasicOLAPRowHeaderUI.this.getHeader().getWidth(), p.y);
                int row = table.rowAtPoint(point);
                int column = table.columnAtPoint(point);
                if (row != -1 && column == -1) {
                    List actions;
                    point.x += table.getViewPosition().x;
                    int maxLevel = BasicOLAPRowHeaderUI.this.header.getMaxLevelCount();
                    ActionSupportFilter filter = table.configureRowHeaderActionFilter(row, -(maxLevel - BasicOLAPRowHeaderUI.this.header.levelAtPoint(p)));
                    ActionList list = table.getActionProvider().getActions(filter);
                    if (list != null && (actions = list.getActions()) != null) {
                        int size = actions.size();
                        for (int i = 0; i < size; ++i) {
                            Object o = actions.get(i);
                            if (!(o instanceof BaseAction) || !(((BaseAction)o).getCommand() instanceof DrillDownCommand)) continue;
                            ((SwingAction)o).actionPerformed(new ActionEvent(this, 1001, null));
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                OLAPRowHeader oHeader = (OLAPRowHeader)BasicOLAPRowHeaderUI.this.getHeader();
                oHeader.setResizingRow(-1);
                oHeader.setDraggedDistance(0);
                if (!oHeader.getTable().hasFocus() && oHeader.getTable().isRequestFocusEnabled()) {
                    oHeader.getTable().requestFocus();
                }
                Point p = e.getPoint();
                this.lastEffectiveMouseY = p.y;
                this.lastEffectiveMouseX = p.x;
                int resizeIndex = this.getResizingRow(p);
                if (oHeader.getResizingAllowed() && resizeIndex != -1) {
                    oHeader.setResizingRow(resizeIndex);
                }
                int rowIndex = oHeader.getTable().rowAtPoint(p);
                if (resizeIndex == -1 && rowIndex != -1 && oHeader.getTable().getRowSelectionAllowed()) {
                    int levelIndex = oHeader.levelAtPoint(p);
                    this.setValueIsAdjusting(true);
                    TableView table = oHeader.getTable();
                    int levelCount = oHeader.getMaxLevelCount();
                    int rowCount = table.getRowCount();
                    table.changeSelection(rowIndex + (levelCount - 1 - levelIndex) * rowCount, -1, e.isControlDown(), e.isShiftDown());
                }
                if (!(SwingUtilities.isLeftMouseButton(e) || BasicOLAPRowHeaderUI.this.getHeader().getDraggedRow() != -1 || BasicOLAPRowHeaderUI.this.getResizingLevelIndex() != -1 || BasicOLAPRowHeaderUI.this.isResizingRow() || BasicOLAPRowHeaderUI.this.isResizingColumnHeader() || e.isConsumed() || !BasicOLAPRowHeaderUI.this.getHeader().getTable().isPopupMenuEnabled())) {
                    Point point = BasicOLAPRowHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? new Point(p.x - BasicOLAPRowHeaderUI.this.getHeader().getWidth(), p.y) : new Point(p.x + BasicOLAPRowHeaderUI.this.header.getTable().getWidth(), p.y);
                    BasicOLAPRowHeaderUI.this.getHeader().getTable().showPopup(point);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.validateCursor(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TableView table = BasicOLAPRowHeaderUI.this.getHeader().getTable();
            if (!this.shouldIgnore(e)) {
                int mouseY = e.getY();
                int mouseX = e.getX();
                boolean headerLeftToRight = BasicOLAPRowHeaderUI.this.header.getComponentOrientation().isLeftToRight();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int deltaY = mouseY - this.lastEffectiveMouseY;
                    int deltaX = mouseX - this.lastEffectiveMouseX;
                    int resizingRow = BasicOLAPRowHeaderUI.this.getHeader().getResizingRow();
                    if (BasicOLAPRowHeaderUI.this.getResizingLevelIndex() != -1 && deltaX != 0) {
                        int oldWidth = 0;
                        int levelsWidth = 0;
                        int maxLevelCount = BasicOLAPRowHeaderUI.this.header.getMaxLevelCount();
                        for (int i = BasicOLAPRowHeaderUI.this.getResizingLevelIndex(); i < maxLevelCount; ++i) {
                            int w = BasicOLAPRowHeaderUI.this.header.getLevelWidth(i);
                            if (i == BasicOLAPRowHeaderUI.this.getResizingLevelIndex()) {
                                oldWidth = w;
                            }
                            levelsWidth += w;
                        }
                        int newWidth = oldWidth + deltaX;
                        int otherWidth = BasicOLAPRowHeaderUI.this.header.getSize().width - levelsWidth;
                        JScrollPane pane = ((OLAPTableView)BasicOLAPRowHeaderUI.this.getHeader().getTable()).getScrollPane();
                        int maxWidth = pane.getSize().width - pane.getInsets().left - pane.getInsets().right - otherWidth;
                        if (newWidth < 1) {
                            newWidth = 1;
                        }
                        if (newWidth > maxWidth) {
                            newWidth = maxWidth;
                        }
                        BasicOLAPRowHeaderUI.this.header.setLevelWidth(BasicOLAPRowHeaderUI.this.getResizingLevelIndex(), newWidth);
                        if (headerLeftToRight) {
                            int acheivedDeltaX = BasicOLAPRowHeaderUI.this.header.getLevelWidth(BasicOLAPRowHeaderUI.this.getResizingLevelIndex()) - oldWidth;
                            this.lastEffectiveMouseX += acheivedDeltaX;
                        }
                        BasicOLAPRowHeaderUI.this.getHeader().resizeAndRepaint();
                    }
                    if (resizingRow != -1 && deltaY != 0) {
                        int oldHeight = table.getRowHeight(resizingRow);
                        int newHeight = oldHeight + deltaY;
                        if (newHeight < 4) {
                            newHeight = 4;
                        }
                        table.setRowHeight(resizingRow, newHeight);
                        int acheivedDeltaY = table.getRowHeight(resizingRow) - oldHeight;
                        this.lastEffectiveMouseY += acheivedDeltaY;
                    }
                    if (BasicOLAPRowHeaderUI.this.isResizingColumnHeader() && deltaY != 0) {
                        int cLevelCount;
                        OLAPColumnHeader oHeader = (OLAPColumnHeader)((Object)table.getTableHeader());
                        int oldHeight = oHeader.getLevelHeight((cLevelCount = oHeader.getMaxLevelCount()) - 1);
                        int newHeight = oldHeight + deltaY;
                        if (newHeight < 0) {
                            newHeight = 0;
                        }
                        oHeader.setLevelHeight(cLevelCount - 1, newHeight);
                    }
                } else {
                    this.lastEffectiveMouseY = mouseY;
                    this.lastEffectiveMouseX = mouseX;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.validateCursor(e);
                BasicOLAPRowHeaderUI.this.getHeader().setResizingRow(-1);
                BasicOLAPRowHeaderUI.this.getHeader().setDraggedRow(-1);
                BasicOLAPRowHeaderUI.this.getHeader().setDraggedDistance(0);
                BasicOLAPRowHeaderUI.this.getHeader().repaint();
                TableView table = BasicOLAPRowHeaderUI.this.getHeader().getTable();
                this.setValueIsAdjusting(false);
                if (table != null) {
                    table.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void validateCursor(MouseEvent e) {
            int resizeIndex = -1;
            if (this.getResizingRow(e.getPoint()) != -1) {
                resizeIndex = this.getResizingHeaderLevel(e.getPoint());
                BasicOLAPRowHeaderUI.this.setResizingLevelIndex(resizeIndex);
                BasicOLAPRowHeaderUI.this.setResizingRow(true);
                BasicOLAPRowHeaderUI.this.setResizingColumnHeader(false);
                Cursor resizeCursor = null;
                resizeCursor = resizeIndex == -1 ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(13);
                if (BasicOLAPRowHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                    BasicOLAPRowHeaderUI.this.getHeader().setCursor(resizeCursor);
                }
            } else {
                resizeIndex = this.getResizingHeaderLevel(e.getPoint());
                if (resizeIndex != -1) {
                    BasicOLAPRowHeaderUI.this.setResizingLevelIndex(resizeIndex);
                    BasicOLAPRowHeaderUI.this.setResizingRow(false);
                    BasicOLAPRowHeaderUI.this.setResizingColumnHeader(false);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(10);
                    if (BasicOLAPRowHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicOLAPRowHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else if (this.canResizeColumnHeader(e.getPoint())) {
                    BasicOLAPRowHeaderUI.this.setResizingLevelIndex(-1);
                    BasicOLAPRowHeaderUI.this.setResizingRow(false);
                    BasicOLAPRowHeaderUI.this.setResizingColumnHeader(true);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(8);
                    if (BasicOLAPRowHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicOLAPRowHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else {
                    BasicOLAPRowHeaderUI.this.setResizingLevelIndex(-1);
                    BasicOLAPRowHeaderUI.this.setResizingRow(false);
                    BasicOLAPRowHeaderUI.this.setResizingColumnHeader(false);
                    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                    if (BasicOLAPRowHeaderUI.this.getHeader().getCursor() != defaultCursor) {
                        BasicOLAPRowHeaderUI.this.getHeader().setCursor(defaultCursor);
                    }
                }
            }
        }

        private int getResizingRow(Point p) {
            return this.getResizingRow(p, BasicOLAPRowHeaderUI.this.header.getTable().rowAtPoint(p), BasicOLAPRowHeaderUI.this.header.levelAtPoint(p));
        }

        private int getResizingRow(Point p, int row, int level) {
            if (row == -1) {
                return -1;
            }
            if (level == -1) {
                return -1;
            }
            Rectangle r = BasicOLAPRowHeaderUI.this.header.getHeaderRect(row, level);
            r.grow(0, -3);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.y + r.height / 2;
            int rowIndex = p.y < midPoint ? row - 1 : row;
            return rowIndex;
        }

        private int getResizingHeaderLevel(Point p) {
            return this.getResizingHeaderLevel(p, BasicOLAPRowHeaderUI.this.header.levelAtPoint(p));
        }

        private int getResizingHeaderLevel(Point p, int level) {
            if (level == -1) {
                return -1;
            }
            int row = BasicOLAPRowHeaderUI.this.header.getTable().rowAtPoint(p);
            if (row == -1) {
                return -1;
            }
            Rectangle r = BasicOLAPRowHeaderUI.this.header.getHeaderRect(row, level);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.x + r.width / 2 + r.width % 2;
            int levelIndex = 0;
            if (BasicOLAPRowHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                levelIndex = p.x < midPoint ? level - 1 : level;
            } else {
                int n = levelIndex = p.x < midPoint ? level : level - 1;
            }
            if (levelIndex >= BasicOLAPRowHeaderUI.this.header.getMaxLevelCount()) {
                levelIndex = -1;
            }
            return levelIndex;
        }

        private boolean canResizeColumnHeader(Point p) {
            if (BasicOLAPRowHeaderUI.this.header.getTable().isColumnHeaderVisible()) {
                return p.y < 3;
            }
            return false;
        }

        private void setValueIsAdjusting(boolean flag) {
            TableView table = BasicOLAPRowHeaderUI.this.getHeader().getTable();
            table.getSelectionModel().setValueIsAdjusting(flag);
            table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
            table.getRowModel().getSelectionModel().setValueIsAdjusting(flag);
        }
    }
}

