/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPOriginComponent;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.tableview.BasicOriginComponentUI;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;

@SASScope(value="ALL")
public class BasicOLAPOriginComponentUI
extends BasicOriginComponentUI {
    protected OLAPOriginComponent OLAPOriginComponent;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicOLAPOriginComponentUI();
    }

    public void installUI(JComponent c) {
        this.OLAPOriginComponent = (OLAPOriginComponent)((Object)c);
        this.rendererPane = new CellRendererPane();
        this.OLAPOriginComponent.add(this.rendererPane);
        this.installListeners();
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.OLAPOriginComponent.addMouseListener(this.mouseInputListener);
        this.OLAPOriginComponent.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.OLAPOriginComponent.remove(this.rendererPane);
        this.rendererPane = null;
        this.OLAPOriginComponent = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.OLAPOriginComponent.removeMouseListener(this.mouseInputListener);
        this.OLAPOriginComponent.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle clip = g.getClipBounds();
        this.paintCells(g);
    }

    private void paintColumnLabelCell(Graphics g, Rectangle cellRect, int levelIndex) {
        Component component = this.OLAPOriginComponent.getColumnHeaderRendererComponent(levelIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, (Container)((Object)this.OLAPOriginComponent), cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintRowLabelCell(Graphics g, Rectangle cellRect, int levelIndex) {
        Component component = this.OLAPOriginComponent.getRowHeaderRendererComponent(levelIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, (Container)((Object)this.OLAPOriginComponent), cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintCells(Graphics g) {
        int i;
        boolean noRowLabels;
        boolean noColumnLabels;
        int rowLevelCount;
        int columnLevelCount;
        OLAPRowHeader rowHeader;
        OLAPColumnHeader columnHeader;
        block17: {
            columnHeader = this.OLAPOriginComponent.getColumnHeader();
            rowHeader = this.OLAPOriginComponent.getRowHeader();
            columnLevelCount = columnHeader.getMaxLevelCount();
            rowLevelCount = rowHeader.getMaxLevelCount();
            noColumnLabels = false;
            noRowLabels = false;
            try {
                int i2;
                String[] axisHeaders;
                if (columnHeader.getAxis() != null && columnHeader.getAxis().getAxisHeaders() != null) {
                    noColumnLabels = true;
                    axisHeaders = columnHeader.getAxis().getAxisHeaders();
                    for (i2 = 0; i2 < axisHeaders.length; ++i2) {
                        if (axisHeaders[i2] == null || axisHeaders[i2].length() == 0) continue;
                        noColumnLabels = false;
                        break;
                    }
                }
                if (rowHeader.getAxis() == null || rowHeader.getAxis().getAxisHeaders() == null) break block17;
                noRowLabels = true;
                axisHeaders = rowHeader.getAxis().getAxisHeaders();
                for (i2 = 0; i2 < axisHeaders.length; ++i2) {
                    if (axisHeaders[i2] == null || axisHeaders[i2].length() == 0) continue;
                    noRowLabels = false;
                    break;
                }
            }
            catch (OLAPException axisHeaders) {
                // empty catch block
            }
        }
        int[] xCoord = new int[rowLevelCount + 1];
        int[] yCoord = new int[columnLevelCount + 1];
        boolean ltr = this.OLAPOriginComponent.getComponentOrientation().isLeftToRight();
        if (ltr) {
            for (i = 0; i <= rowLevelCount; ++i) {
                xCoord[i] = i == 0 ? 0 : xCoord[i - 1] + rowHeader.getLevelWidth(i - 1);
            }
        } else {
            for (i = 0; i <= rowLevelCount; ++i) {
                xCoord[i] = i == 0 ? this.OLAPOriginComponent.getWidth() : xCoord[i - 1] - rowHeader.getLevelWidth(i - 1);
            }
        }
        for (i = 0; i <= columnLevelCount; ++i) {
            yCoord[i] = i == 0 ? 0 : yCoord[i - 1] + columnHeader.getLevelHeight(i - 1);
        }
        int lastLevelHeight = yCoord[columnLevelCount] - yCoord[columnLevelCount - 1];
        int n = columnLevelCount;
        yCoord[n] = yCoord[n] - this.OLAPOriginComponent.rowAxisLabelsHeight;
        Rectangle cellRect = new Rectangle();
        if (noColumnLabels && noRowLabels) {
            cellRect.width = this.OLAPOriginComponent.getRowHeader().getWidth();
            cellRect.height = this.OLAPOriginComponent.getColumnHeader().getHeight();
            TableCellRenderer renderer = this.OLAPOriginComponent.getRowLabelRenderer();
            if (renderer == null) {
                renderer = this.OLAPOriginComponent.getColumnHeader().getDefaultRenderer();
            }
            Component component = renderer.getTableCellRendererComponent((JTable)this.OLAPOriginComponent.getTable(), null, false, false, -1, -1);
            this.rendererPane.add(component);
            this.rendererPane.paintComponent(g, component, (Container)((Object)this.OLAPOriginComponent), cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        } else {
            int level;
            cellRect.width = this.OLAPOriginComponent.getRowHeader().getWidth();
            for (level = 0; level < columnLevelCount; ++level) {
                cellRect.y = yCoord[level];
                cellRect.height = yCoord[level + 1] - yCoord[level];
                this.paintColumnLabelCell(g, cellRect, level);
            }
            cellRect.y += cellRect.height;
            cellRect.height = lastLevelHeight - cellRect.height;
            for (level = 0; level < rowLevelCount; ++level) {
                if (ltr) {
                    cellRect.x = xCoord[level];
                    cellRect.width = xCoord[level + 1] - xCoord[level];
                } else {
                    cellRect.x = xCoord[level + 1];
                    cellRect.width = xCoord[level] - xCoord[level + 1];
                }
                this.paintRowLabelCell(g, cellRect, level);
            }
        }
    }

    @SASScope
    class MouseInputHandler
    implements MouseInputListener {
        MouseInputHandler() {
        }

        private boolean shouldIgnore(MouseEvent e) {
            return !BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().isEnabled() || !BasicOLAPOriginComponentUI.this.OLAPOriginComponent.isEnabled();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                if (!BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().hasFocus() && BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().isRequestFocusEnabled()) {
                    BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().requestFocus();
                }
                Point p = e.getPoint();
                if (!SwingUtilities.isLeftMouseButton(e) && !e.isConsumed() && BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().isPopupMenuEnabled()) {
                    Point point = BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getComponentOrientation().isLeftToRight() ? new Point(p.x - BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getWidth(), p.y - BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getHeight()) : new Point(p.x + BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().getWidth(), p.y - BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getHeight());
                    BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable().showPopup(point);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                // empty if block
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                // empty if block
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void validateCursor(MouseEvent e) {
            int resizeIndex = -1;
            resizeIndex = this.getResizingColumnLevel(e.getPoint());
            if (resizeIndex != -1) {
                Cursor resizeCursor = Cursor.getPredefinedCursor(8);
                if (BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getCursor() != resizeCursor) {
                    BasicOLAPOriginComponentUI.this.OLAPOriginComponent.setCursor(resizeCursor);
                }
            }
        }

        private int getResizingColumnLevel(Point p) {
            return this.getResizingColumnLevel(p, BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getColumnHeader().levelAtPoint(p));
        }

        private int getResizingColumnLevel(Point p, int level) {
            if (level == -1) {
                return -1;
            }
            int levelHeight = BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getColumnHeader().getLevelHeight(level);
            return -1;
        }

        private void setValueIsAdjusting(boolean flag) {
            TableView table = BasicOLAPOriginComponentUI.this.OLAPOriginComponent.getTable();
            table.getSelectionModel().setValueIsAdjusting(flag);
            table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }
    }
}

