/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.olaptableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.SwingAction;
import com.sas.codepolicy.SASScope;
import com.sas.commands.olap.DrillDownCommand;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPColumnHeader;
import com.sas.swing.visuals.olaptableview.OLAPRowHeader;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.swing.visuals.tableview.BasicColumnHeaderUI;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@SASScope(value="ALL")
public class BasicOLAPColumnHeaderUI
extends BasicColumnHeaderUI {
    protected OLAPColumnHeader header;
    protected boolean resizingLevel;
    protected int resizingLevelIndex;
    protected boolean resizingColumn;
    protected boolean resizingRowHeader;
    private static Insets emptyInsets = new Insets(0, 0, 0, 0);

    protected int viewIndexForColumn(int column) {
        return this.getHeader().getTable().convertColumnIndexToView(column);
    }

    protected int modelIndexForColumn(int column) {
        return this.getHeader().getTable().convertColumnIndexToModel(column);
    }

    public void setResizingLevelIndex(int newValue) {
        this.resizingLevelIndex = newValue;
    }

    public int getResizingLevelIndex() {
        return this.resizingLevelIndex;
    }

    public void setResizingColumn(boolean newValue) {
        this.resizingColumn = newValue;
    }

    public boolean isResizingColumn() {
        return this.resizingColumn;
    }

    public void setResizingRowHeader(boolean newValue) {
        this.resizingRowHeader = newValue;
    }

    public boolean isResizingRowHeader() {
        return this.resizingRowHeader;
    }

    public static ComponentUI createUI(JComponent h) {
        return new BasicOLAPColumnHeaderUI();
    }

    public void installUI(JComponent c) {
        this.header = (OLAPColumnHeader)((Object)c);
        super.installUI(c);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public void paint(Graphics g, JComponent c) {
        if (this.header.getColumnModel() == null) {
            return;
        }
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        Rectangle clipBounds = g.getClipBounds();
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        if (this.header.isOpaque()) {
            g.setColor(this.header.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        Dimension size = this.header.getSize();
        int levelCount = this.header.getMaxLevelCount();
        Point left = new Point(clipBounds.x, 0);
        Point right = new Point(clipBounds.x + clipBounds.width - 1, clipBounds.y);
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        int lMax = levelCount - 1;
        int lMin = this.header.levelAtPoint(new Point(0, clipBounds.y));
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.header.getColumnModel().getColumnCount() - 1;
        }
        if (lMin < 0) {
            lMin = 0;
        }
        this.paintCells(g, cMin, cMax, lMin, lMax);
    }

    private void paintCell(Graphics g, Rectangle cellRect, TupleElementInterface element, int level, int indexOnLevel) {
        Component component = this.header.getHeaderRendererComponent(element, level, indexOnLevel);
        this.rendererPane.add(component);
        Insets borderInsets = null;
        borderInsets = component instanceof JComponent && ((JComponent)component).getBorder() != null ? ((JComponent)component).getBorder().getBorderInsets(component) : emptyInsets;
        Rectangle visibleRect = g.getClipBounds();
        if (cellRect.x < visibleRect.x) {
            cellRect.width = cellRect.width - (visibleRect.x - cellRect.x) + borderInsets.left;
            cellRect.x = visibleRect.x - borderInsets.left;
        }
        if (cellRect.x + cellRect.width > visibleRect.x + visibleRect.width) {
            cellRect.width = visibleRect.x + visibleRect.width - cellRect.x + borderInsets.right;
        }
        this.rendererPane.paintComponent(g, component, (Container)((Object)this.header), cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintCells(Graphics g, int cMin, int cMax, int lMin, int lMax) {
        int i;
        int levelCount = this.header.getMaxLevelCount();
        TableColumnModel columnModel = this.header.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        int[] colXCoord = new int[columnCount + 1];
        int[] yCoord = new int[levelCount + 1];
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle cellRect = this.header.getHeaderRect(0);
        if (ltr) {
            for (i = 0; i <= columnCount; ++i) {
                colXCoord[i] = i == 0 ? cellRect.x : colXCoord[i - 1] + columnModel.getColumn(i - 1).getWidth();
            }
        } else {
            for (i = 0; i <= columnCount; ++i) {
                colXCoord[i] = i == 0 ? cellRect.x + cellRect.width : colXCoord[i - 1] - columnModel.getColumn(i - 1).getWidth();
            }
        }
        for (i = 0; i <= levelCount; ++i) {
            yCoord[i] = i == 0 ? 0 : yCoord[i - 1] + this.header.getLevelHeight(i - 1);
        }
        int min = 0;
        int max = 0;
        int span = 0;
        int spanDepth = 0;
        int spanCount = 0;
        TupleElementInterface tupleElement = null;
        for (int j = cMin; j <= cMax; ++j) {
            spanCount = 0;
            for (int level = lMin; level <= lMax; ++level) {
                TupleElementInterface[] elements = this.header.getTupleElementsForCoordinate(j);
                if (level >= elements.length) continue;
                tupleElement = elements[level];
                try {
                    max = tupleElement.getMaximumCoordinate();
                    span = tupleElement.getSpan();
                    spanDepth = tupleElement.getSpanDepth();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                if (j == max || j == cMax) {
                    try {
                        min = tupleElement.getMinimumCoordinate();
                        if (j != max) {
                            tupleElement = this.header.getAxis().getTuples(max, 1)[0].getElements(tupleElement.getTupleElementIndex(), 1)[0];
                        }
                    }
                    catch (OLAPException oLAPException) {
                        // empty catch block
                    }
                    cellRect.y = yCoord[spanCount];
                    cellRect.height = yCoord[spanCount + span] - yCoord[spanCount];
                    if (ltr) {
                        cellRect.x = colXCoord[min];
                        cellRect.width = colXCoord[max + 1] - colXCoord[min];
                    } else {
                        cellRect.x = colXCoord[max + 1];
                        cellRect.width = colXCoord[min] - colXCoord[max + 1];
                    }
                    this.paintCell(g, cellRect, tupleElement, spanCount + spanDepth - 1, j);
                }
                spanCount += span;
            }
        }
    }

    protected int getHeaderHeight() {
        if (this.getHeader().isHeightSet()) {
            return this.header.getHeight();
        }
        int height = 0;
        int levels = this.header.getMaxLevelCount();
        for (int i = 0; i < levels; ++i) {
            height += this.header.getLevelHeight(i);
        }
        return height;
    }

    protected Dimension createHeaderSize(long width) {
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    @SASScope
    class MouseInputHandler
    implements MouseInputListener {
        private int lastEffectiveMouseY;
        private int lastEffectiveMouseX;

        MouseInputHandler() {
        }

        private boolean shouldIgnore(MouseEvent e) {
            return !BasicOLAPColumnHeaderUI.this.header.getTable().isEnabled() || !BasicOLAPColumnHeaderUI.this.header.isEnabled();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && !this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e) && BasicOLAPColumnHeaderUI.this.getHeader().getDraggedColumn() == null && BasicOLAPColumnHeaderUI.this.getResizingLevelIndex() == -1 && BasicOLAPColumnHeaderUI.this.isResizingColumn() && !BasicOLAPColumnHeaderUI.this.isResizingRowHeader() && !e.isConsumed()) {
                BasicOLAPColumnHeaderUI.this.header.sizeColumnToFit(this.getResizingColumn(e.getPoint()));
            }
            if (e.getClickCount() == 2 && !this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e) && BasicOLAPColumnHeaderUI.this.getHeader().getDraggedColumn() == null && BasicOLAPColumnHeaderUI.this.getResizingLevelIndex() == -1 && !BasicOLAPColumnHeaderUI.this.isResizingColumn() && !BasicOLAPColumnHeaderUI.this.isResizingRowHeader() && !e.isConsumed() && ((TableView)BasicOLAPColumnHeaderUI.this.getHeader().getTable()).isPopupMenuEnabled()) {
                OLAPTableView table = (OLAPTableView)((Object)BasicOLAPColumnHeaderUI.this.header.getTable());
                Point p = e.getPoint();
                Point point = new Point(p.x, p.y - BasicOLAPColumnHeaderUI.this.header.getHeight());
                int row = table.rowAtPoint(point);
                int column = table.columnAtPoint(point);
                if (row == -1 && column != -1) {
                    List actions;
                    point.y += table.getViewPosition().y;
                    int maxLevel = BasicOLAPColumnHeaderUI.this.header.getMaxLevelCount();
                    ActionSupportFilter filter = table.configureColumnHeaderActionFilter(-(maxLevel - BasicOLAPColumnHeaderUI.this.header.levelAtPoint(p)), column);
                    ActionList list = table.getActionProvider().getActions(filter);
                    if (list != null && (actions = list.getActions()) != null) {
                        int size = actions.size();
                        for (int i = 0; i < size; ++i) {
                            Object o = actions.get(i);
                            if (!(o instanceof BaseAction) || !(((BaseAction)o).getCommand() instanceof DrillDownCommand)) continue;
                            ((SwingAction)o).actionPerformed(new ActionEvent(this, 1001, null));
                            break;
                        }
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                OLAPColumnHeader oHeader = (OLAPColumnHeader)BasicOLAPColumnHeaderUI.this.getHeader();
                oHeader.setResizingColumn(null);
                oHeader.setDraggedDistance(0);
                if (!oHeader.getTable().hasFocus() && oHeader.getTable().isRequestFocusEnabled()) {
                    oHeader.getTable().requestFocus();
                }
                Point p = e.getPoint();
                this.lastEffectiveMouseY = p.y;
                this.lastEffectiveMouseX = p.x;
                int resizeIndex = this.getResizingColumn(p);
                if (oHeader.getResizingAllowed() && resizeIndex != -1) {
                    int pref = oHeader.getColumnModel().getColumn(resizeIndex).getPreferredWidth();
                    int real = oHeader.getColumnModel().getColumn(resizeIndex).getWidth();
                    Class<?> cl = oHeader.getColumnModel().getColumn(resizeIndex).getClass();
                    oHeader.setResizingColumn(oHeader.getColumnModel().getColumn(resizeIndex));
                }
                int columnIndex = oHeader.columnAtPoint(p);
                if (resizeIndex == -1 && columnIndex != -1 && oHeader.getTable().getColumnSelectionAllowed()) {
                    int levelIndex = oHeader.levelAtPoint(p);
                    this.setValueIsAdjusting(true);
                    JTable table = oHeader.getTable();
                    int levelCount = oHeader.getMaxLevelCount();
                    int columnCount = table.getColumnCount();
                    table.changeSelection(-1, columnIndex + (levelCount - 1 - levelIndex) * columnCount, e.isControlDown(), e.isShiftDown());
                }
                if (!(SwingUtilities.isLeftMouseButton(e) || BasicOLAPColumnHeaderUI.this.getHeader().getDraggedColumn() != null || BasicOLAPColumnHeaderUI.this.getResizingLevelIndex() != -1 || BasicOLAPColumnHeaderUI.this.isResizingColumn() || BasicOLAPColumnHeaderUI.this.isResizingRowHeader() || e.isConsumed() || !((TableView)BasicOLAPColumnHeaderUI.this.getHeader().getTable()).isPopupMenuEnabled())) {
                    Point point = new Point(p.x, p.y - BasicOLAPColumnHeaderUI.this.getHeader().getHeight());
                    if (!BasicOLAPColumnHeaderUI.this.getHeader().getComponentOrientation().isLeftToRight()) {
                        point.x = this.getWidthInRightToLeft() - point.x;
                        if (BasicOLAPColumnHeaderUI.this.getHeader().getTable() != null) {
                            point.x = BasicOLAPColumnHeaderUI.this.getHeader().getTable().getWidth() - point.x;
                        }
                    }
                    ((TableView)BasicOLAPColumnHeaderUI.this.getHeader().getTable()).showPopup(point);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.validateCursor(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                int mouseY = e.getY();
                int mouseX = e.getX();
                boolean headerLeftToRight = BasicOLAPColumnHeaderUI.this.header.getComponentOrientation().isLeftToRight();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int deltaY = mouseY - this.lastEffectiveMouseY;
                    int deltaX = mouseX - this.lastEffectiveMouseX;
                    TableColumn resizingColumn = BasicOLAPColumnHeaderUI.this.getHeader().getResizingColumn();
                    int resizingColumnIndex = -1;
                    if (resizingColumn != null) {
                        resizingColumnIndex = BasicOLAPColumnHeaderUI.this.viewIndexForColumn(resizingColumn.getModelIndex());
                    }
                    if (BasicOLAPColumnHeaderUI.this.getResizingLevelIndex() != -1 && deltaY != 0) {
                        int oldHeight = 0;
                        int levelsHeight = 0;
                        int maxLevelCount = BasicOLAPColumnHeaderUI.this.header.getMaxLevelCount();
                        for (int i = BasicOLAPColumnHeaderUI.this.getResizingLevelIndex(); i < maxLevelCount; ++i) {
                            int h = BasicOLAPColumnHeaderUI.this.header.getLevelHeight(i);
                            if (i == BasicOLAPColumnHeaderUI.this.getResizingLevelIndex()) {
                                oldHeight = h;
                            }
                            levelsHeight += h;
                        }
                        int newHeight = oldHeight + deltaY;
                        int otherHeight = BasicOLAPColumnHeaderUI.this.header.getSize().height - levelsHeight;
                        JScrollPane pane = ((OLAPTableView)((Object)BasicOLAPColumnHeaderUI.this.getHeader().getTable())).getScrollPane();
                        int maxHeight = pane.getSize().height - pane.getInsets().top - pane.getInsets().bottom - otherHeight;
                        if (newHeight < 1) {
                            newHeight = 1;
                        }
                        if (newHeight > maxHeight) {
                            newHeight = maxHeight;
                        }
                        BasicOLAPColumnHeaderUI.this.header.setLevelHeight(BasicOLAPColumnHeaderUI.this.getResizingLevelIndex(), newHeight);
                        int acheivedDeltaY = BasicOLAPColumnHeaderUI.this.header.getLevelHeight(BasicOLAPColumnHeaderUI.this.getResizingLevelIndex()) - oldHeight;
                        this.lastEffectiveMouseY += acheivedDeltaY;
                        BasicOLAPColumnHeaderUI.this.getHeader().resizeAndRepaint();
                    }
                    if (resizingColumnIndex != -1 && deltaX != 0) {
                        int oldWidth = resizingColumn.getWidth();
                        int newWidth = headerLeftToRight ? oldWidth + deltaX : oldWidth - deltaX;
                        resizingColumn.setWidth(newWidth);
                        int acheivedDeltaX = resizingColumn.getWidth() - oldWidth;
                        this.lastEffectiveMouseX = headerLeftToRight ? (this.lastEffectiveMouseX += acheivedDeltaX) : (this.lastEffectiveMouseX -= acheivedDeltaX);
                    }
                    if (BasicOLAPColumnHeaderUI.this.isResizingRowHeader() && deltaX != 0) {
                        int cLevelCount;
                        OLAPRowHeader oHeader = (OLAPRowHeader)((TableView)BasicOLAPColumnHeaderUI.this.header.getTable()).getRowHeader();
                        int oldWidth = oHeader.getLevelWidth((cLevelCount = oHeader.getMaxLevelCount()) - 1);
                        int newWidth = oldWidth + deltaX;
                        if (newWidth < 0) {
                            newWidth = 0;
                        }
                        oHeader.setLevelWidth(cLevelCount - 1, newWidth);
                        this.lastEffectiveMouseY = mouseY;
                    }
                } else {
                    this.lastEffectiveMouseY = mouseY;
                    this.lastEffectiveMouseX = mouseX;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.validateCursor(e);
                BasicOLAPColumnHeaderUI.this.getHeader().setResizingColumn(null);
                BasicOLAPColumnHeaderUI.this.getHeader().setDraggedColumn(null);
                BasicOLAPColumnHeaderUI.this.getHeader().setDraggedDistance(0);
                BasicOLAPColumnHeaderUI.this.getHeader().repaint();
                JTable table = BasicOLAPColumnHeaderUI.this.getHeader().getTable();
                this.setValueIsAdjusting(false);
                if (table != null) {
                    table.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void validateCursor(MouseEvent e) {
            int resizeIndex = -1;
            if (this.getResizingColumn(e.getPoint()) != -1) {
                resizeIndex = this.getResizingHeaderLevel(e.getPoint());
                BasicOLAPColumnHeaderUI.this.setResizingLevelIndex(resizeIndex);
                BasicOLAPColumnHeaderUI.this.setResizingColumn(true);
                BasicOLAPColumnHeaderUI.this.setResizingRowHeader(false);
                Cursor resizeCursor = null;
                resizeCursor = resizeIndex == -1 ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(13);
                if (BasicOLAPColumnHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                    BasicOLAPColumnHeaderUI.this.getHeader().setCursor(resizeCursor);
                }
            } else {
                resizeIndex = this.getResizingHeaderLevel(e.getPoint());
                if (resizeIndex != -1) {
                    BasicOLAPColumnHeaderUI.this.setResizingLevelIndex(resizeIndex);
                    BasicOLAPColumnHeaderUI.this.setResizingColumn(false);
                    BasicOLAPColumnHeaderUI.this.setResizingRowHeader(false);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(8);
                    if (BasicOLAPColumnHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicOLAPColumnHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else if (this.canResizeRowHeader(e.getPoint())) {
                    BasicOLAPColumnHeaderUI.this.setResizingLevelIndex(-1);
                    BasicOLAPColumnHeaderUI.this.setResizingColumn(false);
                    BasicOLAPColumnHeaderUI.this.setResizingRowHeader(true);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(10);
                    if (BasicOLAPColumnHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicOLAPColumnHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else {
                    BasicOLAPColumnHeaderUI.this.setResizingLevelIndex(-1);
                    BasicOLAPColumnHeaderUI.this.setResizingColumn(false);
                    BasicOLAPColumnHeaderUI.this.setResizingRowHeader(false);
                    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                    if (BasicOLAPColumnHeaderUI.this.getHeader().getCursor() != defaultCursor) {
                        BasicOLAPColumnHeaderUI.this.getHeader().setCursor(defaultCursor);
                    }
                }
            }
        }

        private int getResizingColumn(Point p) {
            return this.getResizingColumn(p, BasicOLAPColumnHeaderUI.this.header.columnAtPoint(p), BasicOLAPColumnHeaderUI.this.header.levelAtPoint(p));
        }

        private int getResizingColumn(Point p, int column, int level) {
            if (column == -1) {
                return -1;
            }
            if (level == -1) {
                return -1;
            }
            Rectangle r = BasicOLAPColumnHeaderUI.this.header.getHeaderRect(column, level);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.x + r.width / 2;
            int columnIndex = BasicOLAPColumnHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
            return columnIndex;
        }

        private int getResizingHeaderLevel(Point p) {
            return this.getResizingHeaderLevel(p, BasicOLAPColumnHeaderUI.this.header.levelAtPoint(p));
        }

        private int getResizingHeaderLevel(Point p, int level) {
            int levelIndex;
            if (level == -1) {
                return -1;
            }
            int col = BasicOLAPColumnHeaderUI.this.header.columnAtPoint(p);
            if (col == -1) {
                return -1;
            }
            Rectangle r = BasicOLAPColumnHeaderUI.this.header.getHeaderRect(col, level);
            r.grow(0, -3);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.y + r.height / 2 + r.height % 2;
            int n = levelIndex = p.y < midPoint ? level - 1 : level;
            if (levelIndex >= BasicOLAPColumnHeaderUI.this.header.getMaxLevelCount()) {
                levelIndex = -1;
            }
            return levelIndex;
        }

        private boolean canResizeRowHeader(Point p) {
            if (((TableView)BasicOLAPColumnHeaderUI.this.header.getTable()).isRowHeaderVisible()) {
                return p.x < 3;
            }
            return false;
        }

        private void setValueIsAdjusting(boolean flag) {
            TableView table = (TableView)BasicOLAPColumnHeaderUI.this.getHeader().getTable();
            table.getRowModel().getSelectionModel().setValueIsAdjusting(flag);
            table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
            table.getSelectionModel().setValueIsAdjusting(flag);
        }

        private int getWidthInRightToLeft() {
            if (BasicOLAPColumnHeaderUI.this.getHeader().getTable() != null && BasicOLAPColumnHeaderUI.this.getHeader().getTable().getAutoResizeMode() != 0) {
                return BasicOLAPColumnHeaderUI.this.getHeader().getTable().getWidth();
            }
            return BasicOLAPColumnHeaderUI.this.getHeader().getWidth();
        }
    }
}

