/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.sort.OLAPSortSelectorInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.sort.CellValueSortSelectorRenderer;
import com.sas.swing.visuals.dataselectors.sort.LevelDualTreeSelector;
import com.sas.swing.visuals.dataselectors.sort.LevelLabelDualTreeSelector;
import com.sas.swing.visuals.dataselectors.sort.RB;
import com.sas.swing.visuals.dataselectors.sort.SortSelectorTreeRenderer;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.swing.visuals.dualselector.DualTreeSelector;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.TreeUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.util.PreorderTreeModelIterator;
import com.sas.util.SortDirectionInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

@SASScope(value="ALL")
public class OLAPSortSelector
extends BaseSwingSelectorPanel
implements LayoutConstants,
TreeSelectionListener,
ActionListener,
SortDirectionInterface,
TreeModelListener {
    public static final String RB_KEY = "OLAPSortSelector.";
    private OLAPSortSelectorInterface olapSortSelectorInterfaceModel;
    private JTabbedPane tabbedPane;
    private Container levelLabelContainer;
    private Container cellValueContainer;
    private DualTreeSelector levelDualSelector;
    private JPanel levelSortDirectionPanel;
    private JRadioButton levelAscendingButton;
    private JRadioButton levelDescendingButton;
    private JRadioButton levelNoneButton;
    private ButtonGroup levelDirectionGroup;
    private JCheckBox levelHierarchicalSort;
    private TreeModel levelSortedTreeModel;
    private TreeModel availLevelLabelTreeModel;
    private DualTreeSelector cellDualSelector;
    private JPanel cellSortDirectionPanel;
    private JRadioButton cellAscendingButton;
    private JRadioButton cellDescendingButton;
    private JRadioButton cellNoneButton;
    private ButtonGroup cellDirectionGroup;
    private TreeModel cellSortedTreeModel;
    private TreeModel availCellTreeModel;
    private JCheckBox cellHierarchicalSort;

    public OLAPSortSelector() {
        this.createComponents();
        this.addListeners();
    }

    protected void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        mainLayout.setRemainderRow(1);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout((LayoutManager)mainLayout);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(400, 300));
        this.levelLabelContainer = this.createLevelLabelSortingTab();
        this.cellValueContainer = this.createCellValueSortingTab();
        this.add(this.tabbedPane);
    }

    private Container createLevelLabelSortingTab() {
        JPanel levelSortingPanel = new JPanel();
        AutoSizingGridLayout levelLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        levelLayout.setRemainderRow(1);
        levelSortingPanel.setLayout((LayoutManager)levelLayout);
        this.levelDualSelector = new LevelLabelDualTreeSelector();
        ((JTree)this.levelDualSelector.getSourceComponent()).setRootVisible(false);
        ((JTree)this.levelDualSelector.getSourceComponent()).setShowsRootHandles(true);
        ((JTree)this.levelDualSelector.getTargetComponent()).setRootVisible(false);
        ((JTree)this.levelDualSelector.getTargetComponent()).setShowsRootHandles(true);
        DefaultTreeCellRenderer sourceRenderer = new DefaultTreeCellRenderer();
        sourceRenderer.setLeafIcon(null);
        sourceRenderer.setOpenIcon(null);
        sourceRenderer.setClosedIcon(null);
        this.levelDualSelector.setSourceCellRenderer((TreeCellRenderer)sourceRenderer);
        this.levelDualSelector.setTargetCellRenderer((TreeCellRenderer)new SortSelectorTreeRenderer());
        this.levelDualSelector.setParentNodesMoveable(false);
        this.levelDualSelector.setParentNodesOnlyMoveable(false);
        this.levelDualSelector.setSourceLabel(RB.getStringResource((String)RB_KEY, (String)"availableItemsLabel.txt"));
        this.levelDualSelector.setTargetLabel(RB.getStringResource((String)"sortBy.txt"));
        this.levelDualSelector.setTransferAllControlsVisible(false);
        this.levelDualSelector.setAlternatingSingleButtonStyle(false);
        this.levelSortDirectionPanel = new JPanel();
        JPanel outerDirectionPanel = new JPanel();
        outerDirectionPanel.setBorder(INDENTED_BORDER);
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        outerLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new ProportionalSpacePartitioner(new double[]{0.5, 0.5}));
        outerDirectionPanel.setLayout((LayoutManager)outerLayout);
        AutoSizingGridLayout directionLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, false);
        this.levelSortDirectionPanel.setLayout((LayoutManager)directionLayout);
        this.levelAscendingButton = new JRadioButton(RB.getStringResource((String)"ascending.txt"));
        this.levelDescendingButton = new JRadioButton(RB.getStringResource((String)"descending.txt"));
        this.levelNoneButton = new JRadioButton();
        this.levelDirectionGroup = new ButtonGroup();
        this.levelDirectionGroup.add(this.levelAscendingButton);
        this.levelDirectionGroup.add(this.levelDescendingButton);
        this.levelDirectionGroup.add(this.levelNoneButton);
        this.levelSortDirectionPanel.add(this.levelAscendingButton);
        this.levelSortDirectionPanel.add(this.levelDescendingButton);
        Util.setEnabledOnContainer((Container)this.levelSortDirectionPanel, (boolean)false);
        outerDirectionPanel.add(new JPanel());
        outerDirectionPanel.add(this.levelSortDirectionPanel);
        this.levelHierarchicalSort = new JCheckBox(RB.getStringResource((String)RB_KEY, (String)"hierarchicalSortLabel.txt"));
        this.levelHierarchicalSort.setSelected(true);
        levelSortingPanel.add((Component)this.levelDualSelector);
        levelSortingPanel.add(outerDirectionPanel);
        levelSortingPanel.add(this.levelHierarchicalSort);
        return levelSortingPanel;
    }

    private Container createCellValueSortingTab() {
        JPanel cellSortingPanel = new JPanel();
        AutoSizingGridLayout cellLayout = new AutoSizingGridLayout(3, 1, 5, 5, true, true, true);
        cellLayout.setRemainderRow(1);
        cellSortingPanel.setLayout((LayoutManager)cellLayout);
        this.cellDualSelector = new LevelDualTreeSelector();
        this.cellDualSelector.setCopyModeEnabled(true);
        ((JTree)this.cellDualSelector.getSourceComponent()).setRootVisible(false);
        ((JTree)this.cellDualSelector.getSourceComponent()).setShowsRootHandles(true);
        ((JTree)this.cellDualSelector.getTargetComponent()).setRootVisible(false);
        ((JTree)this.cellDualSelector.getTargetComponent()).setShowsRootHandles(true);
        this.cellDualSelector.setSourceLabel(RB.getStringResource((String)RB_KEY, (String)"availableItemsLabel.txt"));
        this.cellDualSelector.setTargetLabel(RB.getStringResource((String)"sortBy.txt"));
        this.cellDualSelector.setTransferAllControlsVisible(false);
        this.cellDualSelector.setAlternatingSingleButtonStyle(false);
        this.cellDualSelector.setTargetCellRenderer((TreeCellRenderer)new SortSelectorTreeRenderer());
        this.cellDualSelector.setSourceCellRenderer((TreeCellRenderer)new CellValueSortSelectorRenderer());
        this.cellSortDirectionPanel = new JPanel();
        JPanel outerDirectionPanel = new JPanel();
        outerDirectionPanel.setBorder(INDENTED_BORDER);
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        outerLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new ProportionalSpacePartitioner(new double[]{0.5, 0.5}));
        outerDirectionPanel.setLayout((LayoutManager)outerLayout);
        AutoSizingGridLayout directionLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, false);
        this.cellSortDirectionPanel.setLayout((LayoutManager)directionLayout);
        this.cellAscendingButton = new JRadioButton(RB.getStringResource((String)"ascending.txt"));
        this.cellDescendingButton = new JRadioButton(RB.getStringResource((String)"descending.txt"));
        this.cellNoneButton = new JRadioButton();
        this.cellDirectionGroup = new ButtonGroup();
        this.cellDirectionGroup.add(this.cellAscendingButton);
        this.cellDirectionGroup.add(this.cellDescendingButton);
        this.cellDirectionGroup.add(this.cellNoneButton);
        this.cellSortDirectionPanel.add(this.cellAscendingButton);
        this.cellSortDirectionPanel.add(this.cellDescendingButton);
        Util.setEnabledOnContainer((Container)this.cellSortDirectionPanel, (boolean)false);
        outerDirectionPanel.add(new JPanel());
        outerDirectionPanel.add(this.cellSortDirectionPanel);
        this.cellHierarchicalSort = new JCheckBox(RB.getStringResource((String)RB_KEY, (String)"hierarchicalSortLabel.txt"));
        this.cellHierarchicalSort.setSelected(true);
        cellSortingPanel.add((Component)this.cellDualSelector);
        cellSortingPanel.add(outerDirectionPanel);
        cellSortingPanel.add(this.cellHierarchicalSort);
        return cellSortingPanel;
    }

    protected void addListeners() {
        ((JTree)this.levelDualSelector.getTargetComponent()).addTreeSelectionListener(this);
        this.levelAscendingButton.addActionListener(this);
        this.levelDescendingButton.addActionListener(this);
        ((JTree)this.cellDualSelector.getTargetComponent()).addTreeSelectionListener(this);
        this.cellAscendingButton.addActionListener(this);
        this.cellDescendingButton.addActionListener(this);
        this.levelHierarchicalSort.addActionListener(this);
        this.cellHierarchicalSort.addActionListener(this);
    }

    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && model instanceof OLAPSortSelectorInterface) {
            Object old = this.selectorModel;
            this.selectorModel = model;
            this.olapSortSelectorInterfaceModel = (OLAPSortSelectorInterface)model;
            if (this.olapSortSelectorInterfaceModel.isLevelLabelSorting()) {
                this.tabbedPane.addTab(RB.getStringResource((String)RB_KEY, (String)"levelLabelSortingLabel.txt"), this.levelLabelContainer);
                this.levelSortedTreeModel = this.olapSortSelectorInterfaceModel.getSortedLevelLabelItems();
                int[] sortedDirections = this.olapSortSelectorInterfaceModel.getSortedLevelLabelDirections();
                this.levelDualSelector.setTargetModel(this.levelSortedTreeModel);
                TreeUtil.expandAllNodes((JTree)((JTree)this.levelDualSelector.getTargetComponent()));
                this.levelSortedTreeModel.addTreeModelListener(this);
                this.availLevelLabelTreeModel = this.olapSortSelectorInterfaceModel.getAvailableLevelLabelItems();
                this.levelDualSelector.setModel(this.availLevelLabelTreeModel);
                TreeUtil.expandAllNodes((JTree)((JTree)this.levelDualSelector.getSourceComponent()));
                this.availLevelLabelTreeModel.addTreeModelListener(this);
                this.levelHierarchicalSort.setSelected(this.olapSortSelectorInterfaceModel.isLevelLabelHierarchicalSort());
            }
            if (this.olapSortSelectorInterfaceModel.isCellValueSorting()) {
                this.tabbedPane.addTab(RB.getStringResource((String)RB_KEY, (String)"cellValueSortingLabel.txt"), this.cellValueContainer);
                this.cellSortedTreeModel = this.olapSortSelectorInterfaceModel.getSortedCellValueItems();
                this.availCellTreeModel = this.olapSortSelectorInterfaceModel.getAvailableCellValueItems();
                this.cellDualSelector.setModel(this.availCellTreeModel);
                TreeUtil.expandTreeToLevel((JTree)((JTree)this.cellDualSelector.getSourceComponent()), (int)1);
                this.cellDualSelector.setTargetModel(this.cellSortedTreeModel);
                TreeUtil.expandAllNodes((JTree)((JTree)this.cellDualSelector.getTargetComponent()));
                this.cellSortedTreeModel.addTreeModelListener(this);
                this.cellHierarchicalSort.setSelected(this.olapSortSelectorInterfaceModel.isCellValueHierarchicalSort());
            }
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    public String getDialogTitle() {
        return RB.getStringResource((String)"sort.txt");
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JTree levelTree = (JTree)this.levelDualSelector.getTargetComponent();
        JTree cellTree = (JTree)this.cellDualSelector.getTargetComponent();
        if (e.getSource() == levelTree) {
            if (levelTree.getSelectionCount() == 1) {
                Object item = levelTree.getSelectionPath().getLastPathComponent();
                if (item instanceof DefaultMutableTreeNode) {
                    item = ((DefaultMutableTreeNode)item).getUserObject();
                }
                if (item instanceof SortedItem) {
                    Util.setEnabledOnContainer((Container)this.levelSortDirectionPanel, (boolean)true);
                    if (((SortedItem)item).getDirection() == 0) {
                        this.levelAscendingButton.setSelected(true);
                    } else {
                        this.levelDescendingButton.setSelected(true);
                    }
                    return;
                }
            }
            Util.setEnabledOnContainer((Container)this.levelSortDirectionPanel, (boolean)false);
            this.levelNoneButton.setSelected(true);
        } else if (e.getSource() == cellTree) {
            if (cellTree.getSelectionCount() == 1) {
                Object item = cellTree.getSelectionPath().getLastPathComponent();
                if (item instanceof DefaultMutableTreeNode) {
                    item = ((DefaultMutableTreeNode)item).getUserObject();
                }
                if (item instanceof SortedItem) {
                    Util.setEnabledOnContainer((Container)this.cellSortDirectionPanel, (boolean)true);
                    if (((SortedItem)item).getDirection() == 0) {
                        this.cellAscendingButton.setSelected(true);
                    } else {
                        this.cellDescendingButton.setSelected(true);
                    }
                    return;
                }
            }
            Util.setEnabledOnContainer((Container)this.cellSortDirectionPanel, (boolean)false);
            this.cellNoneButton.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.levelHierarchicalSort) {
            this.olapSortSelectorInterfaceModel.setLevelLabelHierarchicalSort(this.levelHierarchicalSort.isSelected());
        } else if (source == this.cellHierarchicalSort) {
            this.olapSortSelectorInterfaceModel.setCellValueHierarchicalSort(this.cellHierarchicalSort.isSelected());
        } else {
            JTree tree = null;
            JRadioButton ascendingButton = null;
            boolean levelModel = false;
            if (source == this.levelAscendingButton || source == this.levelDescendingButton) {
                tree = (JTree)this.levelDualSelector.getTargetComponent();
                ascendingButton = this.levelAscendingButton;
                levelModel = true;
            } else if (source == this.cellAscendingButton || source == this.cellDescendingButton) {
                tree = (JTree)this.cellDualSelector.getTargetComponent();
                ascendingButton = this.cellAscendingButton;
            }
            if (tree != null) {
                Object item = tree.getSelectionPath().getLastPathComponent();
                if (item instanceof DefaultMutableTreeNode) {
                    item = ((DefaultMutableTreeNode)item).getUserObject();
                }
                if (item instanceof SortedItem) {
                    if (ascendingButton.isSelected()) {
                        ((SortedItem)item).setDirection(0);
                    } else {
                        ((SortedItem)item).setDirection(1);
                    }
                    RowMapper rm = tree.getSelectionModel().getRowMapper();
                    if (rm instanceof AbstractLayoutCache) {
                        ((AbstractLayoutCache)rm).invalidateSizes();
                    }
                    tree.repaint();
                    if (levelModel) {
                        this.updateLevelLabelModel();
                    } else {
                        this.updateCellValueModel();
                    }
                }
            }
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        if (e.getSource() == this.cellSortedTreeModel) {
            this.updateCellValueModel();
        } else if (e.getSource() == this.levelSortedTreeModel) {
            this.updateLevelLabelModel();
        } else if (e.getSource() == this.availLevelLabelTreeModel) {
            this.updateAvailabelLevelLabelMaodel();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        if (e.getSource() == this.cellSortedTreeModel) {
            this.updateCellValueModel();
        } else if (e.getSource() == this.levelSortedTreeModel) {
            this.updateLevelLabelModel();
        } else if (e.getSource() == this.availLevelLabelTreeModel) {
            this.updateAvailabelLevelLabelMaodel();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        if (e.getSource() == this.cellSortedTreeModel) {
            this.updateCellValueModel();
        } else if (e.getSource() == this.levelSortedTreeModel) {
            this.updateLevelLabelModel();
        } else if (e.getSource() == this.availLevelLabelTreeModel) {
            this.updateAvailabelLevelLabelMaodel();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        if (e.getSource() == this.cellSortedTreeModel) {
            this.updateCellValueModel();
        } else if (e.getSource() == this.levelSortedTreeModel) {
            this.updateLevelLabelModel();
        } else if (e.getSource() == this.availLevelLabelTreeModel) {
            this.updateAvailabelLevelLabelMaodel();
        }
    }

    private void updateLevelLabelModel() {
        ArrayList arrayDirs = new ArrayList();
        int[] dirs = null;
        PreorderTreeModelIterator iterator = new PreorderTreeModelIterator(this.levelDualSelector.getTargetModel());
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof DefaultMutableTreeNode) {
                obj = ((DefaultMutableTreeNode)obj).getUserObject();
            }
            if (!(obj instanceof SortedItem)) continue;
            arrayDirs.add(obj);
        }
        int size = arrayDirs.size();
        dirs = new int[size];
        for (int i = 0; i < size; ++i) {
            dirs[i] = ((SortedItem)arrayDirs.get(i)).getDirection();
        }
        this.olapSortSelectorInterfaceModel.setSortedLevelLabelItems(this.levelDualSelector.getTargetModel());
        this.olapSortSelectorInterfaceModel.setSortedLevelLabelDirections(dirs);
    }

    private void updateAvailabelLevelLabelMaodel() {
        this.olapSortSelectorInterfaceModel.setAvailableLevelLabelItems(this.levelDualSelector.getModel());
    }

    private void updateCellValueModel() {
        PreorderTreeModelIterator iterator = new PreorderTreeModelIterator(this.cellDualSelector.getTargetModel());
        ArrayList arrayDirs = new ArrayList();
        int[] dirs = null;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof DefaultMutableTreeNode) {
                obj = ((DefaultMutableTreeNode)obj).getUserObject();
            }
            if (!(obj instanceof SortedItem)) continue;
            arrayDirs.add(obj);
        }
        int size = arrayDirs.size();
        dirs = new int[size];
        for (int i = 0; i < size; ++i) {
            dirs[i] = ((SortedItem)arrayDirs.get(i)).getDirection();
        }
        this.olapSortSelectorInterfaceModel.setSortedCellValueDirections(dirs);
    }
}

