/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dataselectors.sort.CellSortedTreeDualSelectorAdapter;
import com.sas.swing.visuals.dataselectors.sort.UpDownTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.DualTreeSelector;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

@SASScope
class LevelDualTreeSelector
extends DualTreeSelector {
    public LevelDualTreeSelector() {
        this.targetAdapter = new UpDownTreeDualSelectorAdapter((JComponent)((Object)this));
        this.targetJTree = (JTree)this.targetAdapter.getComponent();
        this.sourceAdapter = new CellSortedTreeDualSelectorAdapter((JComponent)((Object)this));
        this.sourceJTree = (JTree)this.sourceAdapter.getComponent();
        this.initializeBaseDualSelector();
        this.addListeners();
        this.setSourceMouseListener(this.sourceMouseListener);
        this.setTargetMouseListener(this.targetMouseListener);
    }

    public boolean canTransferAllSourceItems() {
        return false;
    }

    public boolean canTransferSelectedSourceItems() {
        List items = this.sourceAdapter.getSelectedItems();
        if (items != null) {
            int iSize;
            int targetCount = this.targetAdapter.getCount();
            if (targetCount + (iSize = items.size()) > 4 || iSize == 0) {
                return false;
            }
            DefaultMutableTreeNode child1 = (DefaultMutableTreeNode)this.getTargetModel().getChild(this.getTargetModel().getRoot(), 0);
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)this.getTargetModel().getChild(this.getTargetModel().getRoot(), 1);
            int childCount1 = this.getTargetModel().getChildCount(child1);
            int childCount2 = this.getTargetModel().getChildCount(child2);
            for (int i = 0; i < iSize; ++i) {
                Object[] path = ((TreePath)items.get(i)).getPath();
                if (path == null || path.length <= 1 || !(path[1] instanceof DefaultMutableTreeNode) || !(child1.getUserObject().equals(((DefaultMutableTreeNode)path[1]).getUserObject()) ? ++childCount1 > 1 : child2.getUserObject().equals(((DefaultMutableTreeNode)path[1]).getUserObject()) && ++childCount2 > 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

