/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.swing.visuals.dataselectors.sort.UpDownTreeDualSelectorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@SASScope
class CellSortedTreeDualSelectorAdapter
extends UpDownTreeDualSelectorAdapter {
    public CellSortedTreeDualSelectorAdapter(JComponent parent) {
        this(new JTree(), parent);
    }

    public CellSortedTreeDualSelectorAdapter(JTree tree, JComponent parent) {
        super(tree, parent);
    }

    public List getSelectedItems() {
        Vector<TreePath> vector = new Vector<TreePath>();
        TreePath[] selectedItems = this.component.getSelectionPaths();
        if (selectedItems != null) {
            for (int i = 0; i < selectedItems.length; ++i) {
                TreePath tempPath = selectedItems[i];
                DefaultMutableTreeNode lastComponent = (DefaultMutableTreeNode)tempPath.getLastPathComponent();
                int childCount = lastComponent.getChildCount();
                if ((tempPath = this.createPath(tempPath)) == null || vector.contains(tempPath)) continue;
                if (!this.isParentNodeOnlyMoveable() || this.isChildNodesOnlyMoveable()) {
                    if (childCount != 0) continue;
                    vector.add(tempPath);
                    continue;
                }
                if (this.isParentNodeOnlyMoveable()) {
                    if (childCount <= 0) continue;
                    vector.add(tempPath);
                    continue;
                }
                vector.add(tempPath);
            }
        }
        return vector;
    }

    private TreePath createPath(TreePath oldPath) {
        int count = oldPath.getPathCount();
        if (count > 2) {
            Object[] path = new Object[3];
            path[0] = oldPath.getPathComponent(0);
            path[1] = oldPath.getPathComponent(1);
            ArrayList<Object> items = new ArrayList<Object>();
            Object id = null;
            int role = 2;
            boolean valid = true;
            for (int j = 2; j < count; ++j) {
                Object obj = oldPath.getPathComponent(j);
                if (!(obj instanceof DefaultMutableTreeNode)) continue;
                id = ((DefaultMutableTreeNode)obj).getUserObject();
                if (id instanceof SortedItem && ((SortedItem)id).isValid()) {
                    path[2] = path[2] == null ? obj : path[2] + "." + obj;
                    items.add(((SortedItem)id).getID());
                    role = ((SortedItem)id).getRole();
                    continue;
                }
                if (!(id instanceof TupleElementInterface)) continue;
                try {
                    boolean contextual = ((TupleElementInterface)id).isContextual();
                    if (contextual) continue;
                    if (path[2] == null) {
                        path[2] = obj;
                        role = ((TupleElementInterface)id).getTuple().getAxis().getAxisNumber() == 0 ? 1 : 2;
                    } else {
                        path[2] = path[2] + "." + obj;
                    }
                    String name = ((TupleElementInterface)id).getName();
                    if (name != null) {
                        name = name.trim();
                    }
                    items.add(name);
                    continue;
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
            }
            path[2] = new DefaultMutableTreeNode(new SortedItem(path[2], 0, items, role));
            return new TreePath(path);
        }
        return null;
    }

    public boolean isInAdapter(Object item) {
        TreePath path;
        TreeNode node;
        boolean value = false;
        TreeModel tempModel = this.component.getModel();
        if (((DefaultTreeModel)tempModel).getPathToRoot(node = (TreeNode)(path = this.createPath((TreePath)item)).getLastPathComponent()) != null) {
            value = true;
        }
        return value;
    }
}

