/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filterandrank;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filterandrank.FilterAndRankModelInterface;
import com.sas.dataselectors.filterandrank.FilterAxisEnum;
import com.sas.dataselectors.filterandrank.FilterOperatorEnum;
import com.sas.dataselectors.filterandrank.FilterTypeEnum;
import com.sas.dataselectors.filterandrank.RankOrderEnum;
import com.sas.dataselectors.filterandrank.RankTypeEnum;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.filterandrank.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class FilterAndRankSelector
extends BaseSwingSelectorPanel
implements LayoutConstants {
    public static final String RB_KEY = "FilterAndRankSelector.";
    public static final Locale defaultLocale = Locale.getDefault();
    private FilterAxisEnum axis;
    private JLabel axisValueLabel;
    private JLabel basedOnValueLabel;
    private JRadioButton filterRB;
    private JRadioButton rankRB;
    private JLabel conditionLabel;
    private JComboBox conditionComboBox;
    private JLabel filterValueLabel;
    private JTextField filterValueTF;
    private JLabel dummyLabelForRankTopBottomPanel;
    private JLabel dummyLabelForRankDescriptionPanel;
    private JPanel rankTopBottomRadioPanel;
    private JRadioButton topRB;
    private JRadioButton bottomRB;
    private JPanel rankDescriptionPanel;
    private JTextField rankValueTF;
    private JComboBox rankTypeComboBox;
    private JCheckBox includeTiesChkBox;
    private JButton clearB;
    private JButton clearAllB;
    private DefaultComboBoxModel filterOperatorsModel;
    private DefaultListModel currentFiltersModel;
    private JList currentFiltersList;
    private DefaultComboBoxModel rankTypesModel;
    private JPanel fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes;
    private JPanel fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes;

    public FilterAndRankSelector() {
        this.createComponents();
        this.addListeners();
    }

    protected void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 15, true, false, true);
        this.setLayout((LayoutManager)mainLayout);
        JPanel topPanel = new JPanel();
        AutoSizingGridLayout filterRankLayout = new AutoSizingGridLayout(7, 2, 5, 5, true, false, true);
        filterRankLayout.setIgnoreSizeOfNonVisibleComponents(true);
        topPanel.setLayout((LayoutManager)filterRankLayout);
        JLabel filterLabel = new JLabel(RB.getStringResource(RB_KEY, "filterOn.txt"));
        topPanel.add(filterLabel);
        this.axisValueLabel = new JLabel();
        topPanel.add(this.axisValueLabel);
        JLabel filterTypeLabel = new JLabel(RB.getStringResource(RB_KEY, "filterType.txt"));
        topPanel.add(filterTypeLabel);
        JPanel rankAndFilterRadioPanel = new JPanel();
        topPanel.add(rankAndFilterRadioPanel);
        this.filterRB = new JRadioButton(FilterTypeEnum.FILTER.getLabel(defaultLocale));
        this.rankRB = new JRadioButton(FilterTypeEnum.RANK.getLabel(defaultLocale));
        ButtonGroup filterRankGroup = new ButtonGroup();
        filterRankGroup.add(this.filterRB);
        filterRankGroup.add(this.rankRB);
        rankAndFilterRadioPanel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 5, 5, false, false, false));
        rankAndFilterRadioPanel.add(this.filterRB);
        rankAndFilterRadioPanel.add(this.rankRB);
        JLabel basedOnLabel = new JLabel(RB.getStringResource(RB_KEY, "basedOn.txt"));
        topPanel.add(basedOnLabel);
        this.basedOnValueLabel = new JLabel();
        topPanel.add(this.basedOnValueLabel);
        this.conditionLabel = new JLabel(RB.getStringResource(RB_KEY, "filterCondition.txt"));
        topPanel.add(this.conditionLabel);
        this.filterOperatorsModel = new DefaultComboBoxModel();
        this.populateFilterOperatorsModelWithValues();
        this.conditionComboBox = new JComboBox(this.filterOperatorsModel);
        this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes = new JPanel();
        this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, false, true));
        this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes.add(this.conditionComboBox);
        Dimension dimFilter = this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes.getPreferredSize();
        topPanel.add(this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes);
        this.dummyLabelForRankTopBottomPanel = new JLabel("");
        this.dummyLabelForRankTopBottomPanel.setVisible(false);
        topPanel.add(this.dummyLabelForRankTopBottomPanel);
        this.rankTopBottomRadioPanel = new JPanel();
        this.rankTopBottomRadioPanel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 5, 5, false, false, false));
        this.topRB = new JRadioButton(RankOrderEnum.TOP.getLabel(defaultLocale));
        this.bottomRB = new JRadioButton(RankOrderEnum.BOTTOM.getLabel(defaultLocale));
        ButtonGroup topBottomGroup = new ButtonGroup();
        topBottomGroup.add(this.topRB);
        topBottomGroup.add(this.bottomRB);
        this.rankTopBottomRadioPanel.add(this.topRB);
        this.rankTopBottomRadioPanel.add(this.bottomRB);
        this.rankTopBottomRadioPanel.setVisible(false);
        Dimension dimRank = this.rankTopBottomRadioPanel.getPreferredSize();
        topPanel.add(this.rankTopBottomRadioPanel);
        Dimension dim4Max = new Dimension();
        dim4Max.setSize(dimFilter.getWidth() > dimRank.getWidth() ? dimFilter.getWidth() : dimRank.getWidth(), dimFilter.getHeight() > dimRank.getHeight() ? dimFilter.getHeight() : dimRank.getHeight());
        this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setPreferredSize(dim4Max);
        this.rankTopBottomRadioPanel.setPreferredSize(dim4Max);
        this.filterValueLabel = new JLabel(RB.getStringResource(RB_KEY, "filterValue.txt"));
        topPanel.add(this.filterValueLabel);
        this.filterValueTF = new JTextField();
        this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes = new JPanel();
        this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, false, true));
        this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes.add(this.filterValueTF);
        dimFilter = this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes.getPreferredSize();
        topPanel.add(this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes);
        this.dummyLabelForRankDescriptionPanel = new JLabel("");
        this.dummyLabelForRankDescriptionPanel.setVisible(false);
        topPanel.add(this.dummyLabelForRankDescriptionPanel);
        this.rankDescriptionPanel = new JPanel();
        AutoSizingGridLayout rankDescriptionPanelLayout = new AutoSizingGridLayout(1, 3, 5, 5, false, false, false);
        this.rankDescriptionPanel.setLayout((LayoutManager)rankDescriptionPanelLayout);
        this.rankDescriptionPanel.setVisible(false);
        topPanel.add(this.rankDescriptionPanel);
        this.rankValueTF = new JTextField();
        this.rankValueTF.setColumns(8);
        this.rankTypesModel = new DefaultComboBoxModel();
        this.populateRankTypesModelWithValues();
        this.rankTypeComboBox = new JComboBox(this.rankTypesModel);
        this.includeTiesChkBox = new JCheckBox(RB.getStringResource(RB_KEY, "rankOption.txt"));
        this.rankDescriptionPanel.add(this.rankValueTF);
        this.rankDescriptionPanel.add(this.rankTypeComboBox);
        this.rankDescriptionPanel.add(this.includeTiesChkBox);
        dimRank = this.rankDescriptionPanel.getPreferredSize();
        Dimension dim5Max = new Dimension();
        dim5Max.setSize(dimFilter.getWidth() > dimRank.getWidth() ? dimFilter.getWidth() : dimRank.getWidth(), dimFilter.getHeight() > dimRank.getHeight() ? dimFilter.getHeight() : dimRank.getHeight());
        this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setPreferredSize(dim5Max);
        this.rankDescriptionPanel.setPreferredSize(dim5Max);
        this.add(topPanel);
        JPanel currentFiltersPanel = new JPanel();
        AutoSizingGridLayout currentFiltersLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        currentFiltersPanel.setLayout((LayoutManager)currentFiltersLayout);
        JLabel currentFiltersLabel = new JLabel(RB.getStringResource(RB_KEY, "currentFilters.txt"));
        currentFiltersPanel.add(currentFiltersLabel);
        JPanel bottomRowOfCurrentFiltersPanel = new JPanel();
        AutoSizingGridLayout bottomRowOfCurrentFiltersPanelLayout = new AutoSizingGridLayout(1, 2, 10, 5, true, false, true);
        bottomRowOfCurrentFiltersPanelLayout.setRemainderColumn(1);
        bottomRowOfCurrentFiltersPanel.setLayout((LayoutManager)bottomRowOfCurrentFiltersPanelLayout);
        this.currentFiltersModel = new DefaultListModel();
        this.currentFiltersList = new JList(this.currentFiltersModel);
        this.currentFiltersList.setVisibleRowCount(2);
        JScrollPane currentFiltersScrollPane = new JScrollPane(this.currentFiltersList);
        bottomRowOfCurrentFiltersPanel.add(currentFiltersScrollPane);
        JPanel listManipulatingButtonsPanel = new JPanel();
        listManipulatingButtonsPanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, false, false));
        this.clearB = new JButton(RB.getStringResource(RB_KEY, "clearButton.txt"));
        this.clearAllB = new JButton(RB.getStringResource(RB_KEY, "clearAllButton.txt"));
        listManipulatingButtonsPanel.add(this.clearB);
        listManipulatingButtonsPanel.add(this.clearAllB);
        bottomRowOfCurrentFiltersPanel.add(listManipulatingButtonsPanel);
        currentFiltersPanel.add(bottomRowOfCurrentFiltersPanel);
        this.add(currentFiltersPanel);
    }

    private void populateRankTypesModelWithValues() {
        this.rankTypesModel.removeAllElements();
        List list = RankTypeEnum.getTypes();
        for (RankTypeEnum rankTypeEnum : list) {
            this.rankTypesModel.addElement(new RankTypeComboxBoxElement(rankTypeEnum));
        }
    }

    private void populateFilterOperatorsModelWithValues() {
        this.filterOperatorsModel.removeAllElements();
        List list = FilterOperatorEnum.getTypes();
        for (FilterOperatorEnum filterOperatorEnum : list) {
            this.filterOperatorsModel.addElement(new FilterOperatorComboxBoxElement(filterOperatorEnum));
        }
    }

    private void setDefaultComponentState() {
        this.filterRB.setSelected(true);
        this.conditionComboBox.setSelectedIndex(0);
        this.filterValueTF.setText("");
        this.rankValueTF.setText("");
        this.rankTypeComboBox.setSelectedIndex(0);
        this.topRB.setSelected(true);
        this.includeTiesChkBox.setSelected(false);
    }

    protected void addListeners() {
        this.filterRB.addItemListener(new FilterRankRadioButtonListener());
        this.rankTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RankTypeComboxBoxElement cbe = (RankTypeComboxBoxElement)FilterAndRankSelector.this.rankTypeComboBox.getSelectedItem();
                FilterAndRankSelector.this.includeTiesChkBox.setEnabled(cbe.type == RankTypeEnum.COUNT);
            }
        });
        this.currentFiltersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FilterAndRankSelector.this.setEnabledStateOfListManipulatingButtons();
            }
        });
        this.clearB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterAndRankModelInterface farModel = (FilterAndRankModelInterface)FilterAndRankSelector.this.selectorModel;
                Object[] fles = FilterAndRankSelector.this.currentFiltersList.getSelectedValues();
                for (int i = 0; i < fles.length; ++i) {
                    CurrentFiltersListElement fle = (CurrentFiltersListElement)fles[i];
                    farModel.clearStep(fle.filterAxis);
                    FilterAndRankSelector.this.currentFiltersModel.removeElement(fle);
                }
                FilterAndRankSelector.this.setEnabledStateOfListManipulatingButtons();
            }
        });
        this.clearAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterAndRankModelInterface farModel = (FilterAndRankModelInterface)FilterAndRankSelector.this.selectorModel;
                farModel.clearAllSteps();
                FilterAndRankSelector.this.currentFiltersModel.removeAllElements();
                FilterAndRankSelector.this.setEnabledStateOfListManipulatingButtons();
            }
        });
    }

    private void setEnabledStateOfListManipulatingButtons() {
        this.clearAllB.setEnabled(this.currentFiltersModel.getSize() > 0);
        this.clearB.setEnabled(this.currentFiltersList.getSelectedIndex() >= 0);
    }

    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && model instanceof FilterAndRankModelInterface) {
            Object old = this.selectorModel;
            FilterAndRankModelInterface farModel = (FilterAndRankModelInterface)model;
            this.selectorModel = farModel;
            String axisString = null;
            try {
                this.axis = farModel.getFilterAxis();
                axisString = this.axis.getLabel(defaultLocale);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            this.axisValueLabel.setText(axisString);
            String basedOn = farModel.getTupleElementLabel();
            this.basedOnValueLabel.setText(basedOn);
            this.setDefaultComponentState();
            this.currentFiltersModel.clear();
            CurrentFiltersListElement fle = this.getCurrentFiltersListElement(FilterAxisEnum.COLUMNS);
            if (fle != null) {
                this.currentFiltersModel.addElement(fle);
            }
            if ((fle = this.getCurrentFiltersListElement(FilterAxisEnum.ROWS)) != null) {
                this.currentFiltersModel.addElement(fle);
            }
            this.setEnabledStateOfListManipulatingButtons();
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    private CurrentFiltersListElement getCurrentFiltersListElement(FilterAxisEnum axis) {
        String filterText = ((FilterAndRankModelInterface)this.selectorModel).getStepText(axis, defaultLocale);
        if (filterText == null) {
            return null;
        }
        String format = RB.getStringResource(RB_KEY, axis == FilterAxisEnum.COLUMNS ? "currentColumns.txt.fmt" : "currentRows.txt.fmt");
        String text = Message.format((String)format, (Object)filterText);
        return new CurrentFiltersListElement(axis, text);
    }

    public void onApply() {
        this.setContentsValid(true);
        if (this.selectorModel != null) {
            FilterAndRankModelInterface farModel = (FilterAndRankModelInterface)this.selectorModel;
            Object si = null;
            if (this.filterRB.isSelected()) {
                String value = this.filterValueTF.getText();
                if (value.length() > 0) {
                    NumberFormat formatter = NumberFormat.getNumberInstance();
                    ParsePosition parsePosition = new ParsePosition(0);
                    formatter.parse(value, parsePosition);
                    int indexAfterParsing = parsePosition.getIndex();
                    if (indexAfterParsing == 0 || indexAfterParsing < value.length()) {
                        Message message = new Message(RB.getStringResource(RB_KEY, "invalidFilterValue.txt"));
                        this.displayMessageAndSetStatusAndFocus(this.filterValueTF, message);
                        return;
                    }
                    FilterOperatorComboxBoxElement cbe = (FilterOperatorComboxBoxElement)this.filterOperatorsModel.getSelectedItem();
                    si = farModel.createFilterStep(cbe.operator, value);
                }
            } else {
                String value = this.rankValueTF.getText();
                if (value.length() > 0) {
                    int intValue = 0;
                    try {
                        intValue = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Message message = new Message(RB.getStringResource(RB_KEY, "invalidRankValue.txt"));
                        this.displayMessageAndSetStatusAndFocus(this.rankValueTF, message);
                        return;
                    }
                    RankTypeComboxBoxElement cbe = (RankTypeComboxBoxElement)this.rankTypesModel.getSelectedItem();
                    if (cbe.type == RankTypeEnum.COUNT) {
                        if (intValue <= 0) {
                            Message message = new Message(RB.getStringResource(RB_KEY, "rankCountOutOfBounds.txt"));
                            this.displayMessageAndSetStatusAndFocus(this.rankValueTF, message);
                            return;
                        }
                    } else if (cbe.type == RankTypeEnum.PERCENT) {
                        if (intValue <= 0 || intValue > 100) {
                            Message message = new Message(RB.getStringResource(RB_KEY, "rankPercentOutOfBounds.txt"));
                            this.displayMessageAndSetStatusAndFocus(this.rankValueTF, message);
                            return;
                        }
                    } else if (intValue < 0) {
                        Message message = new Message(RB.getStringResource(RB_KEY, "rankSumOutOfBounds.txt"));
                        this.displayMessageAndSetStatusAndFocus(this.rankValueTF, message);
                        return;
                    }
                    boolean includeTies = this.includeTiesChkBox.isSelected();
                    RankOrderEnum roe = this.topRB.isSelected() ? RankOrderEnum.TOP : RankOrderEnum.BOTTOM;
                    si = farModel.createRankStep(roe, intValue, includeTies, cbe.type);
                }
            }
            if (si != null) {
                farModel.setStep(si, this.axis);
            }
        }
    }

    private void displayMessageAndSetStatusAndFocus(Component component, Message message) {
        new JOptionPaneErrorHandler().handleError((Object)component, message, null);
        this.contentsValid = false;
        component.requestFocus();
    }

    public String getDialogTitle() {
        return RB.getStringResource(RB_KEY, "title.txt");
    }

    @SASScope
    static class RankTypeComboxBoxElement {
        RankTypeEnum type;
        String displayText;

        RankTypeComboxBoxElement(RankTypeEnum type) {
            this.type = type;
            this.displayText = type.getLabel(defaultLocale);
        }

        public String toString() {
            return this.displayText;
        }
    }

    @SASScope
    static class FilterOperatorComboxBoxElement {
        FilterOperatorEnum operator;
        String displayText;

        FilterOperatorComboxBoxElement(FilterOperatorEnum operator) {
            this.operator = operator;
            this.displayText = operator.getLabel(defaultLocale);
        }

        public String toString() {
            return this.displayText;
        }
    }

    @SASScope
    class FilterRankRadioButtonListener
    implements ItemListener {
        FilterRankRadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (FilterAndRankSelector.this.filterRB.isSelected()) {
                FilterAndRankSelector.this.dummyLabelForRankTopBottomPanel.setVisible(false);
                FilterAndRankSelector.this.rankTopBottomRadioPanel.setVisible(false);
                FilterAndRankSelector.this.conditionLabel.setVisible(true);
                FilterAndRankSelector.this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setVisible(true);
                FilterAndRankSelector.this.dummyLabelForRankDescriptionPanel.setVisible(false);
                FilterAndRankSelector.this.rankDescriptionPanel.setVisible(false);
                FilterAndRankSelector.this.filterValueLabel.setVisible(true);
                FilterAndRankSelector.this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setVisible(true);
            } else {
                FilterAndRankSelector.this.conditionLabel.setVisible(false);
                FilterAndRankSelector.this.fourthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setVisible(false);
                FilterAndRankSelector.this.dummyLabelForRankTopBottomPanel.setVisible(true);
                FilterAndRankSelector.this.rankTopBottomRadioPanel.setVisible(true);
                FilterAndRankSelector.this.filterValueLabel.setVisible(false);
                FilterAndRankSelector.this.fifthRowSecondColumnPanelCreatedForPreferredSizingPurposes.setVisible(false);
                FilterAndRankSelector.this.dummyLabelForRankDescriptionPanel.setVisible(true);
                FilterAndRankSelector.this.rankDescriptionPanel.setVisible(true);
            }
            FilterAndRankSelector.this.revalidate();
            FilterAndRankSelector.this.repaint();
        }
    }

    @SASScope
    static class CurrentFiltersListElement {
        FilterAxisEnum filterAxis;
        String displayText;

        CurrentFiltersListElement(FilterAxisEnum filterAxis, String displayText) {
            this.filterAxis = filterAxis;
            this.displayText = displayText;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

