/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculations.percent;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculations.percent.FractionalItemInfo;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorInterface;
import com.sas.swing.visuals.dataselectors.calculations.percent.PercentCalculationsElement;
import com.sas.swing.visuals.dataselectors.calculations.percent.RB;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

@SASScope
class PercentCalculationsTableModel
extends AbstractTableModel {
    public static final int NUMERATOR_COLUMN = 0;
    public static final int DENOMINATOR_COLUMN = 1;
    public static final int LABEL_COLUMN = 2;
    private PercentCalculationsSelectorInterface model = null;
    private List fractionalItems = new ArrayList();
    private final String[] columnNames = new String[]{RB.getStringResource("PercentCalculationsTableModel.title1.txt"), RB.getStringResource("PercentCalculationsTableModel.title2.txt"), RB.getStringResource("PercentCalculationsTableModel.title3.txt")};

    PercentCalculationsTableModel() {
    }

    void setDataModel(PercentCalculationsSelectorInterface model) {
        int rowIndex;
        this.model = model;
        if (null != model && null != model.getFractionalItems()) {
            this.fractionalItems.addAll(model.getFractionalItems());
        }
        if ((rowIndex = this.fractionalItems.size() - 1) >= 0) {
            this.fireTableRowsInserted(0, rowIndex);
        }
    }

    @Override
    public int getRowCount() {
        return this.fractionalItems.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FractionalItemInfo itemInfo = (FractionalItemInfo)this.fractionalItems.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return itemInfo.getNumeratorLabel();
            }
            case 1: {
                String value = null;
                value = itemInfo.getDenominatorType() == 0 ? Message.format((ResourceBundle)RB.getResources(), (String)"PercentCalculations.subTotal.txt", (Object)itemInfo.getDenominatorLabel()) : itemInfo.getDenominatorLabel();
                return value;
            }
            case 2: {
                return itemInfo.getLabel();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    FractionalItemInfo getFractionalItemInfo(int rowIndex) {
        return (FractionalItemInfo)this.fractionalItems.get(rowIndex);
    }

    int getIndex(PercentCalculationsElement numerator, PercentCalculationsElement denominator) {
        int i;
        String numeratorId = numerator.getId();
        String denominatorId = denominator.getId();
        int denominatorType = denominator.getDenominatorType();
        boolean found = false;
        int rowCount = this.fractionalItems.size();
        for (i = 0; i < rowCount; ++i) {
            FractionalItemInfo fractionalItem = (FractionalItemInfo)this.fractionalItems.get(i);
            if (!fractionalItem.getNumeratorId().equals(numeratorId)) continue;
            if (!this.model.isOLAP()) {
                found = true;
                break;
            }
            if (fractionalItem.getDenominatorType() == 0) {
                if (!fractionalItem.getDenominatorId().equals(denominatorId)) continue;
                found = true;
                break;
            }
            if (denominatorType != fractionalItem.getDenominatorType()) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    void addRow(PercentCalculationsElement measureElement, PercentCalculationsElement percentOfElement, String label) {
        FractionalItemInfo itemInfo = new FractionalItemInfo();
        itemInfo.setNumeratorId(measureElement.getId());
        itemInfo.setNumeratorLabel(measureElement.getLabel());
        itemInfo.setDenominatorId(percentOfElement.getId());
        itemInfo.setDenominatorLabel(percentOfElement.getLabel());
        itemInfo.setDenominatorType(percentOfElement.getDenominatorType());
        itemInfo.setLabel(label);
        this.fractionalItems.add(itemInfo);
        int rowIndex = this.fractionalItems.size() - 1;
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    void updateRow(PercentCalculationsElement measureElement, PercentCalculationsElement percentOfElement, String label, int index) {
        FractionalItemInfo itemInfo = (FractionalItemInfo)this.fractionalItems.get(index);
        itemInfo.setNumeratorId(measureElement.getId());
        itemInfo.setNumeratorLabel(measureElement.getLabel());
        itemInfo.setDenominatorId(percentOfElement.getId());
        itemInfo.setDenominatorLabel(percentOfElement.getLabel());
        itemInfo.setDenominatorType(percentOfElement.getDenominatorType());
        itemInfo.setLabel(label);
        this.fireTableRowsUpdated(index, index);
    }

    void removeRow(int rowIndex) {
        this.fractionalItems.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    void removeAll() {
        int count = this.fractionalItems.size();
        for (int i = count - 1; i >= 0; --i) {
            this.fractionalItems.remove(i);
        }
        this.fireTableRowsDeleted(0, count - 1);
    }

    void synchronizeAdapter() {
        if (null != this.model) {
            this.model.setFractionalItems(this.fractionalItems);
        }
    }
}

