/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculations.percent;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorInterface;
import com.sas.swing.visuals.OptionsDialog;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.calculations.percent.PercentCalculationsEditPanel;
import com.sas.swing.visuals.dataselectors.calculations.percent.PercentCalculationsTableModel;
import com.sas.swing.visuals.dataselectors.calculations.percent.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

@SASScope(value="ALL")
public class PercentCalculationsSelector
extends BaseSwingSelectorPanel
implements ActionListener,
ListSelectionListener,
TableModelListener,
LayoutConstants {
    static final String RB_KEY = "PercentCalculationsSelector.";
    private boolean isRelational;
    private JButton newButton;
    private JButton deleteButton;
    private JButton deleteAllButton;
    private JButton editButton;
    private JTable summaryTable;
    private PercentCalculationsTableModel tableModel;

    public PercentCalculationsSelector() {
        this.createLayout();
        this.addListeners();
    }

    private void createLayout() {
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        outerLayout.setRemainderRow(2);
        this.setLayout((LayoutManager)outerLayout);
        this.add(new JLabel(RB.getStringResource(RB_KEY, "listTitle.txt")));
        JPanel listPanel = new JPanel();
        AutoSizingGridLayout listLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, true, true);
        listLayout.setRemainderColumn(1);
        listPanel.setLayout((LayoutManager)listLayout);
        this.summaryTable = new JTable();
        this.summaryTable.setShowGrid(false);
        this.summaryTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        this.summaryTable.getSelectionModel().setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.summaryTable);
        listPanel.add(scrollPane);
        JPanel listManipulatingButtonsPanel = new JPanel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(4, 1, 5, 5, true, false, false);
        buttonLayout.setGridGravity(256);
        listManipulatingButtonsPanel.setLayout((LayoutManager)buttonLayout);
        this.newButton = new JButton();
        this.newButton.setToolTipText(RB.getStringResource(RB_KEY, "newButtonToolTip.txt"));
        this.setButtonTextAndMnemonic(RB.getStringResource(RB_KEY, "newButton.txt"), this.newButton);
        this.editButton = new JButton();
        this.editButton.setToolTipText(RB.getStringResource(RB_KEY, "editButtonToolTip.txt"));
        this.setButtonTextAndMnemonic(RB.getStringResource(RB_KEY, "editButton.txt"), this.editButton);
        this.editButton.setEnabled(false);
        this.deleteButton = new JButton();
        this.deleteButton.setToolTipText(RB.getStringResource(RB_KEY, "deleteButtonToolTip.txt"));
        this.setButtonTextAndMnemonic(RB.getStringResource(RB_KEY, "deleteButton.txt"), this.deleteButton);
        this.deleteButton.setEnabled(false);
        this.deleteAllButton = new JButton();
        this.deleteAllButton.setToolTipText(RB.getStringResource(RB_KEY, "deleteAllButtonToolTip.txt"));
        this.setButtonTextAndMnemonic(RB.getStringResource(RB_KEY, "deleteAllButton.txt"), this.deleteAllButton);
        this.deleteAllButton.setEnabled(false);
        listManipulatingButtonsPanel.add(this.newButton);
        listManipulatingButtonsPanel.add(this.editButton);
        listManipulatingButtonsPanel.add(this.deleteButton);
        listManipulatingButtonsPanel.add(this.deleteAllButton);
        listPanel.add(listManipulatingButtonsPanel);
        this.add(listPanel);
    }

    private void addListeners() {
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.deleteAllButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.summaryTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            boolean isSelected = !lsm.isSelectionEmpty();
            this.deleteButton.setEnabled(isSelected);
            this.editButton.setEnabled(isSelected);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.deleteAllButton.setEnabled(this.tableModel.getRowCount() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.newButton) {
            this.editOrAddItem(-1, false);
        } else if (source == this.editButton) {
            ListSelectionModel lsm = this.summaryTable.getSelectionModel();
            if (!lsm.isSelectionEmpty()) {
                int index = lsm.getMinSelectionIndex();
                this.editOrAddItem(index, true);
            }
        } else if (source == this.deleteButton) {
            ListSelectionModel lsm = this.summaryTable.getSelectionModel();
            if (!lsm.isSelectionEmpty() && JOptionPane.showConfirmDialog((Component)((Object)this), RB.getStringResource(RB_KEY, "deleteSelectedQuestion.txt"), RB.getStringResource(RB_KEY, "confirmDeleteDialogTitle.txt"), 0, 2) == 0) {
                int index = lsm.getMinSelectionIndex();
                this.tableModel.removeRow(index);
                this.tableModel.synchronizeAdapter();
            }
        } else if (source == this.deleteAllButton && JOptionPane.showConfirmDialog((Component)((Object)this), RB.getStringResource(RB_KEY, "deleteAllQuestion.txt"), RB.getStringResource(RB_KEY, "confirmDeleteDialogTitle.txt"), 0, 2) == 0 && null != this.tableModel) {
            this.tableModel.removeAll();
            this.tableModel.synchronizeAdapter();
        }
    }

    private void editOrAddItem(int index, boolean isEdit) {
        Frame parent = Util.getParentAWTFrame((Component)((Object)this));
        if (parent == null) {
            parent = new Frame();
        }
        PercentCalculationsEditPanel panel = new PercentCalculationsEditPanel((PercentCalculationsSelectorInterface)this.selectorModel, this.tableModel, index, isEdit, this.isRelational);
        OptionsDialog dialog = new OptionsDialog(parent, (PanelInterface)panel, true);
        String titleResource = isEdit ? "PercentCalculationsEditPanel.editTitle.txt" : "PercentCalculationsEditPanel.newTitle.txt";
        dialog.setTitle(RB.getStringResource(titleResource));
        dialog.pack();
        Util.centerOverWindow((Window)dialog, (Component)((Object)this));
        dialog.setVisible(true);
        if (!dialog.wasCancelled()) {
            this.tableModel.synchronizeAdapter();
        }
    }

    private void populateSummaryTable() {
        if (null == this.tableModel) {
            this.tableModel = new PercentCalculationsTableModel();
        }
        if (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeAll();
        }
        this.tableModel.setDataModel((PercentCalculationsSelectorInterface)this.selectorModel);
        this.tableModel.addTableModelListener(this);
        this.summaryTable.setModel(this.tableModel);
    }

    public void setSelectorModel(Object model) {
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource("PercentCalculationsSelector.nullAdapter.txt"));
        }
        if (!(model instanceof PercentCalculationsSelectorInterface)) {
            throw new IllegalStateException(RB.getStringResource("PercentCalculationsSelector.invalidAdapterType.txt"));
        }
        if (this.selectorModel != model) {
            Object old = this.selectorModel;
            this.selectorModel = model;
            this.isRelational = !((PercentCalculationsSelectorInterface)this.selectorModel).isOLAP();
            this.populateSummaryTable();
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    public String getDialogTitle() {
        return RB.getStringResource("PercentCalculationsSelector.dialogTitle.txt");
    }

    private void setButtonTextAndMnemonic(String item, AbstractButton button) {
        String displayText = Util.getLabelWithoutMnemonic((String)item);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        button.setText(displayText);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(index);
        }
    }
}

