/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculations.percent;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculations.percent.FractionalItemInfo;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.calculations.percent.PercentCalculationsElement;
import com.sas.swing.visuals.dataselectors.calculations.percent.PercentCalculationsTableModel;
import com.sas.swing.visuals.dataselectors.calculations.percent.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@SASScope
class PercentCalculationsEditPanel
extends BaseSwingSelectorPanel
implements DocumentListener,
ItemListener,
LayoutConstants {
    private static final String RB_KEY = "PercentCalculationsEditPanel.";
    private PercentCalculationsSelectorInterface model;
    private JComboBox forMeasureCombo;
    private JComboBox showPercentOfCombo;
    private JLabel showPercentOfColumnTotal;
    private JTextField labelTextField;
    private JLabel forMeasureLabel;
    private JLabel showPercentOfLabel;
    private JLabel labelLabel;
    private PercentCalculationsTableModel tableModel;
    private PercentCalculationsElement columnTotalElement;
    private boolean isEdit;
    private boolean isRelational;
    private int rowIndex;
    private boolean comboFieldsMustChange;

    PercentCalculationsEditPanel(PercentCalculationsSelectorInterface model, PercentCalculationsTableModel tableModel, int rowIndex, boolean isEdit, boolean isRelational) {
        this.model = model;
        this.tableModel = tableModel;
        this.rowIndex = rowIndex;
        this.isEdit = isEdit;
        this.isRelational = isRelational;
        this.comboFieldsMustChange = false;
        this.createLayout();
        this.addListeners();
        this.populateForMeasureCombo();
        if (isRelational) {
            this.populateColumnTotalElement();
        } else {
            this.populateShowPercentOfCombo();
        }
        this.populateLabel();
    }

    private void createLayout() {
        AutoSizingGridLayout inputLayout = new AutoSizingGridLayout(3, 2, 25, 5, true, true, true);
        inputLayout.setRemainderColumn(2);
        this.setLayout((LayoutManager)inputLayout);
        this.forMeasureLabel = new JLabel(RB.getStringResource(RB_KEY, "forMeasure.txt"));
        this.add(this.forMeasureLabel);
        this.forMeasureCombo = new JComboBox();
        this.forMeasureCombo.setPrototypeDisplayValue("12345678901234WWWWWW");
        this.add(this.forMeasureCombo);
        this.showPercentOfLabel = new JLabel(RB.getStringResource(RB_KEY, "showPercentOf.txt"));
        this.add(this.showPercentOfLabel);
        if (this.isRelational) {
            this.showPercentOfColumnTotal = new JLabel(RB.getStringResource(RB_KEY, "columnTotal.txt"));
            this.add(this.showPercentOfColumnTotal);
        } else {
            this.showPercentOfCombo = new JComboBox();
            this.showPercentOfCombo.setPrototypeDisplayValue("12345678901234WWWWWW");
            this.add(this.showPercentOfCombo);
        }
        this.labelLabel = new JLabel(RB.getStringResource(RB_KEY, "label.txt"));
        this.add(this.labelLabel);
        this.labelTextField = new JTextField();
        this.add(this.labelTextField);
    }

    private void addListeners() {
        this.labelTextField.getDocument().addDocumentListener(this);
        this.forMeasureCombo.addItemListener(this);
        if (!this.isRelational) {
            this.showPercentOfCombo.addItemListener(this);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkContentsValid();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkContentsValid();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.comboFieldsMustChange = false;
            this.checkContentsValid();
        }
    }

    private void checkContentsValid() {
        int count = this.labelTextField.getText().trim().length();
        boolean valid = count > 0 && !this.comboFieldsMustChange;
        this.setContentsValid(valid);
    }

    private void populateForMeasureCombo() {
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.forMeasureCombo.getModel();
        if (cbModel == null) {
            cbModel = new DefaultComboBoxModel();
        } else {
            cbModel.removeAllElements();
        }
        this.forMeasureCombo.setModel(this.populateMeasureComboModel(cbModel));
        if (cbModel.getSize() > 0) {
            if (this.isEdit) {
                int comboIndex = this.getComboIndexToSelect(cbModel, true);
                this.forMeasureCombo.setSelectedIndex(comboIndex);
            } else {
                this.forMeasureCombo.setSelectedIndex(0);
            }
        }
    }

    private DefaultComboBoxModel populateMeasureComboModel(DefaultComboBoxModel cbModel) {
        Map numerators = this.model.getNumerators();
        if (numerators == null) {
            return cbModel;
        }
        for (String key : numerators.keySet()) {
            PercentCalculationsElement element = new PercentCalculationsElement();
            element.setId(key);
            element.setLabel((String)numerators.get(key));
            cbModel.addElement(element);
        }
        return cbModel;
    }

    private void populateShowPercentOfCombo() {
        DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.showPercentOfCombo.getModel();
        if (cbModel == null) {
            cbModel = new DefaultComboBoxModel();
        } else {
            cbModel.removeAllElements();
        }
        this.showPercentOfCombo.setModel(this.populatePercentComboModel(cbModel));
        if (cbModel.getSize() > 0) {
            if (this.isEdit) {
                int comboIndex = this.getComboIndexToSelect(cbModel, false);
                this.showPercentOfCombo.setSelectedIndex(comboIndex);
            } else {
                this.showPercentOfCombo.setSelectedIndex(0);
            }
        }
    }

    private DefaultComboBoxModel populatePercentComboModel(DefaultComboBoxModel cbModel) {
        if (cbModel == null) {
            return cbModel;
        }
        Map denominators = this.model.getDenominators();
        if (denominators == null) {
            return cbModel;
        }
        Iterator iterator = denominators.keySet().iterator();
        while (iterator.hasNext()) {
            PercentCalculationsElement element = new PercentCalculationsElement();
            Object key = iterator.next();
            if (key instanceof String) {
                element.setId((String)key);
                element.setLabel(Message.format((ResourceBundle)RB.getResources(), (String)"PercentCalculations.subTotal.txt", denominators.get(key)));
                element.setDenominatorType(0);
            } else {
                element.setId(null);
                element.setLabel((String)denominators.get(key));
                element.setDenominatorType((Integer)key);
            }
            cbModel.addElement(element);
        }
        return cbModel;
    }

    private int getComboIndexToSelect(DefaultComboBoxModel cbModel, boolean isNumerator) {
        FractionalItemInfo info = this.tableModel.getFractionalItemInfo(this.rowIndex);
        String valueFromTable = isNumerator ? info.getNumeratorId() : info.getDenominatorId();
        int denominatorType = info.getDenominatorType();
        int comboIndex = 0;
        int count = cbModel.getSize();
        boolean found = false;
        for (comboIndex = 0; comboIndex < count; ++comboIndex) {
            PercentCalculationsElement element = (PercentCalculationsElement)cbModel.getElementAt(comboIndex);
            if (isNumerator || info.getDenominatorType() == 0) {
                if (!valueFromTable.equals(element.getId())) continue;
                found = true;
                break;
            }
            if (denominatorType != element.getDenominatorType()) continue;
            found = true;
            break;
        }
        if (!found) {
            comboIndex = 0;
        }
        return comboIndex;
    }

    private void populateColumnTotalElement() {
        this.columnTotalElement = new PercentCalculationsElement();
        Map denominators = null;
        if (null != this.model) {
            denominators = this.model.getDenominators();
        }
        if (denominators != null) {
            for (Object key : denominators.keySet()) {
                this.columnTotalElement.setId(null);
                this.columnTotalElement.setLabel((String)denominators.get(key));
                this.columnTotalElement.setDenominatorType((Integer)key);
            }
        } else {
            String msg = RB.getStringResource(RB_KEY, "noDenominatorMap.txt");
            throw new IllegalStateException(msg);
        }
    }

    private void populateLabel() {
        if (this.isEdit) {
            FractionalItemInfo info = this.tableModel.getFractionalItemInfo(this.rowIndex);
            String label = info.getLabel();
            this.labelTextField.setText(label);
        }
    }

    public void onApply() {
        this.setContentsValid(true);
        PercentCalculationsElement selectedMeasureElement = (PercentCalculationsElement)this.forMeasureCombo.getSelectedItem();
        PercentCalculationsElement selectedPercentOfElement = this.isRelational ? this.columnTotalElement : (PercentCalculationsElement)this.showPercentOfCombo.getSelectedItem();
        String label = this.labelTextField.getText().trim();
        if (null != this.model && this.model.isOLAP() && (label.indexOf(91) != -1 || label.indexOf(93) != -1)) {
            this.noBracketsDialog();
            return;
        }
        int index = this.tableModel.getIndex(selectedMeasureElement, selectedPercentOfElement);
        if (this.isEdit) {
            if (-1 == index || this.rowIndex == index) {
                this.tableModel.updateRow(selectedMeasureElement, selectedPercentOfElement, label, this.rowIndex);
            } else {
                this.alreadyExistsDialog();
            }
        } else if (-1 == index) {
            this.tableModel.addRow(selectedMeasureElement, selectedPercentOfElement, label);
        } else {
            this.alreadyExistsDialog();
        }
    }

    private void alreadyExistsDialog() {
        String msg = RB.getStringResource(RB_KEY, "duplicateAddError.txt");
        JOptionPane.showMessageDialog((Component)((Object)this), msg);
        this.comboFieldsMustChange = true;
        this.checkContentsValid();
    }

    private void noBracketsDialog() {
        String msg = RB.getStringResource(RB_KEY, "noBracketsError.txt");
        JOptionPane.showMessageDialog((Component)((Object)this), msg);
        this.setContentsValid(false);
    }
}

