/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.models.FileLocation;
import com.sas.models.FileLocationInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.visuals.BaseRemoteObjectPicker;
import com.sas.swing.visuals.IFileValidator;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.text.Message;
import com.sas.util.FileValidatorInterface;
import com.sas.util.ListFactory;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

@SASScope
public class IFilePicker
extends BaseRemoteObjectPicker {
    private static final long serialVersionUID = -4266846382290931710L;
    public static final String RB_KEY = "IFilePicker.";
    public static int FILES_AND_DIRECTORIES = 0;
    public static int FILES_ONLY = 1;
    public static int DIRECTORIES_ONLY = 2;
    private String logicalServerName;
    private PromptDataProviderInterface dataProvider;
    private IWorkspace workspace;
    private List fileTypes;
    private int selectionMode;
    private boolean validateExistence;
    private FileLocationInterface fileLocation;
    private RemoteFileModel2Interface model;
    private FileValidatorInterface validator;
    private IFileServiceSelectorPanel panel;

    public IFilePicker(FileValidatorInterface validator, String logicalServerName, PromptDataProviderInterface dataProvider) {
        this(validator, logicalServerName, (RemoteFileModel2Interface)null);
        this.dataProvider = dataProvider;
    }

    public IFilePicker(IWorkspace workspace) {
        this(null, workspace);
    }

    public IFilePicker(FileValidatorInterface validator, IWorkspace workspace) {
        this.validator = validator;
        this.workspace = workspace;
        this.init();
    }

    public IFilePicker(FileValidatorInterface validator, String logicalServerName, RemoteFileModel2Interface model) {
        this.validator = validator;
        this.logicalServerName = logicalServerName;
        this.model = model;
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (this.validator == null) {
            if (this.workspace != null) {
                this.validator = new IFileValidator(this.workspace);
            } else if (this.dataProvider != null && this.logicalServerName != null) {
                this.validator = new IFileValidator(this.dataProvider, this.logicalServerName);
            }
        }
        this.validateExistence = true;
        this.selectionMode = FILES_ONLY;
    }

    /*
     * Unable to fully structure code
     */
    private IWorkspace getWorkspace() {
        if (this.workspace == null) {
            if (this.logicalServerName != null && this.dataProvider != null) {
                try {
                    this.workspace = this.dataProvider.getIWorkspace(this.logicalServerName);
                    if (this.validator != null) ** GOTO lbl20
                    this.validator = new IFileValidator(this.workspace);
                }
                catch (ServerConnectionException e) {
                    if (this.getGenericErrorHandler() == null) {
                        ex = new IllegalStateException(RB.getStringResource((String)"IFilePicker.", (String)"errorGettingServer.ex.txt"));
                        ex.initCause(e);
                        throw ex;
                    }
                    this.handleError(new Message(Strings.padSingleQuotesForMessage((String)e.getMessage())));
                    return this.workspace;
                }
            } else {
                if (this.getGenericErrorHandler() == null) {
                    throw new IllegalStateException(RB.getStringResource((String)"IFilePicker.", (String)"errorGettingServer.ex.txt"));
                }
                this.handleError(new Message(Strings.padSingleQuotesForMessage((String)RB.getStringResource((String)"IFilePicker.", (String)"errorGettingServer.ex.txt"))));
                return this.workspace;
            }
        }
lbl20:
        // 4 sources

        if (this.workspace == null) {
            if (this.getGenericErrorHandler() == null) {
                throw new IllegalStateException(RB.getStringResource((String)"IFilePicker.", (String)"nullWorkspace.ex.txt"));
            }
            this.handleError(new Message(Strings.padSingleQuotesForMessage((String)RB.getStringResource((String)"IFilePicker.", (String)"nullWorkspace.ex.txt"))));
        }
        return this.workspace;
    }

    @Override
    protected RemoteFileSelectorDialog getRemoteFileSelectorDialog(BaseRemoteFileSelectorPanel panel) {
        RemoteFileSelectorDialog dialog = super.getRemoteFileSelectorDialog(panel);
        if (this.validateExistence) {
            dialog.setAllowNonExistentSelections(false);
        } else {
            dialog.setAllowNonExistentSelections(true);
        }
        return dialog;
    }

    @Override
    protected BaseRemoteFileSelectorPanel getRemoteFileSelectorPanel() {
        return this.getRemoteFileSelectorPanel((FileLocationInterface)this.getValue());
    }

    private BaseRemoteFileSelectorPanel getRemoteFileSelectorPanel(FileLocationInterface fli) {
        LinkedHashMap<String, List> fileTypes = new LinkedHashMap<String, List>();
        List ft = this.getFileTypes();
        if (ft != null) {
            ft = ListFactory.newList((Collection)ft);
        }
        if (ft != null) {
            for (String type : ft) {
                if (type == null || type.charAt(0) != '.') continue;
                ft.set(ft.indexOf(type), type.substring(1));
            }
        }
        if (ft != null && !ft.isEmpty()) {
            fileTypes.put(RB.getStringResource((String)RB_KEY, (String)"allTypes.txt", (Locale)this.getLocale()), ft);
        } else {
            fileTypes = null;
        }
        String startDir = "";
        boolean isDir = false;
        if (fli != null) {
            startDir = fli.getFileLocation();
            isDir = fli.isDirectory();
        }
        if (startDir != null && !isDir) {
            int index = startDir.lastIndexOf("/");
            if (index != -1) {
                startDir = startDir.substring(0, index) + "/";
            } else {
                index = startDir.lastIndexOf("\\");
                if (index != -1) {
                    startDir = startDir.substring(0, index) + "\\";
                }
            }
        }
        if (!(startDir == null || startDir.length() <= 0 || this.validator != null && this.validator.isFileExisiting(startDir))) {
            startDir = null;
        }
        if (this.panel == null) {
            if (this.model != null) {
                this.panel = new IFileServiceSelectorPanel();
                this.panel.setShowDirectoriesOnly(this.isDirectoryOnly());
                this.panel.initialize(startDir, this.model, null, fileTypes);
            } else {
                IWorkspace ws = this.getWorkspace();
                if (ws != null) {
                    this.panel = new IFileServiceSelectorPanel(startDir, ws, fileTypes, this.isDirectoryOnly());
                }
            }
            if (this.panel != null) {
                this.panel.setMultiSelectionEnabled(false);
                if (this.getSelectionMode() == DIRECTORIES_ONLY) {
                    this.panel.setSelectionMode(BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY);
                } else if (this.getSelectionMode() == FILES_ONLY) {
                    this.panel.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_ONLY);
                } else if (this.getSelectionMode() == FILES_AND_DIRECTORIES) {
                    this.panel.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES);
                }
            }
        } else if (startDir != null && startDir.length() > 0) {
            this.panel.getModel().setLocation(startDir);
        }
        return this.panel;
    }

    private boolean isDirectoryOnly() {
        return this.getSelectionMode() == DIRECTORIES_ONLY;
    }

    @Override
    protected String getRemoteObjectSelectorTitle() {
        if (this.getSelectionMode() == FILES_AND_DIRECTORIES) {
            return RB.getStringResource((String)RB_KEY, (String)"fileDirectoryTitle.txt", (Locale)this.getLocale());
        }
        if (this.getSelectionMode() == DIRECTORIES_ONLY) {
            return RB.getStringResource((String)RB_KEY, (String)"directoryTitle.txt", (Locale)this.getLocale());
        }
        return RB.getStringResource((String)RB_KEY, (String)"fileTitle.txt", (Locale)this.getLocale());
    }

    @Override
    public Object getValue() {
        if (this.fileLocation != null && Strings.equal((String)this.fileLocation.getFileLocation(), (String)this.getText(), (boolean)true, (boolean)false)) {
            return this.fileLocation;
        }
        this.setValue(this.getText());
        return this.fileLocation;
    }

    private void setValueText() {
        if (this.fileLocation != null) {
            this.setText(this.fileLocation.getFileLocation());
        } else {
            this.setText(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object anObject) {
        if (null == this.dataProvider || !(this.dataProvider instanceof DataProvider) || null == ((DataProvider)this.dataProvider).getUserContext() || Util.equal((Object)anObject, (Object)this.fileLocation)) return;
        boolean change = false;
        if (anObject != null) {
            if (anObject instanceof FileLocationInterface) {
                change = this.validateFileLocation((FileLocationInterface)anObject);
            } else {
                String path = anObject.toString().trim();
                if (path.length() > 0) {
                    if (this.validator == null) return;
                    String type = null;
                    if (this.validator.isFileExisiting(path)) {
                        type = this.getFileType(path);
                    }
                    if (type == null) {
                        if (this.isDirectoryOnly()) {
                            this.setValue(new FileLocation(this.logicalServerName, path, true));
                        } else {
                            this.setValue(new FileLocation(this.logicalServerName, path, false));
                        }
                    } else if ("FOLDER".equalsIgnoreCase(type)) {
                        this.setValue(new FileLocation(this.logicalServerName, path, true));
                    } else {
                        this.setValue(new FileLocation(this.logicalServerName, path, false));
                    }
                } else if (this.fileLocation != null) {
                    this.fileLocation = null;
                    change = true;
                }
            }
        } else if (this.fileLocation != null) {
            this.fileLocation = null;
            change = true;
        }
        this.setValueText();
        if (!change) return;
        this.fireValueChanged();
    }

    private String getFileType(String path) {
        String type = null;
        if (this.validator != null) {
            type = this.validator.getFileType(path);
            return type;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateFileLocation(FileLocationInterface fli) {
        boolean change = false;
        if (fli.isFile() && !this.isFileAllowed(fli.getFileLocation())) {
            this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"illegalFileType.ex.txt", (Locale)this.getLocale()), (Object)fli.getFileLocation()));
            return change;
        } else if (this.isValidateExistence()) {
            String fileName = fli.getFileLocation();
            if (this.validator == null) return false;
            boolean exists = this.validator.isFileExisiting(fileName);
            if (this.getSelectionMode() == FILES_AND_DIRECTORIES) {
                if (exists) {
                    this.fileLocation = fli;
                    return true;
                }
                this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"doesNotExists.ex.txt", (Locale)this.getLocale()), (Object)fileName));
                return change;
            } else if (exists) {
                String type = this.getFileType(fileName);
                boolean isAFolder = Strings.equal((String)type, (String)"FOLDER", (boolean)true, (boolean)true);
                if (this.getSelectionMode() == DIRECTORIES_ONLY) {
                    if (isAFolder) {
                        this.fileLocation = fli;
                        return true;
                    }
                    this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"notADirectory.ex.txt", (Locale)this.getLocale()), (Object)fileName));
                    return change;
                } else {
                    if (!isAFolder) {
                        this.fileLocation = fli;
                        return true;
                    }
                    this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"notAFile.ex.txt", (Locale)this.getLocale()), (Object)fileName));
                }
                return change;
            } else if (this.getSelectionMode() == DIRECTORIES_ONLY) {
                this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"directoryDoesNotExist.ex.txt", (Locale)this.getLocale()), (Object)fileName));
                return change;
            } else {
                this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"fileDoesNotExist.ex.txt", (Locale)this.getLocale()), (Object)fileName));
            }
            return change;
        } else {
            if (this.getSelectionMode() == FILES_AND_DIRECTORIES) {
                this.fileLocation = fli;
                return true;
            }
            if (this.getSelectionMode() == FILES_ONLY) {
                if (fli.isFile()) {
                    this.fileLocation = fli;
                    return true;
                }
                this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"notAFile.ex.txt", (Locale)this.getLocale()), (Object)fli.getFileLocation()));
                return change;
            } else {
                if (this.getSelectionMode() != DIRECTORIES_ONLY) return change;
                if (fli.isDirectory()) {
                    this.fileLocation = fli;
                    return true;
                }
                this.handleError(new Message(RB.getStringResource((String)RB_KEY, (String)"notADirectory.ex.txt", (Locale)this.getLocale()), (Object)fli.getFileLocation()));
            }
        }
        return change;
    }

    private boolean isFileAllowed(String path) {
        List ft = this.getFileTypes();
        if (ft == null || ft.isEmpty()) {
            return true;
        }
        int index = path.lastIndexOf(46);
        if (index != -1) {
            String ext = path.substring(index).trim();
            String extWithDot = path.substring(index + 1).trim();
            for (String type : ft) {
                if (!type.equalsIgnoreCase(ext) && !type.equalsIgnoreCase(extWithDot)) continue;
                return true;
            }
        }
        return false;
    }

    public List getFileTypes() {
        return this.fileTypes;
    }

    public void setFileTypes(List fileTypes) {
        if (this.fileTypes != fileTypes) {
            List oldValue = this.fileTypes;
            this.fileTypes = fileTypes;
            this.panel = null;
            if (this.fileLocation != null && !this.isFileAllowed(this.fileLocation.getFileLocation())) {
                this.setValue(null);
            }
            this.firePropertyChange("fileTypes", oldValue, this.fileTypes);
        }
    }

    public boolean isValidateExistence() {
        return this.validateExistence;
    }

    public void setValidateExistence(boolean validateExistence) {
        if (this.validateExistence != validateExistence) {
            boolean oldValue = this.validateExistence;
            this.validateExistence = validateExistence;
            this.firePropertyChange("validateExistence", oldValue, this.validateExistence);
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode != FILES_ONLY && selectionMode != FILES_AND_DIRECTORIES && selectionMode != DIRECTORIES_ONLY) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidSelectionMode.ex.txt", (Locale)this.getLocale()));
        }
        if (this.selectionMode != selectionMode) {
            int oldValue = this.selectionMode;
            this.selectionMode = selectionMode;
            if (this.fileLocation != null && !this.validateFileLocation(this.fileLocation)) {
                this.setValue(null);
            }
            if (this.panel != null) {
                if (selectionMode == FILES_ONLY) {
                    this.panel.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_ONLY);
                } else if (selectionMode == DIRECTORIES_ONLY) {
                    this.panel.setSelectionMode(BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY);
                } else if (selectionMode == FILES_AND_DIRECTORIES) {
                    this.panel.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_AND_DIRECTORIES);
                }
            }
            this.firePropertyChange("selectionMode", oldValue, this.selectionMode);
        }
    }
}

