/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.rmi;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RenameFileInterface;
import com.sas.swing.models.remotefileselector2.rmi.RenameFileRmiInterface;
import com.sas.swing.visuals.remotefileselector2.RB;
import java.util.HashMap;

public class RenameCommand
extends BaseCommand
implements ContentsChangedInterface {
    public static final String RB_KEY = "RenameCommand.";
    private String path;
    private BaseRemoteFileModelInterface remoteModel;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo = new HashMap(2);
    private Object eventSource;
    private String newName;
    private String oldName;
    private SortableTableModelAdapter tableModel;
    private int index;

    public RenameCommand() {
        this(null);
    }

    public RenameCommand(String name) {
        super(name);
    }

    public RenameCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    public void execute(Object o) throws IllegalArgumentException {
        this.tableModel = this.getTableModel();
        this.remoteModel = (BaseRemoteFileModelInterface)this.tableModel.getModel();
        this.setEventSource(this.remoteModel);
        RemoteFileMetadataInterface node = this.remoteModel.getNodeAt(this.getIndex());
        if (node != null && this.remoteModel instanceof RenameFileInterface) {
            RenameFileInterface rfsModel = (RenameFileInterface)((Object)this.remoteModel);
            if (node.isFolder() && rfsModel.isExistingSubFolder(this.remoteModel.getLocation(), this.newName)) {
                this.contentsChanged = false;
                throw new IllegalArgumentException(RB.getStringResource("AddFolderCommand.", "sameName.txt"));
            }
            if (!node.isFolder() && rfsModel.isExistingFileItem(this.remoteModel.getLocation(), this.newName)) {
                this.contentsChanged = false;
                throw new IllegalArgumentException(RB.getStringResource("AddFolderCommand.", "sameName.txt"));
            }
            if (rfsModel instanceof RenameFileRmiInterface) {
                ((RenameFileRmiInterface)rfsModel).renameItem(this.getIndex(), this.newName);
            } else {
                rfsModel.renameItem(node, this.newName);
            }
            this.contentsChanged = true;
        }
        this.eventInfo.put("path", this.remoteModel.getLocation());
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setTableModel(SortableTableModelAdapter sortTableModel) {
        this.tableModel = sortTableModel;
    }

    public SortableTableModelAdapter getTableModel() {
        return this.tableModel;
    }

    public void setIndex(int tableIndex) {
        this.index = tableIndex;
    }

    public int getIndex() {
        return this.index;
    }
}

