/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.rmi;

import com.sas.swing.models.remotefileselector2.AddFolderInterface;
import com.sas.swing.models.remotefileselector2.DeleteFileInterface;
import com.sas.swing.models.remotefileselector2.MutableFileFilterInterface;
import com.sas.swing.models.remotefileselector2.PasteFileInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelDirectoriesOnlyInterface;
import com.sas.swing.models.remotefileselector2.RenameFileInterface;
import com.sas.swing.models.remotefileselector2.informationservices.IncludeSystemFoldersInterface;
import com.sas.swing.models.remotefileselector2.rmi.RemoteFileServiceModelRmi;
import com.sas.swing.models.remotefileselector2.rmi.RenameFileRmiInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RemoteFileServiceModelClientImpl
implements RemoteFileModel2Interface,
RemoteFileModelDirectoriesOnlyInterface,
AddFolderInterface,
DeleteFileInterface,
RenameFileRmiInterface,
RenameFileInterface,
PasteFileInterface,
IncludeSystemFoldersInterface,
MutableFileFilterInterface {
    private static final boolean CHAIN_EXCEPTIONS = false;
    private static final boolean DELAY_TABLE_MODEL_DELIVERY = false;
    private static final boolean DELAY_PROPERTY_CHANGE_DELIVERY = false;
    private RemoteFileServiceModelRmi _delegate;
    private List _filterValues = new ArrayList();
    private CopyOnWriteArrayList tableModelListeners;
    private CopyOnWriteArrayList propertyChangeListeners;
    private Thread daemon;
    private int watchedEventTypes;
    private Integer watchedEventTypesLock;
    private boolean destroyed;
    private Object listenerToken;
    private CommonLoggerInterface log;

    public RemoteFileServiceModelClientImpl(RemoteFileServiceModelRmi delegate) {
        this._delegate = delegate;
        this.propertyChangeListeners = new CopyOnWriteArrayList();
        this.tableModelListeners = new CopyOnWriteArrayList();
        this.daemon = null;
        this.destroyed = false;
        this.watchedEventTypes = 0;
        this.watchedEventTypesLock = new Integer(0);
        this.listenerToken = new Object();
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.destroyed) {
            Object object = this.listenerToken;
            synchronized (object) {
                this.destroyed = true;
                if (this.tableModelListeners.size() > 0) {
                    block10: {
                        --this.watchedEventTypes;
                        try {
                            this._delegate.setKeepTableModelEvents(false);
                        }
                        catch (RemoteException ex) {
                            if (this.log == null) break block10;
                            this.log.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    this.tableModelListeners.clear();
                }
                if (this.propertyChangeListeners.size() > 0) {
                    block11: {
                        --this.watchedEventTypes;
                        try {
                            this._delegate.setKeepPropertyChangeEvents(false);
                        }
                        catch (RemoteException ex) {
                            if (this.log == null) break block11;
                            this.log.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    this.propertyChangeListeners.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeWatchLevel(int delta) {
        Integer n = this.watchedEventTypesLock;
        synchronized (n) {
            this.watchedEventTypes += delta;
            if (this.watchedEventTypes > 0 && this.daemon == null) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        RemoteFileServiceModelClientImpl.this.listen();
                    }
                };
                this.daemon = new Thread(r, "RFS Remote Event Dispatcher");
                this.daemon.setDaemon(true);
                this.daemon.start();
            }
        }
    }

    private void listen() {
        while (!this.destroyed) {
            if (this.watchedEventTypes == 0) {
                Thread.yield();
                continue;
            }
            try {
                this.deliverEvents(this._delegate.getEvents());
            }
            catch (RemoteException ex) {
                this.destroy();
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    private void deliverEvents(List events) {
        try {
            for (final EventObject evt : events) {
                Runnable r;
                if (evt instanceof TableModelEvent) {
                    r = new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    for (int i = 0; i < RemoteFileServiceModelClientImpl.this.tableModelListeners.size(); ++i) {
                                        ((TableModelListener)RemoteFileServiceModelClientImpl.this.tableModelListeners.get(i)).tableChanged((TableModelEvent)evt);
                                    }
                                }
                                catch (Throwable t) {
                                    if (RemoteFileServiceModelClientImpl.this.log == null) break block3;
                                    RemoteFileServiceModelClientImpl.this.log.debug(t.getMessage(), t);
                                }
                            }
                        }
                    };
                    r.run();
                    continue;
                }
                if (!(evt instanceof PropertyChangeEvent)) continue;
                r = new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                for (int i = 0; i < RemoteFileServiceModelClientImpl.this.propertyChangeListeners.size(); ++i) {
                                    ((PropertyChangeListener)RemoteFileServiceModelClientImpl.this.propertyChangeListeners.get(i)).propertyChange((PropertyChangeEvent)evt);
                                }
                            }
                            catch (Throwable t) {
                                if (RemoteFileServiceModelClientImpl.this.log == null) break block3;
                                RemoteFileServiceModelClientImpl.this.log.debug(t.getMessage(), t);
                            }
                        }
                    }
                };
                r.run();
            }
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        try {
            Object object = this.listenerToken;
            synchronized (object) {
                if (this.destroyed) {
                    return;
                }
                if (this.propertyChangeListeners.add(listener) && this.propertyChangeListeners.size() == 1) {
                    this._delegate.setKeepPropertyChangeEvents(true);
                    this.changeWatchLevel(1);
                }
            }
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        try {
            Object object = this.listenerToken;
            synchronized (object) {
                if (this.destroyed) {
                    return;
                }
                if (this.propertyChangeListeners.remove(listener) && this.propertyChangeListeners.size() == 0) {
                    this.changeWatchLevel(-1);
                    this._delegate.setKeepPropertyChangeEvents(false);
                }
            }
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        try {
            Object object = this.listenerToken;
            synchronized (object) {
                if (this.destroyed) {
                    return;
                }
                if (this.tableModelListeners.add(l) && this.tableModelListeners.size() == 1) {
                    this._delegate.setKeepTableModelEvents(true);
                    this.changeWatchLevel(1);
                }
            }
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        try {
            Object object = this.listenerToken;
            synchronized (object) {
                if (this.destroyed) {
                    return;
                }
                if (this.tableModelListeners.remove(l) && this.tableModelListeners.size() == 0) {
                    this.changeWatchLevel(-1);
                    this._delegate.setKeepTableModelEvents(false);
                }
            }
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    public List getFilterValues() {
        return this._filterValues;
    }

    @Override
    public void setFilterValues(List filterValues) {
        try {
            this._delegate.setFilterValues(filterValues);
            this._filterValues = filterValues;
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isFolderPopulated(RemoteFileMetadataInterface folderNode) {
        try {
            return this._delegate.isFolderPopulated(folderNode);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getLocationForFolderItem(String fileName) {
        try {
            return this._delegate.getLocationForFolderItem(fileName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String[] getFileInfo(String fileName) {
        try {
            return this._delegate.getFileInfo(fileName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String buildFullyQualifiedLocation(String location, String entryFile) {
        try {
            return this._delegate.buildFullyQualifiedLocation(location, entryFile);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getRootLocation() {
        try {
            return this._delegate.getRootLocation();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void loadFileInfo() throws Exception {
        try {
            this._delegate.loadFileInfo();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setLocation(String path) {
        try {
            this._delegate.setLocation(path);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void cancelLoadFileInfo() {
    }

    @Override
    public boolean isUpwardPathRestricted() {
        try {
            return this._delegate.isUpwardPathRestricted();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getBasePath() {
        try {
            return this._delegate.getBasePath();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getServerName() {
        try {
            return this._delegate.getServerName();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public RemoteFileMetadataInterface getNodeAt(int rowIndex) {
        try {
            return this._delegate.getNodeAt(rowIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isTableEditable() {
        try {
            return this._delegate.isTableEditable();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setTableEditable(boolean editable) {
        try {
            this._delegate.setTableEditable(editable);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String[][] parseIntoFoldersAndLocations(String path) {
        try {
            return this._delegate.parseIntoFoldersAndLocations(path);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public int getColumnIndex(String column) {
        try {
            return this._delegate.getColumnIndex(column);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setRefreshNeeded(boolean needsRefresh) {
        try {
            this._delegate.setRefreshNeeded(needsRefresh);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isRefreshNeeded() {
        try {
            return this._delegate.isRefreshNeeded();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void addToPasteBuffer(Object node) {
        try {
            this._delegate.addToPasteBuffer(node);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void clearPasteBuffer() {
        try {
            this._delegate.clearPasteBuffer();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public List getPasteBuffer() {
        try {
            return this._delegate.getPasteBuffer();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setPasteBufferCommandType(int commandType) {
        try {
            this._delegate.setPasetBufferCommandType(commandType);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public int getPasteBufferCommandType() {
        try {
            return this._delegate.getPasteBufferCommandType();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public int getColumnCount() {
        try {
            return this._delegate.getColumnCount();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public int getRowCount() {
        try {
            return this._delegate.getRowCount();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            return this._delegate.isCellEditable(rowIndex, columnIndex);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    public Class getColumnClass(int columnIndex) {
        try {
            return this._delegate.getColumnClass(columnIndex);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this._delegate.getValueAt(rowIndex, columnIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this._delegate.setValueAt(aValue, rowIndex, columnIndex);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            return this._delegate.getColumnName(columnIndex);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getLocation() {
        try {
            return this._delegate.getLocation();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public List getLocations() {
        try {
            return this._delegate.getLocations();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public int getLocationsCurrentPathIndex() {
        try {
            return this._delegate.getLocationsCurrentPathIndex();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isDirectoriesOnly() {
        try {
            return this._delegate.isDirectoriesOnly();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setDirectoriesOnly(boolean directoriesOnly) {
        try {
            this._delegate.setDirectoriesOnly(directoriesOnly);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public RemoteFileMetadataInterface addFolder(String path, String folderName) {
        try {
            return this._delegate.addFolder(path, folderName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isExistingSubFolder(String path, String folderName) {
        try {
            return this._delegate.isExistingSubFolder(path, folderName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void renameFolder(RemoteFileMetadataInterface folderNode, String newFolderName) {
        try {
            this._delegate.renameFolder(folderNode, newFolderName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void deleteItem(RemoteFileMetadataInterface nodeOfItemToDelete) {
        try {
            this._delegate.deleteItem(nodeOfItemToDelete);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isExistingFileItem(String path, String itemName) {
        try {
            return this._delegate.isExistingFileItem(path, itemName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void renameItem(RemoteFileMetadataInterface itemNode, String newItemName) {
        try {
            this._delegate.renameItem(itemNode, newItemName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void renameItem(int rowIndex, String newItemName) {
        try {
            this._delegate.renameItem(rowIndex, newItemName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void moveItem(RemoteFileMetadataInterface itemNode) {
        try {
            this._delegate.moveItem(itemNode);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String[] getFileInfo(String folderLocation, String fileName, String fileType) {
        try {
            return this._delegate.getFileInfo(folderLocation, fileName, fileType);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getValidName(String fileName) {
        try {
            return this._delegate.getValidName(fileName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public String getValidNameStatus(String fileName) {
        try {
            return this._delegate.getValidNameStatus(fileName);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isFileDuplicate(String path, String fileName, String selectedFileType) {
        try {
            return this._delegate.isFileDuplicate(path, fileName, selectedFileType);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public boolean isIncludeSystemFolders() {
        try {
            return this._delegate.isIncludeSystemFolders();
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void setIncludeSystemFolders(boolean include) {
        try {
            this._delegate.setIncludeSystemFolders(include);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    @Override
    public void updateFilteredValues(List newFilterValues) {
        try {
            this._delegate.updateFilteredValues(newFilterValues);
        }
        catch (Throwable t) {
            throw this.processException(t);
        }
    }

    private RuntimeException processException(Throwable t) {
        return new RuntimeException(t.getMessage());
    }
}

