/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.informationservices;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.ISUtility;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.iquery.InformationMapMetaData;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

@SASScope
public class InformationServicesNavigationTypesModel
extends InformationServicesNavigationModel {
    private static final long serialVersionUID = 7368210486626770127L;
    private boolean showOLAPMaps;
    private boolean showRelationalMaps;
    private String basePath;
    private List foldersToHide;
    private CommonLoggerInterface log = null;
    private UserContextInterface userContext;

    public InformationServicesNavigationTypesModel(RepositoryInterface repository, boolean showOLAPMaps, boolean showRelationMaps) {
        super(repository);
        this.showOLAPMaps = showOLAPMaps;
        this.showRelationalMaps = showRelationMaps;
        this.basePath = "";
        try {
            this.log = this.setupLogger(repository.getUserContext().getSessionContext());
        }
        catch (Exception e) {
            this.log = this.setupLogger(null);
        }
    }

    public InformationServicesNavigationTypesModel(UserContextInterface user, boolean showOLAPMaps, boolean showRelationMaps) {
        super(user);
        this.showOLAPMaps = showOLAPMaps;
        this.showRelationalMaps = showRelationMaps;
        this.userContext = user;
        this.basePath = "";
        try {
            this.log = this.setupLogger(user.getSessionContext());
        }
        catch (Exception e) {
            this.log = this.setupLogger(null);
        }
    }

    public InformationServicesNavigationTypesModel(UserContextInterface user, List repositories, boolean showOLAPMaps, boolean showRelationMaps) {
        super(user);
        this.reposList = repositories;
        if (this.reposList.size() == 1) {
            this.repository = (RepositoryInterface)this.reposList.get(0);
        }
        this.showOLAPMaps = showOLAPMaps;
        this.showRelationalMaps = showRelationMaps;
        this.userContext = user;
        this.basePath = "";
        try {
            this.log = this.setupLogger(user.getSessionContext());
        }
        catch (Exception e) {
            this.log = this.setupLogger(null);
        }
    }

    private CommonLoggerInterface setupLogger(SessionContextInterface sci) {
        if (null != this.log) {
            return this.log;
        }
        this.log = null == sci ? LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory()) : LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory(sci));
        return this.log;
    }

    @Override
    protected boolean filterData(BrowseMetadataInterface item) {
        boolean value;
        block21: {
            block20: {
                value = true;
                if (this.filterValues != null && !item.isAFolder()) {
                    value = false;
                    Iterator iter = this.filterValues.iterator();
                    while (iter.hasNext() && !value) {
                        String element = (String)iter.next();
                        if (element != null) {
                            String type;
                            if (element.equals("*")) {
                                value = true;
                                continue;
                            }
                            if (item.getNativeType().equals("Transformation") && element.equalsIgnoreCase(type = (String)item.get("TransformRole"))) {
                                value = true;
                            }
                            if (!value && element.equalsIgnoreCase(type = item.getSmartType())) {
                                value = true;
                            }
                            if (value || !element.equalsIgnoreCase(type = item.getNativeType())) continue;
                            value = true;
                            continue;
                        }
                        value = false;
                    }
                }
                String type = item.getSmartType();
                if (value && ("InformationMap".equals(type) || "InformationMap.OLAP".equals(type) || "InformationMap.Relational".equals(type))) {
                    if (!this.showOLAPMaps && !this.showRelationalMaps) {
                        value = false;
                    } else if (!this.showOLAPMaps || !this.showRelationalMaps) {
                        try {
                            InformationMapMetaData metaData = IQUeryUtil.getInfoMapMetaData((String)item.getISEntityKey(), (long)item.getModifyDate(), (ServerInterface)this.server);
                            if (metaData == null || !metaData.isRelational() && !metaData.isOLAP() || metaData.isRelational() && this.showOLAPMaps || metaData.isOLAP() && this.showRelationalMaps) {
                                value = false;
                            }
                        }
                        catch (Exception se) {
                            if (!this.log.isErrorEnabled()) break block20;
                            this.log.error("Exception", (Throwable)se);
                        }
                    }
                }
            }
            if (value && this.foldersToHide != null && !this.foldersToHide.isEmpty()) {
                try {
                    String pathString;
                    PathUrl pathUrl;
                    if (this.userContext == null) {
                        this.userContext = this.repository.getUserContext();
                    }
                    if ((pathUrl = ISUtility.getPathFromEntityKey((UserContextInterface)this.userContext, (String)item.getISEntityKey())) != null && this.foldersToHide.contains(pathString = pathUrl.toString())) {
                        value = false;
                    }
                }
                catch (RemoteException e) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("Exception", (Throwable)e);
                    }
                }
                catch (ServiceException e) {
                    if (!this.log.isErrorEnabled()) break block21;
                    this.log.error("Exception", (Throwable)e);
                }
            }
        }
        return value;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String path) {
        this.basePath = path;
    }

    @Override
    public boolean isUpwardPathRestricted() {
        if (!super.isUpwardPathRestricted()) {
            if (this.basePath != null && this.basePath.trim().length() > 0) {
                String path = this.currentPath;
                PathUrl pathUrl = new PathUrl(path);
                if (pathUrl.getType() != null) {
                    path = path.substring(0, path.lastIndexOf(40));
                }
                return this.basePath.equals(path);
            }
            return false;
        }
        return true;
    }

    public void setFoldersToHide(List folders) {
        this.foldersToHide = folders;
    }

    public void setShowOLAPMaps(boolean showOLAPMaps) {
        if (this.showOLAPMaps != showOLAPMaps) {
            this.showOLAPMaps = showOLAPMaps;
            this.setRefreshNeeded(true);
        }
    }

    public void setShowRelationalMaps(boolean showRelationalMaps) {
        if (this.showRelationalMaps != showRelationalMaps) {
            this.showRelationalMaps = showRelationalMaps;
            this.setRefreshNeeded(true);
        }
    }
}

