/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.informationservices;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.AddFolderInterface;
import com.sas.swing.models.remotefileselector2.DeleteFileInterface;
import com.sas.swing.models.remotefileselector2.PasteFileInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.RenameFileInterface;
import com.sas.swing.models.remotefileselector2.informationservices.BaseInformationServicesModel;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesAdapterSupport;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadata;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadataInterface;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
public class InformationServicesNavigationModel
extends BaseInformationServicesModel
implements RemoteFileModel2Interface,
AddFolderInterface,
DeleteFileInterface,
RenameFileInterface,
PasteFileInterface {
    private boolean showSASFoldersOnly;

    public InformationServicesNavigationModel(RepositoryInterface repository) {
        super(repository);
        this.currentPath = "";
        this.modelNeedsRefresh = true;
        this.setSASFoldersOnlyVisible(false);
    }

    public InformationServicesNavigationModel(UserContextInterface user) {
        this(user, false);
        this.setSASFoldersOnlyVisible(false);
    }

    @SASScope
    public InformationServicesNavigationModel(UserContextInterface user, boolean navigateUsingServer) {
        super(user, navigateUsingServer);
        this.currentPath = "";
        this.modelNeedsRefresh = true;
        if (navigateUsingServer) {
            this.setSASFoldersOnlyVisible(true);
        }
    }

    @SASScope
    public InformationServicesNavigationModel(ServerInterface server) {
        this(server, null);
    }

    @SASScope
    public InformationServicesNavigationModel(ServerInterface server, RepositoryInterface repositoryUsedForFiltering) {
        super(server);
        this.currentPath = "";
        this.modelNeedsRefresh = true;
        this.setSASFoldersOnlyVisible(true);
        this.setRepositoryForServerFilter(repositoryUsedForFiltering);
    }

    @Override
    public void loadFileInfo() {
        this.log.debug("Loading files for " + this.currentPath);
        this.navigatingRepository = null;
        this.infoList = new ArrayList();
        if (this.rootFolderLocation == null && this.server != null) {
            this.loadRootFolderLocation();
        }
        if (this.currentPath.trim().equals("") && this.rootFolderLocation != null) {
            this.currentPath = this.rootFolderLocation;
        }
        if (this.currentPath.trim().equals("") || this.currentPath.equalsIgnoreCase(this.rootFolderLocation)) {
            if (this.server != null) {
                this.loadRootFolders();
                this.loadUserFolder();
            } else if (this.reposList.size() > 1) {
                this.loadRepositoryInfo();
            } else {
                this.loadRootFolderInfo();
                if (this.currentPath.trim().equals("")) {
                    for (int i = 0; i < this.infoList.size(); ++i) {
                        InformationServicesFileMetadataInterface fileMetadata = (InformationServicesFileMetadataInterface)this.infoList.get(i);
                        if (fileMetadata == null || fileMetadata.getLocation() == null) continue;
                        String[][] filesAndLocations = this.parseIntoFoldersAndLocations(fileMetadata.getLocation());
                        this.currentPath = filesAndLocations[filesAndLocations.length - 1][0];
                        break;
                    }
                }
            }
        } else if (this.server != null) {
            this.loadMyFolderLocation();
            this.loadFolders();
        } else if (this.reposList.size() > 1) {
            PathUrl pathUrl = new PathUrl(this.currentPath);
            this.repository = this.getCurrentRepository(pathUrl);
            if (pathUrl.getRootTree() == null || pathUrl.getRootTree().equals("")) {
                this.loadRootFolderInfo();
            } else {
                this.loadFolderInfo();
            }
        } else {
            PathUrl pathUrl = new PathUrl(this.currentPath);
            if (pathUrl.getRootTree() == null || pathUrl.getRootTree().equals("")) {
                this.loadRootFolderInfo();
            } else {
                this.loadFolderInfo();
            }
        }
        this.fireTableDataChanged();
        this.modelNeedsRefresh = false;
    }

    @SASScope
    public void setSASFoldersOnlyVisible(boolean sasFoldersOnly) {
        this.showSASFoldersOnly = sasFoldersOnly;
    }

    @SASScope
    public boolean isSASFoldersOnlyVisible() {
        return this.showSASFoldersOnly;
    }

    private FolderInterface getHomeFolder() {
        try {
            Filter rval = new Filter();
            rval.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
            this.userHomeFolder = this.server.getHomeFolder(null, UserFolderType.MYFOLDER, rval);
            if (this.userHomeFolder != null) {
                this.myFolderLocationUrl = this.userHomeFolder.getPathUrl();
                this.myFolderNode.setLabel(this.userHomeFolder.getName());
            }
        }
        catch (ServiceException e) {
            return null;
        }
        catch (RemoteException e) {
            return null;
        }
        return this.userHomeFolder;
    }

    private void loadRootFolderLocation() {
        if (this.rootFolder == null) {
            try {
                this.rootFolder = this.server.getRootFolder();
                this.rootFolderLocation = this.rootFolder.getPathUrl().toString();
            }
            catch (ServiceException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                this.rootFolderLocation = "";
            }
            catch (RemoteException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                this.rootFolderLocation = "";
            }
        }
    }

    private void loadUserFolder() {
        FolderInterface homeFolder = this.getHomeFolder();
        if (homeFolder != null) {
            RepositoryInterface myFolderRepository = null;
            RepositoryInterface repositoryServerFilter = this.getRepositoryForServerFilter();
            if (repositoryServerFilter != null) {
                try {
                    myFolderRepository = homeFolder.getRepository();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            if (repositoryServerFilter == null || repositoryServerFilter != null && myFolderRepository == repositoryServerFilter) {
                Filter rval = new Filter();
                rval.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n    <Timestamps/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
                BrowseMetadataInterface browseMyFolder = this.getBrowseFolder(homeFolder, (FilterInterface)rval);
                InformationServicesFileMetadata node = new InformationServicesFileMetadata(browseMyFolder);
                if (this.myFolderLocationUrl != null) {
                    node.setLocation(this.myFolderLocationUrl.toString());
                }
                node.setType("My Folder");
                this.infoList.add(node);
            }
        }
    }

    private void loadFolders() {
        if (this.isOpenPackageOn()) {
            MetadataInterface startFolder = InformationServicesAdapterSupport.getMetadataObjectByPath(this.getUserContext(), this.currentPath);
            if (startFolder != null) {
                if (startFolder instanceof PackageInterface) {
                    try {
                        Object resultPackageObject = ((PackageInterface)startFolder).newServiceObject();
                        if (resultPackageObject instanceof ResultPackageInterface) {
                            EntryInterface[] packageEntries = ((ResultPackageInterface)resultPackageObject).getEntries();
                            List tempInfoList = this.createMetadataPackageItems(packageEntries);
                            this.infoList.addAll(tempInfoList);
                        }
                    }
                    catch (ServiceException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                } else if (startFolder instanceof FolderInterface) {
                    this.loadFolderMetadata((FolderInterface)startFolder);
                }
            }
        } else {
            this.loadFolderMetadata(null);
        }
    }

    private void loadFolderMetadata(FolderInterface folderToGetMetadataFor) {
        if ("".equals(this.currentPath)) {
            this.loadRootFolders();
        } else {
            FolderInterface currentFolder = null;
            currentFolder = folderToGetMetadataFor == null ? this.getCurrentFolder(this.currentPath.trim()) : folderToGetMetadataFor;
            if (currentFolder != null) {
                Filter rval = new Filter();
                rval.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n    <Timestamps/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
                List returnList = null;
                List folderItems = null;
                this.navigatingRepository = RemoteFileModelsUtil.getRepositoryForPath(this.currentPath, this.webDavReposList, this.webDavReposNames);
                folderItems = this.navigatingRepository != null ? this.getFolderItems(currentFolder, (FilterInterface)rval, this.navigatingRepository) : this.getFolderItems(currentFolder, (FilterInterface)rval, null);
                returnList = this.createMetadataItems(folderItems);
                this.infoList.addAll(returnList);
            }
        }
    }

    private void loadMyFolderLocation() {
        FolderInterface homeFolder = this.getHomeFolder();
        if (this.currentPath.equals("MY_FOLDER")) {
            this.currentPath = homeFolder != null & this.myFolderLocationUrl != null ? this.myFolderLocationUrl.toString() : "";
        }
    }

    private void loadFolderInfo() {
        if (this.isOpenPackageOn()) {
            Object startFolder = this.getCurrentObject(this.currentPath);
            if (startFolder != null) {
                if (startFolder instanceof PackageInterface) {
                    try {
                        Object resultPackageObject = ((PackageInterface)startFolder).newServiceObject();
                        if (resultPackageObject instanceof ResultPackageInterface) {
                            EntryInterface[] packageEntries = ((ResultPackageInterface)resultPackageObject).getEntries();
                            List tempInfoList = this.createMetadataPackageItems(packageEntries);
                            this.infoList.addAll(tempInfoList);
                        }
                    }
                    catch (ServiceException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (RemoteException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                } else if (startFolder instanceof FolderInterface) {
                    List tempInfoList = this.getFolderInterfaceFiles((FolderInterface)startFolder);
                    this.infoList.addAll(tempInfoList);
                }
            }
        } else {
            FolderInterface startFolder = this.getCurrentFolder(this.currentPath);
            if (startFolder != null) {
                List tempInfoList = this.getFolderInterfaceFiles(startFolder);
                this.infoList.addAll(tempInfoList);
            }
        }
    }

    protected Object getCurrentObject(String path) {
        MetadataInterface folderObject = null;
        try {
            PathUrl newPathUrl = new PathUrl(path);
            folderObject = this.repository.getObjectByPath(newPathUrl);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return folderObject;
    }

    private void loadRootFolders() {
        try {
            if (this.rootFolder == null || this.rootFolderLocation == null) {
                this.loadRootFolderLocation();
            }
            List serverRootFolderItems = null;
            serverRootFolderItems = this.isSASFoldersOnlyVisible() && this.rootFolder instanceof RootFolderInterface ? (this.getRepositoryForServerFilter() != null ? ((RootFolderInterface)this.rootFolder).getSASFolders(this.getRepositoryForServerFilter()) : ((RootFolderInterface)this.rootFolder).getSASFolders()) : this.rootFolder.getChildren();
            ArrayList<InformationServicesFileMetadata> rootBrowseItems = new ArrayList<InformationServicesFileMetadata>(serverRootFolderItems.size());
            for (FolderInterface folder : serverRootFolderItems) {
                String folderType = folder.getFolderType();
                if (!this.isIncludeSystemFolders() && folderType != null && folderType.equalsIgnoreCase("System")) continue;
                Filter rval = new Filter();
                rval.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
                BrowseMetadataInterface browseRootFolder = this.getBrowseFolder(folder, (FilterInterface)rval);
                InformationServicesFileMetadata node = new InformationServicesFileMetadata(browseRootFolder);
                node.setLocation(folder.getPathUrl().toString());
                rootBrowseItems.add(node);
            }
            this.infoList.addAll(rootBrowseItems);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadRootFolderInfo() {
        List<BrowseMetadataInterface> tempInfoList = new ArrayList();
        try {
            List tempList = this.repository.getRootFolders();
            for (FolderInterface folder : tempList) {
                String key = folder.getEntityKey();
                Filter rval = new Filter();
                rval.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
                tempInfoList.add(this.repository.browseFetch(key, (FilterInterface)rval));
            }
            tempList = null;
            tempInfoList = this.createMetadataItems(tempInfoList);
            this.infoList.addAll(tempInfoList);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        tempInfoList = null;
    }

    private void loadRepositoryInfo() {
        List tempInfoList = this.getRepositoryList();
        tempInfoList = this.createRepositoryNodeMetadataItems(tempInfoList);
        this.infoList.addAll(tempInfoList);
    }

    public List getFolderInterfaceFiles(FolderInterface startFolder) {
        List returnList = null;
        try {
            String folderKey = startFolder.getEntityKey();
            Filter rval = new Filter();
            rval.setOMRTemplate("<Templates>\n  <Transformation>\n    <Keywords/>\n    <ResponsibleParties/>\n    <Timestamps/>\n  </Transformation>\n  <ClassifierMap>\n    <Keywords/>\n    <ResponsibleParties/>\n  </ClassifierMap>\n  <ResponsibleParty>\n    <Persons/>\n  </ResponsibleParty>\n</Templates>");
            returnList = this.repository.browseFolder(folderKey, (FilterInterface)rval);
        }
        catch (IllegalStateException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return this.createMetadataItems(returnList);
    }

    @SASScope
    public List getFolderItems(FolderInterface folder, FilterInterface filter, RepositoryInterface repositoryWithItems) {
        try {
            if (repositoryWithItems != null) {
                String folderEntityKey = folder.getEntityKey();
                return repositoryWithItems.browseFolder(folderEntityKey, filter);
            }
            String folderEntityKey = folder.getEntityKey();
            BrowseMetadataInterface browseFolder = this.server.browseFolder(folderEntityKey, filter);
            List folderSubfolders = browseFolder.getSubfolders();
            List folderMembers = browseFolder.getMembers();
            int subfolderSize = 0;
            if (folderSubfolders != null) {
                subfolderSize = folderSubfolders.size();
            }
            int numOfMembers = 0;
            if (folderMembers != null) {
                numOfMembers = folderMembers.size();
            }
            ArrayList<BrowseMetadataInterface> folderItems = new ArrayList<BrowseMetadataInterface>(subfolderSize + numOfMembers);
            if (subfolderSize > 0) {
                if (this.isIncludeSystemFolders()) {
                    folderItems.addAll(folderSubfolders);
                } else {
                    List subFolders = folder.getSubfolders();
                    for (FolderInterface subFolder : subFolders) {
                        BrowseMetadataInterface browseSubFolder;
                        String subfolderType = subFolder.getFolderType();
                        if (subfolderType != null && subfolderType.equalsIgnoreCase("System") || (browseSubFolder = this.server.browseFolder(subFolder.getEntityKey(), filter)) == null) continue;
                        folderItems.add(browseSubFolder);
                    }
                }
            }
            if (numOfMembers > 0) {
                folderItems.addAll(folderMembers);
            }
            return folderItems;
        }
        catch (IllegalStateException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private BrowseMetadataInterface getBrowseFolder(FolderInterface folder, FilterInterface filter) {
        try {
            String folderEntityKey = folder.getEntityKey();
            return this.server.browseFolder(folderEntityKey, filter);
        }
        catch (IllegalStateException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    @SASScope
    public RemoteFileMetadataInterface addFolder(String location, String newFolderName) {
        InformationServicesFileMetadata item = null;
        try {
            FolderInterface currentFolder = this.getCurrentFolder(location);
            FolderInterface returnedFolderInfo = this.addFolder(currentFolder, newFolderName);
            if (returnedFolderInfo == null) {
                return null;
            }
            currentFolder.update();
            String key = returnedFolderInfo.getEntityKey();
            if (this.server != null) {
                this.navigatingRepository = RemoteFileModelsUtil.getRepositoryForPath(location, this.webDavReposList, this.webDavReposNames);
                item = this.navigatingRepository != null ? new InformationServicesFileMetadata(this.navigatingRepository.browseFetch(key, null)) : new InformationServicesFileMetadata(this.server.browseFetch(key, null));
            } else {
                item = new InformationServicesFileMetadata(this.repository.browseFetch(key, null));
            }
            item.setLocation(returnedFolderInfo.getPathUrl().toString());
            this.infoList.add(item);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        int rowCount = this.getRowCount();
        this.fireTableRowsInserted(rowCount - 1, rowCount - 1);
        return item;
    }

    @SASScope
    public FolderInterface addFolder(FolderInterface subFolderForNewFolder, String newFolderName) {
        FolderInterface returnFolderInterface = null;
        try {
            if (!subFolderForNewFolder.isAuthorized("WriteMemberMetadata")) {
                this.spcs.firePropertyChange("addFolderFailedPermission", null, newFolderName);
                return returnFolderInterface;
            }
            returnFolderInterface = subFolderForNewFolder.makeSubfolder(newFolderName);
            subFolderForNewFolder.update();
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            try {
                subFolderForNewFolder.getRepository().getServer().clearPendingChanges(false);
                this.spcs.firePropertyChange("modelUpdateFailed", null, e.getCause().getMessage());
                return null;
            }
            catch (ServiceException se) {
                this.log.error(se.getMessage(), (Throwable)se);
                return null;
            }
            catch (RemoteException re) {
                this.log.error(re.getMessage(), (Throwable)re);
                return null;
            }
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return returnFolderInterface;
    }

    @Override
    @SASScope
    public boolean isExistingSubFolder(String parentLocation, String newFolderName) {
        FolderInterface subFolder = null;
        try {
            FolderInterface parentFolder;
            if (RemoteFileModelsUtil.isValidURL(parentLocation) && (parentFolder = this.getCurrentFolder(parentLocation)) != null) {
                subFolder = parentFolder.getSubfolder(newFolderName);
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return subFolder != null;
    }

    @Override
    @SASScope
    public boolean isExistingFileItem(String parentLocation, String fileName) {
        return false;
    }

    @Override
    @SASScope
    public void deleteItem(RemoteFileMetadataInterface node) {
        try {
            PathUrl nodePathUrl = new PathUrl(node.getLocation());
            MetadataInterface itemToDelete = null;
            itemToDelete = this.server != null ? (node instanceof InformationServicesFileMetadata ? this.server.fetch(((InformationServicesFileMetadata)node).getISEntityKey()) : this.server.getObjectByPath(nodePathUrl)) : this.repository.getObjectByPath(nodePathUrl);
            if (itemToDelete != null) {
                itemToDelete.delete();
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @SASScope
    public void renameFolder(RemoteFileMetadataInterface folderNode, String newFolderName) {
        this.renameItem(folderNode, newFolderName);
    }

    @Override
    @SASScope
    public void renameItem(RemoteFileMetadataInterface node, String newName) {
        try {
            PathUrl nodePathUrl = new PathUrl(node.getLocation());
            MetadataInterface itemToRename = null;
            itemToRename = this.server != null ? (this.navigatingRepository != null ? this.navigatingRepository.getObjectByPath(nodePathUrl) : this.server.getObjectByPath(nodePathUrl)) : this.repository.getObjectByPath(nodePathUrl);
            if (itemToRename != null) {
                itemToRename.setName(newName);
                itemToRename.update();
                if (node instanceof InformationServicesFileMetadata) {
                    ((InformationServicesFileMetadata)node).setLocation(itemToRename.getPathUrl().toString());
                }
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.fireTableDataChanged();
    }

    @Override
    @SASScope
    public void moveItem(RemoteFileMetadataInterface node) {
        try {
            String newLocation = this.getLocation();
            PathUrl nodePathUrl = new PathUrl(node.getLocation());
            MetadataInterface itemToMove = null;
            itemToMove = this.server != null ? this.server.getObjectByPath(nodePathUrl) : this.repository.getObjectByPath(nodePathUrl);
            String newLocationWithName = this.buildNewSBipUrl(newLocation, node.getName(), nodePathUrl.getType());
            if (itemToMove != null) {
                FolderInterface newFolder = this.getCurrentFolder(newLocation);
                if (node.isFolder()) {
                    this.addFolder(newFolder, node.getName());
                    if (itemToMove instanceof FolderInterface) {
                        FolderInterface folderToMove = (FolderInterface)itemToMove;
                        List folderItems = folderToMove.getItems();
                        for (int i = 0; i < folderItems.size(); ++i) {
                            newFolder.addItem((MetadataInterface)folderItems.get(i));
                        }
                        itemToMove.delete();
                    }
                    ((InformationServicesFileMetadata)node).setLocation(newLocationWithName);
                } else {
                    itemToMove.moveTo(newFolder);
                    itemToMove.update();
                    newFolder.update();
                    ((InformationServicesFileMetadata)node).setLocation(newLocationWithName);
                }
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @SASScope
    public boolean isFolderPopulated(RemoteFileMetadataInterface node) {
        if (node instanceof InformationServicesFileMetadataInterface && ((InformationServicesFileMetadataInterface)node).isRepository()) {
            return true;
        }
        try {
            FolderInterface folderNode = this.getCurrentFolder(node.getLocation());
            if (folderNode.getTotalNumberOfItems() > 0) {
                return true;
            }
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @SASScope
    public String getFileType(String fileName) {
        if (fileName.indexOf("/") > -1 || fileName.indexOf("\\") > -1) {
            return "FOLDER";
        }
        return "FILE";
    }

    @Override
    @SASScope
    public String buildFullyQualifiedLocation(String location, String entryFile) {
        return this.buildNewSBipUrl(location, entryFile, null);
    }

    @Override
    @SASScope
    public String[] getFileInfo(String fileName) {
        return InformationServicesAdapterSupport.getFileInfo(this, fileName);
    }

    @Override
    @SASScope
    public boolean isFileDuplicate(String path, String fileName, String fileType) {
        boolean dup = false;
        try {
            if (fileName != null && fileType != null) {
                FolderInterface folderToCheck = this.getCurrentFolder(path);
                dup = folderToCheck.hasDuplicate(fileName, fileType);
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return dup;
    }

    @Override
    @SASScope
    public String[] getFileInfo(String folderLocation, String fileName, String fileType) {
        String[] fileInfo = new String[3];
        if (fileName == null || "".equals(fileName.trim()) || folderLocation == null) {
            return fileInfo;
        }
        try {
            FolderInterface cf = this.getCurrentFolder(folderLocation);
            MetadataInterface item = cf.getItemByType(fileName, fileType);
            if (item != null) {
                fileInfo[0] = "FILE";
                PathUrl locationURL = item.getPathUrl();
                if (locationURL != null) {
                    fileInfo[1] = locationURL.toString();
                    fileInfo[2] = !RemoteFileVisualsUtil.hasWritePermissionsOnFile(this, fileInfo[1]) ? "WRITE_PERMISSIONS_DENIED" : item.getType();
                }
            } else {
                if (fileType != null && (fileType.equals("InformationMap.OLAP") || fileType.equals("InformationMap.Relational"))) {
                    fileType = "InformationMap";
                }
                fileInfo[1] = this.buildNewSBipUrl(folderLocation, fileName, fileType);
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return fileInfo;
    }
}

