/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.informationservices;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadataInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

@SASScope(value="ALL")
public class InformationServicesFileMetadata
implements InformationServicesFileMetadataInterface,
Serializable {
    private Object item;
    private String path;
    private String itemName;
    private String specialType;
    private static final String KEY_TIMESTAMPS = "Timestamps";
    private static final String KEY_DATE_AND_TIME = "DateandTime";
    private static final String KEY_MODIFIED_DATE = "Modified Date";
    private static final String KEY_CREATED_DATE = "Created Date";
    private transient CommonLoggerInterface log;
    private boolean openPackage;

    @SASScope
    public InformationServicesFileMetadata() {
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
    }

    public InformationServicesFileMetadata(BrowseMetadataInterface item) {
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
        this.item = item;
    }

    @SASScope
    public InformationServicesFileMetadata(BrowseMetadataInterface item, boolean drillIntoPackage) {
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        this.item = item;
        this.openPackage = drillIntoPackage;
    }

    public InformationServicesFileMetadata(EntryInterface item) {
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        this.item = item;
    }

    public InformationServicesFileMetadata(RepositoryInterface reposItem) {
        this.item = reposItem;
    }

    @Override
    @SASScope
    public boolean isRepository() {
        return this.item instanceof RepositoryInterface;
    }

    @Override
    public String getName() {
        if (this.itemName != null) {
            return this.itemName;
        }
        if (this.item instanceof BrowseMetadataInterface) {
            return ((BrowseMetadataInterface)this.item).getName();
        }
        if (this.item instanceof RepositoryInterface) {
            try {
                return ((RepositoryInterface)this.item).getISName();
            }
            catch (RemoteException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        } else if (this.item instanceof EntryInterface) {
            return this.getPackageEntryName((EntryInterface)this.item);
        }
        return "";
    }

    private String getPackageEntryName(EntryInterface eItem) {
        return RemoteFileModelsUtil.getPackageName(eItem);
    }

    @Override
    @SASScope
    public void setName(String name) {
        this.itemName = name;
    }

    @Override
    @SASScope
    public String getType() {
        if (this.specialType != null) {
            return this.specialType;
        }
        if (this.item instanceof BrowseMetadataInterface) {
            return (String)((BrowseMetadataInterface)this.item).get("PublicType");
        }
        return "";
    }

    @SASScope
    public void setType(String type) {
        this.specialType = type;
    }

    @Override
    public boolean isFolder() {
        if (this.openPackage && this.getSmartType() != null && this.getSmartType().equalsIgnoreCase("Package")) {
            if (this.item instanceof BrowseMetadataInterface && !"binarypackage".equalsIgnoreCase(((BrowseMetadataInterface)this.item).getNativeType())) {
                return true;
            }
        } else {
            if (this.item instanceof BrowseMetadataInterface) {
                return ((BrowseMetadataInterface)this.item).isAFolder();
            }
            if (this.item instanceof RepositoryInterface) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLocation() {
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    protected void setLocation(String path) {
        this.path = path;
    }

    public String getOwner() {
        List rps;
        String owner = "";
        if (this.item instanceof BrowseMetadataInterface && !((BrowseMetadataInterface)this.item).isAFolder() && (rps = (List)((BrowseMetadataInterface)this.item).get("ResponsibleParties")) != null) {
            for (BrowseMetadataInterface rpBmi : rps) {
                List ownerList;
                String role = (String)rpBmi.get("Role");
                if (!"Owner".equalsIgnoreCase(role) || (ownerList = (List)rpBmi.get("Persons")) == null) continue;
                for (BrowseMetadataInterface ownBmi : ownerList) {
                    owner = ownBmi.getName();
                }
            }
        }
        return owner;
    }

    public Date getModifiedDate() {
        if (this.item instanceof BrowseMetadataInterface) {
            return new Date(this.determineRawDate(KEY_MODIFIED_DATE));
        }
        return null;
    }

    public Date getCreatedDate() {
        if (this.item instanceof RepositoryInterface) {
            return null;
        }
        return new Date(this.determineRawDate(KEY_CREATED_DATE));
    }

    private long determineRawDate(String timeDesired) {
        long rval;
        block5: {
            rval = 0L;
            try {
                List timestamps = (List)((BrowseMetadataInterface)this.item).get(KEY_TIMESTAMPS);
                if (timestamps == null) break block5;
                for (BrowseMetadataInterface candidate : timestamps) {
                    if (candidate == null || !candidate.getName().equals(timeDesired)) continue;
                    String dateAsDoubleStr = (String)candidate.get(KEY_DATE_AND_TIME);
                    rval = new Double(dateAsDoubleStr).longValue();
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (rval <= 0L) {
            long l = rval = timeDesired.equals(KEY_MODIFIED_DATE) ? ((BrowseMetadataInterface)this.item).getModifyDate() : ((BrowseMetadataInterface)this.item).getCreateDate();
            if (rval <= 0L) {
                rval = System.currentTimeMillis();
            }
        }
        return rval;
    }

    public List getKeywords() {
        if (this.item instanceof BrowseMetadataInterface) {
            return ((BrowseMetadataInterface)this.item).getKeywords();
        }
        return null;
    }

    public String getDescription() {
        if (this.item instanceof BrowseMetadataInterface) {
            return ((BrowseMetadataInterface)this.item).getDescription();
        }
        if (this.item instanceof RepositoryInterface) {
            return "";
        }
        if (this.item instanceof EntryInterface) {
            try {
                return ((EntryInterface)this.item).getDescription();
            }
            catch (IllegalStateException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return "";
            }
            catch (RemoteException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return "";
            }
        }
        return "";
    }

    public String getISEntityKey() {
        if (this.item instanceof BrowseMetadataInterface) {
            return ((BrowseMetadataInterface)this.item).getISEntityKey();
        }
        return "";
    }

    public String getSmartType() {
        if (this.item instanceof BrowseMetadataInterface) {
            return ((BrowseMetadataInterface)this.item).getSmartType();
        }
        return null;
    }
}

