/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.informationservices;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.informationservices.BaseInformationServicesModel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileVisualsUtil;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class InformationServicesAdapterSupport {
    public static final String RB_KEY = "RemoteFileSelector.";
    private static final String SBIP = "SBIP://";
    private static CommonLoggerInterface _log = null;

    public static boolean isPathSameAsRoot(BaseInformationServicesModel model, String path) {
        if (path == null || path.equals("/") || path.equals("") || path.equals(model.getRepositoryRootLocation())) {
            return true;
        }
        if (!RemoteFileModelsUtil.isOneTokenPath(path, "/")) {
            return false;
        }
        return InformationServicesAdapterSupport.isValidRepository(model, InformationServicesAdapterSupport.extractFirstTokenFromPath(model, path));
    }

    public static String extractFirstTokenFromPath(BaseInformationServicesModel model, String path) {
        if (path == null) {
            return null;
        }
        String folderLocation = RemoteFileModelsUtil.removeStartingEndingPathDelimiters(path, "/");
        int endIndex = folderLocation.indexOf("/");
        if (endIndex > -1) {
            return folderLocation.substring(0, endIndex);
        }
        return folderLocation;
    }

    public static boolean isValidRepository(BaseInformationServicesModel model, String repositoryName) {
        try {
            boolean isNotValid = true;
            List listOfRepositories = model.getRepositoryList();
            if (listOfRepositories == null) {
                if (model.getServer() == null) {
                    return false;
                }
                try {
                    List repositoryNames = model.getServer().getRepositoryNames();
                    if (repositoryNames == null) {
                        return false;
                    }
                    int num = repositoryNames.size();
                    for (int i = 0; i < num; ++i) {
                        String name = (String)repositoryNames.get(i);
                        if (name == null || !name.equals(repositoryName)) continue;
                        return true;
                    }
                }
                catch (ServiceException repositoryNames) {
                    // empty catch block
                }
                return false;
            }
            int numOfRepositories = listOfRepositories.size();
            for (int i = 0; isNotValid && i < numOfRepositories; ++i) {
                RepositoryInterface repositoryToCheck = (RepositoryInterface)listOfRepositories.get(i);
                if (!repositoryToCheck.getISName().equals(repositoryName)) continue;
                isNotValid = false;
                return true;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static PathUrl getPathUrlFromAbsolutePath(UserContextInterface userContext, ServerInterface server, String path) {
        PathUrl pathUrl = null;
        try {
            pathUrl = InformationServicesAdapterSupport.getPathUrlFromAbsolutePath_orig(userContext, server, path);
        }
        catch (RemoteException e) {
            InformationServicesAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            InformationServicesAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
        }
        return pathUrl;
    }

    private static PathUrl getPathUrlFromAbsolutePath_orig(UserContextInterface userContext, ServerInterface server, String path) throws ServiceException, RemoteException, IllegalArgumentException {
        PathUrl pathUrl;
        block5: {
            boolean repositoryMode;
            if (path == null) {
                return null;
            }
            boolean bl = repositoryMode = server == null;
            if (server == null) {
                if (userContext == null) {
                    return new PathUrl(path);
                }
                server = userContext.getAuthServer();
            }
            pathUrl = null;
            try {
                pathUrl = repositoryMode ? new PathUrl(path) : PathUrl.newPathUrlFromExistingUrl((ServerInterface)server, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path);
                if (!InformationServicesAdapterSupport.isTypeSyntaxPresent(path)) break block5;
                pathUrl.setRootTree(path);
                pathUrl.setType(null);
            }
        }
        return pathUrl;
    }

    private static boolean isTypeSyntaxPresent(String path) {
        int i = path.indexOf(40);
        return i != -1 && path.indexOf(41, i) != -1;
    }

    public static String buildNewSBipUrl(BaseInformationServicesModel model, String pathUrlString, String name, String itemType) {
        pathUrlString = RemoteFileModelsUtil.removeEndingPathDelimiter(pathUrlString, "/");
        String repositoryRootLocation = RemoteFileModelsUtil.removeEndingPathDelimiter(model.getRepositoryRootLocation(), "/");
        String currentPath = model.getLocation();
        if (pathUrlString == null && name == null) {
            return currentPath;
        }
        if (pathUrlString == null) {
            return name;
        }
        if (pathUrlString.equals(repositoryRootLocation) || pathUrlString.equals("")) {
            List reposList = model.getRepositoryList();
            if (pathUrlString.equals("") && reposList != null && reposList.size() == 1) {
                pathUrlString = repositoryRootLocation;
            } else if (pathUrlString.equals("") || pathUrlString.equals(repositoryRootLocation)) {
                String rootAndNoType = repositoryRootLocation.substring(0, repositoryRootLocation.lastIndexOf("/"));
                name = RemoteFileModelsUtil.removeEndingPathDelimiter(name, "/");
                name = RemoteFileModelsUtil.removeStartingPathDelimiter(name, "/");
                if (itemType != null) {
                    return rootAndNoType + "/" + name + "(" + itemType + ")";
                }
                return rootAndNoType + "/" + name;
            }
            if (name != null) {
                name = RemoteFileModelsUtil.removeEndingPathDelimiter(name, "/");
                name = RemoteFileModelsUtil.removeStartingPathDelimiter(name, "/");
                pathUrlString = RemoteFileModelsUtil.normalizeLocation(pathUrlString);
                StringBuffer sbipLocation = new StringBuffer();
                sbipLocation.append(pathUrlString);
                sbipLocation.append("/");
                sbipLocation.append(name);
                if (itemType != null) {
                    sbipLocation.append("(").append(itemType).append(")");
                }
                return sbipLocation.toString();
            }
            return pathUrlString;
        }
        name = RemoteFileModelsUtil.removeEndingPathDelimiter(name, "/");
        name = RemoteFileModelsUtil.removeStartingPathDelimiter(name, "/");
        PathUrl locationUrl = new PathUrl(pathUrlString);
        if (locationUrl != null) {
            return InformationServicesAdapterSupport.buildNewSBipUrl(locationUrl.getRepository(), locationUrl.getRootTree(), locationUrl.getPath(), locationUrl.getName(), name, itemType);
        }
        return null;
    }

    public static String buildNewSBipUrl(String serverName, String rootTreeName, String path, String folderName, String name, String type) {
        StringBuffer locationURLBuffer = new StringBuffer();
        locationURLBuffer.append(SBIP);
        locationURLBuffer.append(serverName);
        if (rootTreeName != null) {
            locationURLBuffer.append("/");
            locationURLBuffer.append(rootTreeName);
        }
        if (path != null) {
            locationURLBuffer.append("/");
            locationURLBuffer.append(path);
        }
        if (folderName != null) {
            locationURLBuffer.append("/");
            if (!folderName.equals("/")) {
                locationURLBuffer.append(folderName);
            }
        }
        if (name != null) {
            locationURLBuffer.append("/");
            locationURLBuffer.append(name);
        }
        if (type != null) {
            locationURLBuffer.append("(").append(type).append(")");
        }
        return locationURLBuffer.toString();
    }

    public static MetadataInterface getMetadataObjectByPath(UserContextInterface user, String path) {
        MetadataInterface metadataObject = null;
        try {
            InformationServiceInterface infoServices = Metadata.getInformationService();
            PathUrl newPathUrl = new PathUrl(path);
            metadataObject = infoServices.getObjectByPath(user, newPathUrl);
        }
        catch (ServiceException e) {
            InformationServicesAdapterSupport.getLog().error(e.getMessage());
        }
        catch (RemoteException e) {
            InformationServicesAdapterSupport.getLog().error(e.getMessage());
        }
        return metadataObject;
    }

    public static String getFolderSBIPForPath(BaseInformationServicesModel model, String path) {
        PathUrl pathUrl = InformationServicesAdapterSupport.getPathUrlFromAbsolutePath(model.getUserContext(), model.getServer(), path);
        String sbipPath = InformationServicesAdapterSupport.buildNewSBipUrl(pathUrl.getRepository(), pathUrl.getRootTree(), pathUrl.getPath(), pathUrl.getName(), null, "Folder");
        MetadataInterface metadataObject = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), sbipPath);
        if (metadataObject instanceof FolderInterface) {
            return sbipPath;
        }
        String fullyQualifiedName = model.buildNewSBipUrl(model.getLocation(), path, "Folder");
        if (fullyQualifiedName.equals(sbipPath)) {
            return null;
        }
        metadataObject = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), fullyQualifiedName);
        if (metadataObject instanceof FolderInterface) {
            return fullyQualifiedName;
        }
        return null;
    }

    public static void updateFileInfoForPath(String[] fileInfo, BaseInformationServicesModel model, String path) {
        PathUrl pathUrl = InformationServicesAdapterSupport.getPathUrlFromAbsolutePath(model.getUserContext(), model.getServer(), path);
        String sbipPath = InformationServicesAdapterSupport.buildNewSBipUrl(pathUrl.getRepository(), pathUrl.getRootTree(), pathUrl.getPath(), pathUrl.getName(), null, null);
        MetadataInterface metadataObject = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), sbipPath);
        if (metadataObject != null) {
            fileInfo[0] = "FILE";
            fileInfo[1] = sbipPath;
            try {
                fileInfo[2] = !metadataObject.isAuthorized("WriteMetadata") ? "WRITE_PERMISSIONS_DENIED" : metadataObject.getType();
            }
            catch (RemoteException remoteException) {
            }
            catch (ServiceException e) {
                InformationServicesAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
            }
            return;
        }
        String currentLocation = model.getLocation();
        String fullyQualifiedName = model.buildNewSBipUrl(currentLocation, path, null);
        metadataObject = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), fullyQualifiedName);
        try {
            if (metadataObject != null) {
                fileInfo[0] = "FILE";
                fileInfo[1] = fullyQualifiedName;
                fileInfo[2] = !metadataObject.isAuthorized("WriteMetadata") ? "WRITE_PERMISSIONS_DENIED" : metadataObject.getType();
            }
        }
        catch (IllegalStateException e1) {
            InformationServicesAdapterSupport.getLog().debug(e1.getMessage(), (Throwable)e1);
        }
        catch (RemoteException e1) {
        }
        catch (ServiceException e) {
            InformationServicesAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
        }
    }

    public static String getFolderFullyQualifiedLocation(BaseInformationServicesModel model, String folderName) {
        StringBuffer fullyQualifiedLocation = new StringBuffer();
        String folderLocation = RemoteFileModelsUtil.removeStartingEndingPathDelimiters(folderName, "/");
        String repositoryName = InformationServicesAdapterSupport.extractFirstTokenFromPath(model, folderLocation);
        if (repositoryName != null && InformationServicesAdapterSupport.isValidRepository(model, repositoryName)) {
            fullyQualifiedLocation.append(SBIP);
            fullyQualifiedLocation.append(folderLocation);
            if (repositoryName == folderLocation) {
                fullyQualifiedLocation.append("/");
            }
            if (folderLocation.indexOf("/") > -1) {
                fullyQualifiedLocation.append("(Folder)");
            }
        } else {
            String location = model.getLocation();
            if (location.equals(model.getRepositoryRootLocation())) {
                String checkFolder = model.combinePathAndFileName(location, folderLocation);
                fullyQualifiedLocation.append(checkFolder).append("(Folder)");
            } else {
                String fullyQualifiedName = model.buildNewSBipUrl(location, folderLocation, "Folder");
                fullyQualifiedLocation.append(fullyQualifiedName);
            }
        }
        try {
            BrowseMetadataInterface itemObject;
            PathUrl fileLocationUrl = new PathUrl(fullyQualifiedLocation.toString());
            RepositoryInterface pathRepository = RemoteFileModelsUtil.getRepositoryForPath(fullyQualifiedLocation.toString(), model.getRepositoryList(), null);
            BrowseMetadataInterface browseMetadataInterface = itemObject = pathRepository != null ? pathRepository.browseObjectByPath(fileLocationUrl, null) : null;
            if (itemObject != null) {
                return fullyQualifiedLocation.toString();
            }
            if (pathRepository instanceof OMIRepositoryInterface && "FOUNDATION".equals(((OMIRepositoryInterface)pathRepository).getRepositoryType())) {
                return fullyQualifiedLocation.toString();
            }
        }
        catch (ServiceException e) {
            InformationServicesAdapterSupport.getLog().error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            InformationServicesAdapterSupport.getLog().error(e.getMessage(), (Throwable)e);
        }
        String path = fullyQualifiedLocation.toString();
        FolderInterface folder = (FolderInterface)InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), path);
        return folder != null ? path : null;
    }

    public static String buildFullyQualifiedPath(BaseInformationServicesModel model, String path) {
        if (path == null || "".equals(path.trim())) {
            return "";
        }
        String rootLocation = model.getRootLocation();
        if (path.equals(rootLocation)) {
            return rootLocation;
        }
        PathUrl pathUrl = InformationServicesAdapterSupport.getPathUrlFromAbsolutePath(model.getUserContext(), model.getServer(), path);
        String sbipPath = InformationServicesAdapterSupport.buildNewSBipUrl(pathUrl.getRepository(), pathUrl.getRootTree(), pathUrl.getPath(), pathUrl.getName(), null, "Folder");
        MetadataInterface folder = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), sbipPath);
        if (folder != null) {
            return sbipPath;
        }
        String currentLocation = model.getLocation();
        String fullyQualifiedName = model.buildNewSBipUrl(currentLocation, path, "Folder");
        folder = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), fullyQualifiedName);
        if (folder != null) {
            return fullyQualifiedName;
        }
        return null;
    }

    public static String[] getFileInfo(BaseInformationServicesModel model, String path) {
        String[] fileInfo = new String[3];
        if (path == null || "".equals(path.trim())) {
            return fileInfo;
        }
        String rootLocation = model.getRootLocation();
        if (path.equals(rootLocation) || path.equals("/")) {
            fileInfo[0] = "FOLDER";
            fileInfo[1] = path;
            return fileInfo;
        }
        String sbip = InformationServicesAdapterSupport.getFolderSBIPForPath(model, path);
        if (sbip != null) {
            fileInfo[0] = "FOLDER";
            fileInfo[1] = sbip;
            return fileInfo;
        }
        InformationServicesAdapterSupport.updateFileInfoForPath(fileInfo, model, path);
        return fileInfo;
    }

    public static boolean startsWithValidAbsolutePathIndentifier(BaseInformationServicesModel model, String path) {
        int endIndex;
        if (path == null) {
            return false;
        }
        if (RemoteFileModelsUtil.isValidURL(path)) {
            return true;
        }
        int startIndex = 0;
        if (path.startsWith("/")) {
            if (path.length() == 1) {
                return true;
            }
            startIndex = 1;
        }
        String pathRoot = (endIndex = path.indexOf("/", startIndex)) == -1 ? path : path.substring(0, endIndex);
        String[] fileInfo = InformationServicesAdapterSupport.getFileInfo(model, pathRoot);
        return fileInfo[0] != null;
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)InformationServicesAdapterSupport.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        }
        return _log;
    }

    public static boolean isItemAtRootLocation(RemoteFileModel2Interface rfsModel, String[] fileInfo, String entryFile) {
        boolean isRoot = false;
        ArrayList<String> fileNamesWithLocations = new ArrayList<String>();
        if (fileInfo[0] == null) {
            if (!RemoteFileVisualsUtil.startsWithValidAbsolutePathIndentifier(rfsModel, entryFile)) {
                fileNamesWithLocations.add(rfsModel.buildFullyQualifiedLocation(rfsModel.getLocation(), entryFile));
            } else {
                fileNamesWithLocations.add(entryFile);
            }
        } else {
            fileNamesWithLocations.add(fileInfo[1]);
        }
        if (fileNamesWithLocations != null && fileNamesWithLocations.size() > 0) {
            String rootLocation;
            String mapLocation = (String)fileNamesWithLocations.get(0);
            if (entryFile != null && entryFile.length() > 0 && mapLocation.contains(entryFile) || mapLocation.endsWith("/(Folder)")) {
                int endIndex = mapLocation.lastIndexOf("/");
                mapLocation = mapLocation.substring(0, endIndex);
            }
            if ((rootLocation = SBIP + rfsModel.getServerName()).equals(mapLocation)) {
                isRoot = true;
            }
        }
        return isRoot;
    }

    public static boolean isRootLocation(RemoteFileModel2Interface rfsModel, String location) {
        String rootLocation;
        boolean isRoot = false;
        ArrayList fileNamesWithLocations = new ArrayList();
        String fullyQualifiedLocation = null;
        String[] fileInfo = rfsModel.getFileInfo(location);
        fullyQualifiedLocation = fileInfo[0] == null ? (!RemoteFileVisualsUtil.startsWithValidAbsolutePathIndentifier(rfsModel, location) ? rfsModel.buildFullyQualifiedLocation(rfsModel.getLocation(), location) : location) : fileInfo[1];
        if (fullyQualifiedLocation.endsWith("(Folder)")) {
            fullyQualifiedLocation = fullyQualifiedLocation.substring(0, fullyQualifiedLocation.length() - 8);
        }
        if (fullyQualifiedLocation.endsWith("/")) {
            fullyQualifiedLocation = fullyQualifiedLocation.substring(0, fullyQualifiedLocation.length() - 1);
        }
        if ((rootLocation = SBIP + rfsModel.getServerName()).equals(fullyQualifiedLocation)) {
            isRoot = true;
        }
        return isRoot;
    }

    public static boolean hasWritePermissionsOnFolder(BaseInformationServicesModel model, String path) throws IllegalArgumentException {
        MetadataInterface metadataObject = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), path);
        if (metadataObject instanceof FolderInterface) {
            try {
                FolderInterface folder = (FolderInterface)metadataObject;
                if (folder.isAuthorized("WriteMemberMetadata")) {
                    return true;
                }
            }
            catch (ServiceException e) {
                InformationServicesAdapterSupport.getLog().error(e.getMessage());
            }
            catch (RemoteException e) {
                InformationServicesAdapterSupport.getLog().error(e.getMessage());
            }
            return false;
        }
        throw new IllegalArgumentException("The specified path isn't an SBIP URL representing a folder.");
    }

    public static boolean hasWritePermissionsOnFile(BaseInformationServicesModel model, String path) {
        MetadataInterface file = InformationServicesAdapterSupport.getMetadataObjectByPath(model.getUserContext(), path);
        if (file != null) {
            try {
                return file.isAuthorized("WriteMetadata");
            }
            catch (ServiceException e) {
                InformationServicesAdapterSupport.getLog().error(e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                InformationServicesAdapterSupport.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }
}

