/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.ifileservice.tree;

import com.sas.iom.SAS.IFileService_1_1Package.DeviceNotMounted;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.nls.collator.SASCollator;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.BaseIFileServiceTreeModel;
import com.sas.swing.models.remotefileselector2.ifileservice.tree.IFileServiceMetadataTreeNode;
import com.sas.util.GenericComparator;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.omg.CORBA.StringHolder;

public class IFileServiceTreeNavigationModel
extends BaseIFileServiceTreeModel {
    private static CommonLoggerInterface _log = null;

    public IFileServiceTreeNavigationModel() {
    }

    public IFileServiceTreeNavigationModel(IWorkspace workspace) {
        this(workspace, 1);
    }

    public IFileServiceTreeNavigationModel(IWorkspace workspace, int fileSystem) {
        super(workspace, fileSystem);
        this.init();
    }

    public void init() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setAllowsChildren(true);
        this.setRoot(root);
        this.addChildrenToNode(root, this.getFileListForPath(this.getBasePath()));
    }

    @Override
    public boolean isLeaf(Object node) {
        if (!(node instanceof IFileServiceMetadataTreeNode)) {
            return super.isLeaf(node);
        }
        return ((IFileServiceMetadataTreeNode)node).isLeaf();
    }

    @Override
    public int getChildCount(Object node) {
        if (!(node instanceof IFileServiceMetadataTreeNode)) {
            return super.getChildCount(node);
        }
        IFileServiceMetadataTreeNode fileTreeNode = (IFileServiceMetadataTreeNode)node;
        if (fileTreeNode.isLeaf()) {
            return 0;
        }
        return this.countChildren(fileTreeNode);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (!(parent instanceof IFileServiceMetadataTreeNode)) {
            return super.getChild(parent, index);
        }
        IFileServiceMetadataTreeNode fileTreeNode = (IFileServiceMetadataTreeNode)parent;
        if (!fileTreeNode.isLoaded()) {
            this.loadChildren(fileTreeNode);
        }
        return super.getChild(parent, index);
    }

    private void loadChildren(IFileServiceMetadataTreeNode ifileTreeNode) {
        if (ifileTreeNode == null) {
            return;
        }
        ifileTreeNode.setLoaded(true);
        if (this.isLeaf(ifileTreeNode)) {
            return;
        }
        this.addChildrenToNode(ifileTreeNode, this.getFileListForPath(ifileTreeNode.getFileMetadata().getLocation()));
    }

    private void addChildrenToNode(DefaultMutableTreeNode node, List childList) {
        if (node == null || childList == null) {
            return;
        }
        Collections.sort(childList, this.getComparator());
        int numFiles = childList.size();
        for (int i = 0; i < numFiles; ++i) {
            IFileServiceMetadataTreeNode newChildNode = new IFileServiceMetadataTreeNode((IFileServiceFileMetadataInterface)childList.get(i));
            newChildNode.setAllowsChildren(true);
            node.add(newChildNode);
        }
    }

    private Comparator getComparator() {
        return new AlphaOrderComparator();
    }

    private List getFileListForPath(String path) {
        List fileList = null;
        try {
            if (path == null) {
                path = "";
            }
            fileList = IFileServiceAdapterSupport.load(this.fileService, path.equals("") ? 10 : 99, path, this.getFilterValues(), new StringHolder(), this.isDirectoriesOnly());
        }
        catch (InvalidFieldMask ifm) {
            IFileServiceTreeNavigationModel.getLog().error(ifm.getMessage());
        }
        catch (DeviceNotMounted dnm) {
            IFileServiceTreeNavigationModel.getLog().error(dnm.getMessage());
        }
        catch (GenericError dnm) {
            // empty catch block
        }
        if (fileList == null || fileList.isEmpty() || !this.isDirectoriesOnly()) {
            return fileList;
        }
        Iterator iterator = fileList.iterator();
        while (iterator.hasNext()) {
            IFileServiceFileMetadataInterface ifsfmi = (IFileServiceFileMetadataInterface)iterator.next();
            if (ifsfmi.isFolder()) continue;
            iterator.remove();
        }
        return fileList;
    }

    private int countFilesForPath(String path) {
        int count = 0;
        try {
            count = IFileServiceAdapterSupport.count(this.fileService, 99, path == null ? "" : path, this.getFilterValues(), this.isDirectoriesOnly());
        }
        catch (InvalidFieldMask ifm) {
            IFileServiceTreeNavigationModel.getLog().error(ifm.getMessage());
        }
        catch (DeviceNotMounted dnm) {
            IFileServiceTreeNavigationModel.getLog().error(dnm.getMessage());
        }
        catch (GenericError genericError) {
            // empty catch block
        }
        return count;
    }

    private int countChildren(IFileServiceMetadataTreeNode fileTreeNode) {
        if (fileTreeNode.isLoaded()) {
            return super.getChildCount(fileTreeNode);
        }
        return this.countFilesForPath(fileTreeNode.getFileMetadata().getLocation());
    }

    private void displayNodeCount() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        System.out.println("Total number of nodes in tree = " + this.getChildCount(root));
    }

    private int getChildCount(DefaultMutableTreeNode node) {
        int numChildren;
        if (node == null) {
            return 0;
        }
        int totalNumChildren = numChildren = node.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            totalNumChildren += this.getChildCount(childNode);
        }
        return totalNumChildren;
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)IFileServiceTreeNavigationModel.class.getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        }
        return _log;
    }

    class AlphaOrderComparator
    implements Comparator {
        Comparator nameComparator;

        public AlphaOrderComparator() {
            SASStringComparator nameCollator = SASCollatorFactory.createCollator();
            if (nameCollator instanceof SASCollator) {
                SASCollator collator = (SASCollator)nameCollator;
                collator.setStrength(1);
                this.nameComparator = new GenericComparator((SASStringComparator)collator);
            } else {
                this.nameComparator = new GenericComparator(nameCollator);
            }
        }

        public int compare(Object o1, Object o2) {
            int retVal = 0;
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 instanceof RemoteFileMetadataInterface && o2 instanceof RemoteFileMetadataInterface) {
                RemoteFileMetadataInterface testObj1 = (RemoteFileMetadataInterface)o1;
                RemoteFileMetadataInterface testObj2 = (RemoteFileMetadataInterface)o2;
                retVal = this.nameComparator.compare(testObj1.getName(), testObj2.getName());
            }
            return retVal;
        }
    }
}

