/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.ifileservice;

import com.sas.iom.SAS.IFileServicePackage.ListFilesIndex;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IFileServicePackage.TypeCategory;
import com.sas.iom.SAS.IFileServicePackage.TypeCategorySeqHolder;
import com.sas.iom.SAS.IFileService_1_1;
import com.sas.iom.SAS.IFileService_1_1Helper;
import com.sas.iom.SAS.IFileService_1_1Package.DeviceNotMounted;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.swing.models.remotefileselector2.AddFolderInterface;
import com.sas.swing.models.remotefileselector2.DeleteFileInterface;
import com.sas.swing.models.remotefileselector2.PasteFileInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelsUtil;
import com.sas.swing.models.remotefileselector2.RenameFileInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadata;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadataInterface;
import com.sas.util.log.LoggerRepository2;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class IFileServiceNavigationModel
extends BaseIFileServiceModel
implements RemoteFileModel2Interface,
AddFolderInterface,
DeleteFileInterface,
RenameFileInterface,
PasteFileInterface {
    private String previousLocation;
    private boolean useRemotableFileMetadata = true;

    public IFileServiceNavigationModel(IWorkspace workspace) {
        this(workspace, 1, true);
    }

    public IFileServiceNavigationModel(IWorkspace workspace, boolean useRemotableFileMetadata) {
        this(workspace, 1, useRemotableFileMetadata);
    }

    public IFileServiceNavigationModel(IWorkspace workspace, int fileSystem) {
        this(workspace, fileSystem, true);
    }

    public IFileServiceNavigationModel(IWorkspace workspace, int fileSystem, boolean useRemotableFileMetadata) {
        super(workspace, fileSystem);
        this.useRemotableFileMetadata = useRemotableFileMetadata;
        this.setMode(11);
        this.setRefreshNeeded(true);
    }

    @Override
    public void loadFileInfo() throws InvalidFieldMask, DeviceNotMounted, GenericError {
        StringHolder listedPath = new StringHolder();
        int mode = this.getMode();
        String path = this.getLocation();
        if ("".equals(path) && mode == 99) {
            mode = 10;
        }
        try {
            this.infoList = IFileServiceAdapterSupport.load(this.workspace.FileService(), mode, path, this.getFilterValues(), listedPath, this.isDirectoriesOnly(), this.useRemotableFileMetadata);
            this.previousLocation = listedPath.value;
            this.currentPath = listedPath.value;
            this.fireTableDataChanged();
            this.modelNeedsRefresh = false;
        }
        catch (InvalidFieldMask e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            this.recoverFromBadPath();
            throw e;
        }
        catch (DeviceNotMounted e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            this.recoverFromBadPath();
            throw e;
        }
        catch (GenericError e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).info(e.getMessage());
            this.recoverFromBadPath();
            throw e;
        }
    }

    private void recoverFromBadPath() throws InvalidFieldMask, DeviceNotMounted, GenericError {
        if (this.previousLocation != null) {
            this.setLocation(this.previousLocation);
            String[][] parsedPath = this.parseIntoFoldersAndLocations(this.previousLocation);
            if (parsedPath.length > 0) {
                this.previousLocation = parsedPath[0][1];
            }
        } else {
            this.setLocation(10);
        }
        this.loadFileInfo();
    }

    @Override
    public RemoteFileMetadataInterface addFolder(String location, String newFolderName) {
        String returnedFolderName = null;
        IFileServiceFileMetadata item = null;
        try {
            returnedFolderName = this.workspace.FileService().MakeDirectory(location, newFolderName);
            item = new IFileServiceFileMetadata(newFolderName, null, TypeCategory.TypeCategoryDirectory, returnedFolderName, 0, 0L, null);
            this.infoList.add(item);
        }
        catch (GenericError e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
        }
        this.fireTableDataChanged();
        return item;
    }

    @Override
    public boolean isExistingSubFolder(String parentLocation, String newFolderName) {
        return this.isExistingFileItem(parentLocation, newFolderName);
    }

    @Override
    public boolean isExistingFileItem(String parentLocation, String newItemName) {
        String newFolderPathAndName = IFileServiceAdapterSupport.combinePathAndFileName(this.workspace.FileService(), parentLocation, newItemName);
        String fileRefName = "";
        int startIndex = newItemName.lastIndexOf("(");
        int endIndex = newItemName.lastIndexOf(")");
        if (startIndex > 0 && endIndex > 0 && endIndex > startIndex) {
            fileRefName = "a" + newItemName.substring(startIndex + 1, endIndex);
        }
        return IFileServiceAdapterSupport.verifyExistenceOfFile(this, newFolderPathAndName, fileRefName);
    }

    public boolean isExistingFileItem(String fileNameWithPath) {
        return IFileServiceAdapterSupport.verifyExistenceOfFile(this, fileNameWithPath, "");
    }

    @Override
    public void renameFolder(RemoteFileMetadataInterface folderNode, String newFolderName) {
        this.renameItem(folderNode, newFolderName);
    }

    @Override
    public void renameItem(RemoteFileMetadataInterface node, String newItemName) {
        String newItemNameWithPath;
        String oldItemNameWithPath;
        if (node != null && !(oldItemNameWithPath = node.getLocation()).equals(newItemNameWithPath = IFileServiceAdapterSupport.combinePathAndFileName(this.workspace.FileService(), this.getLocation(), newItemName))) {
            try {
                this.workspace.FileService().RenameFile(oldItemNameWithPath, newItemNameWithPath);
                if (node instanceof IFileServiceFileMetadataInterface) {
                    ((IFileServiceFileMetadataInterface)node).setLocation(newItemNameWithPath);
                }
            }
            catch (GenericError genericError) {
                // empty catch block
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public void deleteItem(RemoteFileMetadataInterface nodeOfItemToDelete) {
        try {
            String deleteFile = nodeOfItemToDelete.getLocation();
            this.workspace.FileService().DeleteFile(deleteFile);
        }
        catch (GenericError genericError) {
            // empty catch block
        }
    }

    @Override
    public void moveItem(RemoteFileMetadataInterface itemNode) {
        this.renameItem(itemNode, itemNode.getName());
    }

    @Override
    public boolean isFolderPopulated(RemoteFileMetadataInterface itemNode) {
        if (itemNode.isFolder()) {
            return false;
        }
        return false;
    }

    public String getFileType(String parentPath, String fileName) {
        if ((fileName == null || fileName.length() == 0) && parentPath != null && parentPath.length() > 0) {
            return "FOLDER";
        }
        boolean[] fieldMask = new boolean[6];
        StringHolder listedPath = new StringHolder();
        StringSeqHolder names = new StringSeqHolder();
        StringSeqHolder engines = new StringSeqHolder();
        StringSeqHolder typeNames = new StringSeqHolder();
        LongSeqHolder sizes = new LongSeqHolder();
        TypeCategorySeqHolder typeCategories = new TypeCategorySeqHolder();
        DateTimeSeqHolder modtimes = new DateTimeSeqHolder();
        fieldMask[ListFilesIndex.ListFilesIndexSizes.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexTypeNames.value()] = true;
        fieldMask[ListFilesIndex.ListFilesIndexEngines.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexModTimes.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexNames.value()] = true;
        fieldMask[ListFilesIndex.ListFilesIndexTypeCategories.value()] = true;
        try {
            if (this.workspace.FileService() instanceof IFileService_1_1) {
                IFileService_1_1 fileService = IFileService_1_1Helper.narrow((Object)this.workspace.FileService());
                fileService.ListFiles_2(parentPath, ListFilesMode.ListFilesModePath, fieldMask, listedPath, names, typeNames, typeCategories, sizes, modtimes, engines);
            } else {
                this.workspace.FileService().ListFiles(parentPath, ListFilesMode.ListFilesModePath, fieldMask, listedPath, names, typeNames, typeCategories, sizes, modtimes, engines);
            }
        }
        catch (InvalidFieldMask e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (DeviceNotMounted e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (GenericError e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return null;
        }
        for (int i = 0; i < names.value.length; ++i) {
            if (!names.value[i].equalsIgnoreCase(fileName)) continue;
            if (typeCategories.value[i] == TypeCategory.TypeCategoryDirectory) {
                return "FOLDER";
            }
            return typeNames.value[i];
        }
        return null;
    }

    public String getFileType(String fileNameWithLocation) {
        return IFileServiceAdapterSupport.getFileType(this.getWorkspace(), this.getRootLocation(), this.getBasePath(), fileNameWithLocation);
    }

    @Override
    public String[] getFileInfo(String itemName) {
        String[] fileInfo = new String[2];
        if (itemName == null || "".equals(itemName.trim())) {
            return fileInfo;
        }
        String folderLocation = IFileServiceAdapterSupport.getLocationForItem(this.infoList, itemName, 0);
        if (folderLocation != null) {
            fileInfo[0] = "FOLDER";
            fileInfo[1] = folderLocation;
            return fileInfo;
        }
        String fileLocation = IFileServiceAdapterSupport.getLocationForItem(this.infoList, itemName, 1);
        if (fileLocation != null) {
            fileInfo[0] = "FILE";
            fileInfo[1] = fileLocation;
            return fileInfo;
        }
        if (RemoteFileModelsUtil.isPathSameAsRoot(this, itemName)) {
            fileInfo[0] = "FOLDER";
            fileInfo[1] = itemName;
            return fileInfo;
        }
        fileInfo[0] = this.getFileType(itemName);
        if (fileInfo[0] != null) {
            fileInfo[1] = itemName;
            return fileInfo;
        }
        String fileNameWithCompletePath = this.buildFullyQualifiedLocation(this.getLocation(), itemName);
        fileInfo[0] = this.getFileType(fileNameWithCompletePath);
        if (fileInfo[0] != null) {
            fileInfo[1] = fileNameWithCompletePath;
        }
        return fileInfo;
    }

    public String getPreviousLocation() {
        return this.previousLocation;
    }

    public void setPreviousLocation(String previousLocation) {
        this.previousLocation = previousLocation;
    }
}

