/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.ifileservice;

import com.sas.iom.SAS.IFileServicePackage.TypeCategory;
import com.sas.net.util.DateConverter;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadataInterface;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class IFileServiceFileMetadata
implements IFileServiceFileMetadataInterface,
Serializable {
    private String filePath;
    private String fileName;
    private transient TypeCategory fileTypeCategory;
    private int fileTypeCategoryPrimitive;
    private long fileModifiedTime;
    private String fileExtension;
    private int fileSize;
    private String fileEngine;

    public IFileServiceFileMetadata(String name, String extension, TypeCategory category, String path, int size, long modtime, String engine) {
        this.fileName = name;
        this.fileTypeCategory = category;
        this.filePath = path;
        this.fileModifiedTime = modtime;
        this.fileExtension = extension;
        this.fileSize = size;
        this.fileEngine = engine;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public void setName(String name) {
        this.fileName = name;
    }

    @Override
    public boolean isFolder() {
        return this.fileTypeCategory == TypeCategory.TypeCategoryDirectory;
    }

    @Override
    public String getLocation() {
        return this.filePath;
    }

    @Override
    public void setLocation(String path) {
        this.filePath = path;
    }

    public Date getModifiedDate() {
        Calendar calendar = Calendar.getInstance();
        DateConverter.corbaToJava((long)this.fileModifiedTime, (Calendar)calendar);
        return calendar.getTime();
    }

    public String getExtension() {
        return this.fileExtension;
    }

    public int getSize() {
        return this.fileSize;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.fileTypeCategoryPrimitive = this.fileTypeCategory.value();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fileTypeCategory = TypeCategory.from_int((int)this.fileTypeCategoryPrimitive);
    }

    public String getEngine() {
        return this.fileEngine;
    }
}

