/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2.ifileservice;

import com.sas.iom.SAS.IFileInfo;
import com.sas.iom.SAS.IFileInfoHelper;
import com.sas.iom.SAS.IFileInfoPackage.Status;
import com.sas.iom.SAS.IFileInfo_1_1;
import com.sas.iom.SAS.IFileInfo_1_1Helper;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileServicePackage.ListFilesIndex;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IFileServicePackage.TypeCategory;
import com.sas.iom.SAS.IFileServicePackage.TypeCategorySeqHolder;
import com.sas.iom.SAS.IFileService_1_1;
import com.sas.iom.SAS.IFileService_1_1Helper;
import com.sas.iom.SAS.IFileService_1_1Package.DeviceNotMounted;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.IHostSystemPackage.SoftwareInfoIndex;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileListInfo;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadata;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceFileMetadataNonRemotable;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceNavigationModel;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

public class IFileServiceAdapterSupport {
    public static final int MVS_OS_FILESYSTEM = 1;
    public static final int MVS_HFS_FILESYSTEM = 2;
    public static final int ROOT_MODE = 10;
    public static final int USER_MODE = 11;
    public static final int PATH_MODE = 99;
    private static String HFS_FILESYSTEM_OPTION = "OPTIONS FILESYSTEM=HFS;";
    private static String MVS_FILESYSTEM_OPTION = "OPTIONS FILESYSTEM=MVS;";
    private static CommonLoggerInterface _log = null;

    public static void setWorkspaceOptions(IWorkspace workspace, int fileSystem) {
        try {
            IUtilities utilities = workspace.Utilities();
            IHostSystem hostSystem = utilities.HostSystem();
            StringSeqHolder softwareInfo = new StringSeqHolder();
            VariableArray2dOfStringHolder hardwareInfo = new VariableArray2dOfStringHolder();
            hostSystem.GetInfo(softwareInfo, hardwareInfo);
            String hostFamily = softwareInfo.value[SoftwareInfoIndex.SoftwareInfoIndexOSFamily.value()];
            if (hostFamily.equals("OS")) {
                if (fileSystem == 2) {
                    workspace.LanguageService().Submit(HFS_FILESYSTEM_OPTION);
                } else {
                    workspace.LanguageService().Submit(MVS_FILESYSTEM_OPTION);
                }
            }
        }
        catch (GenericError ge) {
            IFileServiceAdapterSupport.getLog().error(ge.getMessage(), (Throwable)ge);
        }
    }

    public static List createMetadataItems(IFileService fileService, StringSeqHolder names, StringSeqHolder extensions, TypeCategorySeqHolder typeCategories, StringHolder listedPath, LongSeqHolder sizes, DateTimeSeqHolder modtimes, StringSeqHolder engines, List filterValues, boolean directoriesOnly) {
        return IFileServiceAdapterSupport.createMetadataItems(fileService, names, extensions, typeCategories, listedPath, sizes, modtimes, engines, filterValues, directoriesOnly, true);
    }

    public static List createMetadataItems(IFileService fileService, StringSeqHolder names, StringSeqHolder extensions, TypeCategorySeqHolder typeCategories, StringHolder listedPath, LongSeqHolder sizes, DateTimeSeqHolder modtimes, StringSeqHolder engines, List filterValues, boolean directoriesOnly, boolean useRemotableFileMetadata) {
        if (names != null && names.value != null) {
            int numberOfFiles = names.value.length;
            ArrayList<IFileServiceFileMetadataNonRemotable> returnList = new ArrayList<IFileServiceFileMetadataNonRemotable>(numberOfFiles);
            for (int i = 0; i < numberOfFiles; ++i) {
                String extension = extensions.value[i];
                String name = names.value[i];
                TypeCategory typeCategory = typeCategories.value[i];
                if (directoriesOnly && typeCategory != TypeCategory.TypeCategoryDirectory || filterValues != null && !filterValues.isEmpty() && (filterValues.get(0) == null || !filterValues.get(0).equals("*")) && !IFileServiceAdapterSupport.filterData(extension, typeCategory, filterValues) && (typeCategory != TypeCategory.TypeCategorySASType || !IFileServiceAdapterSupport.filterData(IFileServiceAdapterSupport.getFileExtension(name), typeCategory, filterValues))) continue;
                int size = sizes.value[i];
                long modtime = modtimes.value[i];
                String engine = engines.value[i];
                IFileServiceFileMetadata item = null;
                item = useRemotableFileMetadata ? new IFileServiceFileMetadata(name, extension, typeCategory, IFileServiceAdapterSupport.combinePathAndFileName(fileService, listedPath.value, name), size, modtime, engine) : new IFileServiceFileMetadataNonRemotable(fileService, name, extension, typeCategory, listedPath.value, size, modtime, engine);
                returnList.add((IFileServiceFileMetadataNonRemotable)item);
            }
            return returnList;
        }
        return new ArrayList(0);
    }

    private static String getFileExtension(String name) {
        if (name != null) {
            int startIndexOfExtension = name.lastIndexOf(".") + 1;
            String fileExtension = name.substring(startIndexOfExtension);
            return fileExtension;
        }
        return null;
    }

    public static int countItems(StringSeqHolder names, StringSeqHolder extensions, TypeCategorySeqHolder typeCategories, List filterValues, boolean directoriesOnly) {
        if (names == null || names.value == null) {
            return 0;
        }
        int numItems = 0;
        int numberOfFiles = names.value.length;
        for (int i = 0; i < numberOfFiles; ++i) {
            String extension = extensions.value[i];
            TypeCategory typeCategory = typeCategories.value[i];
            if (directoriesOnly && typeCategory != TypeCategory.TypeCategoryDirectory || filterValues != null && !filterValues.get(0).equals("*") && !IFileServiceAdapterSupport.filterData(extension, typeCategory, filterValues)) continue;
            ++numItems;
        }
        return numItems;
    }

    private static boolean filterData(String extension, TypeCategory typeCategory, List filterValues) {
        boolean value = false;
        if (extension == null) {
            return false;
        }
        if (typeCategory != TypeCategory.TypeCategoryDirectory) {
            int numFilterValues = filterValues.size();
            for (int i = 0; i < numFilterValues; ++i) {
                String filterValue = (String)filterValues.get(i);
                if (filterValue != null && !extension.toUpperCase().equals(filterValue.toUpperCase())) continue;
                value = true;
            }
        } else {
            value = true;
        }
        return value;
    }

    public static String combinePathAndFileName(IFileService fileService, String path, String name) {
        String fullName = null;
        if (!"".equals(name) && name != null && path != null) {
            try {
                fullName = fileService.FullName(name, path);
            }
            catch (GenericError e) {
                IFileServiceAdapterSupport.getLog().error(e.getMessage(), (Throwable)e);
                return name;
            }
        } else if (name == null || "".equals(name) && path != null) {
            fullName = path;
        } else if (path == null && name != null) {
            fullName = name;
        }
        return fullName;
    }

    public static String[] splitPathAndFileName(IWorkspace workspace, IFileService fileService, String rootLocation, String basePath, String path) {
        StringHolder shortName = new StringHolder();
        StringHolder returnedPath = new StringHolder();
        String[] stringArray = new String[2];
        try {
            if (path != null && !"".equals(path) && !path.equals(rootLocation)) {
                fileService.SplitName(path, shortName, returnedPath);
                stringArray[0] = shortName.value;
                stringArray[1] = returnedPath.value;
            } else if (basePath != null && !"".equals(basePath) && !"".equals(path)) {
                fileService.SplitName(path, shortName, returnedPath);
                stringArray[0] = shortName.value;
                stringArray[1] = returnedPath.value;
            } else {
                stringArray[0] = IFileServiceAdapterSupport.getServerNameFromWorkspace(workspace);
                stringArray[1] = rootLocation;
            }
        }
        catch (GenericError e) {
            e.printStackTrace();
            IFileServiceAdapterSupport.getLog().error(e.getMessage(), (Throwable)e);
        }
        return stringArray;
    }

    public static ListFilesMode getListFilesMode(int mode) {
        if (mode == 10) {
            return ListFilesMode.ListFilesModeRoot;
        }
        if (mode == 11) {
            return ListFilesMode.ListFilesModeUser;
        }
        return ListFilesMode.ListFilesModePath;
    }

    public static List load(IFileService fileService, int mode, String path, List filterValues, StringHolder listedPathHolder, boolean directoriesOnly) throws InvalidFieldMask, DeviceNotMounted, GenericError {
        return IFileServiceAdapterSupport.load(fileService, mode, path, filterValues, listedPathHolder, directoriesOnly, true);
    }

    public static List load(IFileService fileService, int mode, String path, List filterValues, StringHolder listedPathHolder, boolean directoriesOnly, boolean useRemotableFileMetadata) throws InvalidFieldMask, DeviceNotMounted, GenericError {
        ArrayList fileInfoList = null;
        ListFilesMode listFilesMode = IFileServiceAdapterSupport.getListFilesMode(mode);
        if (path == null) {
            path = "";
        }
        IFileServiceFileListInfo fileListInfo = IFileServiceFileListInfo.newInstance(0);
        fileListInfo.listedPath = listedPathHolder;
        IFileServiceFileListInfo.listFiles(fileService, path, listFilesMode, fileListInfo);
        fileInfoList = new ArrayList();
        fileInfoList.addAll(IFileServiceAdapterSupport.createMetadataItems(fileService, fileListInfo.names, fileListInfo.typeNames, fileListInfo.typeCategories, fileListInfo.listedPath, fileListInfo.sizes, fileListInfo.modtimes, fileListInfo.engines, filterValues, directoriesOnly, useRemotableFileMetadata));
        return fileInfoList;
    }

    public static int count(IFileService fileService, int mode, String path, List filterValues, boolean directoriesOnly) throws InvalidFieldMask, DeviceNotMounted, GenericError {
        ListFilesMode listFilesMode = IFileServiceAdapterSupport.getListFilesMode(mode);
        if (path == null) {
            path = "";
        }
        IFileServiceFileListInfo fileListInfo = IFileServiceFileListInfo.newInstance(2);
        IFileServiceFileListInfo.listFiles(fileService, path, listFilesMode, fileListInfo);
        return IFileServiceAdapterSupport.countItems(fileListInfo.names, fileListInfo.typeNames, fileListInfo.typeCategories, filterValues, directoriesOnly);
    }

    public static String[][] parseIntoFoldersAndLocations(IWorkspace workspace, IFileService fileService, String rootLocation, String basePath, String path) {
        String[] folderNameAndLocation;
        String folderName = null;
        String location = path;
        ArrayList<String> locationList = new ArrayList<String>();
        ArrayList<String> folderList = new ArrayList<String>();
        String systemRootPath = rootLocation;
        boolean continueParsing = true;
        while (systemRootPath != null && !systemRootPath.equals(location) && continueParsing && location != null && !location.equals("")) {
            folderNameAndLocation = IFileServiceAdapterSupport.splitPathAndFileName(workspace, fileService, systemRootPath, basePath, location);
            if (IFileServiceAdapterSupport.reSplitDueToEmptyFolderName(folderNameAndLocation, path, location)) {
                location = folderNameAndLocation[1];
                continue;
            }
            locationList.add(location);
            folderName = folderNameAndLocation[0];
            folderList.add(folderName);
            if (location == null || location != null && location.equals(folderNameAndLocation[1])) {
                continueParsing = false;
                continue;
            }
            location = folderNameAndLocation[1];
        }
        if (basePath != null && !"".equals(basePath)) {
            folderNameAndLocation = IFileServiceAdapterSupport.splitPathAndFileName(workspace, fileService, rootLocation, basePath, location);
            locationList.add(location);
            folderList.add(folderNameAndLocation[0]);
        } else {
            folderList.add(IFileServiceAdapterSupport.getServerNameFromWorkspace(workspace));
            locationList.add(systemRootPath);
        }
        String[][] returnArray = new String[locationList.size()][2];
        for (int i = 0; i < locationList.size(); ++i) {
            returnArray[i][0] = (String)locationList.get(i);
            String tempFolderName = (String)folderList.get(i);
            returnArray[i][1] = tempFolderName == null || "".equals(tempFolderName) ? returnArray[i][0] : tempFolderName;
        }
        return returnArray;
    }

    private static boolean reSplitDueToEmptyFolderName(String[] folderNameAndLocationFromSplit, String originalPath, String currentLocation) {
        if (currentLocation == null || !currentLocation.equals(originalPath)) {
            return false;
        }
        if (folderNameAndLocationFromSplit[0] == null || !folderNameAndLocationFromSplit[0].equals("")) {
            return false;
        }
        if (folderNameAndLocationFromSplit[0] == null || !folderNameAndLocationFromSplit[0].equals("")) {
            return false;
        }
        return !currentLocation.equals(folderNameAndLocationFromSplit[1]);
    }

    public static StringHolder getModePath(IFileService fileService, ListFilesMode mode) {
        IFileServiceFileListInfo fileListInfo = IFileServiceFileListInfo.newInstance(1);
        try {
            IFileServiceFileListInfo.listFiles(fileService, "", mode, fileListInfo);
        }
        catch (InvalidFieldMask e) {
            IFileServiceAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
        }
        catch (DeviceNotMounted e) {
            IFileServiceAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
        }
        catch (GenericError e) {
            IFileServiceAdapterSupport.getLog().debug(e.getMessage(), (Throwable)e);
        }
        return fileListInfo.listedPath;
    }

    public static String getServerNameFromWorkspace(IWorkspace workspace) {
        if (workspace != null) {
            IUtilities utility = workspace.Utilities();
            IHostSystem host = utility.HostSystem();
            return host.DNSName();
        }
        return "";
    }

    public static boolean verifyExistenceOfFile(BaseIFileServiceModel model, String newFolderPathAndName, String fileRefName) {
        return IFileServiceAdapterSupport.verifyExistenceOfFile(model.getWorkspace(), newFolderPathAndName, fileRefName);
    }

    public static boolean verifyExistenceOfFile(IWorkspace workspace, String newFolderPathAndName, String fileRefName) {
        try {
            StringHolder assignedName = new StringHolder();
            IFileref fileRef = workspace.FileService().AssignFileref(fileRefName, "DISK", newFolderPathAndName, "", assignedName);
            IFileInfo_1_1 fileInfo = IFileInfo_1_1Helper.narrow((Object)fileRef);
            IntHolder intHolder = new IntHolder();
            StringHolder stringHolder = new StringHolder();
            fileInfo.StatusValueEx(intHolder, stringHolder);
            if (intHolder.value == Status.StatusFileExists.value() || intHolder.value == 9) {
                workspace.FileService().DeassignFileref(assignedName.value);
                return true;
            }
            workspace.FileService().DeassignFileref(assignedName.value);
            return false;
        }
        catch (GenericError ge) {
            return false;
        }
    }

    public static boolean verifyExistenceOfDrive(IWorkspace workspace, String newFolderPathAndName, String fileRefName) {
        try {
            StringHolder assignedName = new StringHolder();
            IFileref fileRef = workspace.FileService().AssignFileref(fileRefName, "DRIVEMAP", newFolderPathAndName, "", assignedName);
            IFileInfo fileInfo = IFileInfoHelper.narrow((Object)fileRef);
            if (fileInfo.StatusValue() == Status.StatusFileExists.value()) {
                workspace.FileService().DeassignFileref(assignedName.value);
                return true;
            }
            workspace.FileService().DeassignFileref(assignedName.value);
            return false;
        }
        catch (GenericError ge) {
            return false;
        }
    }

    public static String getLocationForItem(List infoList, String itemName, int type) {
        for (RemoteFileMetadataInterface item : infoList) {
            if (!itemName.equals(item.getName())) continue;
            if (type == 0 && item.isFolder()) {
                return item.getLocation();
            }
            if (type != 1 || item.isFolder()) continue;
            return item.getLocation();
        }
        return null;
    }

    public static boolean startsWithValidAbsolutePathIndentifier(IFileServiceNavigationModel model, String path) {
        if (path == null) {
            return false;
        }
        String[][] foldersAndLocations = IFileServiceAdapterSupport.parseIntoFoldersAndLocations(model.getWorkspace(), model.getWorkspace().FileService(), model.getRootLocation(), model.getBasePath(), path);
        if (foldersAndLocations == null) {
            return false;
        }
        int maxIndex = foldersAndLocations.length - 1;
        String lastFolderName = foldersAndLocations[maxIndex][1];
        if (lastFolderName == null) {
            return false;
        }
        String root = null;
        if (maxIndex == 0) {
            root = foldersAndLocations[maxIndex][0];
        } else if (lastFolderName.equals(IFileServiceAdapterSupport.getServerNameFromWorkspace(model.getWorkspace()))) {
            root = foldersAndLocations[maxIndex - 1][0];
        }
        String[] fileInfo = model.getFileInfo(root);
        return fileInfo[1] != null && !fileInfo[1].equals(".");
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)IFileServiceAdapterSupport.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        }
        return _log;
    }

    public static String getFileType(IWorkspace workspace, String parentPath, String fileName) {
        boolean[] fieldMask = new boolean[6];
        StringHolder listedPath = new StringHolder();
        StringSeqHolder names = new StringSeqHolder();
        StringSeqHolder engines = new StringSeqHolder();
        StringSeqHolder typeNames = new StringSeqHolder();
        LongSeqHolder sizes = new LongSeqHolder();
        TypeCategorySeqHolder typeCategories = new TypeCategorySeqHolder();
        DateTimeSeqHolder modtimes = new DateTimeSeqHolder();
        fieldMask[ListFilesIndex.ListFilesIndexSizes.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexTypeNames.value()] = true;
        fieldMask[ListFilesIndex.ListFilesIndexEngines.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexModTimes.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexNames.value()] = true;
        fieldMask[ListFilesIndex.ListFilesIndexTypeCategories.value()] = true;
        try {
            if (workspace.FileService() instanceof IFileService_1_1) {
                IFileService_1_1 fileService = IFileService_1_1Helper.narrow((Object)workspace.FileService());
                fileService.ListFiles_2(parentPath, ListFilesMode.ListFilesModePath, fieldMask, listedPath, names, typeNames, typeCategories, sizes, modtimes, engines);
            } else {
                workspace.FileService().ListFiles(parentPath, ListFilesMode.ListFilesModePath, fieldMask, listedPath, names, typeNames, typeCategories, sizes, modtimes, engines);
            }
        }
        catch (InvalidFieldMask e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (DeviceNotMounted e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (GenericError e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return null;
        }
        for (int i = 0; i < names.value.length; ++i) {
            if (!names.value[i].equalsIgnoreCase(fileName)) continue;
            if (typeCategories.value[i] == TypeCategory.TypeCategoryDirectory) {
                return "FOLDER";
            }
            return typeNames.value[i];
        }
        return null;
    }

    public static String getFileType(IWorkspace workspace, String rootLocation, String basePath, String fileNameWithLocation) {
        if (IFileServiceAdapterSupport.isExistingFileItem(workspace, fileNameWithLocation) || IFileServiceAdapterSupport.verifyExistenceOfDrive(workspace, fileNameWithLocation, "")) {
            String[] fileParts = IFileServiceAdapterSupport.splitPathAndFileName(workspace, workspace.FileService(), rootLocation, basePath, fileNameWithLocation);
            String parentLocation = fileParts[1];
            String fileItemName = fileParts[0];
            if (fileNameWithLocation.equals(parentLocation) && !fileNameWithLocation.equals("")) {
                return "FOLDER";
            }
            if (fileNameWithLocation.indexOf(parentLocation) > -1) {
                return IFileServiceAdapterSupport.getFileType(workspace, parentLocation, fileItemName);
            }
        }
        return null;
    }

    public static boolean isExistingFileItem(IWorkspace workspace, String fileNameWithPath) {
        return IFileServiceAdapterSupport.verifyExistenceOfFile(workspace, fileNameWithPath, "");
    }
}

