/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IFileServicePackage.ListFilesIndex;
import com.sas.iom.SAS.IFileServicePackage.ListFilesMode;
import com.sas.iom.SAS.IFileServicePackage.TypeCategorySeqHolder;
import com.sas.iom.SAS.IFileService_1_1;
import com.sas.iom.SAS.IFileService_1_1Helper;
import com.sas.iom.SAS.IFileService_1_1Package.DeviceNotMounted;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidFieldMask;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.publish.BinaryFileEntryInterface;
import com.sas.services.publish.EntryInterface;
import com.sas.services.publish.HTMLEntryInterface;
import com.sas.services.publish.HTMLFileInterface;
import com.sas.services.publish.LibraryMemberEntryInterface;
import com.sas.services.publish.ReferenceEntryInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TextFileEntryInterface;
import com.sas.services.publish.ViewerEntryInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModel2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesAdapterSupport;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

@SASScope
public class RemoteFileModelsUtil {
    protected static final String SBIP = "SBIP://";
    protected static final String SLASH = "/";

    public static boolean isOneTokenPath(String path, String pathDelimiter) {
        if (path == null) {
            return false;
        }
        String trimmedPath = RemoteFileModelsUtil.removeStartingEndingPathDelimiters(path, pathDelimiter);
        return trimmedPath.indexOf(pathDelimiter) <= -1;
    }

    public static boolean isPathSameAsRoot(RemoteFileModel2Interface model, String path) {
        if (model instanceof InformationServicesNavigationModel) {
            return InformationServicesAdapterSupport.isPathSameAsRoot((InformationServicesNavigationModel)model, path);
        }
        return false;
    }

    public static String removeStartingEndingPathDelimiters(String path, String pathDelim) {
        if (path == null) {
            return null;
        }
        return RemoteFileModelsUtil.removeEndingPathDelimiter(RemoteFileModelsUtil.removeStartingPathDelimiter(path, pathDelim), pathDelim);
    }

    public static String removeEndingPathDelimiter(String path, String pathDelim) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(pathDelim)) {
            return path.substring(0, path.lastIndexOf(pathDelim));
        }
        return path;
    }

    public static String removeStartingPathDelimiter(String path, String pathDelim) {
        if (path == null) {
            return null;
        }
        if (path.startsWith(pathDelim)) {
            path = path.substring(path.indexOf(pathDelim) + 1);
        }
        return path;
    }

    public static RepositoryInterface getRepositoryForPath(String path, List repositories, List repositoryNames) {
        if (path != null && !path.equals("") && RemoteFileModelsUtil.isValidURL(path)) {
            PathUrl newPathUrl = new PathUrl(path);
            String repositoryName = newPathUrl.getRepository();
            if (repositories == null) {
                return null;
            }
            if (repositoryNames != null) {
                int nameInListIndex = repositoryNames.indexOf(repositoryName);
                if (nameInListIndex >= 0) {
                    return (RepositoryInterface)repositories.get(nameInListIndex);
                }
            } else {
                try {
                    int numOfWebDavRepositories = repositories.size();
                    for (int i = 0; i < numOfWebDavRepositories; ++i) {
                        RepositoryInterface repos = (RepositoryInterface)repositories.get(i);
                        String reposName = repos.getISName();
                        if (!reposName.equals(repositoryName)) continue;
                        return repos;
                    }
                }
                catch (RemoteException e) {
                    LoggerRepository2.getLogger((String)RemoteFileModelsUtil.class.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory()).error(e.getMessage());
                }
            }
        }
        return null;
    }

    public static boolean isLocationInParentFolder(String parentFolderLocation, String path) {
        if (parentFolderLocation != null && parentFolderLocation.equalsIgnoreCase(path) || parentFolderLocation == null || parentFolderLocation.equals("")) {
            return true;
        }
        if (RemoteFileModelsUtil.isValidURL(parentFolderLocation) && RemoteFileModelsUtil.isValidURL(path)) {
            PathUrl parentFolderPathUrl = null;
            PathUrl pathUrl = null;
            parentFolderPathUrl = new PathUrl(parentFolderLocation);
            pathUrl = new PathUrl(path);
            String parentFolderAbsPath = parentFolderPathUrl.getAbsolutePath();
            String pathAbsPath = pathUrl.getAbsolutePath();
            parentFolderAbsPath = RemoteFileModelsUtil.normalizeLocation(parentFolderAbsPath);
            pathAbsPath = RemoteFileModelsUtil.normalizeLocation(pathAbsPath);
            parentFolderAbsPath = parentFolderAbsPath + SLASH;
            if ((pathAbsPath = pathAbsPath + SLASH).startsWith(parentFolderAbsPath)) {
                return true;
            }
        }
        return false;
    }

    public static String normalizeLocation(String absolutePath) {
        int lastIndexOfOpenParen = absolutePath.lastIndexOf("(");
        if (lastIndexOfOpenParen >= 0) {
            absolutePath = absolutePath.substring(0, lastIndexOfOpenParen);
        }
        absolutePath = RemoteFileModelsUtil.removeStartingEndingPathDelimiters(absolutePath, SLASH);
        return absolutePath;
    }

    public static boolean isValidURL(String SBIPUrl) {
        String validateString;
        boolean validUrl = false;
        if (SBIPUrl != null && !SBIPUrl.equals("") && (validateString = SBIPUrl.trim()).startsWith(SBIP)) {
            validUrl = true;
        }
        return validUrl;
    }

    public static int getModelType(RemoteFileNavigationModelInterface model) {
        int modelType = 0;
        if (model == null || !(model instanceof InformationServicesNavigationModel)) {
            return modelType;
        }
        modelType = 1;
        List repositoryList = ((InformationServicesNavigationModel)model).getRepositoryList();
        if (repositoryList == null || repositoryList.size() <= 1) {
            return modelType;
        }
        modelType = 2;
        return modelType;
    }

    public static List getCustomRepositoriesList(List repositoriesList) {
        ArrayList customRepositoriesList = new ArrayList();
        for (int i = 0; i < repositoriesList.size(); ++i) {
            String repositoryType;
            java.lang.Object repos;
            block3: {
                repos = repositoriesList.get(i);
                repositoryType = null;
                try {
                    if (!(repos instanceof OMIRepositoryInterface)) break block3;
                    repositoryType = ((OMIRepositoryInterface)repos).getRepositoryType();
                }
                catch (RemoteException re) {
                    continue;
                }
            }
            if (repositoryType == null || !"CUSTOM".equals(repositoryType)) continue;
            customRepositoriesList.add(repos);
        }
        return customRepositoriesList;
    }

    public static java.lang.Object[][] getCustomRepositoryRootFolderInfo(List customRepositoriesList) {
        java.lang.Object[][] _customRepositoryRootFolderInfo = new java.lang.Object[customRepositoriesList.size()][3];
        for (int i = 0; i < customRepositoriesList.size(); ++i) {
            OMIRepositoryInterface repos = (OMIRepositoryInterface)customRepositoriesList.get(i);
            try {
                FolderInterface rootFolder = null;
                List rootFolders = repos.getRootFolders();
                if (rootFolders == null || rootFolders.isEmpty()) continue;
                rootFolder = (FolderInterface)rootFolders.get(0);
                String rootFolderPath = rootFolder.getPath();
                _customRepositoryRootFolderInfo[i][0] = "SBIP:/" + rootFolderPath + SLASH;
                _customRepositoryRootFolderInfo[i][1] = rootFolder.getEntityKey();
                _customRepositoryRootFolderInfo[i][2] = repos;
                continue;
            }
            catch (RemoteException re) {
                continue;
            }
            catch (ServiceException re) {
                // empty catch block
            }
        }
        return _customRepositoryRootFolderInfo;
    }

    public static boolean isAFolder(IWorkspace ws, String location) {
        boolean[] fieldMask = new boolean[6];
        StringHolder listedPath = new StringHolder();
        StringSeqHolder names = new StringSeqHolder();
        StringSeqHolder engines = new StringSeqHolder();
        StringSeqHolder typeNames = new StringSeqHolder();
        LongSeqHolder sizes = new LongSeqHolder();
        TypeCategorySeqHolder typeCategories = new TypeCategorySeqHolder();
        DateTimeSeqHolder modtimes = new DateTimeSeqHolder();
        fieldMask[ListFilesIndex.ListFilesIndexSizes.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexTypeNames.value()] = true;
        fieldMask[ListFilesIndex.ListFilesIndexEngines.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexModTimes.value()] = false;
        fieldMask[ListFilesIndex.ListFilesIndexNames.value()] = true;
        fieldMask[ListFilesIndex.ListFilesIndexTypeCategories.value()] = true;
        try {
            if (ws.FileService() instanceof IFileService_1_1) {
                IFileService_1_1 fileService = IFileService_1_1Helper.narrow((Object)ws.FileService());
                fileService.ListFiles_2(location, ListFilesMode.ListFilesModePath, fieldMask, listedPath, names, typeNames, typeCategories, sizes, modtimes, engines);
            } else {
                ws.FileService().ListFiles(location, ListFilesMode.ListFilesModePath, fieldMask, listedPath, names, typeNames, typeCategories, sizes, modtimes, engines);
            }
        }
        catch (InvalidFieldMask e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (DeviceNotMounted e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (GenericError e) {
            LoggerRepository2.getLogger((String)BaseIFileServiceModel.class.getPackage().getName(), null).debug(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getPackageName(EntryInterface item) {
        try {
            if (item instanceof BinaryFileEntryInterface) {
                return ((BinaryFileEntryInterface)item).getName();
            }
            if (item instanceof TextFileEntryInterface) {
                return ((TextFileEntryInterface)item).getName();
            }
            if (item instanceof HTMLEntryInterface) {
                HTMLFileInterface htmlFile = ((HTMLEntryInterface)item).getFile();
                if (htmlFile != null) {
                    return htmlFile.getName();
                }
                return "";
            }
            if (item instanceof LibraryMemberEntryInterface) {
                String library = ((LibraryMemberEntryInterface)item).getLibraryName();
                String memberName = ((LibraryMemberEntryInterface)item).getMemberName();
                return library + ": " + memberName;
            }
            if (item instanceof ReferenceEntryInterface) {
                return ((ReferenceEntryInterface)item).getReference();
            }
            if (item instanceof ResultPackageInterface) {
                return ((ResultPackageInterface)item).getName();
            }
            if (item instanceof ViewerEntryInterface) {
                return ((ViewerEntryInterface)item).getName();
            }
        }
        catch (TransportException e) {
            return "";
        }
        catch (RemoteException e) {
            return "";
        }
        catch (IllegalStateException e) {
            return "";
        }
        return "";
    }
}

