/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.remotefileselector2.LocationNode;
import java.io.Serializable;
import java.util.List;

@SASScope
public class Location
implements Serializable {
    private List locations;

    public Location() {
    }

    public Location(List locationNodes) {
        this.locations = locationNodes;
    }

    public void setLocationNodes(List locationNodes) {
        this.locations = locationNodes;
    }

    public List getLocationNodes() {
        return this.locations;
    }

    public LocationNode getParentLocationNode(String locationValue) {
        LocationNode parentLocationNode = null;
        if (this.locations != null && this.locations.size() > 1) {
            boolean nodeNotFound = true;
            int numOfNodes = this.locations.size();
            for (int allProcessedNodes = 0; nodeNotFound && allProcessedNodes < numOfNodes; ++allProcessedNodes) {
                LocationNode nodeToProcess = (LocationNode)this.locations.get(allProcessedNodes);
                if (!locationValue.equals(nodeToProcess.getLocation())) continue;
                nodeNotFound = false;
                parentLocationNode = (LocationNode)this.locations.get(allProcessedNodes - 1);
            }
        }
        return parentLocationNode;
    }

    public String getFullyQualifiedLocation() {
        if (this.locations != null && this.locations.size() > 0) {
            LocationNode node = (LocationNode)this.locations.get(this.locations.size() - 1);
            return node.getLocation();
        }
        return null;
    }

    public String toString() {
        StringBuffer returnText = new StringBuffer();
        if (this.locations != null && this.locations.size() > 0) {
            for (int i = 0; i < this.locations.size(); ++i) {
                Object node = this.locations.get(i);
                returnText.append("location ").append(i).append("-");
                returnText.append(node.toString()).append("\n");
            }
            return returnText.toString();
        }
        return super.toString();
    }
}

