/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models.remotefileselector2;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.remotefileselector2.MutableFileFilterInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadata2Interface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileModelDirectoriesOnlyInterface;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;

@SASScope(value="ALL")
public abstract class BaseRemoteFileServerModel
extends AbstractTableModel
implements RemoteFileModelDirectoriesOnlyInterface,
MutableFileFilterInterface {
    protected boolean readingFromCache;
    protected boolean directoriesOnly;
    protected boolean tableEditable;
    protected String currentPath;
    protected List infoList;
    protected boolean modelNeedsRefresh;
    protected SwingPropertyChangeSupport spcs = new SwingPropertyChangeSupport(this);
    protected List filterValues;
    private List pasteBuffer;
    private int pasteBufferCommandType = 0;
    private String basePath = "";
    protected String rootLocation;
    protected boolean showDirectoriesOnly;

    @SASScope
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    @SASScope
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public void setLocation(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path cannot be null.");
        }
        if (this.currentPath != path) {
            this.currentPath = path;
            this.setRefreshNeeded(true);
        }
    }

    public String getLocation() {
        return this.currentPath;
    }

    @SASScope
    public void setRootLocation(String rootPath) {
        this.rootLocation = rootPath;
        if (this.currentPath == null || "".equals(this.currentPath)) {
            this.setLocation(this.rootLocation);
        }
        this.spcs.firePropertyChange("path", null, this.currentPath);
    }

    @SASScope
    public String getRootLocation() {
        return this.rootLocation;
    }

    public void cancelLoadFileInfo() {
    }

    public void setRefreshNeeded(boolean refresh) {
        this.modelNeedsRefresh = refresh;
        if (refresh) {
            this.spcs.firePropertyChange("refreshNeeded", false, refresh);
        }
    }

    public boolean isRefreshNeeded() {
        return this.modelNeedsRefresh;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @SASScope
    public void setBasePath(String location) {
        this.basePath = location;
        this.spcs.firePropertyChange("path", null, this.currentPath);
    }

    public RemoteFileMetadataInterface getNodeAt(int rowIndex) {
        if (this.infoList != null && rowIndex <= this.infoList.size() && rowIndex >= 0) {
            return (RemoteFileMetadataInterface)this.infoList.get(rowIndex);
        }
        return null;
    }

    @Override
    @SASScope
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isTableEditable() && columnIndex == 0;
    }

    public boolean isTableEditable() {
        return this.tableEditable;
    }

    public void setTableEditable(boolean editable) {
        if (this.tableEditable != editable) {
            this.tableEditable = editable;
            this.spcs.firePropertyChange("tableEditable", !editable, editable);
        }
    }

    @Override
    public int getRowCount() {
        if (this.infoList != null) {
            return this.infoList.size();
        }
        return 0;
    }

    public void addToPasteBuffer(Object node) {
        if (this.pasteBuffer == null) {
            this.pasteBuffer = new ArrayList();
        }
        this.pasteBuffer.add(node);
    }

    public void clearPasteBuffer() {
        if (this.pasteBuffer != null && this.pasteBuffer.size() > 0) {
            this.pasteBuffer.clear();
        } else {
            this.pasteBuffer = new ArrayList();
        }
    }

    public List getPasteBuffer() {
        return this.pasteBuffer;
    }

    public void setPasteBufferCommandType(int commandType) {
        this.pasteBufferCommandType = commandType;
    }

    public int getPasteBufferCommandType() {
        return this.pasteBufferCommandType;
    }

    @Override
    @SASScope
    public void updateFilteredValues(List newFilterValues) {
        this.setFilterValues(newFilterValues);
    }

    @SASScope
    public void setFilterValues(List newFilterValues) {
        this.filterValues = newFilterValues;
    }

    @SASScope
    public List getFilterValues() {
        return this.filterValues;
    }

    @SASScope
    public boolean isFolderPopulated(RemoteFileMetadataInterface itemNode) {
        return itemNode.isFolder();
    }

    @Override
    @SASScope
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object node;
        if (columnIndex == 0 && aValue != null && !aValue.equals("") && (node = this.infoList.get(rowIndex)) instanceof RemoteFileMetadata2Interface) {
            RemoteFileMetadata2Interface fileNode = (RemoteFileMetadata2Interface)node;
            fileNode.setName(aValue.toString());
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @SASScope
    public String getLocationForFolderItem(String fileName) {
        boolean folderNotFound = true;
        Iterator itemsProcessing = this.infoList.iterator();
        while (folderNotFound && itemsProcessing.hasNext()) {
            RemoteFileMetadataInterface item = (RemoteFileMetadataInterface)itemsProcessing.next();
            if (!fileName.equals(item.getName()) || !item.isFolder()) continue;
            folderNotFound = false;
            return item.getLocation();
        }
        return null;
    }

    @Override
    @SASScope
    public void setDirectoriesOnly(boolean directoriesOnly) {
        this.directoriesOnly = directoriesOnly;
    }

    @Override
    @SASScope
    public boolean isDirectoriesOnly() {
        return this.directoriesOnly;
    }

    @SASScope
    public List getLocations() {
        return null;
    }

    @SASScope
    public int getLocationsCurrentPathIndex() {
        return 0;
    }

    @SASScope
    public String getValidNameStatus(String fileName) {
        return null;
    }

    @SASScope
    public String getValidName(String fileName) {
        return fileName;
    }

    @SASScope
    public boolean isFileDuplicate(String path, String fileName, String fileType) {
        return false;
    }

    public String[] getFileInfo(String folderLocation, String fileName, String fileType) {
        return null;
    }
}

